/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import oracle.ide.Ide;
import oracle.ide.config.ChangeEventSource;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.security.misc.Checksum;

public class ProxyOptions
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "proxy-options";
    private String proxyHost;
    private String proxyPort;
    private String proxyExceptions;
    private Boolean useProxy;
    private Boolean useProxyAuthentication;
    private String proxyUserName;
    private String proxyPassword;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = ProxyOptions.class.desiredAssertionStatus() ^ true;
    }

    void $init$() {
        this.proxyHost = "";
        this.proxyPort = "";
        this.proxyExceptions = "";
        this.useProxy = null;
        this.useProxyAuthentication = null;
        this.proxyUserName = "";
        this.proxyPassword = "";
    }

    public ProxyOptions() {
        this.$init$();
    }

    public static final ProxyOptions getProxyOptions() throws TransientMarker {
        ProxyOptions proxyOptions = (ProxyOptions)Ide.getSettings().getData(KEY_SETTINGS);
        ProxyOptions proxyOptions2 = new ProxyOptions();
        proxyOptions.copyTo(proxyOptions2);
        return proxyOptions2;
    }

    public static final void setProxyOptions(ProxyOptions proxyOptions) throws TransientMarker {
        ProxyOptions proxyOptions2 = (ProxyOptions)Ide.getSettings().getData(KEY_SETTINGS);
        proxyOptions.copyTo(proxyOptions2);
        proxyOptions2.fireChangeEvent();
    }

    public final Object copyTo(Object object) {
        ProxyOptions proxyOptions = object != null ? (ProxyOptions)object : new ProxyOptions();
        this.copyToImpl(proxyOptions);
        return proxyOptions;
    }

    private final void copyToImpl(ProxyOptions proxyOptions) {
        proxyOptions.useProxy = this.useProxy;
        proxyOptions.proxyHost = this.proxyHost;
        proxyOptions.proxyPort = this.proxyPort;
        proxyOptions.proxyExceptions = this.proxyExceptions;
        proxyOptions.useProxyAuthentication = this.useProxyAuthentication;
        proxyOptions.proxyUserName = this.proxyUserName;
        proxyOptions.proxyPassword = this.proxyPassword;
        proxyOptions.fireChangeEvent();
    }

    public final void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public final String getProxyHost() {
        return this.proxyHost;
    }

    public final void setProxyPort(String string) {
        this.proxyPort = string;
    }

    public final String getProxyPort() {
        return this.proxyPort;
    }

    public final void setProxyExceptions(String string) {
        this.proxyExceptions = string;
    }

    public final String getProxyExceptions() {
        return this.proxyExceptions;
    }

    public final void setUseProxy(Boolean bl) {
        this.useProxy = bl;
    }

    public Boolean getUseProxy() {
        return this.useProxy;
    }

    public final void setUseProxyAuthentication(Boolean bl) {
        this.useProxyAuthentication = bl;
    }

    public Boolean getUseProxyAuthentication() {
        return this.useProxyAuthentication;
    }

    public final void setProxyUserName(String string) {
        this.proxyUserName = string;
    }

    public final String getProxyUserName() {
        return this.proxyUserName;
    }

    public final void setProxyPassword(String string) {
        try {
            byte[] byArray = string.getBytes();
            this.proxyPassword = this.encode(Checksum.MD5((byte[])byArray, null));
        }
        catch (Exception exception) {
            this.proxyPassword = "";
        }
    }

    public final String getProxyPassword() throws TransientMarker {
        byte[] byArray = this.decode(this.proxyPassword);
        if (byArray.length > 0) {
            try {
                byArray = Checksum.SHA((byte[])byArray, null);
                String string = new String(byArray);
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public final void setProxyData(String string) {
        this.proxyPassword = string;
    }

    public final String getProxyData() {
        return this.proxyPassword;
    }

    public String[] getJavaProxyOptions() {
        if (this.useProxy != null && this.useProxy.booleanValue() && this.proxyHost != null && this.proxyHost.length() > 0) {
            String[] stringArray = new String[6];
            stringArray[0] = "-Dhttp.proxyHost=" + this.proxyHost;
            String string = this.proxyPort != null && this.proxyPort.length() > 0 ? this.proxyPort : "80";
            stringArray[1] = "-Dhttp.proxyPort=" + string;
            stringArray[2] = "-Dhttp.nonProxyHosts=" + this.proxyExceptions;
            stringArray[3] = "-Dhttps.proxyHost=" + this.proxyHost;
            stringArray[4] = "-Dhttps.proxyPort=" + string;
            stringArray[5] = "-Dhttps.nonProxyHosts=" + this.proxyExceptions;
            return stringArray;
        }
        return null;
    }

    private String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(this.intToAlpha((byArray[n] & 0xF0) >> 4));
            stringBuffer.append(this.intToAlpha(byArray[n] & 0xF));
            ++n;
        }
        return stringBuffer.toString();
    }

    private byte[] decode(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        while (n2 < n) {
            byte by = this.alphaToInt(string.charAt(n2));
            byte by2 = this.alphaToInt(string.charAt(n2 + 1));
            byArray[n2 / 2] = (byte)(by << 4 & 0xF0 | by2 & 0xF);
            n2 += 2;
        }
        return byArray;
    }

    private char intToAlpha(int n) {
        if (!$assertionsDisabled && n >= 16) {
            throw new AssertionError();
        }
        return (char)(n < 10 ? n + 48 : n - 10 + 65);
    }

    private byte alphaToInt(char c) {
        if (!($assertionsDisabled || c >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
            throw new AssertionError();
        }
        return (byte)(c >= 'A' ? c - 65 + 10 : c - 48);
    }
}

