/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ProxySettingsArb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.ProxyOptions;

public final class ProxySettingsPanel
extends DefaultTraversablePanel {
    private JCheckBox checkbox_useProxy;
    private JTextField textfield_proxyHost;
    private WholeNumberField textfield_proxyPort;
    private JTextField textfield_proxyExceptions;
    private JCheckBox checkbox_useProxyAuth;
    private JLabel label_proxyUserName;
    private JTextField textfield_proxyUserName;
    private JLabel label_proxyPassword;
    private JPasswordField textfield_proxyPassword;

    public ProxySettingsPanel() {
        this.setHelpID("f1_idedidesetproxy_html");
        this.initializeComponent();
    }

    private void initializeComponent() {
        String string = ProxySettingsArb.getString(0);
        this.checkbox_useProxy = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_useProxy, string);
        String string2 = ProxySettingsArb.getString(1);
        String string3 = ProxySettingsArb.getString(2);
        String string4 = ProxySettingsArb.getString(3);
        String string5 = ProxySettingsArb.getString(4);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JMultiLineLabel jMultiLineLabel = new JMultiLineLabel(string5);
        jMultiLineLabel.setMinimumRows(4);
        this.textfield_proxyHost = new JTextField();
        this.textfield_proxyPort = new WholeNumberField(8);
        this.textfield_proxyExceptions = new JTextField();
        ResourceUtils.resLabel(jLabel, this.textfield_proxyHost, string2);
        ResourceUtils.resLabel(jLabel2, (Component)((Object)this.textfield_proxyPort), string3);
        ResourceUtils.resLabel(jLabel3, this.textfield_proxyExceptions, string4);
        String string6 = ProxySettingsArb.getString(5);
        this.checkbox_useProxyAuth = new JCheckBox();
        ResourceUtils.resButton(this.checkbox_useProxyAuth, string6);
        String string7 = ProxySettingsArb.getString(6);
        String string8 = ProxySettingsArb.getString(7);
        this.label_proxyUserName = new JLabel();
        this.label_proxyPassword = new JLabel();
        this.textfield_proxyUserName = new JTextField();
        this.textfield_proxyPassword = new JPasswordField();
        ResourceUtils.resLabel(this.label_proxyUserName, this.textfield_proxyUserName, string7);
        ResourceUtils.resLabel(this.label_proxyPassword, this.textfield_proxyPassword, string8);
        Component[] componentArray = new Component[]{jLabel, this.textfield_proxyHost, jLabel2, this.textfield_proxyPort, jLabel3, this.textfield_proxyExceptions, jMultiLineLabel, this.checkbox_useProxyAuth};
        new ItemSelectableTracker(this.checkbox_useProxy, componentArray);
        1 var14_14 = new 1();
        this.checkbox_useProxy.addItemListener(var14_14);
        this.checkbox_useProxyAuth.addItemListener(var14_14);
        this.updateProxyAuthFields();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(2, 29, 2, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.checkbox_useProxy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)this.textfield_proxyHost, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)((Object)this.textfield_proxyPort), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)this.textfield_proxyExceptions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add((Component)((Object)jMultiLineLabel), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 0, new Insets(15, 29, 2, 5), 0, 0);
        this.add((Component)this.checkbox_useProxyAuth, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.label_proxyUserName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel.add((Component)this.textfield_proxyUserName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.label_proxyPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel.add((Component)this.textfield_proxyPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 0), 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
    }

    public void setHost(String string) {
        this.textfield_proxyHost.setText(string);
    }

    public void setPort(String string) {
        this.textfield_proxyPort.setText(string);
    }

    public void setExceptions(String string) {
        this.textfield_proxyExceptions.setText(string);
    }

    public void setUseProxy(boolean bl) {
        this.checkbox_useProxy.setSelected(bl);
    }

    public void setUseProxyAuthentication(boolean bl) {
        this.checkbox_useProxyAuth.setSelected(bl);
    }

    public void setUserName(String string) {
        this.textfield_proxyUserName.setText(string);
    }

    public void setPassword(String string) {
        this.textfield_proxyPassword.setText(string);
    }

    public String getHost() {
        return this.textfield_proxyHost.getText();
    }

    public String getPort() {
        try {
            String string = Integer.toString(this.textfield_proxyPort.getValue());
            return string;
        }
        catch (RuntimeException runtimeException) {
            String string = "";
            return string;
        }
    }

    public String getExceptions() {
        return this.textfield_proxyExceptions.getText();
    }

    public boolean getUseProxy() {
        return this.checkbox_useProxy.isSelected();
    }

    public boolean getUseProxyAuthentication() {
        return this.checkbox_useProxyAuth.isSelected();
    }

    public String getUserName() {
        return this.textfield_proxyUserName.getText();
    }

    public String getPassword() {
        return new String(this.textfield_proxyPassword.getPassword());
    }

    public void setProxyOptions(ProxyOptions proxyOptions) {
        this.setHost(proxyOptions.getProxyHost());
        this.setPort(proxyOptions.getProxyPort());
        this.setUseProxy(proxyOptions.getUseProxy());
        this.setExceptions(proxyOptions.getProxyExceptions());
        this.setUseProxyAuthentication(proxyOptions.getUseProxyAuthentication());
        this.setUserName(proxyOptions.getProxyUserName());
        this.setPassword(new String(proxyOptions.getProxyPassword()));
    }

    public ProxyOptions getProxyOptions() {
        ProxyOptions proxyOptions = new ProxyOptions();
        proxyOptions.setProxyHost(this.getHost());
        proxyOptions.setProxyPort(this.getPort());
        proxyOptions.setProxyExceptions(this.getExceptions());
        proxyOptions.setUseProxy(this.getUseProxy());
        proxyOptions.setUseProxyAuthentication(this.getUseProxyAuthentication());
        proxyOptions.setProxyUserName(this.getUserName());
        proxyOptions.setProxyPassword(this.getPassword());
        return proxyOptions;
    }

    private void updateProxyAuthFields() {
        boolean bl = this.checkbox_useProxy.isSelected() && this.checkbox_useProxyAuth.isSelected();
        this.label_proxyUserName.setEnabled(bl);
        this.label_proxyPassword.setEnabled(bl);
        this.textfield_proxyUserName.setEnabled(bl);
        this.textfield_proxyPassword.setEnabled(bl);
    }

    public void onEntry(TraversableContext traversableContext) {
        ProxyOptions proxyOptions = this.findProxyOptions(traversableContext);
        Boolean bl = proxyOptions.getUseProxy();
        boolean bl2 = bl != null ? bl : false;
        String string = proxyOptions.getProxyHost();
        String string2 = proxyOptions.getProxyPort();
        String string3 = proxyOptions.getProxyExceptions();
        Boolean bl3 = proxyOptions.getUseProxyAuthentication();
        boolean bl4 = bl3 != null ? bl3 : false;
        String string4 = proxyOptions.getProxyUserName();
        String string5 = proxyOptions.getProxyPassword();
        this.setHost(string);
        this.setPort(string2);
        this.setExceptions(string3);
        this.setUseProxy(bl2);
        this.setUseProxyAuthentication(bl4);
        this.setUserName(string4);
        this.setPassword(string5);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ProxyOptions proxyOptions = this.findProxyOptions(traversableContext);
        boolean bl = this.getUseProxy();
        String string = this.getHost();
        String string2 = this.getExceptions();
        String string3 = this.getPort();
        boolean bl2 = this.getUseProxyAuthentication();
        String string4 = this.getUserName();
        String string5 = this.getPassword();
        proxyOptions.setUseProxy(bl ? Boolean.TRUE : Boolean.FALSE);
        proxyOptions.setProxyHost(string);
        proxyOptions.setProxyExceptions(string2);
        proxyOptions.setProxyPort(string3);
        proxyOptions.setUseProxyAuthentication(bl2);
        proxyOptions.setProxyUserName(string4);
        proxyOptions.setProxyPassword(string5);
    }

    private ProxyOptions findProxyOptions(TraversableContext traversableContext) {
        ProxyOptions proxyOptions = (ProxyOptions)traversableContext.find("proxy-options");
        return proxyOptions;
    }

    static void mav$updateProxyAuthFields(ProxySettingsPanel proxySettingsPanel) {
        proxySettingsPanel.updateProxyAuthFields();
    }

    public final class 1
    implements ItemListener {
        public final void itemStateChanged(ItemEvent itemEvent) {
            ProxySettingsPanel.mav$updateProxyAuthFields(ProxySettingsPanel.this);
        }
    }
}

