/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import oracle.ide.resource.PanelsArb;
import oracle.ide.wizard.FSMException;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMStateInfo;
import oracle.ide.wizard.FSMTransitionException;
import oracle.ide.wizard.Step;

public final class FSM {
    static final String START_STATE = "__START_STATE__";
    static final String IS_FINAL_STATE = "__IS_FINAL_STATE__";
    static final String FSMState_OBJ = "__FSMState_OBJ__";
    static final String TRANSITIONS = "__TRANSITIONS__";
    static final String ANY_TRANS = "__*__";
    private final Map _fsmSpec;
    private boolean _starting;
    private boolean _halted;
    private int _initialStepNumber;
    private int _stepNumber;
    private int _expectedStepCount;
    private FSMStateInfo _curStateInfo;
    private int _curStateIndex;
    private Map _curTransMap;
    private FSM _curSubFsm;
    private Map _statePool;
    private Stack _history;

    FSM(Map map) throws FSMInvalidException {
        this.$init$();
        FSM.validateFSM(map);
        this._fsmSpec = map;
        this._starting = true;
    }

    void reset() {
        this._starting = true;
        this._halted = false;
        this._stepNumber = this._initialStepNumber;
        this._curStateInfo = null;
        this._curStateIndex = 0;
        this._curTransMap = null;
        this._curSubFsm = null;
        this._history.clear();
        this._expectedStepCount = 0;
    }

    int getStepNumber() {
        return this._stepNumber;
    }

    boolean isStarting() {
        return this._starting;
    }

    boolean inFinalState() {
        if (this._curStateInfo == null) {
            return false;
        }
        if (!this._curStateInfo.isFinalState()) {
            return false;
        }
        if (this._curSubFsm == null) {
            return true;
        }
        return this._curSubFsm.inFinalState();
    }

    boolean isHalted() {
        return this._halted;
    }

    FSMStateInfo nextState(Object object) throws FSMException {
        if (this._halted) {
            return null;
        }
        if (this._curSubFsm != null) {
            FSMStateInfo fSMStateInfo = this._curSubFsm.nextState(object);
            if (!this._curSubFsm._halted) {
                ++this._stepNumber;
                return fSMStateInfo;
            }
            this._curStateInfo.setSubFSM(this._curSubFsm);
            this._curSubFsm = null;
            if (object instanceof FSM) {
                throw new FSMException(PanelsArb.getString(1));
            }
        }
        if (object instanceof FSM && !this._starting) {
            this._curSubFsm = (FSM)object;
            this._curSubFsm._initialStepNumber = this._stepNumber;
            this._curSubFsm.reset();
            return this.nextState(null);
        }
        int n = this._curStateIndex + 1;
        FSMStateInfo fSMStateInfo = this._curStateInfo;
        FSMStateInfo fSMStateInfo2 = null;
        if (this._starting) {
            fSMStateInfo2 = this.gotoState(START_STATE, 1);
            this._starting = false;
        } else {
            if (this._curTransMap == null) {
                throw new FSMException(PanelsArb.getString(2));
            }
            if (this._curTransMap.containsKey(object)) {
                fSMStateInfo2 = this.gotoState(this._curTransMap.get(object), n);
            } else if (this._curTransMap.containsKey(ANY_TRANS)) {
                fSMStateInfo2 = this.gotoState(this._curTransMap.get(ANY_TRANS), n);
            } else if (this._curStateInfo.isFinalState()) {
                this._halted = true;
                this._curStateIndex = n;
                fSMStateInfo2 = null;
            } else {
                throw new FSMTransitionException(PanelsArb.format(3, object != null ? object.toString() : "<null>"));
            }
        }
        this._history.push(fSMStateInfo);
        ++this._stepNumber;
        return fSMStateInfo2;
    }

    FSMStateInfo previousState() throws FSMException {
        int n;
        FSMStateInfo fSMStateInfo;
        if (this._starting) {
            return null;
        }
        if (this._curSubFsm != null) {
            FSMStateInfo fSMStateInfo2 = this._curSubFsm.previousState();
            if (!this._curSubFsm._starting) {
                --this._stepNumber;
                return fSMStateInfo2;
            }
            this._curSubFsm = null;
            --this._stepNumber;
            return this._curStateInfo;
        }
        try {
            fSMStateInfo = (FSMStateInfo)this._history.pop();
        }
        catch (EmptyStackException emptyStackException) {
            throw new FSMException(PanelsArb.getString(4), emptyStackException);
        }
        catch (ClassCastException classCastException) {
            throw new FSMException(PanelsArb.getString(5), classCastException);
        }
        if (this._history.empty()) {
            if (fSMStateInfo != null) {
                throw new FSMException(PanelsArb.getString(6));
            }
            this.reset();
            return null;
        }
        Object object = fSMStateInfo.getStateID();
        FSMStateInfo fSMStateInfo3 = this.gotoState(object, n = this._curStateIndex - 1);
        if (fSMStateInfo != fSMStateInfo3) {
            throw new FSMException(PanelsArb.getString(7));
        }
        this._halted = false;
        FSM fSM = fSMStateInfo.getSubFSM();
        if (fSM != null) {
            this._curSubFsm = fSM;
            fSMStateInfo.setSubFSM(null);
            return this.previousState();
        }
        --this._stepNumber;
        return fSMStateInfo;
    }

    private static final void validateFSM(Map map) throws FSMInvalidException {
        boolean bl = false;
        if (map == null) {
            throw new FSMInvalidException(PanelsArb.getString(8));
        }
        if (!map.containsKey(START_STATE)) {
            throw new FSMInvalidException(PanelsArb.getString(17));
        }
        for (Object v : map.values()) {
            Object v2;
            if (!(v instanceof Map)) {
                throw new FSMInvalidException(PanelsArb.getString(18));
            }
            Map map2 = (Map)v;
            if (!map2.containsKey(FSMState_OBJ)) {
                throw new FSMInvalidException(PanelsArb.getString(19));
            }
            Object v3 = map2.get(FSMState_OBJ);
            if (!(v3 instanceof Step)) {
                throw new FSMInvalidException(PanelsArb.getString(20));
            }
            if (!map2.containsKey(TRANSITIONS)) {
                throw new FSMInvalidException(PanelsArb.getString(21));
            }
            if (!bl && map2.containsKey(IS_FINAL_STATE)) {
                bl = true;
            }
            if (!((v2 = map2.get(TRANSITIONS)) instanceof Map)) {
                throw new FSMInvalidException(PanelsArb.getString(22));
            }
            Map map3 = (Map)v2;
            if (map3.size() == 0 && !map2.containsKey(IS_FINAL_STATE)) {
                throw new FSMInvalidException(PanelsArb.getString(23));
            }
            for (Object v4 : map3.values()) {
                if (map.containsKey(v4)) continue;
                throw new FSMInvalidException(PanelsArb.format(24, v4));
            }
        }
        if (!bl) {
            throw new FSMInvalidException(PanelsArb.getString(25));
        }
    }

    int getTotalStepCount() {
        return this._fsmSpec.size();
    }

    int getExpectedStepCount() {
        if (this._expectedStepCount == 0) {
            this.countExpectedSteps();
        }
        return this._expectedStepCount;
    }

    int countExpectedSteps() {
        int n = this.getTotalStepCount();
        int n2 = this._curStateIndex;
        int n3 = 0;
        try {
            Object object;
            if (this._starting) {
                object = START_STATE;
                ++n2;
            } else {
                object = this._curStateInfo.getStateID();
            }
            Map map = this.getStateNode(object);
            while (true) {
                Step step;
                Object object2;
                if ((object2 = (step = FSM.getStep(map)).getExpectedTransition()) instanceof FSM) {
                    FSM fSM = (FSM)object2;
                    n3 += fSM.countExpectedSteps();
                    FSMStateInfo fSMStateInfo = fSM._curStateInfo;
                    Object object3 = object2 = fSMStateInfo != null ? fSMStateInfo.getStep().getExpectedTransition() : START_STATE;
                }
                if (!FSM.isFinalState(map) && n2 < n) {
                    Map map2 = FSM.getTransitionMap(map);
                    if (map2.containsKey(object2)) {
                        object = map2.get(object2);
                    } else if (map2.containsKey(ANY_TRANS)) {
                        object = map2.get(ANY_TRANS);
                    } else {
                        throw new FSMTransitionException(PanelsArb.format(3, object2 != null ? object2.toString() : "<null>"));
                    }
                    map = this.getStateNode(object);
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (FSMException fSMException) {
            fSMException.printStackTrace();
            System.err.println("****  Possible causes for this exception:");
            System.err.println("****  -  The expected transition set in the Step is not a transition in the FSM.");
            System.err.println("****  -  A sub-FSM was used but the parent FSM state doesn't have 'null' or FSM.ANY_TRANS as one of its transitions.  When a sub-FSM halts, the next transition is always null.");
        }
        this._expectedStepCount = n2 + n3;
        return this._expectedStepCount;
    }

    private Map getStateNode(Object object) throws FSMException {
        if (this._fsmSpec.containsKey(object)) {
            Object v = this._fsmSpec.get(object);
            if (v instanceof Map) {
                return (Map)v;
            }
            throw new FSMException(PanelsArb.format(10, object.toString()));
        }
        throw new FSMTransitionException(PanelsArb.format(9, object.toString()));
    }

    private static Step getStep(Map map) throws FSMException {
        if (map.containsKey(FSMState_OBJ)) {
            Object v = map.get(FSMState_OBJ);
            if (v instanceof Step) {
                return (Step)v;
            }
            throw new FSMException(PanelsArb.getString(12));
        }
        throw new FSMTransitionException(PanelsArb.getString(11));
    }

    private static Map getTransitionMap(Map map) throws FSMException {
        if (map.containsKey(TRANSITIONS)) {
            Object v = map.get(TRANSITIONS);
            if (v instanceof Map) {
                return (Map)v;
            }
            throw new FSMException(PanelsArb.getString(14));
        }
        throw new FSMException(PanelsArb.getString(13));
    }

    private static boolean isFinalState(Map map) {
        return map.containsKey(IS_FINAL_STATE);
    }

    private FSMStateInfo gotoState(Object object, int n) throws FSMException {
        FSMStateInfo fSMStateInfo;
        if (this._fsmSpec == null) {
            throw new FSMException(PanelsArb.getString(8));
        }
        Map map = this.getStateNode(object);
        Step step = FSM.getStep(map);
        Map map2 = FSM.getTransitionMap(map);
        boolean bl = FSM.isFinalState(map);
        FSMStateInfo fSMStateInfo2 = new FSMStateInfo(object, bl, null);
        if (this._statePool.containsKey(fSMStateInfo2)) {
            fSMStateInfo = (FSMStateInfo)this._statePool.get(fSMStateInfo2);
        } else {
            try {
                fSMStateInfo = new FSMStateInfo(object, bl, step);
            }
            catch (Exception exception) {
                throw new FSMTransitionException(PanelsArb.getString(16), exception);
            }
            this._statePool.put(fSMStateInfo2, fSMStateInfo);
        }
        this._curStateInfo = fSMStateInfo;
        this._curStateIndex = n;
        this._curTransMap = map2;
        return fSMStateInfo;
    }

    void $init$() {
        this._initialStepNumber = 0;
        this._statePool = new HashMap();
        this._history = new Stack();
    }
}

