/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.Step;

public class FSMBuilder {
    private final Map _fsm = new HashMap(23);
    private transient Map _state;
    private transient Map _trans;
    private transient Step _curStep;

    public FSMBuilder() {
    }

    public FSMBuilder(Step[] stepArray) {
        this();
        if (stepArray != null) {
            int n = stepArray.length;
            int n2 = n - 1;
            int n3 = 0;
            while (n3 < n) {
                boolean bl = n3 >= n2;
                String string = n3 == 0 ? "__START_STATE__" : String.valueOf(n3);
                this.newState(string, stepArray[n3], null, bl);
                ++n3;
                if (bl) continue;
                this.setDefaultTrans(String.valueOf(n3));
            }
        }
    }

    public static FSM newFSM(Step[] stepArray) {
        if (stepArray == null || stepArray.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            FSMBuilder fSMBuilder = new FSMBuilder(stepArray);
            FSM fSM = fSMBuilder.getFSM();
            return fSM;
        }
        catch (FSMInvalidException fSMInvalidException) {
            IllegalStateException illegalStateException = new IllegalStateException("#### Internal error in FSMBuilder");
            illegalStateException.initCause(fSMInvalidException);
            throw illegalStateException;
        }
    }

    public void newStartState(Step step, Object object) {
        this.newState("__START_STATE__", step, object, false);
    }

    public void newState(Object object, Step step, Object object2) {
        this.newState(object, step, object2, false);
    }

    public void newFinalState(Object object, Step step) {
        this.newState(object, step, null, true);
    }

    public void newState(Object object, Step step, Object object2, boolean bl) {
        if (this._fsm.containsKey(object)) {
            this._state = (Map)this._fsm.get(object);
            this._trans = (Map)this._state.get("__TRANSITIONS__");
        } else {
            this._state = new HashMap(11);
            this._trans = new HashMap(11);
            this._fsm.put(object, this._state);
            this._state.put("__TRANSITIONS__", this._trans);
        }
        this._curStep = step;
        this._state.put("__FSMState_OBJ__", step);
        if (object2 != null) {
            this.setDefaultTrans(object2);
        } else {
            this.removeStateTrans("__*__");
        }
        if (bl) {
            this._state.put("__IS_FINAL_STATE__", Boolean.TRUE);
        } else {
            this._state.remove("__IS_FINAL_STATE__");
        }
    }

    public void setDefaultTrans(Object object) {
        this.addStateTrans("__*__", object);
    }

    public void addStateTrans(Object object, Object object2) {
        if (this._curStep == null) {
            throw new IllegalStateException();
        }
        if (!this._curStep.isExpectedTransitionSet()) {
            this._curStep.setExpectedTransition(object);
        }
        this._trans.put(object, object2);
    }

    public FSM getFSM() throws FSMInvalidException {
        return new FSM(this._fsm);
    }

    private void removeStateTrans(Object object) {
        this._trans.remove(object);
    }
}

