/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.CommitNotifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.PanelsArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMStateInfo;
import oracle.ide.wizard.FSMTransitionException;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.dialogs.ExceptionDialog;

public final class FSMWizard
extends Wizard
implements CommitNotifier {
    private final FSM _fsm;
    private final Namespace _data;
    private final WizardCallbacks _wc;
    private final JPanel _interactivePanel;
    private final ImageWizardPage _mainPage;
    private final ImageWizardPage _postfixPage;
    private WizardDialog _dialog;
    private FSMStateInfo _curFsmStateInfo;
    private EventListenerList _commitListeners;
    private boolean _showStepNumber;
    private boolean _skipCurStep;
    private String _wizardTitle;
    private String _pageTitle;
    private boolean _welcomePageAdded;
    private boolean _finishPageAdded;

    void $init$() {
        this._postfixPage = new ImageWizardPage();
    }

    public FSMWizard(Step[] stepArray, Namespace namespace) {
        this(FSMBuilder.newFSM(stepArray), namespace);
    }

    public FSMWizard(FSM fSM, Namespace namespace) {
        this.$init$();
        if (fSM == null) {
            throw new IllegalArgumentException(PanelsArb.getString(28));
        }
        if (namespace == null) {
            throw new IllegalArgumentException("FSMWizard data cannot be null.");
        }
        fSM.reset();
        this._fsm = fSM;
        this._data = namespace;
        this._wc = new WC(null);
        this._interactivePanel = new JPanel();
        this._interactivePanel.setLayout(new BorderLayout());
        this._mainPage = new ImageWizardPage((Component)this._interactivePanel, PanelsArb.getImage(37), PanelsArb.getString(27));
        this.doNext();
        this.addPage((WizardPage)new ImageWizardPage(null, PanelsArb.getImage(37), ""));
        this.addPage((WizardPage)this._mainPage);
        this.addPage((WizardPage)this._postfixPage);
        this.selectPage((WizardPage)this._mainPage);
    }

    public void setWizardTitle(String string) {
        this._wizardTitle = string;
    }

    public void setShowStepNumber(boolean bl) {
        this._showStepNumber = bl;
    }

    public boolean getShowStepNumber() {
        return this._showStepNumber;
    }

    public void setWelcomePageAdded(boolean bl) {
        this._welcomePageAdded = bl;
    }

    public void setFinishPageAdded(boolean bl) {
        this._finishPageAdded = bl;
    }

    public void addCommitListener(CommitListener commitListener) {
        if (this._commitListeners == null) {
            this._commitListeners = new EventListenerList();
        }
        this._commitListeners.add(CommitListener.class, commitListener);
    }

    public void removeCommitListener(CommitListener commitListener) {
        if (this._commitListeners != null) {
            this._commitListeners.remove(CommitListener.class, commitListener);
        }
    }

    public void updateImage(Image image) {
        if (image != null && this._mainPage != null) {
            this._mainPage.setImage(image);
            this._mainPage.getContent().repaint();
        }
    }

    public WizardDialog getDialog(Frame frame) {
        return this.getDialogImpl(frame, null);
    }

    public WizardDialog getDialog(Dialog dialog) {
        return this.getDialogImpl(null, dialog);
    }

    public void setDialog(WizardDialog wizardDialog) {
        this._dialog = wizardDialog;
    }

    protected void doFinish() {
        TraversableContext traversableContext = this.exitCurrentPanel(1);
        if (traversableContext != null) {
            IdeUtil.invokeAfterRepaint(new 1(this, traversableContext));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishImpl(TraversableContext traversableContext) {
        try {
            block17: {
                if (this._commitListeners != null) {
                    int n;
                    TraversalException traversalException2;
                    ApplyEvent applyEvent = null;
                    CommitListener[] commitListenerArray = (CommitListener[])this._commitListeners.getListeners(CommitListener.class);
                    int n2 = commitListenerArray.length - 1;
                    while (true) {
                        if (n2 < 0) {
                            int n3 = commitListenerArray.length - 1;
                            try {
                                while (n3 >= 0) {
                                    try {
                                        commitListenerArray[n3].commit(applyEvent);
                                    }
                                    catch (RuntimeException runtimeException) {
                                        ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)runtimeException);
                                    }
                                    --n3;
                                }
                                break block17;
                            }
                            catch (TraversalException traversalException2) {
                                n = n3 + 1;
                                break;
                            }
                        }
                        if (applyEvent == null) {
                            applyEvent = new ApplyEvent(traversableContext);
                        }
                        try {
                            commitListenerArray[n2].checkCommit(applyEvent);
                        }
                        catch (RuntimeException runtimeException) {
                            ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)runtimeException);
                        }
                        --n2;
                    }
                    while (true) {
                        if (n >= commitListenerArray.length) {
                            throw traversalException2;
                        }
                        try {
                            commitListenerArray[n].rollback(applyEvent);
                        }
                        catch (RuntimeException runtimeException) {
                            ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)runtimeException);
                        }
                        ++n;
                    }
                }
            }
            super.doFinish();
            return;
        }
        catch (TraversalException traversalException) {
            traversalException.showMessageDialog((Component)((Object)this));
        }
    }

    protected void doNext() {
        TraversableContext traversableContext = this.exitCurrentPanel(1);
        if (traversableContext != null) {
            try {
                Object object;
                if (this._curFsmStateInfo != null) {
                    Traversable traversable = this._curFsmStateInfo.getTraversable(this);
                    object = traversable.getExitTransition();
                    this._curFsmStateInfo.getStep().setExpectedTransition(object);
                } else {
                    object = null;
                }
                this.gotoPanel(this._fsm.nextState(object), traversableContext);
            }
            catch (FSMTransitionException fSMTransitionException) {
                this.handleFSMTransitionException(fSMTransitionException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void doPrevious() {
        TraversableContext traversableContext = this.exitCurrentPanel(2);
        if (traversableContext != null) {
            try {
                this.gotoPanel(this._fsm.previousState(), traversableContext);
            }
            catch (FSMTransitionException fSMTransitionException) {
                this.handleFSMTransitionException(fSMTransitionException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void doCancel() {
        if (this._commitListeners != null) {
            ApplyEvent applyEvent = null;
            CommitListener[] commitListenerArray = (CommitListener[])this._commitListeners.getListeners(CommitListener.class);
            int n = commitListenerArray.length - 1;
            while (n >= 0) {
                if (applyEvent == null) {
                    TraversableContext traversableContext = new TraversableContext(this._data, 2);
                    traversableContext.setWizardCallbacks(this._wc);
                    applyEvent = new ApplyEvent(traversableContext);
                }
                try {
                    commitListenerArray[n].cancel(applyEvent);
                }
                catch (RuntimeException runtimeException) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)runtimeException);
                }
                --n;
            }
        }
        super.doCancel();
    }

    private WizardDialog getDialogImpl(Frame frame, Dialog dialog) {
        if (this._dialog == null) {
            this._dialog = dialog != null ? new Dlg(this, dialog) : (frame != null ? new Dlg(this, frame) : new Dlg(this));
        }
        if (this._curFsmStateInfo != null) {
            this.updatePageTitle(this._curFsmStateInfo);
        }
        return this._dialog;
    }

    private void handleFSMTransitionException(FSMTransitionException fSMTransitionException) {
        TraversalException traversalException = new TraversalException("Internal error in FSM: " + fSMTransitionException.getLocalizedMessage());
        FSMWizard fSMWizard = this._dialog != null ? (Component)this._dialog : this;
        ExceptionDialog.showExceptionDialog((Component)((Object)fSMWizard), (Throwable)traversalException);
    }

    private void enableButtons(Boolean bl, Boolean bl2, Boolean bl3) {
        boolean bl4 = bl == null ? this._fsm.getStepNumber() > 1 : bl;
        this._mainPage.setCanGoBack(bl4);
        boolean bl5 = bl2 == null ? this._fsm.inFinalState() ^ true : bl2;
        boolean bl6 = bl3 == null ? this._fsm.inFinalState() : bl3.booleanValue();
        boolean bl7 = bl5 || bl6;
        this._mainPage.setCanAdvance(bl7);
        if (bl7) {
            this._postfixPage.setEnabled(bl5);
            if (bl5) {
                this.setMustFinish(bl6 ^ true);
            }
        }
    }

    private void updateAccessibleDescription(String string) {
        this._mainPage.setAccessibleDescription(string);
    }

    private void updateTitle(String string) {
        this._pageTitle = string;
        this.updateTitle();
    }

    private void updateTitle() {
        if (this._dialog != null) {
            int n = this._fsm.getStepNumber();
            int n2 = this._fsm.getExpectedStepCount();
            if (!this._showStepNumber || n == 1 && this._welcomePageAdded || n == n2 && this._finishPageAdded) {
                this.updateTitleImpl(PanelsArb.format(31, this._wizardTitle != null ? this._wizardTitle : "", this._pageTitle));
            } else {
                int n3 = n;
                int n4 = n2;
                if (this._welcomePageAdded) {
                    --n3;
                    --n4;
                }
                if (this._finishPageAdded) {
                    --n4;
                }
                this.updateTitleImpl(PanelsArb.format(30, this._wizardTitle != null ? this._wizardTitle : "", PanelsArb.format(29, new Integer(n3), new Integer(n4)), this._pageTitle));
            }
        }
    }

    private void updateTitleImpl(String string) {
        this._dialog.setTitle(string);
        this.updateAccessibleDescription(string);
    }

    private void updateExpectedTransition(Object object) {
        this._curFsmStateInfo.getStep().setExpectedTransition(object);
        this._fsm.countExpectedSteps();
        this.updateTitle();
    }

    private TraversableContext exitCurrentPanel(int n) {
        TraversableContext traversableContext = new TraversableContext(this._data, n);
        traversableContext.setWizardCallbacks(this._wc);
        if (this._curFsmStateInfo != null) {
            try {
                Traversable traversable = this._curFsmStateInfo.getTraversable(this);
                traversable.onExit(traversableContext);
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)this));
                TraversableContext traversableContext2 = null;
                return traversableContext2;
            }
        }
        return traversableContext;
    }

    private void gotoPanel(FSMStateInfo fSMStateInfo, TraversableContext traversableContext) {
        this.enableButtons(null, null, null);
        Traversable traversable = fSMStateInfo.getTraversable(this);
        this._skipCurStep = false;
        this._curFsmStateInfo = fSMStateInfo;
        this.updatePageTitle(fSMStateInfo);
        try {
            traversable.onEntry(traversableContext);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this._skipCurStep) {
            switch (traversableContext.getDirection()) {
                case 1: {
                    if (this._fsm.isHalted()) break;
                    this.doNext();
                    return;
                }
                case 2: {
                    if (this._fsm.isStarting()) break;
                    this.doPrevious();
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.updateInteractivePanel(traversable.getComponent());
        this.updateHelpID(fSMStateInfo.getStep(), traversable);
        this.resetFocus((WizardPage)this._mainPage);
    }

    private void updateHelpID(Step step, Traversable traversable) {
        JComponent jComponent = (JComponent)this._mainPage.getContent();
        HelpUtils.setHelpID((JComponent)jComponent, null);
        String string = MetaTraversable.findHelpID(step, traversable);
        HelpUtils.setHelpID((JComponent)jComponent, (String)string);
    }

    private void updateInitialFocus(Component component) {
        this._mainPage.setInitialFocus(component);
    }

    private void updateInteractivePanel(Component component) {
        this._interactivePanel.removeAll();
        this._interactivePanel.add(component, "Center");
        this._interactivePanel.updateUI();
    }

    private void updatePageTitle(FSMStateInfo fSMStateInfo) {
        String string = fSMStateInfo.getStep().getPageTitle();
        if (!ModelUtil.hasLength((String)string)) {
            Traversable traversable = this._curFsmStateInfo.getTraversable(this);
            if (traversable instanceof DefaultTraversablePanel) {
                string = ((DefaultTraversablePanel)traversable).getDefaultTitle();
            }
            if (!ModelUtil.hasLength((String)string)) {
                string = this._pageTitle;
            }
        }
        this.updateTitle(string);
    }

    static void mav$finishImpl(FSMWizard fSMWizard, TraversableContext traversableContext) {
        fSMWizard.finishImpl(traversableContext);
    }

    static void mav$updateInitialFocus(FSMWizard fSMWizard, Component component) {
        fSMWizard.updateInitialFocus(component);
    }

    static void mav$updateExpectedTransition(FSMWizard fSMWizard, Object object) {
        fSMWizard.updateExpectedTransition(object);
    }

    static void wa$_showStepNumber(FSMWizard fSMWizard, boolean bl) {
        fSMWizard._showStepNumber = bl;
    }

    static void mav$updateTitle(FSMWizard fSMWizard, String string) {
        fSMWizard.updateTitle(string);
    }

    static void mav$updateAccessibleDescription(FSMWizard fSMWizard, String string) {
        fSMWizard.updateAccessibleDescription(string);
    }

    static void wa$_skipCurStep(FSMWizard fSMWizard, boolean bl) {
        fSMWizard._skipCurStep = bl;
    }

    static void mav$enableButtons(FSMWizard fSMWizard, Boolean bl, Boolean bl2, Boolean bl3) {
        fSMWizard.enableButtons(bl, bl2, bl3);
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ TraversableContext v$tc;
        final /* synthetic */ FSMWizard this$0;

        public void run() {
            FSMWizard.mav$finishImpl(this.this$0, this.v$tc);
        }

        public 1(FSMWizard fSMWizard, TraversableContext traversableContext) {
            this.v$tc = traversableContext;
            this.this$0 = fSMWizard;
        }
    }

    private final class WC
    extends WizardCallbacks {
        public void addCommitListener(CommitListener commitListener) {
            FSMWizard.this.addCommitListener(commitListener);
        }

        public void removeCommitListener(CommitListener commitListener) {
            FSMWizard.this.removeCommitListener(commitListener);
        }

        public void wizardEnableButtons(Boolean bl, Boolean bl2, Boolean bl3) {
            FSMWizard.mav$enableButtons(FSMWizard.this, bl, bl2, bl3);
        }

        public void wizardSkipCurrentStep() {
            FSMWizard.wa$_skipCurStep(FSMWizard.this, true);
        }

        public void wizardUpdateAccessibleDescription(String string) {
            FSMWizard.mav$updateAccessibleDescription(FSMWizard.this, string);
        }

        public void wizardUpdateImage(Image image) {
            FSMWizard.this.updateImage(image);
        }

        public void wizardUpdateTitle(String string, Boolean bl) {
            if (bl != null) {
                FSMWizard.wa$_showStepNumber(FSMWizard.this, bl);
            }
            FSMWizard.mav$updateTitle(FSMWizard.this, string);
        }

        public void wizardUpdateExpectedTransition(Object object) {
            FSMWizard.mav$updateExpectedTransition(FSMWizard.this, object);
        }

        public void wizardSetInitialFocus(Component component) {
            FSMWizard.mav$updateInitialFocus(FSMWizard.this, component);
        }

        public void nextPage() {
            FSMWizard.this.doNext();
        }

        public void previousPage() {
            FSMWizard.this.doPrevious();
        }

        private WC() {
        }

        WC(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class Dlg
    extends WizardDialog {
        Dlg(FSMWizard fSMWizard2) {
            super((BaseWizard)fSMWizard2);
        }

        Dlg(FSMWizard fSMWizard2, Frame frame) {
            super((BaseWizard)fSMWizard2, frame);
        }

        Dlg(FSMWizard fSMWizard2, Dialog dialog) {
            super((BaseWizard)fSMWizard2, dialog);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension.width > 600) {
                dimension.width = 600;
            }
            if (dimension.height > 400) {
                dimension.height = 400;
            }
            return dimension;
        }
    }
}

