/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.awt.Frame;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.CommitNotifier;
import oracle.ide.resource.WizardArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.FinishPanel;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;

public class GenericWizardLauncher
implements CommitNotifier {
    private ArrayList _stepList;
    private boolean _showStepNumber;
    private String _wizardTitle;
    private boolean _welcomePageAdded;
    private boolean _finishPageAdded;
    private Image _wizardImage;
    private EventListenerList _listeners;
    private Namespace _namespace;
    public static final String CONTEXT_KEY = "Context";
    public static final String WIZARD_NAME_KEY = "WizardName";

    void $init$() {
        this._stepList = new ArrayList();
        this._showStepNumber = false;
        this._wizardTitle = null;
        this._welcomePageAdded = false;
        this._finishPageAdded = false;
        this._wizardImage = null;
        this._listeners = null;
        this._namespace = new Namespace();
    }

    public GenericWizardLauncher(Context context) {
        this.$init$();
        this._namespace.put(CONTEXT_KEY, (Object)context);
    }

    public GenericWizardLauncher(Context context, String string) {
        this(context);
        this._wizardTitle = string;
    }

    public final Namespace getNamespace() {
        return this._namespace;
    }

    public void setWizardTitle(String string) {
        this._wizardTitle = string;
    }

    public String getWizardTitle() {
        return this._wizardTitle;
    }

    public void setWizardImage(Image image) {
        this._wizardImage = image;
    }

    public Image getWizardImage() {
        return this._wizardImage;
    }

    public boolean addWelcomePage(String string, String string2, String string3) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)string3)) {
            step.setPageTitle(string3);
        }
        this._addWelcomeStep(step, string2);
        return true;
    }

    public void addWelcomePage(String string, String string2, String string3, String string4) {
        Class[] classArray = new Class[4];
        int n = 0;
        while (n < 4) {
            classArray[n] = String.class;
            ++n;
        }
        Object[] objectArray = new Object[]{this._wizardTitle, string, string2, string3};
        this._addWelcomeStep(new Step(WelcomePanel.class, classArray, objectArray), string4);
    }

    public void addFinishPage(String string) {
        this.addFinishPage(WizardArb.getString(5), "", WizardArb.getString(4), string);
    }

    public void addFinishPage(String string, String string2, String string3, String string4) {
        Class[] classArray = new Class[]{String.class, String.class};
        Object[] objectArray = new Object[]{string, string2};
        Step step = new Step(FinishPanel.class, classArray, objectArray);
        if (!ModelUtil.hasLength((String)string3)) {
            string3 = WizardArb.getString(4);
        }
        step.setPageTitle(string3);
        this._addFinishStep(step, string4);
    }

    public boolean addFinishPage(String string, String string2, String string3) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)string3)) {
            step.setPageTitle(string3);
        }
        this._addFinishStep(step, string2);
        return true;
    }

    public boolean addPage(String string) {
        return this.addPage(string, null, null);
    }

    public boolean addPage(String string, String string2) {
        return this.addPage(string, string2, null);
    }

    public boolean addPage(String string, String string2, String string3) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)string2)) {
            step.setHelpID(string2);
        }
        if (ModelUtil.hasLength((String)string3)) {
            step.setPageTitle(string3);
        }
        this.addPage(step);
        return true;
    }

    public void addPage(Step step) {
        this._stepList.add(step);
    }

    public void addPages(Step[] stepArray) {
        this._stepList.addAll(Arrays.asList(stepArray));
    }

    public boolean runGenericWizard() {
        FSMWizard fSMWizard = new FSMWizard(this._getTraversableSteps(), this._namespace);
        fSMWizard.setWizardTitle(this._wizardTitle);
        fSMWizard.setShowStepNumber(this._showStepNumber);
        fSMWizard.setWelcomePageAdded(this._welcomePageAdded);
        fSMWizard.setFinishPageAdded(this._finishPageAdded);
        if (this._wizardImage != null) {
            fSMWizard.updateImage(this._wizardImage);
        }
        if (ModelUtil.hasLength((String)this.getWizardTitle())) {
            this._namespace.put(WIZARD_NAME_KEY, (Object)this.getWizardTitle());
        }
        if (this._listeners != null) {
            CommitListener[] commitListenerArray = (CommitListener[])this._listeners.getListeners(CommitListener.class);
            int n = 0;
            while (n < commitListenerArray.length) {
                fSMWizard.addCommitListener(commitListenerArray[n]);
                ++n;
            }
        }
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)((Object)Ide.getMainWindow()));
        return WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    public boolean getShowStepNumber() {
        return this._showStepNumber;
    }

    public void setShowStepNumber(boolean bl) {
        this._showStepNumber = bl;
    }

    public void addCommitListener(CommitListener commitListener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(CommitListener.class, commitListener);
    }

    public void removeCommitListener(CommitListener commitListener) {
        if (this._listeners != null) {
            this._listeners.remove(CommitListener.class, commitListener);
        }
    }

    private void _addWelcomeStep(Step step, String string) {
        if (ModelUtil.hasLength((String)string)) {
            step.setHelpID(string);
        }
        this._stepList.add(0, step);
        this._welcomePageAdded = true;
    }

    private void _addFinishStep(Step step, String string) {
        if (ModelUtil.hasLength((String)string)) {
            step.setHelpID(string);
        }
        this._stepList.add(step);
        this._finishPageAdded = true;
    }

    private Step[] _getTraversableSteps() {
        if (!this._finishPageAdded) {
            this.addFinishPage(null);
        }
        return this._stepList.toArray(new Step[this._stepList.size()]);
    }
}

