/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.MenuSpec;
import oracle.ide.wizard.Wizard;

public final class WizardManager {
    public static final int OPEN_WIZARD_CMD_ID = Ide.findOrCreateCmdID("OpenWizardCommand");
    public static final String OPEN_WIZARD_CMD = "oracle.ide.cmd.OpenWizardCommand";
    private static WizardManager _instance = new WizardManager();
    private final ArrayList _wizards;
    private WizardKeyContext _keyContext;
    private IntHashMap _actionHash;
    private final Controller _controller;

    void $init$() {
        this._wizards = new ArrayList();
        this._actionHash = new IntHashMap();
        this._controller = new L(null);
    }

    public static WizardManager getInstance() {
        return _instance;
    }

    public synchronized Wizard getWizard(Class clazz) {
        String string = clazz.getName();
        try {
            int n = this._wizards.size();
            int n2 = 0;
            while (n2 < n) {
                Wizard wizard = (Wizard)this._wizards.get(n2);
                Class<?> clazz2 = wizard.getClass();
                if (clazz2 != null && clazz2.getName().equals(string)) {
                    Wizard wizard2 = wizard;
                    return wizard2;
                }
                ++n2;
            }
            Wizard wizard = (Wizard)((Object)AddinManager.getAddinManager().getAddin(clazz));
            if (wizard == null) {
                try {
                    wizard = (Wizard)clazz.newInstance();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Wizard wizard3 = null;
                    return wizard3;
                }
            }
            this.registerWizard(wizard);
            Wizard wizard4 = wizard;
            return wizard4;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Wizard getWizard(String string) {
        try {
            Wizard wizard = this.getWizard(Class.forName(string));
            return wizard;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWizard(Wizard wizard) {
        if (wizard != null) {
            ArrayList arrayList = this._wizards;
            synchronized (arrayList) {
                if (!this._wizards.contains(wizard)) {
                    this._wizards.add(wizard);
                }
            }
            this.addToToolsMenuIfNonNullMenuSpec(wizard);
        }
    }

    private void addToToolsMenuIfNonNullMenuSpec(Wizard wizard) {
        MenuSpec menuSpec = wizard.getMenuSpecification();
        if (menuSpec == null) {
            return;
        }
        Menubar menubar = Ide.getMenubar();
        ResourceBundle resourceBundle = menuSpec.getResourceBundle();
        String string = wizard.getClass().getName();
        int n = Ide.findOrCreateCmdID(string);
        this._actionHash.put(n, string);
        IdeAction ideAction = resourceBundle != null ? (resourceBundle instanceof ArrayResourceBundle ? IdeAction.get(n, string, menuSpec.label, IdeMainWindow.ACTION_CATEGORY_TOOLS, menuSpec.mnemonic, (ArrayResourceBundle)resourceBundle, (Integer)menuSpec.getBundleKey(), (Object)wizard, false) : IdeAction.get(n, string, menuSpec.label, IdeMainWindow.ACTION_CATEGORY_TOOLS, menuSpec.mnemonic, resourceBundle, (String)menuSpec.getBundleKey(), (Object)wizard, false)) : IdeAction.get(n, string, menuSpec.label, IdeMainWindow.ACTION_CATEGORY_TOOLS, menuSpec.mnemonic, menuSpec.getIcon(), wizard, false);
        if (this._keyContext == null) {
            this._keyContext = new WizardKeyContext(null);
            Ide.getKeyStrokeContextRegistry().addContext(this._keyContext);
        }
        this._keyContext.addAction(ideAction);
        ideAction.addController(this._controller);
        JMenuItem jMenuItem = menubar.createMenuItem(ideAction);
        if (jMenuItem != null) {
            JMenu jMenu = MenuManager.getJMenu("Tools");
            menubar.add(jMenuItem, jMenu, MenuConstants.SECTION_TOOLS_ADDINS);
        }
    }

    public boolean invokeWizard(Wizard wizard, Context context, String[] stringArray, String[] stringArray2) {
        boolean bl = false;
        if (wizard != null) {
            try {
                Project project;
                Wizard.setLegacyParams(context, stringArray);
                bl = wizard.invoke(context);
                if (bl && context != null && stringArray2 != null && (project = context.getProject()) != null) {
                    TechnologyScopeConfiguration.getInstance(project).updateTechnologyScope(stringArray2);
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                ExceptionDialog.showExceptionDialog(context, throwable);
            }
        }
        return bl;
    }

    public void invokeSecondaryWizard(Wizard wizard, Context context, String[] stringArray, String[] stringArray2) {
        2 var5_5 = new 2(this, wizard, context, stringArray, stringArray2);
        IdeUtil.invokeAfterRepaint(new 1(this, var5_5));
    }

    private WizardManager() {
        this.$init$();
    }

    private boolean isWizardAction(IdeAction ideAction) {
        return this._actionHash.containsKey(ideAction.getCommandId());
    }

    static boolean mav$isWizardAction(WizardManager wizardManager, IdeAction ideAction) {
        return wizardManager.isWizardAction(ideAction);
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ Wizard v$wizard;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ String[] v$params;
        private final /* synthetic */ String[] v$technologyKeys;
        final /* synthetic */ WizardManager this$0;

        public void run() {
            this.this$0.invokeWizard(this.v$wizard, this.v$context, this.v$params, this.v$technologyKeys);
        }

        public 2(WizardManager wizardManager, Wizard wizard, Context context, String[] stringArray, String[] stringArray2) {
            this.v$technologyKeys = stringArray2;
            this.v$params = stringArray;
            this.v$context = context;
            this.v$wizard = wizard;
            this.this$0 = wizardManager;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Runnable v$r;
        final /* synthetic */ WizardManager this$0;

        public void run() {
            IdeUtil.invokeAfterRepaint(this.v$r);
        }

        public 1(WizardManager wizardManager, Runnable runnable) {
            this.v$r = runnable;
            this.this$0 = wizardManager;
        }
    }

    private static class WizardKeyContext
    implements KeyStrokeContext {
        private static final String KEY = WizardKeyContext.class.getName();
        private HashSet _actions;

        void $init$() {
            this._actions = new HashSet();
        }

        public String getAcceleratorFile() {
            return null;
        }

        public List getAllPresets() {
            return null;
        }

        public String getName() {
            return KEY;
        }

        public KeyStrokeMap getPresetKeyStrokeMap(Object object, boolean bl) {
            return null;
        }

        public Set getAllActions(boolean bl) {
            return bl ? this._actions : null;
        }

        void addAction(IdeAction ideAction) {
            this._actions.add(ideAction);
        }

        private WizardKeyContext() {
            this.$init$();
        }

        WizardKeyContext(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class L
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Command command = null;
            if (WizardManager.mav$isWizardAction(WizardManager.this, ideAction)) {
                String string = AddinManager.getAddinManager().getCommand(OPEN_WIZARD_CMD_ID, WizardManager.OPEN_WIZARD_CMD);
                command = CommandProcessor.createCommand(string, context);
                command.setData(ideAction.getValue("UserData"));
            }
            if (command != null) {
                try {
                    commandProcessor.invoke(command);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog(context, (Throwable)exception);
                }
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (WizardManager.mav$isWizardAction(WizardManager.this, ideAction)) {
                Object object = ideAction.getValue("UserData");
                Wizard wizard = (Wizard)object;
                ideAction.setEnabled(wizard.isAvailable(context));
                return true;
            }
            return false;
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

