/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.xml;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.Node;
import oracle.ide.model.NodeInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizerException;
import oracle.ide.model.XMLDataNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.NodeInfoLoader;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;

public final class XMLRecognizer
extends Recognizer {
    private static final XMLRecognizer _instance = new XMLRecognizer();
    private static final HashMap _xmlExtensions = new HashMap();
    private static final HashMap _nsElemToClass = new HashMap();
    private static final HashMap _xsiToClass = new HashMap();
    private static final HashMap _doctypeToClass = new HashMap();
    private static final HashMap _rootElementToClass = new HashMap();
    private static final HashMap _classToNodeInfo = new HashMap();

    static {
        XMLRecognizer.treatExtensionAsXML(".xml");
    }

    private XMLRecognizer() {
    }

    public static XMLRecognizer getInstance() {
        return _instance;
    }

    public static void treatExtensionAsXML(String string) {
        XMLRecognizer.treatExtensionAsXML(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void treatExtensionAsXML(String string, NodeInfoLoader nodeInfoLoader) {
        XMLRecognizer.mapExtensionToXML(string);
        if (ModelUtil.hasLength((String)string)) {
            File file = XMLRecognizer.sanitizeExtension(string);
            HashMap hashMap = _xmlExtensions;
            synchronized (hashMap) {
                _xmlExtensions.put(file, nodeInfoLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapNamespaceElemToClass(String string, String string2, Class clazz) {
        if (clazz != null && ModelUtil.hasLength((String)string)) {
            HashMap hashMap = _nsElemToClass;
            synchronized (hashMap) {
                _nsElemToClass.put(new NSElem(string, string2), clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapSchemaInstanceToClass(String string, String string2, Class clazz) {
        if (clazz != null && ModelUtil.hasLength((String)string)) {
            HashMap hashMap = _xsiToClass;
            synchronized (hashMap) {
                _xsiToClass.put(new NSElem(string, string2), clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapDoctypeToClass(String string, String string2, Class clazz) {
        if (clazz != null && (string != null || string2 != null)) {
            Doctype doctype = new Doctype(string, string2);
            HashMap hashMap = _doctypeToClass;
            synchronized (hashMap) {
                _doctypeToClass.put(doctype, clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapRootElementToClass(String string, Class clazz) {
        if (clazz != null && ModelUtil.hasLength((String)string)) {
            HashMap hashMap = _rootElementToClass;
            synchronized (hashMap) {
                _rootElementToClass.put(string, clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNodeInfo(NodeInfo nodeInfo) {
        if (nodeInfo != null) {
            Class clazz = nodeInfo.getDataClass();
            String string = nodeInfo.getXMLRootElement();
            String string2 = nodeInfo.getXMLNamespaceURI();
            if (ModelUtil.hasLength((String)string2)) {
                XMLRecognizer.mapNamespaceElemToClass(string2, string, clazz);
                Object2Dom.registerNamespaceElem(clazz, string2, string);
            }
            XMLRecognizer.mapRootElementToClass(nodeInfo.getXMLRootElement(), clazz);
            HashMap hashMap = _classToNodeInfo;
            synchronized (hashMap) {
                _classToNodeInfo.put(clazz, nodeInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeInfo findNodeInfo(Class clazz) {
        if (clazz == null) {
            return null;
        }
        HashMap hashMap = _classToNodeInfo;
        synchronized (hashMap) {
            NodeInfo nodeInfo = (NodeInfo)_classToNodeInfo.get(clazz);
            return nodeInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class recognize(URL uRL) {
        block27: {
            try {
                String string;
                StartElementPacket startElementPacket = XMLUtil.getXMLRootElement(uRL);
                if (startElementPacket == null) break block27;
                XMLRecognizer.ensureNodeInfosLoaded(XMLRecognizer.sanitizeExtension(URLFileSystem.getSuffix(uRL)));
                if (ModelUtil.hasLength((String)startElementPacket.namespaceURI)) {
                    String string2;
                    if (startElementPacket.attributes != null && ModelUtil.hasLength((String)(string2 = startElementPacket.attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation")))) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2);
                        while (stringTokenizer.hasMoreTokens()) {
                            String string3 = stringTokenizer.nextToken();
                            if (!startElementPacket.namespaceURI.equals(string3)) continue;
                            if (!stringTokenizer.hasMoreTokens()) break;
                            String string4 = stringTokenizer.nextToken();
                            HashMap hashMap = _xsiToClass;
                            synchronized (hashMap) {
                                NSElem nSElem = new NSElem(string4, startElementPacket.localName);
                                Object v = _xsiToClass.get(nSElem);
                                if (v != null) {
                                    Class clazz = (Class)v;
                                    return clazz;
                                }
                            }
                        }
                    }
                    HashMap hashMap = _nsElemToClass;
                    synchronized (hashMap) {
                        NSElem nSElem = new NSElem(startElementPacket.namespaceURI, startElementPacket.localName);
                        Object v = _nsElemToClass.get(nSElem);
                        if (v != null) {
                            Class clazz = (Class)v;
                            return clazz;
                        }
                    }
                }
                if (startElementPacket.attributes != null && ModelUtil.hasLength((String)(string = startElementPacket.attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")))) {
                    HashMap hashMap = _xsiToClass;
                    synchronized (hashMap) {
                        NSElem nSElem = new NSElem(string, startElementPacket.localName);
                        Object v = _xsiToClass.get(nSElem);
                        if (v != null) {
                            Class clazz = (Class)v;
                            return clazz;
                        }
                    }
                }
                if (startElementPacket.publicId != null || startElementPacket.systemId != null) {
                    HashMap hashMap = _doctypeToClass;
                    synchronized (hashMap) {
                        Doctype doctype = new Doctype(startElementPacket.publicId, startElementPacket.systemId);
                        Object v = _doctypeToClass.get(doctype);
                        if (v != null) {
                            Class clazz = (Class)v;
                            return clazz;
                        }
                    }
                }
                HashMap hashMap = _rootElementToClass;
                synchronized (hashMap) {
                    Object v = _rootElementToClass.get(startElementPacket.localName);
                    if (v != null) {
                        Class clazz = (Class)v;
                        return clazz;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Node create(URL uRL, Class clazz) throws IllegalAccessException, InstantiationException {
        if (uRL != null && clazz != null) {
            NodeInfo nodeInfo = XMLRecognizer.findNodeInfo(clazz);
            if (nodeInfo != null) {
                Class clazz2 = nodeInfo.getNodeClass();
                XMLDataNode xMLDataNode = (XMLDataNode)super.create(uRL, clazz2);
                xMLDataNode.setNodeInfo(nodeInfo);
                return xMLDataNode;
            }
            return super.create(uRL, clazz);
        }
        return null;
    }

    public URL validate(URL uRL, URL uRL2) throws RecognizerException {
        String string = URLFileSystem.getSuffix(uRL);
        if (XMLRecognizer.isXmlExtension(string)) {
            return uRL;
        }
        if (this.recognize(uRL2) != null) {
            String string2 = URLFileSystem.getSuffix(uRL2);
            try {
                String string3 = uRL.getPath() + string2;
                URL uRL3 = URLFactory.replacePathPart(uRL, string3);
                return uRL3;
            }
            catch (Exception exception) {
                throw new RecognizerException("Internal exception: Unable to build new URL: " + exception.getLocalizedMessage());
            }
        }
        throw new RecognizerException("Internal exception: Old URL not recognized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureNodeInfosLoaded(File file) {
        HashMap hashMap = _xmlExtensions;
        synchronized (hashMap) {
            Object v = _xmlExtensions.get(file);
            if (v != null) {
                ((NodeInfoLoader)v).loadNodeInfos();
                _xmlExtensions.put(file, null);
            }
        }
    }

    private static final class NSElem {
        final String namespaceURI;
        final String localElemName;
        private Integer _hashCode;

        NSElem(String string, String string2) {
            this.namespaceURI = string;
            this.localElemName = string2;
        }

        public boolean equals(Object object) {
            NSElem nSElem = (NSElem)object;
            return ModelUtil.areEqual((Object)this.namespaceURI, (Object)nSElem.namespaceURI) && ModelUtil.areEqual((Object)this.localElemName, (Object)nSElem.localElemName);
        }

        public int hashCode() {
            if (this._hashCode == null) {
                int n = this.namespaceURI != null ? this.namespaceURI.hashCode() : 0;
                int n2 = this.localElemName != null ? this.localElemName.hashCode() : 0;
                this._hashCode = new Integer(n ^ n2);
            }
            return this._hashCode;
        }
    }

    private static final class Doctype {
        final String publicId;
        final String systemId;
        private Integer _hashCode;

        Doctype(String string, String string2) {
            this.publicId = string;
            this.systemId = string2;
        }

        public boolean equals(Object object) {
            Doctype doctype = (Doctype)object;
            if (this.publicId == null || doctype.publicId == null) {
                return ModelUtil.areEqual((Object)this.systemId, (Object)doctype.systemId);
            }
            return this.publicId.equals(doctype.publicId);
        }

        public int hashCode() {
            if (this._hashCode == null) {
                int n = this.publicId != null ? this.publicId.hashCode() : (this.systemId != null ? this.systemId.hashCode() : 0);
                this._hashCode = new Integer(n);
            }
            return this._hashCode;
        }
    }
}

