/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import oracle.ide.Version;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Encodings;
import oracle.ide.xml.RootElementHandler;
import oracle.ide.xml.SAXParserDoneException;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLPrinter;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLUtil {
    public static StartElementPacket getXMLRootElement(URL uRL) throws FileNotFoundException {
        try {
            StartElementPacket startElementPacket = XMLUtil.getXMLRootElement(URLFileSystem.openInputStream(uRL));
            return startElementPacket;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            StartElementPacket startElementPacket = null;
            return startElementPacket;
        }
    }

    public static StartElementPacket getXMLRootElement(InputStream inputStream) {
        return XMLUtil.getXMLRootElementImpl(inputStream, null);
    }

    public static StartElementPacket getXMLRootElement(Reader reader) {
        return XMLUtil.getXMLRootElementImpl(null, reader);
    }

    public static XSLStylesheet loadXSLT(URL uRL) throws IOException, SAXException, XSLException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        dOMParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        dOMParser.parse(uRL);
        XMLDocument xMLDocument = dOMParser.getDocument();
        Element element = xMLDocument.getDocumentElement();
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/1999/XSL/Transform", "output");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                element2.setAttribute("encoding", Encodings.getDefaultIanaEncoding());
            }
            ++n2;
        }
        return new XSLProcessor().newXSLStylesheet(xMLDocument);
    }

    public static void transformXML(URL uRL, URL uRL2) throws IOException, SAXException, XSLException {
        XSLStylesheet xSLStylesheet = XMLUtil.loadXSLT(uRL2);
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        dOMParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        dOMParser.parse(uRL);
        XSLProcessor xSLProcessor = new XSLProcessor();
        OutputStream outputStream = null;
        try {
            outputStream = URLFileSystem.openOutputStream(uRL);
            xSLProcessor.processXSL(xSLStylesheet, dOMParser.getDocument(), outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeXML(XMLDocument xMLDocument, URL uRL) throws IOException {
        OutputStream outputStream = URLFileSystem.openOutputStream(uRL);
        XMLUtil.writeXML(xMLDocument, outputStream);
    }

    public static void writeXML(XMLDocument xMLDocument, OutputStream outputStream) throws IOException {
        if (xMLDocument == null || outputStream == null) {
            return;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            xMLDocument.print((OutputStream)bufferedOutputStream);
        }
        finally {
            if (bufferedOutputStream != null) {
                try {
                    bufferedOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static void writeXML(XMLDocument xMLDocument, PrintWriter printWriter) throws IOException {
        XMLUtil.writeXML(xMLDocument, printWriter, -1);
    }

    public static void writeXML(XMLDocument xMLDocument, PrintWriter printWriter, int n) throws IOException {
        XMLUtil.writeXML(xMLDocument, printWriter, n, false, 8);
    }

    public static void writeXML(XMLDocument xMLDocument, PrintWriter printWriter, int n, boolean bl, int n2) throws IOException {
        if (xMLDocument == null || printWriter == null) {
            return;
        }
        try {
            if (n >= 0) {
                xMLDocument.print((PrintDriver)new XMLPrinter(printWriter, n, bl, n2));
            } else {
                xMLDocument.print(printWriter);
            }
        }
        finally {
            printWriter.close();
        }
    }

    public static String toNamespaceURI(String string) {
        StringBuffer stringBuffer = new StringBuffer(Version.BASE_NAMESPACE_URI);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String toString(XMLDocument xMLDocument) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            xMLDocument.print(printWriter);
            stringWriter.close();
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException iOException) {
            String string = "";
            return string;
        }
    }

    public static String getElementValue(URL uRL, String string) {
        try {
            String string2 = XMLUtil.getElementValue(new InputSource(uRL.openStream()), string);
            return string2;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return null;
        }
    }

    public static String getElementValue(File file, String string) {
        try {
            String string2 = XMLUtil.getElementValue(file.toURL(), string);
            return string2;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return null;
        }
    }

    private static StartElementPacket getXMLRootElementImpl(InputStream inputStream, Reader reader) {
        SAXParser sAXParser = new SAXParser();
        sAXParser.setValidationMode(0);
        RootElementHandler rootElementHandler = new RootElementHandler();
        sAXParser.setContentHandler((ContentHandler)rootElementHandler);
        sAXParser.setEntityResolver((EntityResolver)rootElementHandler);
        try {
            try {
                if (inputStream != null) {
                    sAXParser.parse(inputStream);
                } else {
                    sAXParser.parse(reader);
                }
            }
            catch (SAXParserDoneException sAXParserDoneException) {
            }
            catch (XMLParseException xMLParseException) {
                StartElementPacket startElementPacket = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return startElementPacket;
            }
            catch (Exception exception) {
                StartElementPacket startElementPacket = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                return startElementPacket;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        StartElementPacket startElementPacket = rootElementHandler.getRootElement();
        return startElementPacket;
    }

    private static String getElementValue(InputSource inputSource, String string) {
        ElementValueHandler elementValueHandler = new ElementValueHandler(null);
        elementValueHandler.setTargetElement(string);
        try {
            SAXParser sAXParser = new SAXParser();
            sAXParser.setContentHandler((ContentHandler)elementValueHandler);
            sAXParser.parse(inputSource);
        }
        catch (SAXParserDoneException sAXParserDoneException) {
            String string2 = elementValueHandler.getValue();
            return string2;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return null;
    }

    private XMLUtil() {
    }

    private static class ElementValueHandler
    extends DefaultHandler {
        private String _targetElement;
        private String _currentElement;
        private String _value;

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this._currentElement = string2;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            String string = new String(cArray, n, n2);
            if (this._currentElement.equals(this._targetElement)) {
                this._value = string;
                throw new SAXParserDoneException();
            }
        }

        public String getValue() {
            return this._value;
        }

        public void setTargetElement(String string) {
            this._targetElement = string;
        }

        private ElementValueHandler() {
        }

        ElementValueHandler(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

