/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controls.FocusHierarchyEvent;
import oracle.ide.controls.FocusHierarchyListener;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.MainWindowImpl;

public class ActiveViewHandlerImpl
implements MainWindowImpl.ControllerContextImpl,
ChangeListener,
FocusHierarchyListener {
    private static final boolean DEBUG_TRACE_VIEW_CHANGES = Boolean.valueOf(Ide.getProperty("DEBUG_TRACE_VIEW_CHANGES", "false"));
    private static final boolean DEBUG_TRACE_FOCUS_CHANGES = Boolean.valueOf(Ide.getProperty("DEBUG_TRACE_FOCUS_CHANGES", "false"));
    private View _lastActiveView;
    private Hashtable _componentToView;
    private Hashtable _viewToComponent;
    private Hashtable _componentToControllerProvider;
    private ArrayList _activeViewListeners;
    private HashMap _cachedControllerStacks;

    void $init$() {
        this._componentToView = new Hashtable();
        this._viewToComponent = new Hashtable();
        this._componentToControllerProvider = new Hashtable();
        this._activeViewListeners = new ArrayList(2);
        this._cachedControllerStacks = new HashMap();
    }

    ActiveViewHandlerImpl() {
        this.$init$();
    }

    public synchronized void addDependant(Component component, View view) {
        this._componentToView.put(component, view);
        this._viewToComponent.put(view, component);
        this.clearControllerStacksCache();
    }

    public synchronized void removeDependant(View view) {
        block3: {
            if (view == null) break block3;
            try {
                Component component = (Component)this._viewToComponent.remove(view);
                if (component == null) break block3;
                this._componentToView.remove(component);
                this.clearControllerStacksCache();
                if (view == this.getLastActiveView()) {
                    this.solveActiveView(null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void removeDependant(Component component) {
        block0: {
            View view = (View)this._componentToView.get(component);
            if (view == null) break block0;
            this.removeDependant(view);
        }
    }

    public synchronized void addControllerProvider(Component component, ControllerProvider controllerProvider) {
        this._componentToControllerProvider.put(component, controllerProvider);
        this.clearControllerStacksCache();
    }

    public synchronized void removeControllerProvider(Component component) {
        this._componentToControllerProvider.remove(component);
        this.clearControllerStacksCache();
    }

    public synchronized void addActiveViewListener(ActiveViewListener activeViewListener) {
        if (!this._activeViewListeners.contains(activeViewListener)) {
            this._activeViewListeners.add(activeViewListener);
        }
    }

    public synchronized void removeActiveViewListener(ActiveViewListener activeViewListener) {
        this._activeViewListeners.remove(activeViewListener);
    }

    private synchronized void fireActiveViewChanged(ActiveViewEvent activeViewEvent) {
        int n = this._activeViewListeners.size();
        ActiveViewListener[] activeViewListenerArray = this._activeViewListeners.toArray(new ActiveViewListener[n]);
        int n2 = 0;
        while (n2 < n) {
            activeViewListenerArray[n2].activeViewChanged(activeViewEvent);
            ++n2;
        }
    }

    private void cacheControllerStack(View view, List list) {
        this._cachedControllerStacks.put(view, list);
    }

    private Object getCachedControllerStack(View view) {
        return this._cachedControllerStacks.get(view);
    }

    private void clearControllerStacksCache() {
        this._cachedControllerStacks.clear();
    }

    public View getLastActiveView() {
        return this._lastActiveView;
    }

    private void setActiveView(View view) {
        if (view != null && view != this._lastActiveView) {
            this.clearControllerStacksCache();
            if (DEBUG_TRACE_VIEW_CHANGES) {
                // empty if block
            }
            if (this._lastActiveView != null) {
                try {
                    this._lastActiveView.deactivate();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            ActiveViewEvent activeViewEvent = new ActiveViewEvent(this, this._lastActiveView, view);
            this._lastActiveView = view;
            if (this._lastActiveView != null) {
                try {
                    this._lastActiveView.activate();
                    this._lastActiveView.updateSelection();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            this.fireActiveViewChanged(activeViewEvent);
        }
    }

    public void focusGained(FocusHierarchyEvent focusHierarchyEvent) {
        this.trace("focusGained", focusHierarchyEvent);
        ArrayList arrayList = focusHierarchyEvent.getHierarchy();
        if (arrayList.size() > 0) {
            this.addTabbedPaneChangeListener(arrayList);
            Component component = (Component)arrayList.get(0);
            this.solveActiveView(component);
        }
    }

    public void focusLost(FocusHierarchyEvent focusHierarchyEvent) {
        this.trace("focusLost", focusHierarchyEvent);
        ArrayList arrayList = focusHierarchyEvent.getHierarchy();
        if (arrayList.size() > 0) {
            this.removeTabbedPaneChangeListener(arrayList);
        }
    }

    private void trace(String string, FocusHierarchyEvent focusHierarchyEvent) {
        if (DEBUG_TRACE_FOCUS_CHANGES) {
            ArrayList arrayList = focusHierarchyEvent.getHierarchy();
            Component component = (Component)arrayList.get(0);
            System.out.println("-------------------------- " + string);
            ArrayList<String> arrayList2 = new ArrayList<String>(20);
            while (component != null) {
                String string2 = component.getClass().getName();
                arrayList2.add(string2);
                component = component.getParent();
            }
            int n = arrayList2.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3 = 0;
                while (n3 < n - n2) {
                    System.out.print("  ");
                    ++n3;
                }
                String string3 = (String)arrayList2.get(n2);
                System.out.println(string3);
                --n2;
            }
            System.out.flush();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Component component = (Component)changeEvent.getSource();
        if (component.hasFocus()) {
            this.solveActiveView(component);
        }
    }

    private void addTabbedPaneChangeListener(List list) {
        int n = 0;
        while (n < list.size()) {
            Component component = (Component)list.get(n);
            if (component instanceof JTabbedPane) {
                JTabbedPane jTabbedPane = (JTabbedPane)component;
                jTabbedPane.addChangeListener(this);
                break;
            }
            ++n;
        }
    }

    private void removeTabbedPaneChangeListener(List list) {
        int n = 0;
        while (n < list.size()) {
            Component component = (Component)list.get(n);
            if (component instanceof JTabbedPane) {
                JTabbedPane jTabbedPane = (JTabbedPane)component;
                jTabbedPane.removeChangeListener(this);
                break;
            }
            ++n;
        }
    }

    private void solveActiveView(Component component) {
        View view = this.findActiveView(component);
        this.setActiveView(view);
    }

    private View findActiveView(Component component) {
        View view = null;
        if (component != null) {
            Component component2 = component;
            while (view == null && component2 != null) {
                Object v = this._componentToView.get(component2);
                if (v != null) {
                    View view2 = (View)v;
                    if (view == null) {
                        view = view2;
                    }
                }
                component2 = component2.getParent();
            }
        } else {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            view = ideMainWindow.getIdeMainWindowView();
        }
        return view;
    }

    public List getControllerProviders(View view) {
        ArrayList arrayList;
        Object object = this.getCachedControllerStack(view);
        if (object == null) {
            Object object2;
            Component component = (Component)this._viewToComponent.get(view);
            arrayList = null;
            if (component != null) {
                object2 = component;
            } else {
                IdeMainWindow ideMainWindow = Ide.getMainWindow();
                object2 = ideMainWindow;
            }
            object2 = ((Component)object2).getParent();
            while (object2 != null) {
                Object v = this._componentToControllerProvider.get(object2);
                if (v == null) {
                    v = this._componentToView.get(object2);
                }
                if (v != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(2);
                    }
                    arrayList.add(v);
                }
                object2 = ((Component)object2).getParent();
            }
            if (arrayList == null) {
                arrayList = Collections.EMPTY_LIST;
            }
            this.cacheControllerStack(view, arrayList);
        } else {
            arrayList = (ArrayList)object;
        }
        return arrayList;
    }

    EventListener[] getListeners(Class clazz) {
        return this._activeViewListeners.toArray(new EventListener[this._activeViewListeners.size()]);
    }

    List getVisibleViews() {
        ArrayList<View> arrayList = new ArrayList<View>();
        Enumeration enumeration = this._viewToComponent.keys();
        while (enumeration.hasMoreElements()) {
            View view = (View)enumeration.nextElement();
            if (view == null || !view.isVisible()) continue;
            arrayList.add(view);
        }
        arrayList.add(Ide.getMainWindow().getIdeMainWindowView());
        return arrayList;
    }
}

