/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import javax.ide.extension.Extension;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.IconDescription;
import javax.ide.util.MissingIconException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeMainWindow;
import oracle.ide.IdeUIManager;
import oracle.ide.Version;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.AboutBoxFactory;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.keyboard.IdeInputMapUIResource;
import oracle.ide.layout.Layouts;
import oracle.ide.migration.MigrationManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.IdeUIManagerImpl;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.ProductHook;
import oracle.ideimpl.ProductInformation;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.extension.AddinManagerImpl;
import oracle.ideimpl.help.AboutPropertiesPage;
import oracle.ideimpl.help.AboutVersionPage;
import oracle.ideimpl.jsr198.ToolbarManagerImpl;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.ideimpl.migration.MigrationManagerImpl;
import oracle.ideimpl.migration.UserDataHandler;
import oracle.ideimpl.navigator.WorkspaceNavigatorManager;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.jndi.Names;

public class DefaultIdeCore
extends IdeCore {
    public DefaultIdeCore(IdeArgs ideArgs) {
        super(ideArgs);
    }

    public DefaultIdeCore(IdeArgs ideArgs, String string) {
        this(ideArgs);
        this.productID = string;
    }

    protected void initializeLookAndFeel() {
        IdeUIManager ideUIManager = this.createUIManager(Names.newInitialContext());
        if (ideUIManager != null) {
            EnvironOptions environOptions = Ide.getEnvironOptions();
            String string = environOptions.getLafClass();
            String string2 = environOptions.getLafThemeClass();
            ideUIManager.setLookAndFeel(string, string2);
        }
        IdeInputMapUIResource.replaceInputMapUIResources();
    }

    protected AddinManager getAddinManager() {
        InitialContext initialContext = Names.newInitialContext();
        this.createMigrationManager(initialContext);
        return this.createAddinManager(initialContext);
    }

    protected Addin[] createCoreModules() {
        return this.createCoreModules(Names.newInitialContext());
    }

    protected Addin[] createCoreModules(InitialContext initialContext) {
        return new Addin[]{this.createToolbarManager(initialContext), this.createMainWindow(initialContext), this.createDockStation(initialContext), this.createWorkspaceNavigatorManager(initialContext), this.createEditorManager(initialContext), this.createLayouts(initialContext)};
    }

    protected final void installAboutBox(AboutBoxFactory aboutBoxFactory) {
        aboutBoxFactory.addPage(AboutVersionPage.class);
        aboutBoxFactory.addPage(AboutPropertiesPage.class);
    }

    private ProductInformation getProductInformation() {
        ProductHook productHook = (ProductHook)ExtensionRegistry.getExtensionRegistry().getHook(ProductHook.NAME);
        return productHook.getProductInformation();
    }

    protected void brandMainWindow() {
        ProductInformation productInformation = this.getProductInformation();
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        if (ideMainWindow != null) {
            ideMainWindow.setMainTitle(productInformation.getName());
            try {
                ImageIcon imageIcon = new ImageIcon(productInformation.getIcon().getURL());
                ideMainWindow.setMainIcon(imageIcon.getImage());
            }
            catch (MissingIconException missingIconException) {
                missingIconException.printStackTrace();
            }
        }
    }

    protected String getProductNameFromBranding() {
        return this.getProductInformation().getName();
    }

    protected String getProductShortNameFromBranding() {
        return this.getProductInformation().getShortName();
    }

    protected void initAboutBoxModel() {
        1 var1_1 = new 1();
        var1_1.setProductName(this.getProductInformation().getName());
        var1_1.setCopyrightMessage(this.getProductInformation().getCopyright());
        var1_1.setVersionString(IdeArb.format(461, Version.EDITION, Ide.getProductVersion()));
        var1_1.setBuildString(IdeArb.format(462, Version.BUILD_LABEL));
        var1_1.setDialogTitle(Ide.getProgramName());
        int n = Ide.getProductVersion().lastIndexOf(46);
        String string = Ide.getProductVersion().substring(0, n);
        var1_1.setProductVersion(string);
        AboutBoxFactory.getAboutBoxFactory().setModel(var1_1);
    }

    protected void copyExtensionUserData() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        UserDataHandler userDataHandler = (UserDataHandler)extensionRegistry.getIdeHook(UserDataHandler.ELEMENT);
        for (Extension extension : extensionRegistry.getExtensions()) {
            Collection collection;
            if (!extensionRegistry.isNewlyInstalled(extension.getID())) continue;
            URL uRL = extensionRegistry.getSystemDirectory(extension.getID());
            if (!URLFileSystem.mkdirs(uRL)) {
                // empty if block
            }
            if ((collection = userDataHandler.getUserDataURIs(extension.getID())) == null) continue;
            for (URI uRI : collection) {
                try {
                    URL uRL2 = VirtualFileSystem.getVirtualFileSystem().toURL(uRI);
                    this.copyURL(uRL2, uRL);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void copyURL(URL uRL, URL uRL2) throws IOException {
        String string = JarUtil.getJarEntry(uRL);
        URL uRL3 = URLFactory.newURL(uRL2, string);
        if (URLFileSystem.isDirectory(uRL)) {
            this.copyDirectoryRecursive(uRL, URLFileSystem.getParent(uRL3));
        } else {
            URLFileSystem.copy(uRL, uRL3);
        }
    }

    private void copyDirectoryRecursive(URL uRL, URL uRL2) throws IOException {
        String string = URLFileSystem.getFileName(uRL);
        if (URLFileSystem.isDirectory(uRL)) {
            URL uRL3 = URLFactory.newDirURL(uRL2, string);
            URLFileSystem.mkdirs(uRL3);
            URL[] uRLArray = URLFileSystem.list(uRL);
            int n = 0;
            while (n < uRLArray.length) {
                this.copyDirectoryRecursive(uRLArray[n], uRL3);
                ++n;
            }
        } else {
            URL uRL4 = URLFactory.newURL(uRL2, string);
            URLFileSystem.copy(uRL, uRL4);
        }
    }

    private IdeMainWindow createMainWindow(InitialContext initialContext) {
        MainWindowImpl mainWindowImpl = null;
        PerformanceLogger.get().startTiming("oracle.ideimpl.DefaultIdeCore.createMainWindow0");
        mainWindowImpl = new MainWindowImpl();
        MainWindow.setMainWindow((Context)initialContext, (MainWindow)mainWindowImpl, (int)1);
        PerformanceLogger.get().stopTiming("oracle.ideimpl.DefaultIdeCore.createMainWindow0", "Created main window");
        return mainWindowImpl;
    }

    protected ToolbarManager createToolbarManager(InitialContext initialContext) {
        ToolbarManagerImpl toolbarManagerImpl = new ToolbarManagerImpl();
        ToolbarManager.setToolbarManager(toolbarManagerImpl);
        return toolbarManagerImpl;
    }

    protected DockStation createDockStation(InitialContext initialContext) {
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        DockStation.setDockStation(dockStationImpl);
        return dockStationImpl;
    }

    protected IdeUIManager createUIManager(InitialContext initialContext) {
        IdeUIManagerImpl ideUIManagerImpl = IdeUIManagerImpl.getInstance();
        IdeUIManager.setUIManager(ideUIManagerImpl);
        return ideUIManagerImpl;
    }

    protected MigrationManager createMigrationManager(InitialContext initialContext) {
        MigrationManager migrationManager = MigrationManagerImpl.getInstance();
        MigrationManager.setMigrationManager(migrationManager);
        return migrationManager;
    }

    protected AddinManager createAddinManager(InitialContext initialContext) {
        AddinManager addinManager = AddinManagerImpl.createInstance();
        AddinManager.setAddinManager(addinManager);
        return addinManager;
    }

    protected NavigatorManager createWorkspaceNavigatorManager(InitialContext initialContext) {
        WorkspaceNavigatorManager workspaceNavigatorManager = new WorkspaceNavigatorManager();
        NavigatorManager.setWorkspaceNavigatorManager(workspaceNavigatorManager);
        return workspaceNavigatorManager;
    }

    protected EditorManager createEditorManager(InitialContext initialContext) {
        EditorManagerImpl editorManagerImpl = EditorManagerImpl.createInstance();
        EditorManager.setEditorManager(editorManagerImpl);
        return editorManagerImpl;
    }

    protected Layouts createLayouts(InitialContext initialContext) {
        LayoutsImpl layoutsImpl = LayoutsImpl.createInstance();
        Layouts.setLayouts(layoutsImpl);
        return layoutsImpl;
    }

    static ProductInformation mav$getProductInformation(DefaultIdeCore defaultIdeCore) {
        return defaultIdeCore.getProductInformation();
    }

    public final class 1
    extends AboutBoxModel {
        public Icon getBannerImage() {
            try {
                IconDescription iconDescription = DefaultIdeCore.mav$getProductInformation(DefaultIdeCore.this).getBannerImage();
                if (iconDescription != null) {
                    ImageIcon imageIcon = new ImageIcon(iconDescription.getURL());
                    return imageIcon;
                }
                Icon icon = null;
                return icon;
            }
            catch (MissingIconException missingIconException) {
                Icon icon = null;
                return icon;
            }
        }

        public Icon getHeaderImage() {
            try {
                IconDescription iconDescription = DefaultIdeCore.mav$getProductInformation(DefaultIdeCore.this).getImage();
                if (iconDescription != null) {
                    ImageIcon imageIcon = new ImageIcon(iconDescription.getURL());
                    return imageIcon;
                }
                Icon icon = null;
                return icon;
            }
            catch (MissingIconException missingIconException) {
                Icon icon = null;
                return icon;
            }
        }
    }
}

