/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideimpl.resource.IdeImplMenuArb;
import oracle.ideri.util.Product;

public final class IdeMenus {
    private static final Menubar menuMgr = Ide.getMenubar();

    public static JMenu findJMenu(String string) {
        String string2 = string = string != null ? string.trim() : null;
        if (string == null || string.length() == 0) {
            return null;
        }
        return MenuManager.getJMenu(string);
    }

    public static JMenu findOrCreateJMenu(String string) {
        JMenu jMenu = IdeMenus.findJMenu(string);
        if (jMenu != null) {
            return jMenu;
        }
        if (string.equals("File")) {
            jMenu = IdeMenus.createFileMenu();
        } else if (string.equals("Edit")) {
            jMenu = IdeMenus.createEditMenu();
        } else if (string.equals("View")) {
            jMenu = IdeMenus.createViewMenu();
        } else if (string.equals("Navigate")) {
            jMenu = IdeMenus.createNavigateMenu();
        } else if (string.equals("Run")) {
            jMenu = IdeMenus.createRunMenu();
        } else if (string.equals("Tools")) {
            jMenu = IdeMenus.createToolsMenu();
        } else if (string.equals("Help")) {
            jMenu = IdeMenus.createHelpMenu();
        }
        if (jMenu != null) {
            MenuManager.putJMenu(string, jMenu);
            menuMgr.add(jMenu);
        }
        return jMenu;
    }

    public static JMenuItem createMenuItem(int n, String string, String string2, String string3, Integer n2, ArrayResourceBundle arrayResourceBundle, int n3, Object object, boolean bl, float f) {
        String string4 = AddinManager.getAddinManager().getCommand(n, string);
        IdeAction ideAction = IdeAction.get(n, string4, string2, string3, n2, arrayResourceBundle, n3, object, bl);
        return Ide.getMenubar().createMenuItem(ideAction, f);
    }

    public static JMenuItem createMenuItem(Controller controller, int n, String string, String string2, String string3, Integer n2, ArrayResourceBundle arrayResourceBundle, int n3, Object object, boolean bl, float f) {
        String string4 = AddinManager.getAddinManager().getCommand(n, string);
        IdeAction ideAction = IdeAction.get(n, string4, string2, string3, n2, arrayResourceBundle, n3, object, bl);
        ideAction.addController(controller);
        return Ide.getMenubar().createMenuItem(ideAction, f);
    }

    public static JMenuItem createMenuItem(IdeAction ideAction, float f) {
        return menuMgr.createMenuItem(ideAction, f);
    }

    public static JMenu loadFileMenu() {
        JMenu jMenu = IdeMenus.findJMenu("File");
        if (jMenu == null && (jMenu = IdeMenus.findOrCreateJMenu("File")) != null) {
            menuMgr.add(IdeMenus.createExitMenuItem(), jMenu, MenuConstants.SECTION_FILE_EXIT);
        }
        menuMgr.add(IdeMenus.createOpenMenuItem(), jMenu, 1.0f);
        JMenu jMenu2 = IdeMenus.createReopenMenu();
        MenuManager.putJMenu("FileReopen", jMenu2);
        menuMgr.add(jMenu2, jMenu, 1.0f);
        menuMgr.add(IdeMenus.createCloseMenuItem(), jMenu, MenuConstants.SECTION_FILE_CLOSE);
        menuMgr.add(IdeMenus.createCloseAllMenuItem(), jMenu, MenuConstants.SECTION_FILE_CLOSE);
        menuMgr.add(IdeMenus.createSaveMenuItem(), jMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add(IdeMenus.createSaveAsMenuItem(), jMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add(IdeMenus.createSaveAllMenuItem(), jMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add(IdeMenus.createRenameMenuItem(), jMenu, MenuConstants.SECTION_FILE_SAVE);
        menuMgr.add(IdeMenus.createReloadAllMenuItem(), jMenu, MenuConstants.SECTION_FILE_SAVE);
        if (!Product.isRaptor()) {
            menuMgr.add(IdeMenus.createRemoveFromDiskMenuItem(), jMenu, MenuConstants.SECTION_FILE_ERASE_REMOVE);
        }
        return jMenu;
    }

    private static JMenu createFileMenu() {
        return menuMgr.createMenu(IdeArb.getString(22), IdeArb.getInteger(23), 1.0f, MenuConstants.SECTION_FILE_ADDINS);
    }

    private static JMenuItem createOpenMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileOpenAction(), MenuConstants.WEIGHT_FILE_OPEN);
    }

    private static JMenu createReopenMenu() {
        return menuMgr.createSubMenu(IdeArb.getString(56), IdeArb.getInteger(57), MenuConstants.WEIGHT_FILE_REOPEN);
    }

    private static JMenuItem createCloseMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileCloseAction(), MenuConstants.WEIGHT_FILE_CLOSE);
    }

    private static JMenuItem createCloseAllMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileCloseAllAction(), MenuConstants.WEIGHT_FILE_CLOSE_ALL);
    }

    private static JMenuItem createSaveMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileSaveAction(), MenuConstants.WEIGHT_FILE_SAVE);
    }

    private static JMenuItem createSaveAsMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileSaveAsAction(), MenuConstants.WEIGHT_FILE_SAVE_AS);
    }

    private static JMenuItem createSaveAllMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileSaveAllAction(), MenuConstants.WEIGHT_FILE_SAVE_ALL);
    }

    private static JMenuItem createRenameMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileRenameAction(), MenuConstants.WEIGHT_FILE_RENAME);
    }

    private static JMenuItem createRemoveFromDiskMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileRemoveFromDiskAction(), MenuConstants.WEIGHT_FILE_ERASE);
    }

    private static JMenuItem createExitMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getFileExitAction(), MenuConstants.WEIGHT_FILE_EXIT);
    }

    private static JMenuItem createReloadAllMenuItem() {
        JMenuItem jMenuItem = IdeMenus.createMenuItem(IdeActions.getFileReloadNodesAction(), MenuConstants.WEIGHT_FILE_RELOAD);
        EnvironOptions environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options");
        boolean bl = environOptions.getAutoReloadExtMod() ^ true;
        jMenuItem.setVisible(bl);
        return jMenuItem;
    }

    public static JMenu loadEditMenu() {
        JMenu jMenu = IdeMenus.findOrCreateJMenu("Edit");
        menuMgr.add(IdeMenus.createUndoMenuItem(), jMenu, 1.0f);
        menuMgr.add(IdeMenus.createRedoMenuItem(), jMenu, 1.0f);
        menuMgr.add(IdeMenus.createCutMenuItem(), jMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createCopyMenuItem(), jMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createCopyPathMenuItem(), jMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createPasteMenuItem(), jMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createExtendedPasteMenuItem(), jMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createDeleteMenuItem(), jMenu, MenuConstants.SECTION_EDIT_CUT_COPY_PASTE);
        menuMgr.add(IdeMenus.createSelectAllMenuItem(), jMenu, MenuConstants.SECTION_EDIT_SELECT_ALL);
        menuMgr.add(IdeMenus.createPropertiesMenuItem(), jMenu, MenuConstants.SECTION_EDIT_PROPERTIES);
        return jMenu;
    }

    private static JMenu createEditMenu() {
        return menuMgr.createMenu(IdeArb.getString(80), IdeArb.getInteger(81), MenuConstants.WEIGHT_EDIT_MENU, MenuConstants.SECTION_EDIT_ADDINS);
    }

    private static JMenuItem createUndoMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditUndoAction(), 1.0f);
    }

    private static JMenuItem createRedoMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditRedoAction(), MenuConstants.WEIGHT_EDIT_REDO);
    }

    private static JMenuItem createCutMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditCutAction(), MenuConstants.WEIGHT_EDIT_CUT);
    }

    private static JMenuItem createCopyMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditCopyAction(), MenuConstants.WEIGHT_EDIT_COPY);
    }

    private static JMenuItem createCopyPathMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditCopyPathAction(), MenuConstants.WEIGHT_EDIT_COPY_PATH);
    }

    private static JMenuItem createPasteMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditPasteAction(), MenuConstants.WEIGHT_EDIT_PASTE);
    }

    private static JMenuItem createExtendedPasteMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditExtendedPasteAction(), MenuConstants.WEIGHT_EDIT_EXTENDED_PASTE);
    }

    private static JMenuItem createDeleteMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditDeleteAction(), MenuConstants.WEIGHT_EDIT_DELETE);
    }

    private static JMenuItem createSelectAllMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditSelectAllAction(), MenuConstants.WEIGHT_EDIT_SELECT_ALL);
    }

    private static JMenuItem createPropertiesMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getEditPropertiesAction(), MenuConstants.WEIGHT_EDIT_PROPERTIES);
    }

    public static JMenu loadViewMenu() {
        JMenu jMenu = IdeMenus.findOrCreateJMenu("View");
        JMenu jMenu2 = IdeMenus.createViewOptionsSubMenu();
        MenuManager.putJMenu("ViewOptions", jMenu2);
        menuMgr.add(IdeMenus.createNewViewMenuItem(), jMenu2, 1.0f);
        menuMgr.add(IdeMenus.createFreezeMenuItem(), jMenu2, 1.0f);
        JMenu jMenu3 = IdeMenus.createToolbarsSubMenu();
        MenuManager.putJMenu("ViewToolbars", jMenu3);
        jMenu3.add(IdeMenus.createMainToolbarMenuItem());
        menuMgr.add(jMenu2, jMenu, 1.0f);
        menuMgr.add(jMenu3, jMenu, MenuConstants.SECTION_VIEW_TOOLBAR);
        menuMgr.add(IdeMenus.createStatusBarMenuItem(), jMenu, MenuConstants.SECTION_VIEW_TOOLBAR);
        menuMgr.add(IdeMenus.createRefreshMenuItem(), jMenu, MenuConstants.SECTION_VIEW_REFRESH);
        return jMenu;
    }

    private static JMenu createViewMenu() {
        return menuMgr.createMenu(IdeArb.getString(151), IdeArb.getInteger(152), MenuConstants.WEIGHT_VIEW_MENU, MenuConstants.SECTION_VIEW_ADDINS);
    }

    private static JMenu createViewOptionsSubMenu() {
        return menuMgr.createSubMenu(IdeArb.getString(153), IdeArb.getInteger(154), 1.0f);
    }

    private static JMenuItem createNewViewMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewNewViewAction(), 1.0f);
    }

    private static JMenuItem createFreezeMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewFreezeAction(), 1.0f);
    }

    private static JMenu createToolbarsSubMenu() {
        return menuMgr.createSubMenu(IdeImplMenuArb.getString(0), IdeImplMenuArb.getInteger(1));
    }

    private static JMenuItem createMainToolbarMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewMainToolbarAction(), MenuConstants.WEIGHT_VIEW_TOOLBARS_MAIN);
    }

    private static JMenuItem createStatusBarMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewStatusBarAction(), MenuConstants.WEIGHT_VIEW_STATUS_BAR);
    }

    private static JMenuItem createRefreshMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getViewRefreshAction(), MenuConstants.WEIGHT_VIEW_REFRESH);
    }

    public static JMenu loadNavigateMenu() {
        JMenu jMenu = IdeMenus.findOrCreateJMenu("Navigate");
        menuMgr.add(IdeMenus.createNextMsgMenuItem(), jMenu, MenuConstants.SECTION_NAVIGATE_GOTO_MESSAGE);
        menuMgr.add(IdeMenus.createPrevMsgMenuItem(), jMenu, MenuConstants.SECTION_NAVIGATE_GOTO_MESSAGE);
        return jMenu;
    }

    private static JMenu createNavigateMenu() {
        return menuMgr.createMenu(IdeArb.getString(144), IdeArb.getInteger(145), MenuConstants.WEIGHT_NAVIGATE_MENU, MenuConstants.SECTION_NAVIGATE_ADDINS);
    }

    private static JMenuItem createNextMsgMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getNavigateGoToNextMessageAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_NEXT_MESSAGE);
    }

    private static JMenuItem createPrevMsgMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getNavigateGoToPreviousMessageAction(), MenuConstants.WEIGHT_NAVIGATE_GO_TO_PREVIOUS_MESSAGE);
    }

    public static JMenu loadRunMenu() {
        return IdeMenus.findOrCreateJMenu("Run");
    }

    private static JMenu createRunMenu() {
        return menuMgr.createMenu(IdeArb.getString(146), IdeArb.getInteger(147), MenuConstants.WEIGHT_RUN_MENU, MenuConstants.SECTION_RUN_ADDINS);
    }

    public static JMenu loadToolsMenu() {
        JMenu jMenu = IdeMenus.findOrCreateJMenu("Tools");
        menuMgr.add(IdeMenus.createPreferencesMenuItem(), jMenu, MenuConstants.SECTION_TOOLS_PREFERENCES);
        return jMenu;
    }

    private static JMenu createToolsMenu() {
        return menuMgr.createMenu(IdeArb.getString(181), IdeArb.getInteger(182), MenuConstants.WEIGHT_TOOLS_MENU, MenuConstants.SECTION_TOOLS_ADDINS);
    }

    private static JMenuItem createPreferencesMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getToolsPreferencesAction(), MenuConstants.WEIGHT_TOOLS_PREFERENCES);
    }

    private static JMenu createHelpMenu() {
        return menuMgr.createMenu(IdeArb.getString(415), IdeArb.getInteger(416), MenuConstants.WEIGHT_HELP_MENU, MenuConstants.SECTION_HELP_ADDINS);
    }

    public static JMenu loadHelpMenu() {
        JMenu jMenu = IdeMenus.findOrCreateJMenu("Help");
        menuMgr.add(IdeMenus.createAboutMenuItem(), jMenu, MenuConstants.SECTION_HELP_ABOUT);
        return jMenu;
    }

    private static JMenuItem createAboutMenuItem() {
        return IdeMenus.createMenuItem(IdeActions.getHelpAboutAction(), 1.0f);
    }
}

