/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.layout.IdeProperties;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.JDK;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.plaf.ImageIconUIResource;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.util.PlatformUtils;

public final class IdeUIManagerImpl
extends IdeUIManager {
    private static final IdeUIManagerImpl INSTANCE = new IdeUIManagerImpl();
    private static final String OLAF2_NAME = "oracle.bali.ewt.olaf2.OracleLookAndFeel";
    private static final String DEFAULT_THEME_NAME = "oracle.ideimpl.plaf.theme.DefaultTheme";
    private static final String FONT_SIZE_PROP = "Ide.FontSize";
    private static final IdeUIManager.ThemeInfo[] NO_THEMES = new IdeUIManager.ThemeInfo[0];
    private IdeUIManager.ThemeInfo[] _plasticThemes;

    private IdeUIManagerImpl() {
        this.initialize();
    }

    public static IdeUIManagerImpl getInstance() {
        return INSTANCE;
    }

    public void initLookAndFeel(String string) {
        this.setLookAndFeel(string, null);
    }

    public boolean setSystemLookAndFeel() {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    public boolean setCrossPlatformLookAndFeel() {
        throw new UnsupportedOperationException("This method is no longer supported.");
    }

    public static boolean isWindows() {
        return PlatformUtils.isWindows();
    }

    public static boolean isXPStyle() {
        if (!IdeUIManagerImpl.isWindowsXPorGreater() || Boolean.getBoolean("swing.noxp")) {
            return false;
        }
        return Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"));
    }

    public static boolean isWindowsRegistryFontSupported() {
        if (!IdeUIManagerImpl.isWindows()) {
            return false;
        }
        if (!JDK.HAS_BUG_WINDOWS_REGISTRY_FONT_MULTIBYTE_SUPPORT) {
            return true;
        }
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        String string2 = System.getProperty("windows.shell.font.languages", Locale.ENGLISH.getLanguage());
        String[] stringArray = string2.split("[,\\s]");
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string.equalsIgnoreCase(string3)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setLookAndFeel(String string, String string2) {
        if (JDK.HAS_BUG_4765282) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setDefaultFocusTraversalPolicy(new PatchedLayoutFocusTraversalPolicy(null));
        }
        boolean bl = false;
        String string3 = System.getProperty("swing.defaultlaf");
        if (ModelUtil.hasLength((String)string3) && this._setLookAndFeel(string3, string2, true)) {
            bl = true;
        }
        if (!bl && ModelUtil.hasLength((String)string) && this._setLookAndFeel(string, string2, true)) {
            bl = true;
        }
        if (!bl) {
            bl = this._setDefaultLookAndFeel(string2);
        }
        if (bl) {
            this.updateLookAndFeelDefaults();
        }
    }

    public IdeUIManager.ThemeInfo[] getInstalledThemes(String string) {
        if (IdeUIManagerImpl.isThemedLookAndFeelClassName(string)) {
            return this.getPlasticThemes();
        }
        return NO_THEMES;
    }

    public IdeUIManager.ThemeInfo getCurrentTheme(String string) {
        if (IdeUIManagerImpl.isThemedLookAndFeelClassName(string)) {
            PlasticTheme plasticTheme = PlasticLookAndFeel.getMyCurrentTheme();
            return new IdeUIManager.ThemeInfo(plasticTheme.getName(), plasticTheme.getClass().getName());
        }
        return null;
    }

    public IdeUIManager.ThemeInfo getDefaultTheme(String string) {
        if (IdeUIManagerImpl.isThemedLookAndFeelClassName(string)) {
            PlasticTheme plasticTheme = this.createPlasticTheme(DEFAULT_THEME_NAME);
            return new IdeUIManager.ThemeInfo(plasticTheme.getName(), plasticTheme.getClass().getName());
        }
        return null;
    }

    public void initialize() {
        ArrayList<UIManager.LookAndFeelInfo> arrayList = new ArrayList<UIManager.LookAndFeelInfo>();
        arrayList.add(new UIManager.LookAndFeelInfo("Oracle", OLAF2_NAME));
        if (IdeUIManagerImpl.isWindows() || IdeUIManagerImpl.isMacintosh()) {
            String string = UIManager.getSystemLookAndFeelClassName();
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = 0;
            while (n < lookAndFeelInfoArray.length) {
                UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[n];
                if (ModelUtil.areEqual((Object)string, (Object)lookAndFeelInfo.getClassName())) {
                    arrayList.add(lookAndFeelInfo);
                    break;
                }
                ++n;
            }
        }
        UIManager.setInstalledLookAndFeels(arrayList.toArray(new UIManager.LookAndFeelInfo[arrayList.size()]));
        if (JDK.IS_JDK15) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                Class<?> clazz = graphicsEnvironment.getClass();
                Method method = clazz.getMethod("preferProportionalFonts", null);
                method.invoke((Object)graphicsEnvironment, null);
            }
            catch (Exception exception) {
                System.err.println("Unable to set proportional fonts.");
            }
        }
    }

    private static boolean isWindowsXPorGreater() {
        return PlatformUtils.isAtLeastWindowsXP();
    }

    private static boolean isMacintosh() {
        return PlatformUtils.isMac();
    }

    private static boolean isOracleLookAndFeelClassName(String string) {
        return string.equals(OLAF2_NAME);
    }

    private static boolean isPlasticLookAndFeelClassName(String string) {
        return string.equals("com.jgoodies.looks.plastic.PlasticXPLookAndFeel") || string.equals("com.jgoodies.looks.plastic.Plastic3DLookAndFeel") || string.equals("com.jgoodies.looks.plastic.PlasticLookAndFeel");
    }

    private static boolean isThemedLookAndFeelClassName(String string) {
        return IdeUIManagerImpl.isOracleLookAndFeelClassName(string) || IdeUIManagerImpl.isPlasticLookAndFeelClassName(string);
    }

    private boolean _setDefaultLookAndFeel(String string) {
        String string2 = IdeUIManagerImpl.isMacintosh() ? UIManager.getSystemLookAndFeelClassName() : OLAF2_NAME;
        return this._setLookAndFeel(string2, string, false);
    }

    private boolean _setLookAndFeel(String string, String string2, boolean bl) {
        if (!ModelUtil.hasLength((String)string)) {
            return false;
        }
        try {
            LookAndFeel lookAndFeel;
            String string3;
            if (!(!IdeUIManagerImpl.isThemedLookAndFeelClassName(string) || ModelUtil.hasLength((String)(string3 = System.getProperty("plastic.theme"))) && this.setPlasticTheme(string3))) {
                if (!ModelUtil.hasLength((String)string2)) {
                    string2 = DEFAULT_THEME_NAME;
                }
                this.setPlasticTheme(string2);
            }
            if ((lookAndFeel = UIManager.getLookAndFeel()) == null || ModelUtil.areDifferent((Object)string, (Object)lookAndFeel.getClass().getName())) {
                UIManager.setLookAndFeel(string);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            if (!bl) {
                exception.printStackTrace();
            }
            return false;
        }
    }

    private IdeUIManager.ThemeInfo[] getPlasticThemes() {
        if (this._plasticThemes == null) {
            String[] stringArray = new String[]{DEFAULT_THEME_NAME, "oracle.ideimpl.plaf.theme.DesertBlue", "oracle.ideimpl.plaf.theme.DesertBluer", "oracle.ideimpl.plaf.theme.DesertGreen", "oracle.ideimpl.plaf.theme.DesertRed", "oracle.ideimpl.plaf.theme.DesertYellow", "oracle.ideimpl.plaf.theme.ExperienceBlue", "oracle.ideimpl.plaf.theme.ExperienceBluer", "oracle.ideimpl.plaf.theme.ExperienceGreen", "oracle.ideimpl.plaf.theme.SkyBlue", "oracle.ideimpl.plaf.theme.SkyBluer", "oracle.ideimpl.plaf.theme.SkyGreen", "oracle.ideimpl.plaf.theme.SkyKrupp", "oracle.ideimpl.plaf.theme.SkyPink", "oracle.ideimpl.plaf.theme.SkyRed", "oracle.ideimpl.plaf.theme.SkyYellow"};
            HashSet<IdeUIManager.ThemeInfo> hashSet = new HashSet<IdeUIManager.ThemeInfo>();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                PlasticTheme plasticTheme = this.createPlasticTheme(string);
                if (plasticTheme != null) {
                    IdeUIManager.ThemeInfo themeInfo = new IdeUIManager.ThemeInfo(plasticTheme.getName(), plasticTheme.getClass().getName());
                    hashSet.add(themeInfo);
                }
                ++n;
            }
            this._plasticThemes = hashSet.toArray(new IdeUIManager.ThemeInfo[hashSet.size()]);
        }
        return this._plasticThemes;
    }

    private PlasticTheme createPlasticTheme(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            PlasticTheme plasticTheme = (PlasticTheme)clazz.newInstance();
            return plasticTheme;
        }
        catch (Exception exception) {
            PlasticTheme plasticTheme = null;
            return plasticTheme;
        }
    }

    private boolean setPlasticTheme(String string) {
        PlasticTheme plasticTheme = this.createPlasticTheme(string);
        if (plasticTheme != null) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)plasticTheme);
            return true;
        }
        return false;
    }

    private void updateLookAndFeelDefaults() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        Class<?> clazz = lookAndFeel.getClass();
        String string = clazz.getName();
        this.updateDefaultFontSizes(lookAndFeel.getID());
        this.updateBasicLookAndFeelDefaults();
        if (IdeUIManagerImpl.isOracleLookAndFeelClassName(string)) {
            this.updateOracleLookAndFeelDefaults();
        } else if (IdeUIManagerImpl.isPlasticLookAndFeelClassName(string)) {
            this.updatePlasticLookAndFeelDefaults();
        } else if (string.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
            this.updateWindowsLookAndFeelDefaults();
        } else if (string.equals("apple.laf.AquaLookAndFeel")) {
            this.updateMacOSLookAndFeelDefaults();
        }
    }

    private void updateBasicLookAndFeelDefaults() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        new StatusBar();
        Object object = uIDefaults.get("EWTStatusBarUI");
        Object[] objectArray = new Object[]{"oracle.ide.controls.StatusBarControlUI", object};
        uIDefaults.putDefaults(objectArray);
        String[] stringArray = new String[]{"Tree.leafIcon", "Tree.openIcon", "Tree.closedIcon", "FileView.directoryIcon", "FileView.hardDriveIcon", "FileView.fileIcon", "FileChooser.upFolderIcon", "FileChooser.newFolderIcon", "FileChooser.listViewIcon", "FileChooser.detailsViewIcon"};
        int n = 0;
        while (n < stringArray.length) {
            this.replaceIcon(uIDefaults, stringArray[n]);
            ++n;
        }
        if (Boolean.getBoolean("oracle.menu.item.inset.fix")) {
            UIDefaults uIDefaults2 = UIManager.getDefaults();
            uIDefaults2.put("MenuItem.checkIcon", new NullIcon(-8, 0));
            uIDefaults2.put("Menu.checkIcon", new NullIcon(-8, 0));
            uIDefaults2.put("RadioButtonMenuItem.arrowIcon", new NullIcon(0, 0));
            uIDefaults2.put("CheckBoxMenuItem.arrowIcon", new NullIcon(0, 0));
        }
    }

    private void updateOracleLookAndFeelDefaults() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Options.setUseNarrowButtons((boolean)false);
        UIDefaults.ProxyLazyValue proxyLazyValue = new UIDefaults.ProxyLazyValue("javax.swing.plaf.basic.BasicBorders", "getSplitPaneBorder");
        InsetsUIResource insetsUIResource = LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(1, 14, 1, 14) : new InsetsUIResource(2, 14, 2, 14);
        UIDefaults.ProxyLazyValue proxyLazyValue2 = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getPlasticArchiveIcon");
        Object[] objectArray = new Object[]{"Menu.crossMenuMnemonic", Boolean.FALSE, "SplitPane.border", proxyLazyValue, "Button.margin", insetsUIResource, "ToggleButton.margin", insetsUIResource};
        uIDefaults.putDefaults(objectArray);
        Object[] objectArray2 = new Object[]{"oracle.ide.controls.StatusBarControlUI", "oracle.ideimpl.plaf.WindowsEWTStatusBarUI", "oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground", uIDefaults.get("control"), "oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground", uIDefaults.get("controlText"), "FileView.archiveIcon", proxyLazyValue2};
        uIDefaults.putDefaults(objectArray2);
    }

    private void updatePlasticLookAndFeelDefaults() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        UIDefaults.ProxyLazyValue proxyLazyValue = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getPlasticMenuBarBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue2 = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getPlasticToolBarBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue3 = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getPlasticArchiveIcon");
        Object[] objectArray = new Object[]{"MenuBar.border", proxyLazyValue, "ToolBar.border", proxyLazyValue2, "TabbedPaneUI", "javax.swing.plaf.metal.MetalTabbedPaneUI", "PasswordFieldUI", "oracle.bali.ewt.olaf2.OraclePasswordFieldUI", "TextFieldUI", "oracle.bali.ewt.olaf2.OracleTextFieldUI"};
        uIDefaults.putDefaults(objectArray);
        Object[] objectArray2 = new Object[]{"oracle.ide.controls.StatusBarControlUI", "oracle.ideimpl.plaf.WindowsEWTStatusBarUI", "oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground", uIDefaults.get("control"), "oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground", uIDefaults.get("controlText"), "FileView.archiveIcon", proxyLazyValue3};
        uIDefaults.putDefaults(objectArray2);
        if (JDK.HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST) {
            uIDefaults.put("ListUI", "oracle.bali.ewt.olaf2.OracleListUI");
        }
    }

    private void updateMacOSLookAndFeelDefaults() {
        String string = "javax.swing.plaf.metal.MetalIconFactory";
        Font font = UIManager.getFont("Label.font");
        Font font2 = new Font("Verdana", font.getStyle(), font.getSize());
        Object[] objectArray = new Object[]{"FileChooser.upFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserUpFolderIcon"), "FileChooser.newFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserNewFolderIcon"), "FileChooser.detailsViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserDetailViewIcon"), "FileChooser.listViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserListViewIcon"), "Oracle.dirtyFont", font2, "Menu.shortcutKeys", null};
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        uIDefaults.putDefaults(objectArray);
        IdeProperties ideProperties = Ide.getIdeProperties();
        ideProperties.setProperty("Ide.DefaultDialogHeight", "550");
    }

    private void updateWindowsLookAndFeelDefaults() {
        1 var1_1 = new 1();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(var1_1);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        InsetsUIResource insetsUIResource = new InsetsUIResource(1, 1, 1, 1);
        Color color = uIDefaults.getColor("windowText");
        UIDefaults.ProxyLazyValue proxyLazyValue = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getWindowsMenuBarBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue2 = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getWindowsToolBarBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue3 = new UIDefaults.ProxyLazyValue(IdeUIManagerImpl.class.getName(), "getWindowsArchiveIcon");
        Object[] objectArray = new Object[]{"Desktop.background", new ColorUIResource(96, 96, 96), "EditorPane.selectionBackground", new ColorUIResource(0, 0, 128), "CheckBox.foreground", color, "Label.foreground", color, "RadioButton.foreground", color, "Table.focusCellForeground", color, "Table.foreground", color, "TitledBorder.titleColor", color, "LabelUI", "javax.swing.plaf.metal.MetalLabelUI", "Label.disabledForeground", new ColorUIResource(153, 153, 153), "MenuBar.border", proxyLazyValue, "CheckBoxMenuItem.margin", insetsUIResource, "Menu.margin", insetsUIResource, "MenuItem.margin", insetsUIResource, "RadioButtonMenuItem.margin", insetsUIResource, "ToolBar.border", proxyLazyValue2, "CheckBoxMenuItemUI", "oracle.ideimpl.plaf.WindowsCheckBoxMenuItemUI", "ComboBoxUI", "oracle.ideimpl.plaf.WindowsComboBoxUI", "MenuUI", "oracle.ideimpl.plaf.WindowsMenuUI", "MenuItemUI", "oracle.ideimpl.plaf.WindowsMenuItemUI", "PasswordFieldUI", "oracle.ideimpl.plaf.WindowsPasswordFieldUI", "RadioButtonMenuItemUI", "oracle.ideimpl.plaf.WindowsRadioButtonMenuItemUI", "TextFieldUI", "oracle.ideimpl.plaf.WindowsTextFieldUI", "ToolBarUI", "oracle.ideimpl.plaf.WindowsToolBarUI", "TreeUI", "oracle.ideimpl.plaf.WindowsTreeUI", "SingleRowTabbedPaneUI", "oracle.ide.controls.SingleRowTabbedPaneUI"};
        uIDefaults.putDefaults(objectArray);
        Object[] objectArray2 = new Object[]{"oracle.ide.controls.StatusBarControlUI", "oracle.ideimpl.plaf.WindowsEWTStatusBarUI", "oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground", uIDefaults.get("control"), "oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground", uIDefaults.get("controlText"), "FileView.archiveIcon", proxyLazyValue3};
        uIDefaults.putDefaults(objectArray2);
        if (JDK.IS_JDK141) {
            String string = "CheckBox.margin";
            Insets insets = uIDefaults.getInsets("CheckBox.margin");
            if (insets != null) {
                InsetsUIResource insetsUIResource2 = new InsetsUIResource(insets.top, 0, insets.bottom, insets.right);
                uIDefaults.put("CheckBox.margin", insetsUIResource2);
            }
        }
        if (!JDK.IS_JDK142) {
            uIDefaults.put("SpinnerUI", "oracle.ideimpl.plaf.WindowsSpinnerUI");
        }
        if (JDK.HAS_BUG_4753146) {
            uIDefaults.put("Button.showMnemonics", Boolean.TRUE);
        }
        if (JDK.HAS_BUG_4674205) {
            uIDefaults.put("Table.focusCellHighlightBorder", new ColorlessDashedBorder());
            uIDefaults.put("Tree.focusBorder", new ColorlessDashedBorder());
        }
        if (JDK.HAS_BUG_4749792) {
            uIDefaults.put("SplitPane.highlight", uIDefaults.getColor("Button.highlight"));
        }
        if (JDK.HAS_BUG_4551985) {
            Object[] objectArray3 = new Object[]{"MenuBar.background", uIDefaults.get("control")};
            uIDefaults.putDefaults(objectArray3);
        }
        if (JDK.HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST) {
            uIDefaults.put("ListUI", "oracle.ideimpl.plaf.WindowsListUI");
        }
        if (!IdeUIManagerImpl.isWindowsRegistryFontSupported()) {
            Iterator iterator = uIDefaults.keySet().iterator();
            while (iterator.hasNext()) {
                Font font;
                String string = iterator.next().toString();
                if (!string.toLowerCase().endsWith("font") || (font = uIDefaults.getFont(string)) == null || !font.getFontName().equalsIgnoreCase("tahoma")) continue;
                int n = font.getStyle();
                int n2 = font.getSize();
                FontUIResource fontUIResource = new FontUIResource("Dialog", n, n2);
                uIDefaults.put(string, fontUIResource);
            }
        }
        if (JDK.HAS_BUG_2645826) {
            Object object = uIDefaults.get("OptionPane.font");
            Object object2 = uIDefaults.get("Button.font");
            for (Map.Entry entry : uIDefaults.entrySet()) {
                Object v;
                String string = entry.getKey().toString();
                if (!string.toLowerCase().endsWith("font") || (v = entry.getValue()) != object2) continue;
                uIDefaults.put(string, object);
            }
        }
        uIDefaults.put("RadioButtonMenuItem.checkIcon", new WindowsRadioButtonMenuItemIcon(null));
        IdeUIManagerImpl.setDefaultLookAndFeelDecorated(true);
    }

    private static void setDefaultLookAndFeelDecorated(boolean bl) {
        JDialog.setDefaultLookAndFeelDecorated(bl);
        JFrame.setDefaultLookAndFeelDecorated(bl);
    }

    private void replaceIcon(UIDefaults uIDefaults, Object object) {
        Icon icon = uIDefaults.getIcon(object);
        if (icon != null && !(icon instanceof ImageIcon)) {
            ImageIconUIResource imageIconUIResource = new ImageIconUIResource(icon);
            uIDefaults.put(object, imageIconUIResource);
        }
    }

    private void updateDefaultFontSizes(String string) {
        if (string == null) {
            return;
        }
        int n = this.getFontSize(string);
        if (n <= 0) {
            return;
        }
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Integer n2 = new Integer(n);
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Font font;
            Object k = enumeration.nextElement();
            if (!(k instanceof String) || !((String)k).toLowerCase().endsWith("font") || (font = uIDefaults.getFont(k)) == null || n == font.getSize()) continue;
            String string2 = font.getName();
            Integer n3 = new Integer(font.getStyle());
            UIDefaults.ProxyLazyValue proxyLazyValue = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{string2, n3, n2});
            uIDefaults.put(k, proxyLazyValue);
        }
    }

    private int getFontSize(String string) {
        Locale locale = Locale.getDefault();
        String string2 = locale.getLanguage();
        String string3 = null;
        if (string2.length() > 0 && (string3 = Ide.getProperty("Ide.FontSize." + string + "." + string2)) == null) {
            string3 = Ide.getProperty("Ide.FontSize." + string2);
        }
        if (string3 == null && (string3 = Ide.getProperty("Ide.FontSize." + string)) == null) {
            string3 = Ide.getProperty(FONT_SIZE_PROP);
        }
        if (string3 != null) {
            try {
                int n = Integer.parseInt(string3);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static Border getPlasticMenuBarBorder() {
        Border border = JavatoolsBorderFactory.createBottomBorder((Color)IdeConstants.COLOR_IDE_LINES);
        Border border2 = BorderFactory.createEmptyBorder(0, 1, 0, 1);
        return BorderFactory.createCompoundBorder(border, border2);
    }

    public static Border getPlasticToolBarBorder() {
        Border border = JavatoolsBorderFactory.createBottomBorder((Color)IdeConstants.COLOR_IDE_LINES);
        Border border2 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        return BorderFactory.createCompoundBorder(border, border2);
    }

    public static Border getWindowsMenuBarBorder() {
        Border border;
        Border border2;
        if (IdeUIManagerImpl.isXPStyle()) {
            border2 = JavatoolsBorderFactory.createBottomBorder((Color)IdeConstants.COLOR_IDE_LINES);
            border = BorderFactory.createEmptyBorder(2, 3, 2, 3);
        } else {
            border2 = BasicBorders.getMenuBarBorder();
            border = BorderFactory.createEmptyBorder(2, 0, 2, 0);
        }
        return BorderFactory.createCompoundBorder(border2, border);
    }

    public static Border getWindowsToolBarBorder() {
        if (IdeUIManagerImpl.isXPStyle()) {
            Border border = JavatoolsBorderFactory.createBottomBorder((Color)IdeConstants.COLOR_IDE_LINES);
            Border border2 = BorderFactory.createEmptyBorder(0, 2, 0, 2);
            return BorderFactory.createCompoundBorder(border, border2);
        }
        return JavatoolsBorderFactory.createBottomBorder((Color)SystemColor.controlShadow);
    }

    public static Icon getWindowsArchiveIcon() {
        return IdeUIManagerImpl.getArchiveIcon(3, 1);
    }

    public static Icon getPlasticArchiveIcon() {
        return IdeUIManagerImpl.getArchiveIcon(3, 1);
    }

    private static Icon getArchiveIcon(int n, int n2) {
        return new OverlayIcon(UIManager.getIcon("FileView.directoryIcon"), new ZipperIcon(n, n2));
    }

    public final class 1
    implements KeyEventPostProcessor {
        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            return keyEvent.isConsumed() && keyEvent.getKeyCode() == 18 && keyEvent.getID() == 401 && keyEvent.getSource() instanceof ColorChoice;
        }
    }

    private static class WindowsRadioButtonMenuItemIcon
    implements Serializable,
    UIResource,
    Icon {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            if (abstractButton.isSelected()) {
                graphics.fillRect(n + 1, n2, 4, 6);
                graphics.fillRect(n, n2 + 1, 6, 4);
            }
        }

        public int getIconWidth() {
            return 6;
        }

        public int getIconHeight() {
            return 6;
        }

        private WindowsRadioButtonMenuItemIcon() {
        }

        WindowsRadioButtonMenuItemIcon(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ZipperIcon
    implements Serializable,
    UIResource,
    Icon {
        private static final int H = 11;
        private static final int W = 3;
        private int xOffset;
        private int yOffset;

        public ZipperIcon() {
            this(0, 0);
        }

        public ZipperIcon(int n, int n2) {
            this.xOffset = n;
            this.yOffset = n2;
        }

        public int getIconWidth() {
            return 3 + this.xOffset;
        }

        public int getIconHeight() {
            return 11 + this.yOffset;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawLine((n += this.xOffset) + 1, (n2 += this.yOffset) + 4, n + 1, n2 + 4);
            int n3 = 5;
            while (n3 < 11) {
                graphics.drawLine(n, n2 + n3, n, n2 + n3);
                n3 += 2;
            }
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            graphics.drawLine(n + 1, n2 + 3, n + 1, n2 + 3);
            int n4 = 4;
            while (n4 < 11) {
                graphics.drawLine(n, n2 + n4, n, n2 + n4);
                graphics.drawLine(n + 2, n2 + n4, n + 2, n2 + n4);
                n4 += 2;
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n + 1, n2, n + 1, n2);
            graphics.drawLine(n, n2 + 1, n, n2 + 3);
            graphics.drawLine(n + 1, n2 + 5, n + 1, n2 + 11);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(n + 2, n2 + 1, n + 2, n2 + 3);
            int n5 = 5;
            while (n5 < 11) {
                graphics.drawLine(n + 2, n2 + n5, n + 2, n2 + n5);
                n5 += 2;
            }
            graphics.setColor(Color.white);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 2);
        }
    }

    private static class PatchedLayoutFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        protected boolean accept(Component component) {
            return component instanceof JScrollBar ? false : super.accept(component);
        }

        private PatchedLayoutFocusTraversalPolicy() {
        }

        PatchedLayoutFocusTraversalPolicy(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ColorlessDashedBorder
    extends LineBorder
    implements UIResource {
        public ColorlessDashedBorder() {
            super(null, 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BasicGraphicsUtils.drawDashedRect(graphics, n, n2, n3, n4);
        }
    }
}

