/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.ideimpl.MonitorThread;
import oracle.ideimpl.resource.IdeImplArb;

final class MemoryMonitor
implements MonitorThread.MonitorListener,
Runnable,
Controller {
    private static final long FACTOR = 0x100000L;
    private JLabel _memLabel;
    private IdeAction _action;
    private long _lastTotal;
    private long _lastFree;
    private final int GC_CMD_ID;

    void $init$() {
        this.GC_CMD_ID = Ide.findOrCreateCmdID("MemoryMonitor.GC_CMD_ID");
    }

    MemoryMonitor(StatusBar statusBar) {
        this.$init$();
        Toolbar toolbar = statusBar.getToolbar();
        this._memLabel = new JLabel();
        this._memLabel.setHorizontalAlignment(0);
        this._memLabel.setVerticalAlignment(0);
        this.updateText();
        toolbar.add(this.getAction());
        toolbar.add(this._memLabel);
        statusBar.getGUI().validate();
    }

    void startMonitor() {
        MonitorThread monitorThread = new MonitorThread();
        monitorThread.monitorObject(this, this);
        monitorThread.start();
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this.GC_CMD_ID) {
            Runtime.getRuntime().gc();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    private static Object[] getParams(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        return objectArray;
    }

    private IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get(this.GC_CMD_ID, AddinManager.getAddinManager().getCommand(this.GC_CMD_ID, null), IdeImplArb.getString(83), null, IdeImplArb.getInteger(84), IdeImplArb.getInstance(), 85, null, true);
            this._action.addController(this);
        }
        return this._action;
    }

    private void updateText() {
        long l = this._lastTotal - this._lastFree;
        String string = IdeImplArb.format(82, MemoryMonitor.getParams(" ", Long.toString(l), Long.toString(this._lastTotal), " "));
        this._memLabel.setText(string);
    }

    public void monitor(Object object) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() / 0x100000L;
        long l2 = runtime.freeMemory() / 0x100000L;
        if (l != this._lastTotal || l2 != this._lastFree) {
            this._lastTotal = l;
            this._lastFree = l2;
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        this.updateText();
    }
}

