/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.PropertyResolver;
import oracle.ide.javaxide.Util;

public final class IdeActionHook
extends IdeHook {
    private static final Logger LOGGER = Logger.getLogger(IdeActionHook.class.getName());
    public static final ElementName ELEMENT = IdeActionHook.element("actions");
    private static final ElementName ACTION = IdeActionHook.element("action");
    private static final ElementName PROPERTIES = IdeActionHook.element("properties");
    private static final ElementName PROPERTY = IdeActionHook.element("property");
    private static final ElementName CONTROLLER_CLASS = IdeActionHook.element("controller-class");
    private static final String KEY_ACTION = "oide_action";
    private static final String KEY_RESOLVER = "oide_action_resolver";
    private final ElementVisitor _actionVisitor;
    private final ElementVisitor _propertiesVisitor;
    private final ElementVisitor _propertyVisitor;
    private final ElementVisitor _controllerVisitor;
    private Map<String, DeclarativeAction> _actions;

    void $init$() {
        this._actionVisitor = new ActionVisitor(null);
        this._propertiesVisitor = new PropertiesVisitor(null);
        this._propertyVisitor = new PropertyVisitor(null);
        this._controllerVisitor = new ControllerVisitor(null);
        this._actions = new HashMap<String, DeclarativeAction>();
    }

    public void start(ElementStartContext elementStartContext) {
        elementStartContext.registerChildVisitor(ACTION, this._actionVisitor);
    }

    public void end(ElementEndContext elementEndContext) {
    }

    void installActions() {
        for (DeclarativeAction declarativeAction : this._actions.values()) {
            declarativeAction.installAction();
        }
        this._actions.clear();
    }

    public IdeActionHook() {
        this.$init$();
    }

    static Map ra$_actions(IdeActionHook ideActionHook) {
        return ideActionHook._actions;
    }

    static ElementName ra$PROPERTIES() {
        return PROPERTIES;
    }

    static ElementVisitor ra$_propertiesVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._propertiesVisitor;
    }

    static ElementName ra$CONTROLLER_CLASS() {
        return CONTROLLER_CLASS;
    }

    static ElementVisitor ra$_controllerVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._controllerVisitor;
    }

    static ElementName ra$PROPERTY() {
        return PROPERTY;
    }

    static ElementVisitor ra$_propertyVisitor(IdeActionHook ideActionHook) {
        return ideActionHook._propertyVisitor;
    }

    static Logger ra$LOGGER() {
        return LOGGER;
    }

    private final class ActionVisitor
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            String string = elementStartContext.getAttributeValue("id");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log((ElementContext)elementStartContext, Level.SEVERE, "Missing required attribute 'id'.");
                return;
            }
            if (IdeActionHook.ra$_actions(IdeActionHook.this).containsKey(string)) {
                this.log((ElementContext)elementStartContext, Level.SEVERE, "Duplicate action id: " + string);
                return;
            }
            Integer n = Ide.findCmdID(string);
            if (n != null) {
                this.log((ElementContext)elementStartContext, Level.SEVERE, "Duplicate action id: " + string);
                return;
            }
            DeclarativeAction declarativeAction = new DeclarativeAction(string);
            IdeActionHook.ra$_actions(IdeActionHook.this).put(string, declarativeAction);
            ClassLoader classLoader = (ClassLoader)elementStartContext.getScopeData().get("classLoader");
            String string2 = (String)elementStartContext.getScopeData().get("rsbundleclass");
            DeclarativeResolver declarativeResolver = new DeclarativeResolver(classLoader, string2);
            declarativeAction.setPropertyResolver(declarativeResolver);
            elementStartContext.getScopeData().put(IdeActionHook.KEY_RESOLVER, declarativeResolver);
            elementStartContext.getScopeData().put(IdeActionHook.KEY_ACTION, declarativeAction);
            elementStartContext.registerChildVisitor(IdeActionHook.ra$PROPERTIES(), IdeActionHook.ra$_propertiesVisitor(IdeActionHook.this));
            elementStartContext.registerChildVisitor(IdeActionHook.ra$CONTROLLER_CLASS(), IdeActionHook.ra$_controllerVisitor(IdeActionHook.this));
        }

        public void end(ElementEndContext elementEndContext) {
            super.end(elementEndContext);
        }

        private ActionVisitor() {
        }

        ActionVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class PropertiesVisitor
    extends ElementVisitor {
        public void start(ElementStartContext elementStartContext) {
            elementStartContext.registerChildVisitor(IdeActionHook.ra$PROPERTY(), IdeActionHook.ra$_propertyVisitor(IdeActionHook.this));
        }

        private PropertiesVisitor() {
        }

        PropertiesVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class PropertyVisitor
    extends ElementVisitor {
        private String _rskey;
        private String _name;

        void $init$() {
            this._rskey = null;
            this._name = null;
        }

        public void start(ElementStartContext elementStartContext) {
            this._rskey = null;
            this._name = null;
            String string = elementStartContext.getAttributeValue("name");
            if (string == null || (string = string.trim()).length() == 0) {
                this.log((ElementContext)elementStartContext, Level.SEVERE, "Missing required attribute 'name'.");
                return;
            }
            this._name = string;
            this._rskey = elementStartContext.getAttributeValue("rskey");
            if (this._rskey != null) {
                this._rskey = this._rskey.trim();
            }
        }

        public void end(ElementEndContext elementEndContext) {
            if (this._name != null) {
                DeclarativeResolver declarativeResolver = (DeclarativeResolver)elementEndContext.getScopeData().get(IdeActionHook.KEY_RESOLVER);
                if (this._rskey != null) {
                    DeclarativeResolver.mav$put(declarativeResolver, this._name, declarativeResolver.createResString(this._rskey));
                } else if (elementEndContext.getText() == null || elementEndContext.getText().trim().length() == 0) {
                    this.log((ElementContext)elementEndContext, Level.WARNING, "Value expected for property '" + this._name + "'.");
                } else {
                    DeclarativeResolver.mav$put(declarativeResolver, this._name, elementEndContext.getText().trim());
                }
            }
        }

        private PropertyVisitor() {
            this.$init$();
        }

        PropertyVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class MetaClassController
    implements Controller {
        private final MetaClass _metaClass;
        private Controller _delegate;

        void $init$() {
            this._delegate = null;
        }

        MetaClassController(MetaClass metaClass) {
            this.$init$();
            this._metaClass = metaClass;
        }

        private Controller getDelegate() {
            if (this._delegate == null) {
                this._delegate = Util.createInstance(this._metaClass, Controller.class);
                if (this._delegate == null) {
                    this._delegate = new 1();
                }
            }
            return this._delegate;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return this.getDelegate().handleEvent(ideAction, context);
        }

        public boolean update(IdeAction ideAction, Context context) {
            return this.getDelegate().update(ideAction, context);
        }

        public final class 1
        implements Controller {
            public boolean handleEvent(IdeAction ideAction, Context context) {
                return false;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        }
    }

    private static final class DeclarativeResolver
    extends PropertyResolver {
        private ClassLoader _resLoader;
        private String _resBundleClass;
        private final Map _properties;

        void $init$() {
            this._resLoader = null;
            this._resBundleClass = null;
            this._properties = new HashMap();
        }

        DeclarativeResolver(ClassLoader classLoader, String string) {
            this.$init$();
            this._resLoader = classLoader;
            this._resBundleClass = string;
        }

        public Object get(String string) {
            Object object = this._properties.get(string);
            if (object instanceof ResString) {
                object = ((ResString)object).get();
            }
            if ("SmallIcon".equals(string) && !(object instanceof Icon)) {
                if (object == null) {
                    return null;
                }
                ImageIcon imageIcon = null;
                ResourceBundle resourceBundle = this.getBundle();
                URL uRL = resourceBundle.getClass().getResource((String)object);
                if (uRL == null) {
                    IdeActionHook.ra$LOGGER().severe("Failed to load icon " + object + ". Base class was " + resourceBundle.getClass());
                } else {
                    imageIcon = new ImageIcon(uRL);
                }
                return imageIcon;
            }
            if (("Check".equals(string) || "State".equals(string) || "Radio".equals(string)) && !(object instanceof Boolean)) {
                Boolean bl = Boolean.valueOf((String)object);
                return bl;
            }
            if ("MnemonicKey".equals(string) && !(object instanceof Integer)) {
                if (object == null) {
                    Object object2 = this._properties.get("Name");
                    if (object2 instanceof ResString) {
                        object2 = ((ResString)object2).get();
                    }
                    if (object2 != null) {
                        int n = StringUtils.getMnemonicKeyCode((String)object2.toString());
                        if (n == 0) {
                            return new Integer(0);
                        }
                        return new Integer(n);
                    }
                }
                if (((String)object).length() > 0) {
                    char c = ((String)object).charAt(0);
                    object = new Integer(c);
                    return object;
                }
                return new Integer(0);
            }
            if ("Name".equals(string)) {
                return StringUtils.stripMnemonic((String)((String)object));
            }
            return object;
        }

        private void put(Object object, Object object2) {
            this._properties.put(object, object2);
        }

        private ResourceBundle getBundle() {
            if (this._resLoader == null) {
                this._resLoader = Thread.currentThread().getContextClassLoader();
            }
            return ResourceBundle.getBundle(this._resBundleClass, Locale.getDefault(), this._resLoader);
        }

        ResString createResString(String string) {
            return new ResString(string);
        }

        static void mav$put(DeclarativeResolver declarativeResolver, Object object, Object object2) {
            declarativeResolver.put(object, object2);
        }

        static ResourceBundle mav$getBundle(DeclarativeResolver declarativeResolver) {
            return declarativeResolver.getBundle();
        }

        private class ResString {
            private final String _key;

            ResString(String string) {
                this._key = string;
            }

            public String get() {
                ResourceBundle resourceBundle = DeclarativeResolver.mav$getBundle(DeclarativeResolver.this);
                return resourceBundle.getString(this._key);
            }
        }
    }

    private final class ControllerVisitor
    extends MetaClassVisitor {
        protected void metaClass(ElementContext elementContext, MetaClass metaClass) {
            DeclarativeAction declarativeAction = (DeclarativeAction)elementContext.getScopeData().get(IdeActionHook.KEY_ACTION);
            declarativeAction.addController(new MetaClassController(metaClass));
        }

        private ControllerVisitor() {
        }

        ControllerVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DeclarativeAction {
        private String _id;
        private PropertyResolver _resolver;
        private Collection<Controller> _controllers;

        void $init$() {
            this._controllers = new ArrayList<Controller>();
        }

        DeclarativeAction(String string) {
            this.$init$();
            this._id = string;
        }

        public void setPropertyResolver(PropertyResolver propertyResolver) {
            this._resolver = propertyResolver;
        }

        public void addController(Controller controller) {
            this._controllers.add(controller);
        }

        void installAction() {
            int n = Ide.findOrCreateCmdID(this._id);
            IdeAction ideAction = IdeAction.get(n);
            ideAction.addPropertyResolver(this._resolver);
            for (Controller controller : this._controllers) {
                ideAction.addController(controller);
            }
        }
    }
}

