/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.TabbedWindow;
import oracle.ide.controls.TabbedWindowEvent;
import oracle.ide.controls.TabbedWindowListener;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.log.LogPage;
import oracle.ideimpl.controls.SwitchablePanel;

public final class FlatTabbedWindow
extends TabbedWindow
implements ListSelectionListener {
    private SwitchablePanel _switchablePanel;

    void $init$() {
        this._switchablePanel = new SwitchablePanel();
    }

    public FlatTabbedWindow() {
        this(true);
    }

    public FlatTabbedWindow(boolean bl) {
        this.$init$();
        this._switchablePanel.getCustomTab().addSelectionListener(this);
        this._switchablePanel.getCustomTab().setMinTabWidth(30);
        if (bl) {
            this._switchablePanel.getCustomTab().setCloseAction(new TabCloseAction());
            this._switchablePanel.getCustomTab().setCtrlClickCloseEnabled(true);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this._switchablePanel, "Center");
    }

    public void setDisplayTabNavigators(boolean bl) {
        this._switchablePanel.setDisplayTabNavigators(bl);
    }

    public final void add(String string, Icon icon, Component component, String string2, Object object) {
        this.add(string, icon, component, string2, object, true);
    }

    public final void add(String string, Icon icon, Component component, String string2, Object object, boolean bl) {
        this._switchablePanel.addPage(string, icon, component, string2, object);
        this.setActive(component, bl);
    }

    public void removeComponent(Component component) {
        DefaultCustomTabPage defaultCustomTabPage = this._switchablePanel.getTabPageForComponent(component);
        this._switchablePanel.removePage(defaultCustomTabPage);
    }

    public void setActive(Component component) {
        this.setActive(component, true);
    }

    public void setActive(Component component, boolean bl) {
        DefaultCustomTabPage defaultCustomTabPage = this._switchablePanel.getTabPageForComponent(component);
        CustomTab customTab = this._switchablePanel.getCustomTab();
        customTab.setSelectedPage(customTab.searchPage(defaultCustomTabPage));
        this._switchablePanel.moveToFront(defaultCustomTabPage, bl);
    }

    public Object getActiveData() {
        int n;
        CustomTab customTab = this._switchablePanel.getCustomTab();
        if (customTab != null && (n = customTab.getSelectedPage()) > -1) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)customTab.getPage(n);
            return defaultCustomTabPage.getUserObject();
        }
        return null;
    }

    public int getCount() {
        return this._switchablePanel.getPageCount();
    }

    public void navigateLeft() {
        int n;
        CustomTab customTab = this._switchablePanel.getCustomTab();
        if (customTab != null && (n = customTab.getSelectedPage()) - 1 >= 0) {
            customTab.setSelectedPage(n - 1);
        }
    }

    public void navigateRight() {
        int n;
        CustomTab customTab = this._switchablePanel.getCustomTab();
        if (customTab != null && (n = customTab.getSelectedPage()) + 1 <= this.getCount() - 1) {
            customTab.setSelectedPage(n + 1);
        }
    }

    public void displayDropdownMenu() {
        this._switchablePanel.displayDropdownMenu();
    }

    public void highlightPage(LogPage logPage) {
        CustomTab customTab = this._switchablePanel.getCustomTab();
        int n = customTab.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            CustomTabPage customTabPage = customTab.getPage(n2);
            if (customTabPage instanceof DefaultCustomTabPage && (object = ((DefaultCustomTabPage)customTabPage).getUserObject()) instanceof LogPage && object == logPage) {
                customTab.setHighlighted(n2, true);
                break;
            }
            ++n2;
        }
    }

    public void highlightPage(Component component) {
        CustomTab customTab = this._switchablePanel.getCustomTab();
        DefaultCustomTabPage defaultCustomTabPage = this._switchablePanel.getTabPageForComponent(component);
        int n = customTab.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            CustomTabPage customTabPage = customTab.getPage(n2);
            if (customTabPage == defaultCustomTabPage) {
                customTab.setHighlighted(n2, true);
                break;
            }
            ++n2;
        }
    }

    public CustomTabPage getTabPageForComponent(Component component) {
        return this._switchablePanel.getTabPageForComponent(component);
    }

    public TabbedWindow.PageInfo[] getPages() {
        int n = this.getCount();
        TabbedWindow.PageInfo[] pageInfoArray = new TabbedWindow.PageInfo[n];
        int n2 = 0;
        while (n2 < n) {
            TabbedWindow.PageInfo pageInfo;
            CustomTab customTab = this._switchablePanel.getCustomTab();
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)customTab.getPage(n2);
            pageInfoArray[n2] = pageInfo = new TabbedWindow.PageInfo(defaultCustomTabPage.getLabel(), defaultCustomTabPage.getIcon(), this._switchablePanel.getComponentForPage(defaultCustomTabPage), defaultCustomTabPage.getTooltip(), defaultCustomTabPage.getUserObject());
            ++n2;
        }
        return pageInfoArray;
    }

    public void addTabbedWindowListener(TabbedWindowListener tabbedWindowListener) {
        this.listenerList.add(TabbedWindowListener.class, tabbedWindowListener);
    }

    public void removeTabbedWindowListener(TabbedWindowListener tabbedWindowListener) {
        this.listenerList.remove(TabbedWindowListener.class, tabbedWindowListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this._switchablePanel.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this._switchablePanel.removeMouseListener(mouseListener);
    }

    public CustomTab getCustomTab() {
        return this._switchablePanel.getCustomTab();
    }

    public void setTabTooltip(Component component, String string) {
        DefaultCustomTabPage defaultCustomTabPage = this._switchablePanel.getTabPageForComponent(component);
        defaultCustomTabPage.setTooltip(string);
    }

    public void setTabName(Component component, String string) {
        DefaultCustomTabPage defaultCustomTabPage = this._switchablePanel.getTabPageForComponent(component);
        defaultCustomTabPage.setLabel(string);
        this._switchablePanel.validate();
        this._switchablePanel.invalidate();
        this._switchablePanel.repaint();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getFirstIndex() == -1) {
            return;
        }
        Object object = this.getActiveData();
        if (object != null) {
            this._fireTabbedWindowListener(object);
        }
    }

    private void _fireTabbedWindowListener(Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        TabbedWindowEvent tabbedWindowEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == TabbedWindowListener.class) {
                if (tabbedWindowEvent == null) {
                    tabbedWindowEvent = new TabbedWindowEvent(this, object);
                }
                ((TabbedWindowListener)objectArray[n + 1]).activeChanged(tabbedWindowEvent);
            }
            n -= 2;
        }
    }

    static SwitchablePanel ra$_switchablePanel(FlatTabbedWindow flatTabbedWindow) {
        return flatTabbedWindow._switchablePanel;
    }

    private final class TabCloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)actionEvent.getSource();
            FlatTabbedWindow.ra$_switchablePanel(FlatTabbedWindow.this).removePage(defaultCustomTabPage);
        }
    }
}

