/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import oracle.ide.util.BitField;

public class OneLineBorder
implements Border {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    private int _sides;
    private Color _color;

    public OneLineBorder(int n, Color color) {
        this._sides = n;
        this._color = color;
    }

    private Color getLineColor(Component component) {
        return this._color != null ? this._color : component.getBackground().darker();
    }

    public void setLineColor(Color color) {
        this._color = color;
    }

    public int getSides() {
        return this._sides;
    }

    public void setSides(int n) {
        this._sides = n;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Color color2 = this.getLineColor(component);
        graphics.setColor(color2);
        if (BitField.isSet(this._sides, 1)) {
            graphics.drawLine(n, 0, n + n3, 0);
        }
        if (BitField.isSet(this._sides, 2)) {
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
        if (BitField.isSet(this._sides, 4)) {
            graphics.drawLine(0, n2, 0, n2 + n4);
        }
        if (BitField.isSet(this._sides, 8)) {
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
        }
        graphics.setColor(color);
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(BitField.isSet(this._sides, 1) ? 1 : 0, BitField.isSet(this._sides, 4) ? 1 : 0, BitField.isSet(this._sides, 2) ? 1 : 0, BitField.isSet(this._sides, 8) ? 1 : 0);
    }

    public boolean isBorderOpaque() {
        return true;
    }
}

