/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.customtab.AutoRepeatButtonModel;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ideimpl.controls.ArrowIcon;

public class ScrollableCustomTab
extends JPanel
implements ListSelectionListener,
ListDataListener,
ActionListener {
    private static final int SCROLL_ARROW_SIZE = 4;
    private final JViewport _viewport;
    private final CustomTab _customTab;
    private final JButton _scrollLeftButton;
    private final JButton _scrollRightButton;

    public ScrollableCustomTab(int n) {
        super(new GridBagLayout());
        this._customTab = new CustomTab(n);
        this._customTab.addListDataListener(this);
        this._customTab.addSelectionListener(this);
        this._viewport = new JViewport();
        this._viewport.setView(this._customTab);
        this._scrollLeftButton = new JButton();
        this.initScrollButton(this._scrollLeftButton, "Left", 7);
        this._scrollRightButton = new JButton();
        this.initScrollButton(this._scrollRightButton, "Right", 3);
        Insets insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._viewport, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)this._scrollLeftButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, insets, 0, 0));
        this.add((Component)this._scrollRightButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 0, insets, 0, 0));
    }

    private void initScrollButton(AbstractButton abstractButton, String string, int n) {
        abstractButton.setModel(new AutoRepeatButtonModel(400, 100));
        abstractButton.addActionListener(this);
        ArrowIcon arrowIcon = new ArrowIcon(4, n);
        int n2 = Math.max(arrowIcon.getIconWidth() + 8, arrowIcon.getIconHeight() + 8);
        if (n2 % 2 != 0) {
            ++n2;
        }
        Dimension dimension = new Dimension(n2, n2);
        abstractButton.setIcon(arrowIcon);
        abstractButton.setToolTipText(string);
        abstractButton.setMinimumSize(dimension);
        abstractButton.setSize(dimension);
        abstractButton.setMaximumSize(dimension);
        abstractButton.setPreferredSize(dimension);
        abstractButton.setFocusable(false);
        abstractButton.setRolloverEnabled(false);
        abstractButton.setAlignmentY(0.0f);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        Insets insets = abstractButton.getInsets();
        if (insets.top > 3 || insets.left > 3 || insets.bottom > 3 || insets.right > 3) {
            abstractButton.setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
        }
    }

    private void updateButtons() {
        int n = this._customTab.getPageCount();
        int n2 = this._customTab.getSelectedPage();
        boolean bl = false;
        int n3 = n2 - 1;
        while (!bl && n3 >= 0) {
            CustomTabPage customTabPage = this._customTab.getPage(n3);
            if (customTabPage.isEnabled()) {
                bl = true;
            }
            --n3;
        }
        boolean bl2 = false;
        int n4 = n2 + 1;
        while (!bl2 && n4 < n) {
            CustomTabPage customTabPage = this._customTab.getPage(n4);
            if (customTabPage.isEnabled()) {
                bl2 = true;
            }
            ++n4;
        }
        this._scrollLeftButton.setEnabled(bl);
        this._scrollRightButton.setEnabled(bl2);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateButtons();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateButtons();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateButtons();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block4: {
            Object object;
            block5: {
                object = actionEvent.getSource();
                if (this._scrollLeftButton != object) break block5;
                int n = this._customTab.getSelectedPage();
                int n2 = n - 1;
                while (n2 >= 0) {
                    CustomTabPage customTabPage = this._customTab.getPage(n2);
                    if (customTabPage.isEnabled()) {
                        this._customTab.setSelectedPage(n2);
                        break block4;
                    }
                    --n2;
                }
                break block4;
            }
            if (this._scrollRightButton != object) break block4;
            int n = this._customTab.getSelectedPage();
            int n3 = this._customTab.getPageCount();
            int n4 = n + 1;
            while (n4 < n3) {
                CustomTabPage customTabPage = this._customTab.getPage(n4);
                if (customTabPage.isEnabled()) {
                    this._customTab.setSelectedPage(n4);
                    break;
                }
                ++n4;
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this._customTab.getSelectedPage();
        if (n != -1) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._customTab.getPage(n);
            Dimension dimension = this._customTab.getPreferredSize();
            if (dimension != null) {
                Rectangle rectangle = defaultCustomTabPage.getBounds();
                Rectangle rectangle2 = this._viewport.getViewRect();
                if (rectangle.x < rectangle2.x) {
                    this._viewport.setViewPosition(new Point(rectangle.x, 0));
                } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                    this._viewport.setViewPosition(new Point(rectangle.x + rectangle.width - rectangle2.width, 0));
                }
            }
            this.updateButtons();
        }
    }

    public void doLayout() {
        Dimension dimension = this._customTab.getPreferredSize();
        boolean bl = dimension.width > this.getWidth();
        this._scrollLeftButton.setVisible(bl);
        this._scrollRightButton.setVisible(bl);
        super.doLayout();
    }

    public CustomTab getCustomTab() {
        return this._customTab;
    }
}

