/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.IdeConstants;
import oracle.ide.controls.customtab.AutoRepeatButtonModel;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.log.LogPage;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.editor.DropDownMenuButton;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.log.LogPageCustomTab;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.border.JavatoolsBorderFactory;

public final class SwitchablePanel
extends JLayeredPane
implements ItemListener,
ActionListener,
ListSelectionListener {
    private static final int SCROLL_ARROW_SIZE = 4;
    private CustomTab _tab;
    private HashMap _map;
    DefaultListModel _model;
    private boolean _removingAllPages;
    private final JViewport _viewport;
    private final Box _buttonBox;
    private final JButton _scrollLeftButton;
    private final JButton _scrollRightButton;
    private final DropDownMenuButton _dropDownButton;
    private boolean _ensureTabVisibleAfterValidate;
    private boolean _displayTabNavigators;

    void $init$() {
        this._map = new HashMap();
        this._model = new DefaultListModel();
        this._ensureTabVisibleAfterValidate = true;
    }

    public SwitchablePanel() {
        this.$init$();
        this._tab = new CustomTab(3);
        this._tab.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this._tab.setGapBetweenTabs(-1);
        this._tab.setGapLeft(2);
        this._tab.setGapRight(2);
        this._tab.setOffsetSelected(0);
        this._tab.addSelectionListener(this);
        this._tab.setCompressible(true);
        this._tab.setModel(this._model);
        this._tab.setPreferredSize(null);
        this._tab.setOpaque(false);
        this._viewport = new JViewport();
        this._viewport.setView(this._tab);
        this._viewport.setOpaque(false);
        this._viewport.setFocusable(false);
        String string = KeyUtil.buildTooltip(70);
        this._scrollLeftButton = new JButton();
        this._scrollLeftButton.setFocusable(false);
        this._scrollLeftButton.setModel(new ScrollButtonModel());
        this._scrollLeftButton.addActionListener(this);
        this.initScrollButton(this._scrollLeftButton, string, 7);
        String string2 = KeyUtil.buildTooltip(71);
        this._scrollRightButton = new JButton();
        this._scrollRightButton.setFocusable(false);
        this._scrollRightButton.setModel(new ScrollButtonModel());
        this._scrollRightButton.addActionListener(this);
        this.initScrollButton(this._scrollRightButton, string2, 3);
        String string3 = IdeImplArb.getString(97);
        String string4 = KeyUtil.getAcceleratorTooltip(EditorManagerImpl.SHOW_DROPDOWN_CMD_ID);
        if (ModelUtil.hasLength((String)string4)) {
            string3 = string3 + " (" + string4 + ")";
        }
        this._dropDownButton = new DropDownMenuButton();
        this._dropDownButton.addItemListener(this);
        this.initScrollButton(this._dropDownButton, string3, 5);
        Component component = Box.createHorizontalStrut(5);
        component.setFocusable(false);
        Component component2 = Box.createVerticalStrut(3);
        component2.setFocusable(false);
        this._buttonBox = new Box(0);
        this._buttonBox.setBorder(JavatoolsBorderFactory.createTopBorder((Color)IdeConstants.COLOR_IDE_LINES));
        this._buttonBox.setOpaque(false);
        this._buttonBox.setFocusable(false);
        this._buttonBox.add(component);
        this._buttonBox.add(component2);
        this._buttonBox.add(this._scrollLeftButton);
        this._buttonBox.add(this._scrollRightButton);
        this._buttonBox.add(this._dropDownButton);
        this.handleButtons();
        this.add(this._buttonBox, new Integer(JLayeredPane.DEFAULT_LAYER + 1), -1);
        this.add(this._viewport, new Integer(JLayeredPane.DEFAULT_LAYER + 1), -1);
    }

    public void setDisplayTabNavigators(boolean bl) {
        this._displayTabNavigators = bl;
    }

    public void displayDropdownMenu() {
        if (this._displayTabNavigators && this._tab.getPageCount() > 1) {
            this.whenDropDownButtonPressed(true);
            this._dropDownButton.showPopupMenu();
        }
    }

    public void doLayout() {
        Rectangle rectangle;
        Rectangle rectangle2;
        Rectangle rectangle3;
        int n;
        Insets insets = this.getInsets();
        int n2 = 0;
        int n3 = this.getWidth() - (insets.left + insets.right);
        int n4 = this.getHeight() - (insets.top + insets.bottom);
        if (this._tab.isVisible()) {
            Dimension dimension = this._tab.getPreferredSize();
            n = dimension.height;
        } else {
            n = 0;
        }
        Dimension dimension = null;
        if (this._displayTabNavigators && this._buttonBox.isVisible()) {
            dimension = this._buttonBox.getPreferredSize();
            n = Math.max(n, this._buttonBox.getHeight());
        } else {
            dimension = new Dimension(0, 0);
        }
        n2 = Math.min(n, n4);
        if (this._tab.getPosition() == 1) {
            rectangle3 = new Rectangle(insets.left, insets.top, n3 - (insets.left + dimension.width - insets.right), n2);
            rectangle2 = new Rectangle(rectangle3.x + rectangle3.width, insets.top + 1, dimension.width, n2 - 1);
            rectangle = new Rectangle(insets.left, n2, n3, n4 - n2);
        } else {
            rectangle = new Rectangle(insets.left, insets.top, n3, Math.max(0, n4 - n2));
            rectangle3 = new Rectangle(insets.left, Math.max(insets.top, n4 - n2), n3 - (insets.left + dimension.width - insets.right), n2);
            rectangle2 = new Rectangle(rectangle3.x + rectangle3.width, rectangle3.y, dimension.width, n2);
        }
        this._viewport.setBounds(rectangle3);
        this._buttonBox.setBounds(rectangle2);
        Component[] componentArray = this.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
        int n5 = 0;
        while (n5 < componentArray.length) {
            Component component = componentArray[n5];
            component.setBounds(rectangle);
            ++n5;
        }
    }

    public void validate() {
        super.validate();
        if (this._ensureTabVisibleAfterValidate) {
            this._ensureTabVisibleAfterValidate = false;
            this.ensureTabVisible();
        }
    }

    public void addPage(CustomTabPage customTabPage, Component component) {
        if (!this._map.containsKey(customTabPage)) {
            this._map.put(customTabPage, component);
            this._model.addElement(customTabPage);
            this.add(component, JLayeredPane.DEFAULT_LAYER, -1);
            if (component instanceof Container) {
                ((Container)component).setFocusCycleRoot(true);
            }
            this.handleButtons();
        }
    }

    public void addPage(CustomTabPage customTabPage, Component component, int n) {
        this.addPage(customTabPage, component);
        this._model.removeElement(customTabPage);
        this._model.add(n, customTabPage);
    }

    public DefaultListModel getModel() {
        return this._model;
    }

    public void addPage(String string, Icon icon, Component component, String string2, Object object) {
        DefaultCustomTabPage defaultCustomTabPage = null;
        if (object instanceof LogPage) {
            defaultCustomTabPage = new LogPageCustomTab((LogPage)object);
        } else {
            defaultCustomTabPage = new DefaultCustomTabPage(icon, string, object);
            ((DefaultCustomTabPage)defaultCustomTabPage).setTooltip(string2);
        }
        this.addPage(defaultCustomTabPage, component);
        if (component.getAccessibleContext() != null) {
            component.getAccessibleContext().setAccessibleName(string);
        }
    }

    public void removePage(CustomTabPage customTabPage) {
        Component component = (Component)this._map.get(customTabPage);
        boolean bl = false;
        if (component != null) {
            Component component2 = GraphicsUtils.getFocusedChildComponent(component);
            if (component2 != null) {
                bl = true;
            }
            this.moveToBack(component);
            SwingUtilities.invokeLater(new 3(this, component));
            this._model.removeElement(customTabPage);
            this._map.remove(customTabPage);
            if (this._model.getSize() > 0 && !this._removingAllPages) {
                int n = this._tab.getSelectedPage();
                Component component3 = null;
                if (n != -1) {
                    CustomTabPage customTabPage2 = this._tab.getPage(n);
                    component3 = this.getComponentForPage(customTabPage2);
                    component3.setVisible(true);
                }
                if (bl && component3 != null) {
                    GraphicsUtils.focusComponentOrChild(component3, true);
                }
            }
            this.handleButtons();
        }
    }

    public void removeAllPages() {
        this._removingAllPages = true;
        int n = this._map.size();
        CustomTabPage[] customTabPageArray = this._map.keySet().toArray(new CustomTabPage[n]);
        int n2 = 0;
        while (n2 < customTabPageArray.length) {
            this.removePage(customTabPageArray[n2]);
            ++n2;
        }
        this._removingAllPages = false;
    }

    public void removeComponent(Component component) {
        Iterator iterator = this._map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != component) continue;
            iterator.remove();
            return;
        }
    }

    public int getPageCount() {
        return this._map.size();
    }

    public Component getComponentForPage(CustomTabPage customTabPage) {
        return (Component)this._map.get(customTabPage);
    }

    public DefaultCustomTabPage getTabPageForComponent(Component component) {
        for (Map.Entry entry : this._map.entrySet()) {
            if (entry.getValue() != component || !(entry.getKey() instanceof DefaultCustomTabPage)) continue;
            return (DefaultCustomTabPage)entry.getKey();
        }
        return null;
    }

    public CustomTab getCustomTab() {
        return this._tab;
    }

    public void moveToFront(Component component, boolean bl) {
        JComponent jComponent;
        if (this.getPosition(component) != 0) {
            Component[] componentArray = super.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            Component component2 = componentArray[0];
            super.moveToFront(component);
            component2.setVisible(false);
            componentArray = super.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            component.setVisible(true);
            this._ensureTabVisibleAfterValidate = true;
            this.validate();
        }
        if (bl && (jComponent = GraphicsUtils.focusComponentOrChild(component, true)) != null && jComponent.getAccessibleContext() != null) {
            jComponent.getAccessibleContext().setAccessibleName(component.getAccessibleContext().getAccessibleName());
        }
    }

    public void moveToFront(CustomTabPage customTabPage, boolean bl) {
        block0: {
            Component component = this.getComponentForPage(customTabPage);
            if (component == null) break block0;
            this.moveToFront(component, bl);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getFirstIndex() == -1) {
            return;
        }
        CustomTabPage customTabPage = this._tab.getPage(listSelectionEvent.getFirstIndex());
        Component component = this.getComponentForPage(customTabPage);
        if (component != null && this.getPosition(component) != 0) {
            boolean bl = GraphicsUtils.isAncestorOfFocusedComponent(this);
            this.moveToFront(component, bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._scrollLeftButton) {
            this.whenScrollTabsLeft();
        } else if (object == this._scrollRightButton) {
            this.whenScrollTabsRight();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this._dropDownButton) {
            if (itemEvent.getStateChange() == 1) {
                this.whenDropDownButtonPressed(true);
            } else if (itemEvent.getStateChange() == 2) {
                this.whenDropDownButtonPressed(false);
            }
        }
    }

    private void whenScrollTabsRight() {
        int n = this._tab.getSelectedPage() + 1;
        if (n >= 0 && n < this._tab.getPageCount()) {
            this._tab.setSelectedPage(n);
        }
    }

    private void whenScrollTabsLeft() {
        int n = this._tab.getSelectedPage() - 1;
        if (n >= 0) {
            this._tab.setSelectedPage(n);
        }
    }

    private void whenDropDownButtonPressed(boolean bl) {
        this._dropDownButton.removeAllPopupItems();
        if (!bl) {
            return;
        }
        Dimension dimension = this._dropDownButton.getToolkit().getScreenSize();
        List list = this.getTabPopupItems();
        int n = list.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            JMenuItem jMenuItem = (JMenuItem)list.get(n3);
            int n4 = jMenuItem.getPreferredSize().height;
            n2 += n4;
            ++n3;
        }
        if (n2 < dimension.height * 9 / 10) {
            n = list.size();
            int n5 = 0;
            while (n5 < n) {
                JMenuItem jMenuItem = (JMenuItem)list.get(n5);
                this._dropDownButton.addPopupItem(jMenuItem);
                ++n5;
            }
        } else {
            n = list.size();
            int n6 = dimension.height * 9 / 10;
            int n7 = n2 / n6 + 1;
            int n8 = list.size() / n7 + 1;
            int n9 = n8 + 1;
            JMenu jMenu = null;
            int n10 = 0;
            while (n10 < n) {
                JMenuItem jMenuItem = (JMenuItem)list.get(n10);
                if (n9 >= n8) {
                    String string = jMenuItem.getText();
                    int n11 = Math.min(n10 + n8, n) - 1;
                    JMenuItem jMenuItem2 = (JMenuItem)list.get(n11);
                    String string2 = jMenuItem2.getText();
                    jMenu = new JMenu(string + " - " + string2);
                    this._dropDownButton.addPopupItem(jMenu);
                    n9 = 0;
                }
                jMenu.add(jMenuItem);
                ++n9;
                ++n10;
            }
        }
    }

    private List getTabPopupItems() {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        int n = this._tab.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            CustomTabPage customTabPage = this._tab.getPage(n2);
            String string = customTabPage.getLongLabel();
            if (!ModelUtil.hasLength((String)string)) {
                string = customTabPage.getLabel();
            }
            2 var6_6 = new 2(string, customTabPage.getIcon());
            var6_6.putValue("pageNum", new Integer(n2));
            JMenuItem jMenuItem = new JMenuItem(var6_6);
            arrayList.add(jMenuItem);
            ++n2;
        }
        Collections.sort(arrayList, new 1());
        return arrayList;
    }

    private void initScrollButton(AbstractButton abstractButton, String string, int n) {
        ArrowIcon arrowIcon = new ArrowIcon(4, n);
        int n2 = Math.max(arrowIcon.getIconWidth() + 8, arrowIcon.getIconHeight() + 8);
        if (n2 % 2 != 0) {
            ++n2;
        }
        Dimension dimension = new Dimension(n2, n2);
        abstractButton.setIcon(arrowIcon);
        abstractButton.setToolTipText(string);
        abstractButton.setMaximumSize(dimension);
        abstractButton.setPreferredSize(dimension);
        abstractButton.setFocusable(false);
        abstractButton.setRolloverEnabled(false);
        abstractButton.setAlignmentY(1.0f);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        Insets insets = abstractButton.getInsets();
        if (insets.top > 3 || insets.left > 3 || insets.bottom > 3 || insets.right > 3) {
            abstractButton.setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
        }
    }

    public void ensureTabVisible() {
        int n = this._tab.getSelectedPage();
        if (n != -1) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._tab.getPage(n);
            Dimension dimension = this._tab.getPreferredSize();
            if (dimension != null) {
                Rectangle rectangle = defaultCustomTabPage.getBounds();
                if (rectangle.width == 0) {
                    this._tab.invalidate();
                    this._tab.repaint();
                    this._tab.doLayout();
                    rectangle = defaultCustomTabPage.getBounds();
                }
                Rectangle rectangle2 = this._viewport.getViewRect();
                if (rectangle.x < rectangle2.x) {
                    this._viewport.setViewPosition(new Point(rectangle.x, 0));
                } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                    this._viewport.setViewPosition(new Point(rectangle.x + rectangle.width - rectangle2.width, 0));
                }
            }
            this.handleButtons();
        }
    }

    private void handleButtons() {
        if (this._tab.getPageCount() <= 1 || !this._displayTabNavigators) {
            this._buttonBox.setVisible(false);
            this._tab.setVisible(false);
        } else {
            this._buttonBox.setVisible(true);
            this._tab.setVisible(true);
            int n = this._tab.getSelectedPage();
            if (n != -1) {
                this._scrollLeftButton.setEnabled(n > 0);
                this._scrollRightButton.setEnabled(n < this._tab.getPageCount() - 1);
            }
            this._dropDownButton.setEnabled(this._tab.getPageCount() > 1);
        }
    }

    static CustomTab ra$_tab(SwitchablePanel switchablePanel) {
        return switchablePanel._tab;
    }

    public final class 3
    implements Runnable {
        private final /* synthetic */ Component v$comp;
        final /* synthetic */ SwitchablePanel this$0;

        public void run() {
            this.this$0.remove(this.v$comp);
        }

        public 3(SwitchablePanel switchablePanel, Component component) {
            this.v$comp = component;
            this.this$0 = switchablePanel;
        }
    }

    public final class 2
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            AbstractAction abstractAction = (AbstractAction)jMenuItem.getAction();
            int n = (Integer)abstractAction.getValue("pageNum");
            SwitchablePanel.ra$_tab(SwitchablePanel.this).setSelectedPage(n);
        }

        public 2(String string, Icon icon) {
            super(string, icon);
        }
    }

    public final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            JMenuItem jMenuItem = (JMenuItem)object;
            JMenuItem jMenuItem2 = (JMenuItem)object2;
            return String.CASE_INSENSITIVE_ORDER.compare(jMenuItem.getText(), jMenuItem2.getText());
        }
    }

    private static final class ScrollButtonModel
    extends AutoRepeatButtonModel {
        public ScrollButtonModel() {
            super(400, 100);
        }
    }

    private static final class ArrowIcon
    implements Icon {
        private final int _height;
        private final int _width;
        private final Polygon _polygon;

        public ArrowIcon(int n, int n2) {
            int[] nArray;
            int[] nArray2;
            if (n2 == 7 || n2 == 3) {
                int[] nArray3;
                if (n2 == 7) {
                    int[] nArray4 = new int[4];
                    nArray4[0] = 0;
                    nArray4[1] = n - 1;
                    nArray4[2] = n - 1;
                    nArray3 = nArray4;
                    nArray4[3] = 0;
                } else {
                    int[] nArray5 = new int[4];
                    nArray5[0] = n - 1;
                    nArray5[1] = 0;
                    nArray5[2] = 0;
                    nArray3 = nArray5;
                    nArray5[3] = n - 1;
                }
                nArray2 = nArray3;
                nArray = new int[]{n - 1, 0, n * 2 - 1, n};
                this._height = n * 2;
                this._width = n;
            } else if (n2 == 1 || n2 == 5) {
                int[] nArray6;
                nArray2 = new int[]{n - 1, 0, n * 2 - 1, n};
                if (n2 == 1) {
                    int[] nArray7 = new int[4];
                    nArray7[0] = 0;
                    nArray7[1] = n - 1;
                    nArray7[2] = n - 1;
                    nArray6 = nArray7;
                    nArray7[3] = 0;
                } else {
                    int[] nArray8 = new int[4];
                    nArray8[0] = n - 1;
                    nArray8[1] = 0;
                    nArray8[2] = 0;
                    nArray6 = nArray8;
                    nArray8[3] = n - 1;
                }
                nArray = nArray6;
                this._height = n;
                this._width = n * 2;
            } else {
                throw new IllegalArgumentException("Invalid arrow direction");
            }
            this._polygon = new Polygon(nArray2, nArray, 4);
        }

        public int getIconHeight() {
            return this._height;
        }

        public int getIconWidth() {
            return this._width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor(component.isEnabled() ? "controlText" : "textInactiveText"));
            graphics.translate(n, n2);
            graphics.fillPolygon(this._polygon);
            graphics.drawPolygon(this._polygon);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }
}

