/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoHorzNode;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoVertNode;
import oracle.ideimpl.controls.dockLayout.DockLayoutPersistence;
import oracle.ideimpl.controls.dockLayout.DockLayoutUtil;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;

public abstract class AbstractDockLayoutInfoNode
implements TreeNode,
DockLayoutInfo {
    private int _orientation;
    private ArrayList _nodes;
    private ArrayList _dividers;
    private ArrayList _inserts;

    void $init$() {
        this._nodes = new ArrayList();
        this._dividers = new ArrayList();
        this._inserts = new ArrayList();
    }

    AbstractDockLayoutInfoNode(int n) {
        this.$init$();
        this._orientation = n;
    }

    public final boolean isReferring(Object object) {
        return object == this;
    }

    public final int getNodeCount() {
        return this._nodes.size();
    }

    public final DockLayoutInfo getNode(int n) {
        return (DockLayoutInfo)this._nodes.get(n);
    }

    final void insertNode(DockLayoutInfo dockLayoutInfo, int n) {
        this._nodes.add(n, dockLayoutInfo);
    }

    private final void addNode(DockLayoutInfo dockLayoutInfo) {
        this.insertNode(dockLayoutInfo, this.getNodeCount());
    }

    private final void setNode(DockLayoutInfo dockLayoutInfo, int n) {
        this._nodes.set(n, dockLayoutInfo);
    }

    private final void removeNode(int n) {
        this._nodes.remove(n);
    }

    public final DockLayoutInfoLeaf getLayoutInfo(JComponent jComponent) {
        DockLayoutInfoLeaf dockLayoutInfoLeaf = null;
        int n = this.getNodeCount();
        int n2 = 0;
        while (n2 < n & dockLayoutInfoLeaf == null) {
            DockLayoutInfo dockLayoutInfo = this.getNode(n2);
            dockLayoutInfoLeaf = dockLayoutInfo.getLayoutInfo(jComponent);
            ++n2;
        }
        return dockLayoutInfoLeaf;
    }

    public final void invalidateLayout(Container container) {
        this.removeDividers();
        this.removeInserts();
        int n = this.getNodeCount();
        int n2 = 0;
        while (n2 < n) {
            this.getNode(n2).invalidateLayout(container);
            ++n2;
        }
    }

    public final boolean isVisible() {
        int n = this.getNodeCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getNode(n2).isVisible()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final int moveBy(int n, int n2) {
        int n3 = 0;
        int n4 = this.getNodeCount();
        if (this.isSameOrientation(n2)) {
            n3 = n;
            if (DockLayoutUtil.isBefore(n2)) {
                int n5 = 0;
                while (n5 < n4) {
                    DockLayoutInfo dockLayoutInfo = this.getNode(n5);
                    n -= dockLayoutInfo.moveBy(n, n2);
                    ++n5;
                }
            } else {
                int n6 = n4 - 1;
                while (n6 >= 0) {
                    DockLayoutInfo dockLayoutInfo = this.getNode(n6);
                    n -= dockLayoutInfo.moveBy(n, n2);
                    --n6;
                }
            }
            n3 -= n;
        } else {
            n3 = n;
            int n7 = 0;
            while (n7 < n4) {
                DockLayoutInfo dockLayoutInfo = this.getNode(n7);
                int n8 = dockLayoutInfo.moveBy(n, n2);
                n3 = n > 0 ? Math.min(n, n8) : Math.max(n, n8);
                ++n7;
            }
        }
        return n3;
    }

    public final void getInsertionPoints(ArrayList arrayList) {
        arrayList.addAll(this.getInserts());
        int n = this.getNodeCount();
        int n2 = 0;
        while (n2 < n) {
            DockLayoutInfo dockLayoutInfo = this.getNode(n2);
            dockLayoutInfo.getInsertionPoints(arrayList);
            ++n2;
        }
    }

    public final boolean saveLayout(DockLayoutPersistence dockLayoutPersistence, String string) {
        int n = this.getNodeCount();
        int n2 = 0;
        dockLayoutPersistence.setProperty(string + ".ItemCount", Integer.toString(n));
        int n3 = 0;
        while (n3 < n) {
            String string2;
            DockLayoutInfo dockLayoutInfo = this.getNode(n3);
            if (dockLayoutInfo.saveLayout(dockLayoutPersistence, string2 = string + ".Item_" + n3)) {
                ++n2;
            }
            ++n3;
        }
        return n2 > 0;
    }

    final boolean addLayoutComponent(JComponent jComponent, DockLayoutConstraint dockLayoutConstraint) {
        int n = this.getNodeCount();
        boolean bl = false;
        Object object = dockLayoutConstraint.getReference();
        if (object == null || object == this) {
            int n2 = dockLayoutConstraint.getOrientation();
            int n3 = DockLayoutUtil.isBefore(n2) ? 0 : this.getNodeCount() - 1;
            this.addLayoutInfoLeaf(jComponent, n3, dockLayoutConstraint);
            bl = true;
        } else {
            int n4 = 0;
            while (!bl && n4 < n) {
                DockLayoutInfo dockLayoutInfo = this.getNode(n4);
                if (dockLayoutInfo.isReferring(object)) {
                    this.addLayoutInfoLeaf(jComponent, n4, dockLayoutConstraint);
                    bl = true;
                } else if (dockLayoutInfo instanceof AbstractDockLayoutInfoNode) {
                    AbstractDockLayoutInfoNode abstractDockLayoutInfoNode = (AbstractDockLayoutInfoNode)dockLayoutInfo;
                    bl = abstractDockLayoutInfoNode.addLayoutComponent(jComponent, dockLayoutConstraint);
                }
                ++n4;
            }
        }
        return bl;
    }

    final boolean removeLayoutComponent(JComponent jComponent) {
        int n = this.getNodeCount();
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < n) {
            DockLayoutInfo dockLayoutInfo = this.getNode(n2);
            if (dockLayoutInfo instanceof DockLayoutInfoLeaf) {
                DockLayoutInfoLeaf dockLayoutInfoLeaf = (DockLayoutInfoLeaf)dockLayoutInfo;
                if (dockLayoutInfoLeaf.isReferring(jComponent)) {
                    this.removeNode(n2);
                    bl = true;
                }
            } else {
                AbstractDockLayoutInfoNode abstractDockLayoutInfoNode = (AbstractDockLayoutInfoNode)dockLayoutInfo;
                bl = abstractDockLayoutInfoNode.removeLayoutComponent(jComponent);
            }
            ++n2;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    final void optimize() {
        this.removeDividers();
        this.removeInserts();
        var1_1 = this.getNodeCount() - 1;
        block4: while (var1_1 >= 0) {
            var2_2 = this.getNode(var1_1);
            if (!(var2_2 instanceof AbstractDockLayoutInfoNode)) ** GOTO lbl-1000
            var3_3 = (AbstractDockLayoutInfoNode)var2_2;
            var3_3.optimize();
            switch (var3_3.getNodeCount()) {
                case 0: {
                    this.removeNode(var1_1);
                    ** GOTO lbl27
                }
                case 1: {
                    var4_4 = var3_3.getNode(0);
                    if (var4_4 instanceof AbstractDockLayoutInfoNode) {
                        var5_5 = (AbstractDockLayoutInfoNode)var4_4;
                        this.removeNode(var1_1);
                        var6_6 = var5_5.getNodeCount();
                        var7_7 = 0;
                        while (var7_7 < var6_6) {
                            this.insertNode(var5_5.getNode(var7_7), var1_1 + var7_7);
                            ++var7_7;
                        }
                        continue block4;
                    }
                    this.setNode(var4_4, var1_1);
                    break;
                }
lbl27:
                // 2 sources

                default: lbl-1000:
                // 2 sources

                {
                    --var1_1;
                }
            }
        }
    }

    final DockLayoutInfo loadLayout(Container container, DockLayoutPersistence dockLayoutPersistence, String string) {
        return this.loadLayout(dockLayoutPersistence, string, 0, "");
    }

    protected final ArrayList getDividers() {
        return this._dividers;
    }

    public final DockDivider getDivider(JComponent jComponent, int n) {
        DockDivider dockDivider = null;
        int n2 = this.getNodeCount();
        int n3 = 0;
        while (n3 < n2) {
            DockLayoutInfo dockLayoutInfo = this.getNode(n3);
            dockDivider = dockLayoutInfo.getDivider(jComponent, n);
            if (dockDivider != null) {
                return dockDivider;
            }
            ++n3;
        }
        if (n == this._orientation) {
            n2 = this._dividers.size();
            int n4 = 0;
            while (n4 < n2) {
                DockDivider dockDivider2 = (DockDivider)this._dividers.get(n4);
                int n5 = dockDivider2.referenceType(jComponent);
                if (n5 != 0) {
                    dockDivider = dockDivider2;
                }
                ++n4;
            }
        }
        return dockDivider;
    }

    protected final void addDivider(DockDivider dockDivider) {
        this._dividers.add(dockDivider);
    }

    protected final void removeDividers() {
        this._dividers.clear();
    }

    protected final void addInsert(DockInsertionPoint dockInsertionPoint) {
        this._inserts.add(dockInsertionPoint);
    }

    protected final void removeInserts() {
        this._inserts.clear();
    }

    private final ArrayList getInserts() {
        return this._inserts;
    }

    private final void addLayoutInfoLeaf(JComponent jComponent, int n, DockLayoutConstraint dockLayoutConstraint) {
        int n2 = dockLayoutConstraint.getOrientation();
        Dimension dimension = dockLayoutConstraint.getPreferredDimension();
        DockLayoutInfoLeaf dockLayoutInfoLeaf = new DockLayoutInfoLeaf(jComponent, dimension);
        boolean bl = DockLayoutUtil.isBefore(n2);
        int n3 = this.getNodeCount();
        if (n3 == 0 || this.isSameOrientation(n2)) {
            if (!bl) {
                ++n;
            }
            if (n > n3) {
                n = n3;
            }
            this.insertNode(dockLayoutInfoLeaf, n);
        } else {
            AbstractDockLayoutInfoNode abstractDockLayoutInfoNode = AbstractDockLayoutInfoNode.createInfoNode(this._orientation);
            int n4 = dockLayoutConstraint.getExtent();
            int n5 = Math.min(n4, n3);
            int n6 = 0;
            while (n6 < n5) {
                abstractDockLayoutInfoNode.insertNode(this.getNode(n), abstractDockLayoutInfoNode.getNodeCount());
                this.removeNode(n);
                ++n6;
            }
            AbstractDockLayoutInfoNode abstractDockLayoutInfoNode2 = AbstractDockLayoutInfoNode.createInfoNode(n2);
            abstractDockLayoutInfoNode2.insertNode(abstractDockLayoutInfoNode, 0);
            abstractDockLayoutInfoNode2.insertNode(dockLayoutInfoLeaf, bl ? 0 : 1);
            this.insertNode(abstractDockLayoutInfoNode2, n);
        }
    }

    public final boolean isSameOrientation(int n) {
        return DockLayoutUtil.isSameOrientation(this._orientation, n);
    }

    private static final AbstractDockLayoutInfoNode createInfoNode(int n) {
        if (DockLayoutUtil.isHorz(n)) {
            return new DockLayoutInfoHorzNode();
        }
        return new DockLayoutInfoVertNode();
    }

    private final DockLayoutInfo loadLayout(DockLayoutPersistence dockLayoutPersistence, String string, int n, String string2) {
        DockLayoutInfo dockLayoutInfo = null;
        String string3 = dockLayoutPersistence.getProperty(string + ".ItemCount", null);
        if (string3 != null) {
            AbstractDockLayoutInfoNode abstractDockLayoutInfoNode = AbstractDockLayoutInfoNode.createInfoNode(n);
            int n2 = Integer.parseInt(string3);
            int n3 = 0;
            while (n3 < n2) {
                String string4 = string + ".Item_" + n3;
                DockLayoutInfo dockLayoutInfo2 = this.loadLayout(dockLayoutPersistence, string4, DockLayoutUtil.invertOrientation(n), "  " + string2);
                if (dockLayoutInfo2 != null) {
                    abstractDockLayoutInfoNode.addNode(dockLayoutInfo2);
                }
                ++n3;
            }
            if (abstractDockLayoutInfoNode.getNodeCount() != 0) {
                dockLayoutInfo = abstractDockLayoutInfoNode;
            }
        } else {
            dockLayoutInfo = DockLayoutInfoLeaf.loadLayout(dockLayoutPersistence, string);
        }
        return dockLayoutInfo;
    }

    public static AbstractDockLayoutInfoNode loadLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        return AbstractDockLayoutInfoNode.loadLayout(xMLDockLayoutPersistence, structuredPropertyAccess, 0);
    }

    private static final AbstractDockLayoutInfoNode loadLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess, int n) {
        AbstractDockLayoutInfoNode abstractDockLayoutInfoNode = AbstractDockLayoutInfoNode.createInfoNode(n);
        Iterator iterator = structuredPropertyAccess.getChildNodes();
        while (iterator.hasNext()) {
            DockLayoutInfo dockLayoutInfo = null;
            StructuredPropertyAccess structuredPropertyAccess2 = (StructuredPropertyAccess)iterator.next();
            if ("box".equals(structuredPropertyAccess2.getName())) {
                dockLayoutInfo = AbstractDockLayoutInfoNode.loadLayout(xMLDockLayoutPersistence, structuredPropertyAccess2, DockLayoutUtil.invertOrientation(n));
            } else if ("leafBox".equals(structuredPropertyAccess2.getName())) {
                dockLayoutInfo = DockLayoutInfoLeaf.loadLayout(xMLDockLayoutPersistence, structuredPropertyAccess2);
            }
            if (dockLayoutInfo == null) continue;
            abstractDockLayoutInfoNode.addNode(dockLayoutInfo);
        }
        return abstractDockLayoutInfoNode.getChildCount() > 0 ? abstractDockLayoutInfoNode : null;
    }

    public boolean saveLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        int n = this.getNodeCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess;
            DockLayoutInfo dockLayoutInfo = this.getNode(n3);
            if (dockLayoutInfo.saveLayout(xMLDockLayoutPersistence, defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess("box"))) {
                structuredPropertyAccess.appendChild(defaultStructuredPropertyAccess);
                ++n2;
            }
            ++n3;
        }
        return n2 > 0;
    }

    public final TreeNode getChildAt(int n) {
        return this.getNode(n);
    }

    public final int getChildCount() {
        return this.getNodeCount();
    }

    public final TreeNode getParent() {
        throw new UnsupportedOperationException();
    }

    public final int getIndex(TreeNode treeNode) {
        int n = this.getChildCount();
        while (n >= 0) {
            if (this.getChildAt(n) == treeNode) break;
            --n;
        }
        return n;
    }

    public final boolean getAllowsChildren() {
        return false;
    }

    public final boolean isLeaf() {
        return false;
    }

    public final Enumeration children() {
        return Collections.enumeration(this._nodes);
    }
}

