/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Rectangle;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;

public final class DockDivider {
    private float _fScale;
    private DockLayoutInfo _liBefore;
    private DockLayoutInfo _liAfter;
    private Rectangle _rect;
    private int _nMaxUp;
    private int _nMaxDn;

    DockDivider(DockLayoutInfo dockLayoutInfo, DockLayoutInfo dockLayoutInfo2, Rectangle rectangle, int n, int n2, float f) {
        this._liBefore = dockLayoutInfo;
        this._liAfter = dockLayoutInfo2;
        this._rect = rectangle;
        this._nMaxUp = n;
        this._nMaxDn = n2;
        this._fScale = f;
    }

    public Rectangle getRectangle() {
        return this._rect;
    }

    public int adjustForMax(int n) {
        if (n < this._nMaxUp) {
            n = this._nMaxUp;
        } else if (n > this._nMaxDn) {
            n = this._nMaxDn;
        }
        return n;
    }

    public void moveBy(int n, boolean bl) {
        int n2 = (int)((float)n / this._fScale);
        int n3 = bl ? 0 : 2;
        this._liBefore.moveBy(n2, n3 + 1);
        this._liAfter.moveBy(-n2, n3);
    }

    int referenceType(Object object) {
        if (this._liBefore.isReferring(object)) {
            return 2;
        }
        if (this._liAfter.isReferring(object)) {
            return 1;
        }
        return 0;
    }

    public DockLayoutInfo getBefore() {
        return this._liBefore;
    }

    public DockLayoutInfo getAfter() {
        return this._liAfter;
    }
}

