/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.controls.dockLayout.AbstractDockLayoutInfoNode;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoHorzNode;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.DockLayoutLoadConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutPersistence;
import oracle.ideimpl.controls.dockLayout.TreeIterator;
import oracle.ideimpl.controls.dockLayout.TreeIteratorFactory;
import oracle.ideimpl.controls.dockLayout.TreeIteratorLeaves;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;

public final class DockLayout
implements LayoutManager2 {
    private AbstractDockLayoutInfoNode _constraints;
    private ArrayList _cacheHorzDividers;
    private ArrayList _cacheVertDividers;
    private ArrayList _cacheInsertionPoints;
    private boolean _bOptimized;
    private int _nOptimizeLocks;
    private static final String ROOT_TAG = "window-layout";

    void $init$() {
        this._constraints = new DockLayoutInfoHorzNode();
        this._bOptimized = true;
        this._nOptimizeLocks = 0;
    }

    public DockLayout() {
        this.$init$();
    }

    public void addLayoutComponent(String string, Component component) {
        throw new IllegalArgumentException("Please use specific DockLayout constraints");
    }

    public void addLayoutComponent(Component component, Object object) {
        if (component == null) {
            throw new IllegalArgumentException("Cannot add null Components");
        }
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException("DockLayout only accepts JComponents");
        }
        this.addLayoutComponent((JComponent)component, object);
    }

    public DockLayoutInfoLeaf getLayoutInfo(JComponent jComponent) {
        return this._constraints.getLayoutInfo(jComponent);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        this.clearCaches();
        this._constraints.invalidateLayout(container);
    }

    public void removeLayoutComponent(Component component) {
        this._constraints.removeLayoutComponent((JComponent)component);
        this._bOptimized = false;
    }

    public Dimension maximumLayoutSize(Container container) {
        return this._constraints.getSize(3);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this._constraints.getSize(2);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this._constraints.getSize(0);
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
        this.optimize();
        this.clearCaches();
        this._constraints.layoutContainer(rectangle);
    }

    public DockLayoutInfo getConstraints() {
        this.optimize();
        return this._constraints;
    }

    public ArrayList getHorzDividers(Container container) {
        if (this._cacheHorzDividers == null) {
            this.recalcDividers(container);
        }
        return this._cacheHorzDividers;
    }

    public ArrayList getVertDividers(Container container) {
        if (this._cacheVertDividers == null) {
            this.recalcDividers(container);
        }
        return this._cacheVertDividers;
    }

    public DockDivider getDivider(JComponent jComponent, int n) {
        return this._constraints.getDivider(jComponent, n);
    }

    public ArrayList getInsertionPoints(Container container) {
        if (this._cacheInsertionPoints == null) {
            this.recalcDividers(container);
        }
        return this._cacheInsertionPoints;
    }

    public void saveLayout(DockLayoutPersistence dockLayoutPersistence, String string) {
        this.optimize();
        this._constraints.saveLayout(dockLayoutPersistence, string);
    }

    public void loadLayout(Container container, DockLayoutPersistence dockLayoutPersistence, String string) {
        DockLayoutInfo dockLayoutInfo = this._constraints.loadLayout(container, dockLayoutPersistence, string);
        if (dockLayoutInfo != null) {
            this._constraints = (AbstractDockLayoutInfoNode)dockLayoutInfo;
            this.runLoadedLayout(container, dockLayoutInfo);
            this._bOptimized = false;
        }
    }

    public void saveLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        this.optimize();
        this._constraints.saveLayout(xMLDockLayoutPersistence, structuredPropertyAccess);
    }

    public void loadLayout(Container container, XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        AbstractDockLayoutInfoNode abstractDockLayoutInfoNode = AbstractDockLayoutInfoNode.loadLayout(xMLDockLayoutPersistence, structuredPropertyAccess);
        if (abstractDockLayoutInfoNode != null) {
            this._constraints = abstractDockLayoutInfoNode;
            this.runLoadedLayout(container, abstractDockLayoutInfoNode);
            this._bOptimized = false;
        }
    }

    private void addLayoutComponent(JComponent jComponent, Object object) {
        if (object == null) {
            this._constraints.insertNode(new DockLayoutInfoLeaf(jComponent, new Dimension(5, 5)), 0);
            System.err.println("DockLayout.addLayoutComponent() - Should not dock with null constraints !");
        } else if (object instanceof DockLayoutConstraint) {
            this.addLayoutComponent(jComponent, (DockLayoutConstraint)object);
        } else if (!(object instanceof DockLayoutLoadConstraint)) {
            throw new IllegalArgumentException("Please use specific DockLayout constraints");
        }
    }

    private void addLayoutComponent(JComponent jComponent, DockLayoutConstraint dockLayoutConstraint) {
        if (!this._constraints.addLayoutComponent(jComponent, dockLayoutConstraint)) {
            throw new IllegalArgumentException("Constraint refers to an unknown object");
        }
        this._bOptimized = false;
    }

    private void recalcDividers(Container container) {
        this.layoutContainer(container);
        this._cacheHorzDividers = new ArrayList();
        this._cacheVertDividers = new ArrayList();
        this._constraints.getDividers(this._cacheHorzDividers, this._cacheVertDividers);
        this._cacheInsertionPoints = new ArrayList();
        this._constraints.getInsertionPoints(this._cacheInsertionPoints);
    }

    private void runLoadedLayout(Container container, DockLayoutInfo dockLayoutInfo) {
        if (dockLayoutInfo instanceof AbstractDockLayoutInfoNode) {
            AbstractDockLayoutInfoNode abstractDockLayoutInfoNode = (AbstractDockLayoutInfoNode)dockLayoutInfo;
            int n = 0;
            while (n < abstractDockLayoutInfoNode.getNodeCount()) {
                DockLayoutInfo dockLayoutInfo2 = abstractDockLayoutInfoNode.getNode(n);
                this.runLoadedLayout(container, dockLayoutInfo2);
                ++n;
            }
        } else {
            DockLayoutInfoLeaf dockLayoutInfoLeaf = (DockLayoutInfoLeaf)dockLayoutInfo;
            JComponent jComponent = dockLayoutInfoLeaf.getComponent();
            if (jComponent != null) {
                DockLayoutLoadConstraint dockLayoutLoadConstraint = new DockLayoutLoadConstraint();
                container.add((Component)jComponent, dockLayoutLoadConstraint);
            }
        }
    }

    private void clearCaches() {
        this._cacheHorzDividers = null;
        this._cacheVertDividers = null;
        this._cacheInsertionPoints = null;
    }

    public void lockOptimize() {
        ++this._nOptimizeLocks;
    }

    public void unlockOptimize() {
        --this._nOptimizeLocks;
        if (this._nOptimizeLocks == 0) {
            this.optimize();
        }
    }

    private void optimize() {
        if (!this._bOptimized && this._nOptimizeLocks == 0) {
            this._bOptimized = true;
            this.clearCaches();
            this._constraints.optimize();
        }
    }

    public TreeIteratorLeaves iterator(TreeIteratorFactory.Type type) {
        TreeIterator treeIterator = TreeIteratorFactory.createIterator(type, this._constraints);
        return new TreeIteratorLeaves(treeIterator);
    }
}

