/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutPersistence;
import oracle.ideimpl.controls.dockLayout.DockLayoutUtil;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;

public final class DockLayoutInfoLeaf
implements TreeNode,
DockLayoutInfo {
    private Dimension _dimPref;
    private JComponent _component;
    private DockInsertionPoint _insert;

    public DockLayoutInfoLeaf(JComponent jComponent, Dimension dimension) {
        this._component = jComponent;
        this._dimPref = dimension;
    }

    public boolean saveLayout(DockLayoutPersistence dockLayoutPersistence, String string) {
        boolean bl = false;
        String string2 = string + ".component";
        if (dockLayoutPersistence.saveComponent(this._component, string2)) {
            dockLayoutPersistence.setProperty(string + ".ItemCount", null);
            dockLayoutPersistence.setProperty(string + ".width", "" + this._dimPref.width);
            dockLayoutPersistence.setProperty(string + ".height", "" + this._dimPref.height);
            bl = true;
        }
        return bl;
    }

    public static DockLayoutInfoLeaf loadLayout(DockLayoutPersistence dockLayoutPersistence, String string) {
        DockLayoutInfoLeaf dockLayoutInfoLeaf = null;
        String string2 = string + ".component";
        JComponent jComponent = dockLayoutPersistence.loadComponent(string2);
        if (jComponent != null) {
            String string3 = dockLayoutPersistence.getProperty(string + ".width", "100");
            String string4 = dockLayoutPersistence.getProperty(string + ".height", "100");
            int n = Integer.parseInt(string3);
            int n2 = Integer.parseInt(string4);
            dockLayoutInfoLeaf = new DockLayoutInfoLeaf(jComponent, new Dimension(n, n2));
        }
        return dockLayoutInfoLeaf;
    }

    public boolean saveLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        boolean bl = false;
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess("leafBox");
        if (xMLDockLayoutPersistence.saveComponent(defaultStructuredPropertyAccess, this._component)) {
            defaultStructuredPropertyAccess.setProperty("width", Integer.toString(this._dimPref.width));
            defaultStructuredPropertyAccess.setProperty("height", Integer.toString(this._dimPref.height));
            structuredPropertyAccess.appendChild(defaultStructuredPropertyAccess);
            bl = true;
        }
        return bl;
    }

    public static DockLayoutInfoLeaf loadLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        DockLayoutInfoLeaf dockLayoutInfoLeaf = null;
        JComponent jComponent = xMLDockLayoutPersistence.loadComponent(structuredPropertyAccess);
        if (jComponent != null) {
            int n = Integer.parseInt(structuredPropertyAccess.getProperty("width", "100"));
            int n2 = Integer.parseInt(structuredPropertyAccess.getProperty("height", "100"));
            dockLayoutInfoLeaf = new DockLayoutInfoLeaf(jComponent, new Dimension(n, n2));
        }
        return dockLayoutInfoLeaf;
    }

    public boolean isReferring(Object object) {
        return object == this || object == this._component;
    }

    public int getNodeCount() {
        return 1;
    }

    public DockLayoutInfo getNode(int n) {
        return null;
    }

    public boolean isVisible() {
        return this._component.isVisible();
    }

    public Dimension getSize(int n) {
        Dimension dimension;
        switch (n) {
            case 0: {
                dimension = this._component.getMinimumSize();
                break;
            }
            case 1: {
                if (this.isVisible()) {
                    dimension = this._component.getSize();
                    break;
                }
                dimension = new Dimension(0, 0);
                break;
            }
            case 2: {
                dimension = this._dimPref;
                break;
            }
            case 3: {
                dimension = this._component.getMaximumSize();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return dimension;
    }

    public Dimension getPrefSize() {
        return this.getSize(2);
    }

    public void getDividers(ArrayList arrayList, ArrayList arrayList2) {
    }

    public DockDivider getDivider(JComponent jComponent, int n) {
        return null;
    }

    public DockLayoutInfoLeaf getLayoutInfo(JComponent jComponent) {
        if (this._component == jComponent) {
            return this;
        }
        return null;
    }

    public void getInsertionPoints(ArrayList arrayList) {
        if (this._insert != null) {
            arrayList.add(this._insert);
        }
    }

    public void invalidateLayout(Container container) {
        this._insert = null;
    }

    public void layoutContainer(Rectangle rectangle) {
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        Dimension dimension = new Dimension(rectangle.width / 3, rectangle.height / 3);
        Rectangle rectangle2 = new Rectangle(point.x - dimension.width, point.y - dimension.height, dimension.width * 2, dimension.height * 2);
        this._insert = new DockInsertionPoint(this, 4, point, rectangle2);
        this._component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int moveBy(int n, int n2) {
        int n3 = 0;
        Dimension dimension = this.getSize(0);
        if (DockLayoutUtil.isHorz(n2)) {
            int n4 = this._dimPref.width + n;
            if (n4 < dimension.width) {
                n4 = dimension.width;
            }
            n3 = n4 - this._dimPref.width;
            this._dimPref.width = n4;
        } else {
            int n5 = this._dimPref.height + n;
            if (n5 < dimension.height) {
                n5 = dimension.height;
            }
            n3 = n5 - this._dimPref.height;
            this._dimPref.height = n5;
        }
        this._component.invalidate();
        return n3;
    }

    public JComponent getComponent() {
        return this._component;
    }

    public TreeNode getChildAt(int n) {
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getChildCount() {
        return 0;
    }

    public TreeNode getParent() {
        throw new UnsupportedOperationException();
    }

    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }
}

