/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;

public class DockLayoutPanel
extends JPanel
implements MouseInputListener {
    protected DockLayout _layout;
    protected DockDivider _draggedDivider;
    protected boolean _draggedIsHorz;
    protected Point _draggedPtStart;
    protected Point _draggedPtLast;
    private boolean _paintingDividers;

    void $init$() {
        this._draggedPtStart = new Point();
        this._draggedPtLast = new Point();
        this._paintingDividers = true;
    }

    public DockLayoutPanel() {
        super(new DockLayout());
        this.$init$();
        this._layout = (DockLayout)this.getLayout();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPaintingDividers(false);
        this.setOpaque(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockInsertionPoint getDockInsertionAt(Point point) {
        DockInsertionPoint dockInsertionPoint = null;
        Rectangle rectangle = this.getBounds();
        if (rectangle.contains(point)) {
            ArrayList arrayList;
            double d = 2.147483647E9;
            Object object = this.getTreeLock();
            synchronized (object) {
                arrayList = this._layout.getInsertionPoints(this);
            }
            int n = arrayList.size();
            if (n != 0) {
                int n2 = 0;
                while (n2 < n) {
                    DockInsertionPoint dockInsertionPoint2 = (DockInsertionPoint)arrayList.get(n2);
                    Point point2 = dockInsertionPoint2.getAnchor();
                    double d2 = point.distance(point2);
                    if (d2 < d) {
                        d = d2;
                        dockInsertionPoint = dockInsertionPoint2;
                    }
                    ++n2;
                }
            }
            if (dockInsertionPoint != null) {
                dockInsertionPoint.setContainer(this);
            }
        }
        return dockInsertionPoint;
    }

    public DockLayoutInfoLeaf getLayoutInfo(JComponent jComponent) {
        return this._layout.getLayoutInfo(jComponent);
    }

    public void saveLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        this._layout.saveLayout(xMLDockLayoutPersistence, structuredPropertyAccess);
    }

    public void loadLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        this._layout.loadLayout((Container)this, xMLDockLayoutPersistence, structuredPropertyAccess);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isPaintingDividers()) {
            this.paintDivider(graphics, this._layout.getHorzDividers(this), false);
            this.paintDivider(graphics, this._layout.getVertDividers(this), true);
        }
    }

    private boolean isPaintingDividers() {
        return this._paintingDividers;
    }

    public void setPaintingDividers(boolean bl) {
        this._paintingDividers = bl;
    }

    private void paintDivider(Graphics graphics, Rectangle rectangle, boolean bl) {
        if (graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height) && this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void paintDivider(Graphics graphics, ArrayList arrayList, boolean bl) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            DockDivider dockDivider = (DockDivider)arrayList.get(n2);
            this.paintDivider(graphics, dockDivider.getRectangle(), bl);
            ++n2;
        }
    }

    private boolean isDraggingDivider() {
        return this._draggedDivider != null;
    }

    private static DockDivider findDivider(ArrayList arrayList, Point point) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            DockDivider dockDivider = (DockDivider)arrayList.get(n2);
            if (dockDivider.getRectangle().contains(point)) {
                return dockDivider;
            }
            ++n2;
        }
        return null;
    }

    private void setCursor(Point point) {
        DockDivider dockDivider = DockLayoutPanel.findDivider(this._layout.getHorzDividers(this), point);
        if (dockDivider != null) {
            this.setCursor(Cursor.getPredefinedCursor(11));
            return;
        }
        dockDivider = DockLayoutPanel.findDivider(this._layout.getVertDividers(this), point);
        if (dockDivider != null) {
            this.setCursor(Cursor.getPredefinedCursor(9));
            return;
        }
        this.setCursor((Cursor)null);
    }

    private void renderDividerDrag() {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle rectangle = this._draggedDivider.getRectangle();
        if (this._draggedIsHorz) {
            n3 = n4 = this._draggedPtLast.x + rectangle.width / 2;
            n2 = rectangle.y;
            n = rectangle.y + rectangle.height;
        } else {
            n4 = rectangle.x;
            n3 = rectangle.x + rectangle.width;
            n = n2 = this._draggedPtLast.y + rectangle.height / 2;
        }
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.getBackground());
        graphics.drawLine(n4, n2, n3, n);
    }

    protected void whenDividerMoving() {
    }

    protected void whenDividerMoved() {
        int n = this._draggedIsHorz ? this._draggedPtLast.x - this._draggedPtStart.x : this._draggedPtLast.y - this._draggedPtStart.y;
        this._draggedDivider.moveBy(n, this._draggedIsHorz);
        this._draggedDivider = null;
        this.revalidate();
        this.setCursor((Cursor)null);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.setCursor(mouseEvent.getPoint());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor((Cursor)null);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isDraggingDivider()) {
            this._draggedPtStart.setLocation(mouseEvent.getPoint());
            this._draggedDivider = DockLayoutPanel.findDivider(this._layout.getHorzDividers(this), this._draggedPtStart);
            if (this._draggedDivider != null) {
                this._draggedIsHorz = true;
            } else {
                this._draggedDivider = DockLayoutPanel.findDivider(this._layout.getVertDividers(this), this._draggedPtStart);
                this._draggedIsHorz = false;
            }
        }
        if (this.isDraggingDivider()) {
            this._draggedPtLast.setLocation(this._draggedPtStart);
            this.renderDividerDrag();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isDraggingDivider()) {
            this.renderDividerDrag();
            this._draggedPtLast.setLocation(mouseEvent.getPoint());
            this.whenDividerMoving();
            this.renderDividerDrag();
            this.setCursor(this._draggedIsHorz ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(9));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isDraggingDivider()) {
            this.renderDividerDrag();
            this.whenDividerMoved();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && !mouseEvent.isPopupTrigger()) {
            int n;
            Point point = mouseEvent.getPoint();
            DockDivider dockDivider = DockLayoutPanel.findDivider(this._layout.getHorzDividers(this), point);
            if (dockDivider != null) {
                n = 0;
            } else {
                dockDivider = DockLayoutPanel.findDivider(this._layout.getVertDividers(this), point);
                n = 1;
            }
            if (dockDivider != null) {
                this.whenDividerDoubleClicked(dockDivider, n);
            }
        }
    }

    protected void whenDividerDoubleClicked(DockDivider dockDivider, int n) {
    }
}

