/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.util.NoSuchElementException;
import javax.swing.tree.TreeNode;
import oracle.ideimpl.controls.dockLayout.TreeIterator;

public final class TreeIteratorFactory {
    public static final Type TI_ABDC = new Type();
    public static final Type TI_ACBD = new Type();

    private TreeIteratorFactory() {
    }

    public static TreeIterator createIterator(Type type, TreeNode treeNode) {
        if (type == TI_ABDC) {
            return new TreeIteratorABDC(treeNode);
        }
        if (type == TI_ACBD) {
            return new TreeIteratorACBD(treeNode);
        }
        throw new IllegalArgumentException();
    }

    public static final class Type {
        Type() {
        }
    }

    private static class TreeIteratorABDC
    implements TreeIterator {
        protected TreeNode _root;
        private int _nPos;
        private TreeIterator _deeper;

        public TreeIteratorABDC(TreeNode treeNode) {
            this._root = treeNode;
            this._deeper = this;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this._deeper == this || this._deeper != null && this._deeper.hasNext() || this.isValidPos(this.nextPos(this._nPos));
        }

        public Object next() {
            return this.nextNode();
        }

        public TreeNode nextNode() {
            TreeNode treeNode = null;
            if (this._deeper == this) {
                treeNode = this._root;
                this._deeper = null;
                this._nPos = this.getBeforeFirstPos();
            } else {
                if (this._deeper != null && this._deeper.hasNext()) {
                    return this._deeper.nextNode();
                }
                this._nPos = this.nextPos(this._nPos);
                if (this.isValidPos(this._nPos)) {
                    TreeNode treeNode2 = this._root.getChildAt(this._nPos);
                    this._deeper = this.createDeeper(treeNode2);
                    treeNode = this._deeper.nextNode();
                }
            }
            if (treeNode == null) {
                throw new NoSuchElementException();
            }
            return treeNode;
        }

        protected int nextPos(int n) {
            return n + 1;
        }

        protected boolean isValidPos(int n) {
            return n < this._root.getChildCount();
        }

        protected int getBeforeFirstPos() {
            return -1;
        }

        protected TreeIterator createDeeper(TreeNode treeNode) {
            return new TreeIteratorABDC(treeNode);
        }
    }

    private static class TreeIteratorACBD
    extends TreeIteratorABDC
    implements TreeIterator {
        public TreeIteratorACBD(TreeNode treeNode) {
            super(treeNode);
        }

        protected int nextPos(int n) {
            return n - 1;
        }

        protected boolean isValidPos(int n) {
            return n >= 0;
        }

        protected int getBeforeFirstPos() {
            return this._root.getChildCount();
        }

        protected TreeIterator createDeeper(TreeNode treeNode) {
            return new TreeIteratorACBD(treeNode);
        }
    }
}

