/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import oracle.ide.controls.DragComponentEvent;
import oracle.ide.controls.DragComponentListener;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.Site;
import oracle.ide.util.GraphicsUtils;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.DragFeedback;

abstract class AbstractDockPanelDragListener
implements KeyEventDispatcher,
DragComponentListener {
    private DragFeedback _feedback;
    private static Point _ptDragFrom;
    private static Rectangle _rcOriginalBounds;
    private Dimension _preferredFloatingSize;
    private DockLayout _lockedLayout;

    protected boolean isDraggingTab() {
        return false;
    }

    protected abstract DockInsertionPoint getDockInsertionPoint(DragComponentEvent var1);

    protected abstract void dropComponent(DragComponentEvent var1);

    protected abstract void dragComponent(DragComponentEvent var1);

    protected AbstractDockPanelDragListener(DockableHolder dockableHolder) {
        this._preferredFloatingSize = AbstractDockPanelDragListener.getPreferredFloatingSize(dockableHolder);
    }

    private final DragFeedback getFeedback() {
        if (this._feedback == null) {
            this._feedback = new DragFeedback();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.addKeyEventDispatcher(this);
        }
        return this._feedback;
    }

    private final void disposeFeedback() {
        if (this._feedback != null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.removeKeyEventDispatcher(this);
            this._feedback.dispose();
            this._feedback = null;
        }
    }

    private static final boolean isDragging() {
        return _ptDragFrom != null;
    }

    private static final void endDragging() {
        _ptDragFrom = null;
    }

    public void start(DragComponentEvent dragComponentEvent) {
        Point point = dragComponentEvent.getPoint();
        _ptDragFrom = new Point(point);
        Component component = (Component)dragComponentEvent.getSource();
        _rcOriginalBounds = new Rectangle(component.getLocationOnScreen(), component.getSize());
        if (this.isDraggingTab()) {
            AbstractDockPanelDragListener._rcOriginalBounds.x = AbstractDockPanelDragListener._ptDragFrom.x - AbstractDockPanelDragListener._rcOriginalBounds.width / 2;
            AbstractDockPanelDragListener._rcOriginalBounds.y = AbstractDockPanelDragListener._ptDragFrom.y - 5;
        }
        this.dragComponent(dragComponentEvent);
    }

    public final void move(DragComponentEvent dragComponentEvent) {
        if (AbstractDockPanelDragListener.isDragging()) {
            DockInsertionPoint dockInsertionPoint = this.getDockInsertionPoint(dragComponentEvent);
            if (dockInsertionPoint != null) {
                DockLayoutPanel dockLayoutPanel = dockInsertionPoint.getContainer();
                DockLayout dockLayout = (DockLayout)dockLayoutPanel.getLayout();
                this.lockOptimize(dockLayout);
                Point point = dockInsertionPoint.getContainer().getLocationOnScreen();
                Rectangle rectangle = dockInsertionPoint.getFeedback();
                this.getFeedback().setFeedbackPosition(point.x + rectangle.x, point.y + rectangle.y, rectangle.width, rectangle.height);
            } else {
                Rectangle rectangle = this.getFloatingRect(dragComponentEvent);
                if (rectangle != null) {
                    this.getFeedback().setFloatingFeedbackPosition(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    this.getFeedback().setFloatingFeedbackPosition(0, 0, 0, 0);
                }
            }
            dragComponentEvent.consume();
        }
    }

    public final void end(DragComponentEvent dragComponentEvent) {
        block6: {
            try {
                if (!AbstractDockPanelDragListener.isDragging()) break block6;
                this.disposeFeedback();
                DockStationImpl dockStationImpl = DockStationImpl.getInstance();
                dockStationImpl.addDockableEventContext(12);
                try {
                    this.dropComponent(dragComponentEvent);
                }
                finally {
                    dockStationImpl.removeDockableEventContext(12);
                }
                AbstractDockPanelDragListener.endDragging();
                dragComponentEvent.consume();
            }
            finally {
                this.lockOptimize(null);
            }
        }
    }

    public void canceled(DragComponentEvent dragComponentEvent) {
        try {
            this.disposeFeedback();
            AbstractDockPanelDragListener.endDragging();
        }
        finally {
            this.lockOptimize(null);
        }
    }

    final Rectangle getFloatingRect(DragComponentEvent dragComponentEvent) {
        Point point = dragComponentEvent.getPoint();
        boolean bl = false;
        Rectangle[] rectangleArray = GraphicsUtils.getScreenBounds();
        Rectangle rectangle = rectangleArray[0];
        double d = Double.MAX_VALUE;
        int n = 0;
        while (!bl && n < rectangleArray.length) {
            Rectangle rectangle2 = rectangleArray[n];
            bl = rectangle2.contains(point);
            if (!bl) {
                Point point2 = new Point();
                int n2 = 0;
                while (n2 < 2) {
                    point2.x = rectangle2.x + n2 * rectangle2.width;
                    int n3 = 0;
                    while (n3 < 2) {
                        point2.y = rectangle2.y + n3 * rectangle2.height;
                        double d2 = point.distance(point2);
                        if (d2 < d) {
                            rectangle = rectangle2;
                            d = d2;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (!bl) {
            point.x = Math.max(point.x, rectangle.x);
            point.y = Math.max(point.y, rectangle.y);
            point.x = Math.min(point.x, rectangle.x + rectangle.width);
            point.y = Math.min(point.y, rectangle.y + rectangle.height);
        }
        return AbstractDockPanelDragListener.calcFloatFeedback(_ptDragFrom, point, _rcOriginalBounds, this._preferredFloatingSize);
    }

    private static final Dimension getPreferredFloatingSize(DockableHolder dockableHolder) {
        Dockable dockable = dockableHolder.getDockable();
        Dimension dimension = null;
        Site site = dockable.getSite();
        if (site.geometry != null) {
            dimension = site.geometry.getSize();
        }
        if (dimension == null) {
            JComponent jComponent = dockableHolder.getComponent();
            dimension = jComponent.getPreferredSize();
        }
        return dimension;
    }

    private static final Rectangle calcFloatFeedback(Point point, Point point2, Rectangle rectangle, Dimension dimension) {
        Rectangle rectangle2 = new Rectangle(point2.x - (point.x - rectangle.x) * dimension.width / rectangle.width, point2.y - (point.y - rectangle.y), dimension.width, dimension.height);
        return rectangle2;
    }

    private final void lockOptimize(DockLayout dockLayout) {
        if (this._lockedLayout != null) {
            this._lockedLayout.unlockOptimize();
        }
        if (dockLayout != null) {
            dockLayout.lockOptimize();
        }
        this._lockedLayout = dockLayout;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.canceled(null);
                return true;
            }
        }
        return false;
    }
}

