/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import oracle.ide.docking.Dockable;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.VisibilityLayout;

abstract class AbstractDockPanelHost
implements DockPanelHost {
    public boolean getDockablePath(DockablePath dockablePath, DockableCriteria dockableCriteria) {
        DockPanel dockPanel = this.getDockPanel();
        switch (dockableCriteria.getSearchFor()) {
            case 4: {
                if (dockPanel != dockableCriteria.getCriteria()) break;
                dockablePath.setDockPanel(dockPanel);
                return true;
            }
        }
        if (dockPanel.getDockablePath(dockablePath, dockableCriteria)) {
            dockablePath.setDockPanel(dockPanel);
            return true;
        }
        return false;
    }

    public DockInsertionPoint getClosestDockInsertionPoint(Point point, Dimension dimension, TitledPanel titledPanel) {
        DockPanel dockPanel = this.getDockPanel();
        return dockPanel.getClosestDockInsertionPoint(point, dimension, titledPanel);
    }

    public void getDockablePaths(List list) {
        DockPanel dockPanel = this.getDockPanel();
        int n = list.size();
        dockPanel.getDockablePaths(list);
        int n2 = n;
        while (n2 < list.size()) {
            DockablePath dockablePath = (DockablePath)list.get(n2);
            dockablePath.setDockPanel(dockPanel);
            ++n2;
        }
    }

    public void setDockableVisible(DockablePath dockablePath, boolean bl, int n) {
        DockPanel dockPanel = dockablePath.getDockPanel();
        dockPanel.setDockableVisible(dockablePath, bl, n);
    }

    public boolean activateDockable(DockablePath dockablePath) {
        DockPanel dockPanel = dockablePath.getDockPanel();
        return dockPanel.activateDockable(dockablePath);
    }

    public boolean getActiveDockablePath(DockablePath dockablePath) {
        DockPanel dockPanel = this.getDockPanel();
        if (dockPanel.getActiveDockablePath(dockablePath)) {
            dockablePath.setDockPanel(dockPanel);
            return true;
        }
        return false;
    }

    public void loadVisibilityLayout(VisibilityLayout visibilityLayout, boolean bl, int n) {
        DockPanel dockPanel = this.getDockPanel();
        dockPanel.loadVisibilityLayout(visibilityLayout, bl, n);
    }

    public void saveVisibilityLayout(VisibilityLayout visibilityLayout) {
        this.getDockPanel().saveVisibilityLayout(visibilityLayout);
    }

    public void dumpAllDockables() {
        DockPanel dockPanel = this.getDockPanel();
        int n = dockPanel.getTitledPanelCount();
        int n2 = 0;
        while (n2 < n) {
            TitledPanel titledPanel = dockPanel.getTitledPanel(n2);
            int n3 = titledPanel.getClientCount();
            int n4 = 0;
            while (n4 < n3) {
                Dockable dockable = titledPanel.getClient(n4);
                System.out.println(dockable.getClass().getName() + " -> " + dockable.getUniqueName());
                ++n4;
            }
            ++n2;
        }
    }

    public void dock(TitledPanel titledPanel, DockLayoutConstraint dockLayoutConstraint) {
        this.getDockPanel().dock(titledPanel, dockLayoutConstraint);
    }

    AbstractDockPanelHost() {
    }
}

