/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableContainer;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.GraphicsUtils;
import oracle.ideimpl.TitledContainer;
import oracle.ideimpl.controls.OneLineBorder;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.controls.Handlebar;
import oracle.ideimpl.resource.IdeImplArb;

public abstract class AbstractTitledPanel
extends JPanel
implements TitledContainer,
MouseInputListener,
ActionListener,
DockableContainer {
    private static final int BUTTON_POS_PAD = 0;
    private static final int BUTTON_POS_CLOSE = 1;
    private static final int BUTTON_POS_MINIMIZE_RESTORE = 2;
    private static final Dimension BUTTON_PAD_SIZE = new Dimension(3, 3);
    protected Handlebar _handlebar;
    protected Component _buttonPad;
    protected AbstractButton _buttonClose;
    protected AbstractButton _buttonPin;
    private DoubleClickTrigger _titleTrigger;
    protected static boolean _bDraging;
    protected static Point _ptStart;
    protected static final int DRAGSTART;

    static {
        _ptStart = new Point();
        DRAGSTART = AbstractTitledPanel.getDragStart();
    }

    void $init$() {
        this._titleTrigger = new DoubleClickTrigger();
    }

    protected abstract JPopupMenu getTitleContextMenu();

    protected abstract void whenSystemMenuClose(DockableHolder var1);

    protected void systemMenuMoveFloating() {
    }

    protected void systemMenuSizeFloating() {
    }

    protected abstract void whenMinimize(int var1);

    protected abstract void whenMaximize(int var1);

    protected abstract void whenRestore(int var1, DockableHolder var2);

    protected abstract void whenClose(int var1);

    protected abstract void systemMenuSizeDocked();

    protected void systemMenuMoveDocked() {
    }

    protected abstract void whenSystemMenuFloat(DockableHolder var1);

    protected void whenSystemMenuDock() {
    }

    protected abstract boolean isMinimized();

    protected abstract boolean isMinimizable();

    protected abstract boolean isMaximized();

    protected abstract boolean isMaximizable();

    protected abstract boolean isFloating();

    protected abstract boolean canMove();

    protected abstract boolean canSize();

    protected abstract DockableHolder getSelectedHolder();

    private static int getDragStart() {
        String string = "20";
        String string2 = Ide.getProperty("docking.dragThreshold", "20");
        int n = 5;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n * n;
    }

    protected AbstractTitledPanel() {
        super(new BorderLayout());
        this.$init$();
    }

    Handlebar getHandlebar() {
        return this._handlebar;
    }

    protected void createTitle() {
        this._handlebar = new Handlebar();
        this._handlebar.addMouseListener(this);
        this._handlebar.addMouseMotionListener(this);
        OneLineBorder oneLineBorder = new OneLineBorder(2, IdeConstants.COLOR_IDE_LINES);
        this._handlebar.setBorder(oneLineBorder);
    }

    protected final void createUIMap() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        AbstractTitledPanelAction abstractTitledPanelAction = new AbstractTitledPanelAction("aEditor");
        inputMap.put(keyStroke, abstractTitledPanelAction);
        actionMap.put(abstractTitledPanelAction, abstractTitledPanelAction);
        keyStroke = KeyStroke.getKeyStroke(45, 8);
        abstractTitledPanelAction = new AbstractTitledPanelAction("showSysMenu");
        inputMap.put(keyStroke, abstractTitledPanelAction);
        actionMap.put(abstractTitledPanelAction, abstractTitledPanelAction);
        keyStroke = AbstractTitledPanel.getClosePanelKeyStroke();
        abstractTitledPanelAction = new AbstractTitledPanelAction("sysClose");
        inputMap.put(keyStroke, abstractTitledPanelAction);
        actionMap.put(abstractTitledPanelAction, abstractTitledPanelAction);
    }

    protected static KeyStroke getClosePanelKeyStroke() {
        return KeyStroke.getKeyStroke(27, 1);
    }

    protected void titleMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showTitleContextMenu(mouseEvent);
        }
    }

    protected void titleMouseDragged(MouseEvent mouseEvent) {
    }

    protected void titleMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showTitleContextMenu(mouseEvent);
        }
    }

    protected void showTitleContextMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = this.getTitleContextMenu();
        if (jPopupMenu != null) {
            Point point = GraphicsUtils.getPopupMenuShowPoint(jPopupMenu, mouseEvent);
            jPopupMenu.show(mouseEvent.getComponent(), point.x, point.y);
        }
    }

    private AbstractButton addButton(int n, ArrayResourceBundle arrayResourceBundle, int n2, String string) {
        SmallSquareButton smallSquareButton = new SmallSquareButton(arrayResourceBundle, n2, string);
        smallSquareButton.setOpaque(false);
        smallSquareButton.addActionListener(this);
        this.getHandlebar().addButton(smallSquareButton, n);
        return smallSquareButton;
    }

    private void removeButton(int n) {
        this.getHandlebar().removeButton(n);
    }

    protected void adjustButtons(Dockable dockable) {
        if (this._buttonPad == null) {
            this._buttonPad = Box.createRigidArea(BUTTON_PAD_SIZE);
            this.getHandlebar().add(this._buttonPad, new Integer(0));
        }
        if (this._buttonClose == null) {
            String string = IdeArb.getString(464);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 1);
            String string2 = KeyUtil.toString(keyStroke);
            String string3 = string + " (" + string2 + ")";
            this._buttonClose = this.addButton(1, IdeArb.getInstance(), 463, string3);
        }
        if (this.isMinimizable() || this.isMaximizable()) {
            if (this._buttonPin == null) {
                if (this.isMinimized() || this.isMaximized()) {
                    String string = IdeImplArb.getString(58);
                    this._buttonPin = this.addButton(2, IdeImplArb.getInstance(), 57, string);
                } else {
                    String string = IdeImplArb.getString(56);
                    this._buttonPin = this.addButton(2, IdeImplArb.getInstance(), 55, string);
                }
            }
        } else if (this._buttonPin != null) {
            this.removeButton(2);
            this._buttonPin = null;
        }
    }

    protected void adjustTitle(Dockable dockable) {
        String string = dockable.getTitleName();
        this.setTitle(string);
        this.setIcon(dockable.getTabIcon());
    }

    private void setTitle(String string) {
        this._handlebar.setTitle(string);
    }

    private void setIcon(Icon icon) {
        this._handlebar.setIcon(icon);
    }

    boolean isActive() {
        return this._handlebar.isActive();
    }

    protected JPopupMenu createSystemMenu(DockableHolder dockableHolder) {
        KeyStroke keyStroke;
        String string;
        AbstractTitledPanelAction abstractTitledPanelAction;
        String string2;
        JPopupMenu jPopupMenu = new JPopupMenu();
        boolean bl = this.isFloating();
        if (this.isMaximizable() || this.isMinimizable()) {
            string2 = IdeImplArb.getString(46);
            abstractTitledPanelAction = new AbstractTitledPanelAction("restore", StringUtils.stripMnemonic((String)string2));
            abstractTitledPanelAction.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
            abstractTitledPanelAction.putValue("selectedHolder", dockableHolder);
            abstractTitledPanelAction.setEnabled(this.isMaximized() || this.isMinimized());
            jPopupMenu.add(abstractTitledPanelAction);
        }
        if (bl) {
            string2 = IdeImplArb.getString(47);
            abstractTitledPanelAction = new AbstractTitledPanelAction("dock", StringUtils.stripMnemonic((String)string2));
            abstractTitledPanelAction.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
            jPopupMenu.add(abstractTitledPanelAction);
        }
        string2 = IdeImplArb.getString(48);
        abstractTitledPanelAction = bl ? new AbstractTitledPanelAction("moveFloat", StringUtils.stripMnemonic((String)string2)) : new AbstractTitledPanelAction("moveDocked", StringUtils.stripMnemonic((String)string2));
        abstractTitledPanelAction.putValue("Name", StringUtils.stripMnemonic((String)string2));
        abstractTitledPanelAction.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
        abstractTitledPanelAction.setEnabled(this.canMove());
        jPopupMenu.add(abstractTitledPanelAction);
        string2 = IdeImplArb.getString(49);
        abstractTitledPanelAction = bl ? new AbstractTitledPanelAction("sizeFloat", StringUtils.stripMnemonic((String)string2)) : new AbstractTitledPanelAction("sizeDocked", StringUtils.stripMnemonic((String)string2));
        abstractTitledPanelAction.putValue("Name", StringUtils.stripMnemonic((String)string2));
        abstractTitledPanelAction.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
        abstractTitledPanelAction.setEnabled(this.canSize());
        jPopupMenu.add(abstractTitledPanelAction);
        if (!bl) {
            string2 = IdeImplArb.getString(50);
            abstractTitledPanelAction = new AbstractTitledPanelAction("float", StringUtils.stripMnemonic((String)string2));
            abstractTitledPanelAction.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
            abstractTitledPanelAction.putValue("selectedHolder", dockableHolder);
            jPopupMenu.add(abstractTitledPanelAction);
        }
        string2 = IdeImplArb.getString(51);
        abstractTitledPanelAction = new AbstractTitledPanelAction("minimize", StringUtils.stripMnemonic((String)string2));
        abstractTitledPanelAction.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
        abstractTitledPanelAction.setEnabled(this.isMinimizable() && !this.isMinimized());
        jPopupMenu.add(abstractTitledPanelAction);
        string2 = IdeImplArb.getString(52);
        abstractTitledPanelAction = new AbstractTitledPanelAction("maximize", StringUtils.stripMnemonic((String)string2));
        abstractTitledPanelAction.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
        abstractTitledPanelAction.setEnabled(this.isMaximizable() && !this.isMaximized());
        jPopupMenu.add(abstractTitledPanelAction);
        jPopupMenu.add(new JSeparator());
        if (dockableHolder != null) {
            string = "sysClose";
            string2 = IdeImplArb.getString(53);
            keyStroke = AbstractTitledPanel.getClosePanelKeyStroke();
        } else {
            string = "close";
            string2 = IdeImplArb.getString(44);
            keyStroke = null;
        }
        abstractTitledPanelAction = new AbstractTitledPanelAction(string, StringUtils.stripMnemonic((String)string2));
        abstractTitledPanelAction.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
        abstractTitledPanelAction.putValue("AcceleratorKey", keyStroke);
        abstractTitledPanelAction.putValue("selectedHolder", dockableHolder);
        jPopupMenu.add(abstractTitledPanelAction);
        return jPopupMenu;
    }

    protected void whenShowSystemMenu() {
        Component component;
        DockableHolder dockableHolder = this.getSelectedHolder();
        JPopupMenu jPopupMenu = this.createSystemMenu(dockableHolder);
        Component component2 = this;
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null && (component = window.getFocusOwner()) != null) {
            component2 = component;
        }
        Point point = this.getLocationOnScreen();
        Insets insets = this.getInsets();
        point.x += insets.left;
        if (this._handlebar != null) {
            point.y += this._handlebar.getHeight();
        }
        point = GraphicsUtils.getPopupMenuShowPoint(jPopupMenu, point.x, point.y);
        SwingUtilities.convertPointFromScreen(point, component2);
        jPopupMenu.show(component2, point.x, point.y);
    }

    private static void whenActivateEditors() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.activateCurrentEditorFrame();
        Ide.getMainWindow().toFront();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._buttonClose) {
            this.whenClose(20);
        } else if (object == this._buttonPin) {
            if (this.isMinimized() || this.isMaximized()) {
                this.whenRestore(4, this.getSelectedHolder());
            } else {
                this.whenMinimize(4);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._titleTrigger.isDoubleClick(mouseEvent) && this.isMaximizable()) {
            if (this.isMaximized()) {
                this.whenRestore(4, this.getSelectedHolder());
            } else {
                this.whenMaximize(4);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.titleMousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.titleMouseReleased(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.titleMouseDragged(mouseEvent);
    }

    public void containerActivated(boolean bl) {
        this._handlebar.setActive(bl);
    }

    private String getTitle() {
        return this._handlebar.getTitle();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new MyAccessibleContext();
        }
        return this.accessibleContext;
    }

    public String getName() {
        return this.getTitle();
    }

    static void maS$whenActivateEditors() {
        AbstractTitledPanel.whenActivateEditors();
    }

    static String mav$getTitle(AbstractTitledPanel abstractTitledPanel) {
        return abstractTitledPanel.getTitle();
    }

    protected class AbstractTitledPanelAction
    extends AbstractAction {
        public static final String CMD_CLOSE = "close";
        public static final String CMD_SHOW_SYS_MENU = "showSysMenu";
        public static final String CMD_ACTIVATE_EDITOR = "aEditor";
        public static final String CMD_SYS_MENU_CLOSE = "sysClose";
        public static final String CMD_SYS_MENU_MINIMIZE = "minimize";
        public static final String CMD_SYS_MENU_MAXIMIZE = "maximize";
        public static final String CMD_SYS_MENU_RESTORE = "restore";
        public static final String CMD_SYS_MENU_DOCK = "dock";
        public static final String CMD_SYS_MENU_FLOAT = "float";
        public static final String CMD_SYS_MOVE_DOCKED = "moveDocked";
        public static final String CMD_SYS_SIZE_DOCKED = "sizeDocked";
        public static final String CMD_SYS_MOVE_FLOAT = "moveFloat";
        public static final String CMD_SYS_SIZE_FLOAT = "sizeFloat";
        public static final String SELECTED_HOLDER_KEY = "selectedHolder";

        AbstractTitledPanelAction(String string) {
            this.init(string);
        }

        AbstractTitledPanelAction(String string, String string2) {
            super(string2);
            this.init(string);
        }

        AbstractTitledPanelAction(String string, String string2, Icon icon) {
            super(string2, icon);
            this.init(string);
        }

        private void init(String string) {
            this.putValue("ActionCommandKey", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DockStationImpl dockStationImpl = DockStationImpl.getInstance();
            dockStationImpl.addDockableEventContext(4);
            try {
                String string;
                DockableHolder dockableHolder = (DockableHolder)this.getValue(SELECTED_HOLDER_KEY);
                if (dockableHolder == null) {
                    dockableHolder = AbstractTitledPanel.this.getSelectedHolder();
                }
                if ((string = (String)this.getValue("ActionCommandKey")) == CMD_CLOSE) {
                    AbstractTitledPanel.this.whenClose(20);
                } else if (string == CMD_SHOW_SYS_MENU) {
                    AbstractTitledPanel.this.whenShowSystemMenu();
                } else if (string == CMD_ACTIVATE_EDITOR) {
                    AbstractTitledPanel.maS$whenActivateEditors();
                } else if (string == CMD_SYS_MENU_CLOSE) {
                    AbstractTitledPanel.this.whenSystemMenuClose(dockableHolder);
                } else if (string == CMD_SYS_MENU_MINIMIZE) {
                    AbstractTitledPanel.this.whenMinimize(4);
                } else if (string == CMD_SYS_MENU_MAXIMIZE) {
                    AbstractTitledPanel.this.whenMaximize(4);
                } else if (string == CMD_SYS_MENU_RESTORE) {
                    AbstractTitledPanel.this.whenRestore(4, dockableHolder);
                } else if (string == CMD_SYS_MENU_DOCK) {
                    AbstractTitledPanel.this.whenSystemMenuDock();
                } else if (string == CMD_SYS_MENU_FLOAT) {
                    AbstractTitledPanel.this.whenSystemMenuFloat(dockableHolder);
                } else if (string == CMD_SYS_MOVE_DOCKED) {
                    AbstractTitledPanel.this.systemMenuMoveDocked();
                } else if (string == CMD_SYS_SIZE_DOCKED) {
                    AbstractTitledPanel.this.systemMenuSizeDocked();
                } else if (string == CMD_SYS_MOVE_FLOAT) {
                    AbstractTitledPanel.this.systemMenuMoveFloating();
                } else if (string == CMD_SYS_SIZE_FLOAT) {
                    AbstractTitledPanel.this.systemMenuSizeFloating();
                }
            }
            finally {
                dockStationImpl.removeDockableEventContext(4);
            }
        }
    }

    protected class MyAccessibleContext
    extends JPanel.AccessibleJPanel {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return AbstractTitledPanel.mav$getTitle(AbstractTitledPanel.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.INTERNAL_FRAME;
        }

        protected MyAccessibleContext() {
            super(AbstractTitledPanel.this);
        }
    }
}

