/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.controls.Divider;
import oracle.ideimpl.docking.controls.DividerEvent;
import oracle.ideimpl.docking.controls.DividerListener;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterMargin;

public final class DividerControlledPanel
extends JPanel
implements SwingConstants {
    private static final int DIVIDER_SIZE = 4;
    private static final int MIN_SHOW = 10;
    private String _strOrientation;
    private ShutterMargin _margin;
    private DockPanel _dockPanel;
    private Divider _divider;
    private Dimension _dimRestore;
    private boolean _bResizable;

    void $init$() {
        this._bResizable = false;
    }

    public DividerControlledPanel(DockPanel dockPanel, String string) {
        this.$init$();
        this.setOpaque(false);
        this._dockPanel = dockPanel;
        this._strOrientation = DividerControlledPanel.getReverseOrientation(string);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this._margin = ShutterManager.getInstance().createShutterMargin(string);
        this._divider = new Divider(DividerControlledPanel.getIntOrientation(string), 4);
        this._divider.setOpaque(false);
        this.add((Component)dockPanel, "Center");
        this.add((Component)this._divider, this._strOrientation);
        this.add((Component)this._margin, string);
        this._divider.addDividerListener(new 1());
        this._divider.setVisible(false);
    }

    public DockPanel getDockPanel() {
        return this._dockPanel;
    }

    public ShutterMargin getShutterMargin() {
        return this._margin;
    }

    public void setRestoredSize(Dimension dimension) {
        this._dimRestore = new Dimension(dimension);
    }

    public Dimension getRestoredSize() {
        return this._dimRestore;
    }

    public void setResizable(boolean bl) {
        if (this._bResizable != bl) {
            this._divider.setVisible(bl);
            Container container = this.getParent();
            if (container != null) {
                container.doLayout();
            }
            this._bResizable = bl;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this._bResizable ? new Dimension(this._dimRestore) : this.getShutterMargin().getPreferredSize();
        return dimension;
    }

    String getOrientation() {
        return this._strOrientation;
    }

    private static String getReverseOrientation(String string) {
        String string2 = string == "West" ? "East" : (string == "North" ? "South" : (string == "East" ? "West" : "North"));
        return string2;
    }

    void moveBy(int n) {
        Dimension dimension = this._dockPanel.getMinimumSize();
        if (this._strOrientation.equalsIgnoreCase("West")) {
            this._dimRestore.width = Math.max(this._dimRestore.width - n, dimension.width + 4 + 10);
        } else if (this._strOrientation.equalsIgnoreCase("East")) {
            this._dimRestore.width = Math.max(this._dimRestore.width + n, dimension.width + 4 + 10);
        } else if (this._strOrientation.equalsIgnoreCase("North")) {
            this._dimRestore.height = Math.max(this._dimRestore.height - n, dimension.height + 4 + 10);
        } else if (this._strOrientation.equalsIgnoreCase("South")) {
            this._dimRestore.height = Math.max(this._dimRestore.height + n, dimension.height + 4 + 10);
        }
        Container container = this.getParent();
        if (container != null) {
            container.invalidate();
            container.validate();
        }
    }

    private static int getIntOrientation(String string) {
        if (string.equalsIgnoreCase("West") || string.equalsIgnoreCase("East")) {
            return 1;
        }
        return 0;
    }

    public final class 1
    implements DividerListener {
        public void dividerMoved(DividerEvent dividerEvent) {
            DividerControlledPanel.this.moveBy(dividerEvent.getDelta());
        }
    }
}

