/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.VisibilityLayout;
import oracle.ideimpl.docking.shutter.ShutterMargin;

public final class DockPanel
extends DockLayoutPanel {
    public void dock(TitledPanel titledPanel, DockLayoutConstraint dockLayoutConstraint) {
        DockStationImpl.transfer(titledPanel, this, dockLayoutConstraint);
    }

    public void remove(int n) {
        ShutterMargin shutterMargin = this.getShutterMargin();
        if (shutterMargin != null) {
            TitledPanel titledPanel = (TitledPanel)this.getComponent(n);
            shutterMargin.removeShutter(titledPanel);
        }
        super.remove(n);
    }

    public void removeAll() {
        ShutterMargin shutterMargin = this.getShutterMargin();
        if (shutterMargin != null) {
            shutterMargin.removeAll();
        }
        super.removeAll();
    }

    public static boolean canDock(JComponent jComponent, DockLayoutConstraint dockLayoutConstraint) {
        DockLayoutInfo dockLayoutInfo;
        Object object = dockLayoutConstraint.getReference();
        return !(object instanceof DockLayoutInfo ? (dockLayoutInfo = (DockLayoutInfo)object).isReferring(jComponent) : jComponent == object);
    }

    public int getTitledPanelCount() {
        return this.getComponentCount();
    }

    public TitledPanel getTitledPanel(int n) {
        return (TitledPanel)this.getComponent(n);
    }

    public int indexOfTitledPanel(TitledPanel titledPanel) {
        int n = this.getComponentCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (titledPanel == this.getComponent(n2)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public TitledPanel[] getAllTitledPanels() {
        int n = this.getComponentCount();
        TitledPanel[] titledPanelArray = new TitledPanel[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            titledPanelArray[n2] = (TitledPanel)this.getComponent(n2);
            --n2;
        }
        return titledPanelArray;
    }

    protected void whenDividerMoving() {
        if (this._draggedIsHorz) {
            this._draggedPtLast.x = this._draggedDivider.adjustForMax(this._draggedPtLast.x);
        } else {
            this._draggedPtLast.y = this._draggedDivider.adjustForMax(this._draggedPtLast.y);
        }
    }

    public void loadVisibilityLayout(VisibilityLayout visibilityLayout, boolean bl, int n) {
        int n2 = this.getTitledPanelCount();
        int n3 = 0;
        while (n3 < n2) {
            TitledPanel titledPanel = this.getTitledPanel(n3);
            titledPanel.loadVisibilityLayout(visibilityLayout, bl, n);
            ++n3;
        }
    }

    void saveVisibilityLayout(VisibilityLayout visibilityLayout) {
        int n = this.getTitledPanelCount();
        int n2 = 0;
        while (n2 < n) {
            TitledPanel titledPanel = this.getTitledPanel(n2);
            titledPanel.saveVisibilityLayout(visibilityLayout);
            ++n2;
        }
    }

    public boolean getDockablePath(DockablePath dockablePath, DockableCriteria dockableCriteria) {
        switch (dockableCriteria.getSearchFor()) {
            case 1: {
                TitledPanel titledPanel = (TitledPanel)dockableCriteria.getCriteria();
                int n = this.indexOfTitledPanel(titledPanel);
                if (n == -1) break;
                dockablePath.setTitledPanel(titledPanel);
                return true;
            }
            default: {
                int n = this.getTitledPanelCount();
                int n2 = 0;
                while (n2 < n) {
                    TitledPanel titledPanel = this.getTitledPanel(n2);
                    if (titledPanel.getDockablePath(dockablePath, dockableCriteria)) {
                        dockablePath.setTitledPanel(titledPanel);
                        return true;
                    }
                    ++n2;
                }
                break block0;
            }
        }
        return false;
    }

    public DockInsertionPoint getClosestDockInsertionPoint(Point point, Dimension dimension, TitledPanel titledPanel) {
        DockInsertionPoint dockInsertionPoint = null;
        if (this.isShowing()) {
            double d = Double.MAX_VALUE;
            Point point2 = this.getLocationOnScreen();
            DockLayout dockLayout = (DockLayout)this.getLayout();
            ArrayList arrayList = dockLayout.getInsertionPoints(this);
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                DockLayoutConstraint dockLayoutConstraint;
                double d2;
                DockInsertionPoint dockInsertionPoint2 = (DockInsertionPoint)arrayList.get(n2);
                Point point3 = dockInsertionPoint2.getAnchor();
                Point point4 = new Point(point3.x + point2.x, point3.y + point2.y);
                if ((dimension.width < 0 && point4.x < point.x || dimension.width > 0 && point4.x > point.x || dimension.height < 0 && point4.y < point.y || dimension.height > 0 && point4.y > point.y) && (d2 = point.distance(point4)) < d && DockPanel.canDock(titledPanel, dockLayoutConstraint = dockInsertionPoint2.createConstraint())) {
                    dockInsertionPoint = dockInsertionPoint2;
                    d = d2;
                    dockInsertionPoint.setContainer(this);
                }
                ++n2;
            }
        }
        return dockInsertionPoint;
    }

    public void getDockablePaths(List list) {
        int n = this.getTitledPanelCount();
        int n2 = 0;
        while (n2 < n) {
            TitledPanel titledPanel = this.getTitledPanel(n2);
            int n3 = list.size();
            titledPanel.getDockablePaths(list);
            int n4 = n3;
            while (n4 < list.size()) {
                DockablePath dockablePath = (DockablePath)list.get(n4);
                dockablePath.setTitledPanel(titledPanel);
                ++n4;
            }
            ++n2;
        }
    }

    public void setDockableVisible(DockablePath dockablePath, boolean bl, int n) {
        TitledPanel titledPanel = dockablePath.getTitledPanel();
        titledPanel.setDockableVisible(dockablePath, bl, n);
    }

    public boolean activateDockable(DockablePath dockablePath) {
        TitledPanel titledPanel = dockablePath.getTitledPanel();
        return titledPanel.activateDockable(dockablePath, 0);
    }

    public boolean getActiveDockablePath(DockablePath dockablePath) {
        int n = this.getTitledPanelCount();
        int n2 = 0;
        while (n2 < n) {
            TitledPanel titledPanel = this.getTitledPanel(n2);
            if (titledPanel.getActiveDockablePath(dockablePath)) {
                dockablePath.setTitledPanel(titledPanel);
                return true;
            }
            ++n2;
        }
        return false;
    }

    DividerControlledPanel getDividerControlledPanel() {
        Container container = this.getParent();
        return container instanceof DividerControlledPanel ? (DividerControlledPanel)container : null;
    }

    ShutterMargin getShutterMargin() {
        DividerControlledPanel dividerControlledPanel = this.getDividerControlledPanel();
        if (dividerControlledPanel != null) {
            return dividerControlledPanel.getShutterMargin();
        }
        return null;
    }
}

