/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.PentaLayout;
import oracle.ide.controls.SplashScreen;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.ide.panels.Navigable;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.PropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.ProfileIDs;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutUtil;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockStationListener;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.DockableSelector;
import oracle.ideimpl.docking.DockingConfigOptions;
import oracle.ideimpl.docking.DockingConfigPanel;
import oracle.ideimpl.docking.FactoriesRegistry;
import oracle.ideimpl.docking.FloatDockWindow;
import oracle.ideimpl.docking.SidePort;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelXMLDockLayoutPersistence;
import oracle.ideimpl.docking.VisibilityLayout;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.ideimpl.resource.IdeImplArb;

public final class DockStationImpl
extends DockStation
implements ChangeListener,
ControllerProvider,
Controller {
    private static final boolean DEBUG_PRINT_EVENTS = false;
    private static final DockableSelector DOCKABLE_SELECTOR = DockableSelector.getInstance();
    private PentaLayout _pentaLayout;
    private ArrayList _dockPanelHosts;
    private JFrame _frame;
    private static DockStationImpl _instance;
    private DockStationListener _dockStationListener;
    private FactoriesRegistry _factoryRegistry;
    private HashMap _dockableCache;
    private boolean _bIsUIVisible;
    private ArrayList _floatToShow;
    private HashMap _dockableListeners;
    private int _nDockableEventContext;
    static final int DONE = 0;
    static final int NOT_FOUND = 1;
    static final int LAST = 2;
    private VisibilityLayout _currentVisibilityLayout;
    private Layout _currentLayout;
    private static final boolean DEBUG_PRINT = false;
    private boolean _printInvalidDockingOperations;
    private ActiveViewHandlerImpl _activeViewHandler;
    private Container _topPanel;
    private SidePort[] _sidePorts;

    void $init$() {
        this._dockPanelHosts = new ArrayList(5);
        this._factoryRegistry = new FactoriesRegistry();
        this._dockableCache = new HashMap(20);
        this._bIsUIVisible = false;
        this._printInvalidDockingOperations = false;
    }

    public static final DockStationImpl getInstance() {
        if (_instance == null) {
            _instance = new DockStationImpl();
        }
        return _instance;
    }

    private DockStationListener getLayoutListener() {
        if (this._dockStationListener == null) {
            this._dockStationListener = new DockStationListener();
        }
        return this._dockStationListener;
    }

    public void registerDockableFactory(String string, DockableFactory dockableFactory) {
        this.registerDockableFactory(string, dockableFactory, 1000.0);
    }

    public void registerDockableFactory(String string, DockableFactory dockableFactory, double d) {
        this._factoryRegistry.registerDockableFactory(string, dockableFactory, d);
        if (this._bIsUIVisible) {
            ArrayList arrayList = this.getAllDockables();
            dockableFactory.install();
            ArrayList arrayList2 = this.getAllDockables();
            arrayList2.removeAll(arrayList);
            if (!arrayList2.isEmpty()) {
                this.setDefaultState(arrayList2, this._currentLayout);
            }
        }
    }

    public void unregisterDockableFactory(String string) {
        this._factoryRegistry.unregisterDockableFactory(string);
    }

    public void addDockableListener(DockableListener dockableListener, Dockable dockable) {
        HashMap hashMap = this.getDockableListeners();
        ArrayList<DockableListener> arrayList = (ArrayList<DockableListener>)hashMap.get(dockable);
        if (arrayList == null) {
            arrayList = new ArrayList<DockableListener>(1);
            hashMap.put(dockable, arrayList);
        }
        arrayList.add(dockableListener);
    }

    public void removeDockableListener(DockableListener dockableListener, Dockable dockable) {
        HashMap hashMap = this.getDockableListeners();
        ArrayList arrayList = (ArrayList)hashMap.get(dockable);
        if (arrayList != null) {
            arrayList.remove(dockableListener);
        }
    }

    public void initialize() {
        ClientSetting clientSetting = ClientSetting.findOrCreate("oracle.ide");
        DockingConfigOptions dockingConfigOptions = (DockingConfigOptions)clientSetting.getData("DockingConfigOptions");
        if (dockingConfigOptions == null) {
            dockingConfigOptions = new DockingConfigOptions();
            clientSetting.putData("DockingConfigOptions", dockingConfigOptions);
        }
        this.stateChanged(null);
        dockingConfigOptions.addChangeListener(this);
        String string = IdeImplArb.getString(59);
        Navigable navigable = new Navigable(string, DockingConfigPanel.class);
        Navigable navigable2 = Ide.getSettings().getEnvironNavigable();
        navigable2.addChildNavigable(navigable);
        Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            layouts.addLayoutListener("DockStation", this.getLayoutListener());
        }
    }

    public void install(JFrame jFrame, Container container, JComponent jComponent) {
        this._topPanel = container;
        this.setApplicationFrame(jFrame);
        this._pentaLayout = new PentaLayout(15, 0, 0);
        this._topPanel.setLayout(this._pentaLayout);
        this._topPanel.add((Component)jComponent, PentaLayout.CENTER);
        this._sidePorts = new SidePort[4];
        int n = 0;
        while (n < this._sidePorts.length) {
            this._sidePorts[n] = new SidePort(container, n);
            this.registerDockPanelHost(this._sidePorts[n]);
            ++n;
        }
    }

    public void setPentaLayoutStyle(byte by) {
        this._pentaLayout.setStyle(by);
        this._topPanel.invalidate();
        this._topPanel.validate();
    }

    public boolean getDockablePath(DockablePath dockablePath, DockableCriteria dockableCriteria) {
        int n = 0;
        while (n < this._dockPanelHosts.size()) {
            DockPanelHost dockPanelHost = (DockPanelHost)this._dockPanelHosts.get(n);
            if (dockPanelHost.getDockablePath(dockablePath, dockableCriteria)) {
                dockablePath.setDockPanelHost(dockPanelHost);
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isDockableVisible(Dockable dockable) {
        TitledPanel titledPanel;
        DockablePath dockablePath;
        return dockable != null && this.getDockablePath(dockablePath = new DockablePath(), new DockableCriteria(dockable)) && (titledPanel = dockablePath.getTitledPanel()).isClientAccessible(dockable);
    }

    public boolean isDockableVisible(String string) {
        return this.isDockableVisible(this.getDockable(new ViewId(string)));
    }

    public int getDockableStatus(Dockable dockable) {
        int n = 0;
        DockablePath dockablePath = new DockablePath();
        if (this.getDockablePath(dockablePath, new DockableCriteria(dockable))) {
            TitledPanel titledPanel = dockablePath.getTitledPanel();
            n = n | 1 | titledPanel.getDockableStatus(dockable);
        }
        return n;
    }

    public boolean isDockableAccessible(Dockable dockable) {
        DockablePath dockablePath;
        if (dockable != null && this.getDockablePath(dockablePath = new DockablePath(), new DockableCriteria(dockable))) {
            TitledPanel titledPanel = dockablePath.getTitledPanel();
            return titledPanel.isClientAccessible(dockable);
        }
        return false;
    }

    public void dock(Dockable dockable, DockingParam dockingParam) {
        this.dock(dockable, dockingParam, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void dock(Dockable dockable, DockingParam dockingParam, int n) {
        if (this._printInvalidDockingOperations) {
            // empty if block
        }
        if (!dockingParam.isFloating()) {
            Dockable dockable2 = dockingParam.getReference();
            if (dockable2 == null) {
                int n2 = dockingParam.getOrientation();
                this._dockAtAbsolutePosition(dockable, n2, n);
                return;
            } else {
                DockablePath dockablePath = new DockablePath();
                if (this.getDockablePath(dockablePath, new DockableCriteria(dockable2))) {
                    TitledPanel titledPanel = dockablePath.getTitledPanel();
                    int n3 = dockingParam.getOrientation();
                    if (n3 != 4) {
                        DockLayoutConstraint dockLayoutConstraint = new DockLayoutConstraint(titledPanel, n3, dockingParam.getExtents(), null);
                        TitledPanel titledPanel2 = DockStationImpl.wrap(dockable, false, n);
                        DockPanel dockPanel = dockablePath.getDockPanel();
                        dockPanel.dock(titledPanel2, dockLayoutConstraint);
                        return;
                    } else {
                        DockableHolder dockableHolder = new DockableHolder(dockable);
                        titledPanel.addClient(dockableHolder, n);
                    }
                    return;
                } else {
                    int n4 = dockingParam.getAlternateOrientation();
                    if (n4 == -1) throw new IllegalArgumentException("Reference dockable not found");
                    this._dockAtAbsolutePosition(dockable, n4, n);
                }
            }
            return;
        } else {
            TitledPanel titledPanel = DockStationImpl.wrap(dockable, false, n);
            DockableHolder dockableHolder = titledPanel.getHolder(dockable);
            Rectangle rectangle = dockingParam.getFloatingPosition();
            Boolean bl = dockingParam.isFloatOnTop();
            dockableHolder.setFloatOnTop(bl);
            FloatDockWindow floatDockWindow = this.dockFloat(titledPanel, rectangle.getLocation(), rectangle.getSize());
            dockingParam.setFloatingToolWindow(floatDockWindow);
        }
    }

    private void _dockAtAbsolutePosition(Dockable dockable, int n, int n2) {
        if (n > 3) {
            throw new IllegalArgumentException("nOrientation must be in the range of WEST to SOUTH");
        }
        int n3 = DockLayoutUtil.isHorz(n) ? 2 : 0;
        Dimension dimension = dockable.getSite().size;
        DockLayoutConstraint dockLayoutConstraint = new DockLayoutConstraint(n3 |= 1, dimension);
        DockPanel dockPanel = this._sidePorts[n].getDockPanel();
        this._dock(dockable, dockPanel, dockLayoutConstraint, false, n2);
    }

    public void undock(Dockable dockable) {
        this.undock(dockable, 0);
    }

    void undock(Dockable dockable, int n) {
        DockablePath dockablePath = new DockablePath();
        if (this.getDockablePath(dockablePath, new DockableCriteria(dockable))) {
            TitledPanel titledPanel = dockablePath.getTitledPanel();
            titledPanel.removeClient(dockable, n);
        }
    }

    public void setDockableVisible(String string, boolean bl) {
        ViewId viewId = new ViewId(string);
        Dockable dockable = this.getDockable(viewId);
        if (dockable == null && bl) {
            dockable = this.createDockable(viewId);
        }
        if (dockable != null) {
            this.setDockableVisible(dockable, bl, 0);
        }
    }

    public void setDockableVisible(Dockable dockable, boolean bl) {
        this.setDockableVisible(dockable, bl, 0);
    }

    void setDockableVisible(Dockable dockable, boolean bl, int n) {
        DockablePath dockablePath = new DockablePath();
        DockableCriteria dockableCriteria = new DockableCriteria(dockable);
        if (!this.getDockablePath(dockablePath, dockableCriteria)) {
            if (this._bIsUIVisible && bl) {
                DockingParam dockingParam = new DockingParam();
                dockingParam.setPosition(0);
                this.dock(dockable, dockingParam, n);
                if (this.getDockablePath(dockablePath, dockableCriteria)) {
                    this.setDockableVisible(dockablePath, bl, n);
                }
            }
        } else {
            this.setDockableVisible(dockablePath, bl, n);
        }
    }

    void setDockableVisible(DockablePath dockablePath, boolean bl, int n) {
        DockableHolder dockableHolder;
        JComponent jComponent;
        MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
        int n2 = mainWindowImpl.getMaximizedWindowType();
        if (n2 != 0 && (jComponent = (dockableHolder = dockablePath.getDockableHolder()).getComponent()) != null && !jComponent.isShowing()) {
            mainWindowImpl.restore();
        }
        DockPanelHost dockPanelHost = dockablePath.getDockPanelHost();
        dockPanelHost.setDockableVisible(dockablePath, bl, n);
    }

    public void close(Dockable dockable) {
        this.addDockableEventContext(20);
        try {
            this.closeDockable(dockable, 20);
        }
        finally {
            this.removeDockableEventContext(20);
        }
    }

    public void saveLayout(PropertyAccess propertyAccess) {
        this.saveVisibilityLayout(this._currentVisibilityLayout);
        this.saveKnownFactories();
        this.savePositions();
    }

    private void savePositions() {
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess(null);
        TitledPanelXMLDockLayoutPersistence titledPanelXMLDockLayoutPersistence = new TitledPanelXMLDockLayoutPersistence();
        int n = 0;
        while (n < this._sidePorts.length) {
            SidePort sidePort = this._sidePorts[n];
            try {
                StructuredPropertyAccess structuredPropertyAccess = sidePort.saveLayout(titledPanelXMLDockLayoutPersistence);
                defaultStructuredPropertyAccess.appendChild(structuredPropertyAccess);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        int n2 = this._dockPanelHosts.size();
        while (n < n2) {
            DockPanelHost dockPanelHost = (DockPanelHost)this._dockPanelHosts.get(n);
            try {
                StructuredPropertyAccess structuredPropertyAccess = dockPanelHost.saveLayout(titledPanelXMLDockLayoutPersistence);
                defaultStructuredPropertyAccess.appendChild(structuredPropertyAccess);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        LayoutsImpl layoutsImpl = LayoutsImpl.getInstance();
        layoutsImpl.setDockablePositions(defaultStructuredPropertyAccess);
    }

    private void saveKnownFactories() {
        ArrayList arrayList = this._factoryRegistry.getDockableFactoriesNames();
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        LayoutsImpl layoutsImpl = LayoutsImpl.getInstance();
        layoutsImpl.setKnownDockableFactories(stringArray);
    }

    void closeDockable(Dockable dockable, int n) {
        DockablePath dockablePath = new DockablePath();
        if (this.getDockablePath(dockablePath, new DockableCriteria(dockable))) {
            int n2;
            DockableHolder dockableHolder;
            JComponent jComponent;
            TitledPanel titledPanel = dockablePath.getTitledPanel();
            boolean bl = false;
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getPermanentFocusOwner();
            if (component != null && (jComponent = (dockableHolder = titledPanel.getHolder(dockable)).getComponent()) != null && jComponent.isAncestorOf(component)) {
                keyboardFocusManager.clearGlobalFocusOwner();
                bl = true;
            }
            if (BitField.isSet(n2 = dockable.getType(), 1)) {
                this.undock(dockable, n);
                int n3 = titledPanel.getClientCount();
                if (n3 == 0) {
                    DockPanel dockPanel = titledPanel.getDockPanel();
                    dockPanel.remove(titledPanel);
                }
            } else {
                this.setDockableVisible(dockable, false, n);
            }
            if (bl) {
                IdeUtil.tryToRestoreFocus(null);
            }
        }
    }

    public TitledPanel _dock(Dockable dockable, DockPanel dockPanel, DockLayoutConstraint dockLayoutConstraint, boolean bl, int n) {
        TitledPanel titledPanel = DockStationImpl.wrap(dockable, bl, n);
        if (titledPanel != null) {
            this._dock(titledPanel, dockPanel, dockLayoutConstraint);
        }
        return titledPanel;
    }

    private DockStationImpl() {
        this.$init$();
    }

    private ArrayList getDockablePaths() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this._dockPanelHosts.size()) {
            DockPanelHost dockPanelHost = (DockPanelHost)this._dockPanelHosts.get(n);
            int n2 = arrayList.size();
            dockPanelHost.getDockablePaths(arrayList);
            int n3 = n2;
            while (n3 < arrayList.size()) {
                DockablePath dockablePath = (DockablePath)arrayList.get(n3);
                dockablePath.setDockPanelHost(dockPanelHost);
                ++n3;
            }
            ++n;
        }
        return arrayList;
    }

    private HashMap getDockableListeners() {
        if (this._dockableListeners == null) {
            this._dockableListeners = new HashMap(3);
        }
        return this._dockableListeners;
    }

    private void setApplicationFrame(JFrame jFrame) {
        this._frame = jFrame;
        JLayeredPane jLayeredPane = this._frame.getLayeredPane();
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        jLayeredPane.add((Component)shutterPanel, new Integer(50));
    }

    public void setActiveViewHandler(ActiveViewHandlerImpl activeViewHandlerImpl) {
        this._activeViewHandler = activeViewHandlerImpl;
        int n = 0;
        while (n < this._sidePorts.length) {
            SidePort sidePort = this._sidePorts[n];
            sidePort.setActiveViewHandler(activeViewHandlerImpl);
            ++n;
        }
    }

    ActiveViewHandlerImpl getActiveViewHandler() {
        return this._activeViewHandler;
    }

    public int getPanelOrientation(DockPanel dockPanel) {
        int n = 0;
        while (n < this._sidePorts.length) {
            SidePort sidePort = this._sidePorts[n];
            if (sidePort.getDockablePath(new DockablePath(), new DockableCriteria(dockPanel))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    SidePort getSidePort(int n) {
        return this._sidePorts[n];
    }

    private Dockable getActiveDockable() {
        DockablePath dockablePath = new DockablePath();
        return this.getActiveDockablePath(dockablePath) ? dockablePath.getDockable() : null;
    }

    private boolean getActiveDockablePath(DockablePath dockablePath) {
        int n = 0;
        while (n < this._dockPanelHosts.size()) {
            DockPanelHost dockPanelHost = (DockPanelHost)this._dockPanelHosts.get(n);
            if (dockPanelHost.getActiveDockablePath(dockablePath)) {
                dockablePath.setDockPanelHost(dockPanelHost);
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean activateDockable(DockablePath dockablePath) {
        Dockable dockable;
        boolean bl = false;
        TitledPanel titledPanel = dockablePath.getTitledPanel();
        if (titledPanel.isClientAccessible(dockable = dockablePath.getDockable())) {
            DockPanelHost dockPanelHost = dockablePath.getDockPanelHost();
            bl = dockPanelHost.activateDockable(dockablePath);
        }
        return bl;
    }

    public boolean activateDockable(Dockable dockable) {
        if (this.getActiveDockable() == dockable) {
            return true;
        }
        boolean bl = false;
        DockablePath dockablePath = new DockablePath();
        if (this.getDockablePath(dockablePath, new DockableCriteria(dockable))) {
            this.setDockableVisible(dockablePath, true, 0);
            bl = this.activateDockable(dockablePath);
        }
        return bl;
    }

    public boolean activateAnyDockable() {
        return this.activateFirstDockable();
    }

    private boolean activateNextDockable(boolean bl) {
        DockablePath dockablePath = new DockablePath();
        if (this.getActiveDockablePath(dockablePath)) {
            DockablePath dockablePath2;
            ArrayList arrayList = this.getDockablePaths();
            LinkedList<DockablePath> linkedList = new LinkedList<DockablePath>();
            for (DockablePath dockablePath3 : arrayList) {
                Dockable dockable = dockablePath3.getDockable();
                if (!this.isDockableVisible(dockable)) continue;
                linkedList.addLast(dockablePath3);
            }
            if (linkedList.size() < 2) {
                return false;
            }
            while (!(dockablePath2 = (DockablePath)linkedList.getFirst()).equals(dockablePath)) {
                linkedList.removeFirst();
                linkedList.addLast(dockablePath2);
            }
            if (bl) {
                DOCKABLE_SELECTOR.selectNext(linkedList);
            } else {
                DOCKABLE_SELECTOR.selectPrevious(linkedList);
            }
            return true;
        }
        return false;
    }

    private boolean activateFirstDockable() {
        ArrayList arrayList = this.getDockablePaths();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            DockablePath dockablePath = (DockablePath)arrayList.get(n2);
            if (this.isVisible(dockablePath) && this.activateDockable(dockablePath)) {
                return true;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            DockablePath dockablePath = (DockablePath)arrayList.get(n3);
            if (this.isMinimized(dockablePath) && this.activateDockable(dockablePath)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private boolean isVisible(DockablePath dockablePath) {
        TitledPanel titledPanel = dockablePath.getTitledPanel();
        Dockable dockable = dockablePath.getDockable();
        int n = titledPanel.getDockableStatus(dockable);
        return BitField.isSet(n, 32);
    }

    private boolean isMinimized(DockablePath dockablePath) {
        TitledPanel titledPanel = dockablePath.getTitledPanel();
        Dockable dockable = dockablePath.getDockable();
        int n = titledPanel.getDockableStatus(dockable);
        return BitField.isSet(n, 4);
    }

    private static void fireDockableEvent(ArrayList arrayList, DockableEvent dockableEvent) {
        if (arrayList != null) {
            int n = dockableEvent.getID();
            for (DockableListener dockableListener : arrayList) {
                switch (n) {
                    case 1: {
                        dockableListener.dockableHidden(dockableEvent);
                        break;
                    }
                    case 0: {
                        dockableListener.dockableShown(dockableEvent);
                    }
                }
            }
        }
    }

    public void fireDockableEvent(DockableEvent dockableEvent) {
        HashMap hashMap = this.getDockableListeners();
        int n = dockableEvent.getContext();
        DockStationImpl.fireDockableEvent((ArrayList)hashMap.get(dockableEvent.getSource()), dockableEvent);
        DockStationImpl.fireDockableEvent((ArrayList)hashMap.get(null), dockableEvent);
    }

    private static String getContextName(int n) {
        String string = (BitField.isSet(n, 1) ? "LAYOUT_CHANGE " : "") + (BitField.isSet(n, 2) ? "LAYOUT_INSTALL " : "") + (BitField.isSet(n, 4) ? "USER_ACTION " : "") + (BitField.isSet(n, 8) ? "DRAG " : "") + (BitField.isSet(n, 16) ? "TOGGLE " : "");
        return string;
    }

    public void addDockableEventContext(int n) {
        this._nDockableEventContext |= n;
    }

    public void removeDockableEventContext(int n) {
        this._nDockableEventContext &= ~n;
    }

    private int getDockableEventContext() {
        return this._nDockableEventContext;
    }

    private static Component prepareToRemove(TitledPanel titledPanel) {
        Component component;
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component2 != null && SwingUtilities.isDescendingFrom(component2, titledPanel)) {
            component = component2;
            IdeUtil.moveFocusAway();
        } else {
            component = null;
        }
        return component;
    }

    void _dock(TitledPanel titledPanel, DockPanel dockPanel, DockLayoutConstraint dockLayoutConstraint) {
        Component component = DockStationImpl.prepareToRemove(titledPanel);
        dockPanel.dock(titledPanel, dockLayoutConstraint);
        if (component != null) {
            SwingUtilities.invokeLater(new 2(this, component));
        }
        dockPanel.revalidate();
    }

    private static TitledPanel wrap(Dockable dockable, boolean bl, int n) {
        TitledPanel titledPanel = new TitledPanel();
        if (!bl) {
            titledPanel.setVisible(false);
        }
        titledPanel.addClient(dockable, bl, n);
        return titledPanel;
    }

    static void transferClients(TitledPanel titledPanel, TitledPanel titledPanel2, int n) {
        Container container = titledPanel.getParent();
        Container container2 = titledPanel2.getParent();
        DockableHolder dockableHolder = titledPanel.getSelectedHolder();
        Dockable dockable = dockableHolder.getDockable();
        titledPanel2.transferClients(titledPanel, n);
        titledPanel2.activateDockable(dockable);
        Container container3 = titledPanel.getParent();
        container3.remove(titledPanel);
        container.validate();
        container2.validate();
    }

    FloatDockWindow dockFloat(TitledPanel titledPanel, Point point) {
        return this.dockFloat(titledPanel, point, null);
    }

    private FloatDockWindow dockFloat(TitledPanel titledPanel, Point point, Dimension dimension) {
        boolean bl = titledPanel.isVisible();
        FloatDockWindow floatDockWindow = new FloatDockWindow(this._frame);
        Dimension dimension2 = titledPanel.getPrefDockedSize();
        DockLayoutConstraint dockLayoutConstraint = new DockLayoutConstraint(0, dimension2);
        floatDockWindow.dock(titledPanel, dockLayoutConstraint);
        floatDockWindow.createWindowUI();
        Dimension dimension3 = dimension == null ? titledPanel.getPrefFloatSize() : dimension;
        floatDockWindow.adjustClientSize(dimension3, false);
        Window window = floatDockWindow.getGUI();
        window.setVisible(false);
        window.setSize(dimension3);
        if (point != null) {
            window.setLocation(point);
        } else {
            GraphicsUtils.centerWindowOnComponent(window, this._frame);
        }
        if (bl) {
            this.setFloatVisible(floatDockWindow, true);
        }
        return floatDockWindow;
    }

    void registerDockPanelHost(DockPanelHost dockPanelHost) {
        this._dockPanelHosts.add(dockPanelHost);
    }

    void unregisterDockPanelHost(DockPanelHost dockPanelHost) {
        this._dockPanelHosts.remove(dockPanelHost);
    }

    DockInsertionPoint getDockInsertionAt(Point point) {
        MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
        int n = mainWindowImpl.getMaximizedWindowType();
        if (n != 0) {
            return null;
        }
        DockInsertionPoint dockInsertionPoint = null;
        double d = 2.147483647E9;
        Point point2 = new Point();
        boolean bl = false;
        int n2 = this._dockPanelHosts.size();
        int n3 = 0;
        while (n3 < n2) {
            DockPanelHost dockPanelHost = (DockPanelHost)this._dockPanelHosts.get(n3);
            DockInsertionPoint dockInsertionPoint2 = dockPanelHost.getDockInsertionAt(point);
            if (dockInsertionPoint2 != null) {
                Point point3 = dockInsertionPoint2.getAnchor();
                double d2 = point2.distanceSq(point3);
                boolean bl2 = dockPanelHost instanceof FloatDockWindow;
                if (d2 < d || bl2 && !bl) {
                    d = d2;
                    dockInsertionPoint = dockInsertionPoint2;
                    bl = bl2;
                }
            }
            ++n3;
        }
        return dockInsertionPoint;
    }

    Dockable loadDockable(PropertyAccess propertyAccess, String string) {
        Dockable dockable = this.findDockable(new ViewId(string));
        if (dockable != null) {
            dockable.loadLayout(propertyAccess);
        }
        return dockable;
    }

    public Dockable getDockable(ViewId viewId) {
        return (Dockable)this._dockableCache.get(viewId.getId());
    }

    public Dockable findDockable(ViewId viewId) {
        Dockable dockable = this.getDockable(viewId);
        if (dockable == null) {
            dockable = this.createDockable(viewId);
        }
        return dockable;
    }

    private Dockable createDockable(ViewId viewId) {
        Dockable dockable = null;
        DockableFactory dockableFactory = this._factoryRegistry.getFactory(viewId.getType());
        if (dockableFactory != null) {
            int n = 0;
            if (IdeProfile.isEventActive(IdeProfile.PROF_DOCK_LAYOUT)) {
                n = IdeProfile.startEvent(IdeProfile.PROF_DOCK_LAYOUT, dockableFactory.getClass().getName() + ".getDockable(" + viewId + ")");
            }
            dockable = dockableFactory.getDockable(viewId);
            SplashScreen.log((String)" dockable loaded");
            if (IdeProfile.isEventActive(IdeProfile.PROF_DOCK_LAYOUT)) {
                IdeProfile.endEvent(n);
            }
        }
        return dockable;
    }

    void addToCache(Dockable dockable) {
        this._dockableCache.put(dockable.getUniqueName(), dockable);
    }

    void removeFromCache(Dockable dockable) {
        boolean bl;
        boolean bl2 = bl = (this.getDockableEventContext() & 1) != 0;
        if (!bl) {
            this._dockableCache.remove(dockable.getUniqueName());
        }
    }

    void loadLayout(Layout layout) {
        this.dumpRegisteredFactories();
        if (layout instanceof IdeLayout) {
            IdeLayout ideLayout = (IdeLayout)layout;
            layout = ideLayout.getActiveLayout();
        } else {
            System.out.println("DockStationImpl.loadLayout: This time, the layout is of type " + layout.getClass().getName());
        }
        if (this._currentLayout != null) {
            this.onLayoutChange(layout);
        } else {
            this.tellMeWhenIdeIsUp();
            LayoutsImpl layoutsImpl = LayoutsImpl.getInstance();
            if (layoutsImpl.hasDockableFactoryNode()) {
                this.onStartup(layout);
            } else {
                this.onFreshInstall(layout);
            }
        }
        this.dumpAllDockables();
    }

    private void onFreshInstall(Layout layout) {
        this._currentLayout = layout;
        this._currentVisibilityLayout = DockStationImpl.getVisibilityLayout(layout);
        ArrayList arrayList = this.getRegisteredFactories();
        this.installFactories(arrayList);
        ArrayList arrayList2 = this.getAllDockables();
        this.setDefaultState(arrayList2, layout);
    }

    private void onStartup(Layout layout) {
        LayoutsImpl layoutsImpl = LayoutsImpl.getInstance();
        this._currentLayout = layout;
        this._currentVisibilityLayout = DockStationImpl.getVisibilityLayout(layout);
        StructuredPropertyAccess structuredPropertyAccess = layoutsImpl.getDockablePositions();
        if (structuredPropertyAccess != null) {
            TitledPanelXMLDockLayoutPersistence titledPanelXMLDockLayoutPersistence = new TitledPanelXMLDockLayoutPersistence();
            this.loadValidLayout(titledPanelXMLDockLayoutPersistence, structuredPropertyAccess);
        }
        ArrayList arrayList = this.getAllDockables();
        ArrayList arrayList2 = this.getNewFactories();
        ArrayList arrayList3 = null;
        if (!arrayList2.isEmpty()) {
            this.installFactories(arrayList2);
            arrayList3 = this.getAllDockables();
            arrayList3.removeAll(arrayList);
        }
        int n = 0;
        while (n < this._dockPanelHosts.size()) {
            DockPanelHost dockPanelHost = (DockPanelHost)this._dockPanelHosts.get(n);
            dockPanelHost.loadVisibilityLayout(this._currentVisibilityLayout, true, 0);
            ++n;
        }
        if (arrayList3 != null) {
            this.setDefaultState(arrayList3, this._currentLayout);
        }
    }

    private void onLayoutChange(Layout layout) {
        VisibilityLayout visibilityLayout = DockStationImpl.getVisibilityLayout(layout);
        VisibilityLayout visibilityLayout2 = this._currentVisibilityLayout;
        this.saveVisibilityLayout(visibilityLayout2);
        this.switchVisibilityLayout(visibilityLayout2, visibilityLayout, layout);
        this._currentVisibilityLayout = visibilityLayout;
        this._currentLayout = layout;
    }

    private void setDefaultState(List list, Layout layout) {
        int n = 0;
        while (n < list.size()) {
            boolean bl;
            DockablePath dockablePath;
            Dockable dockable = (Dockable)list.get(n);
            int n2 = this.safeGetDefaultVisibility(dockable, layout);
            boolean bl2 = BitField.isSet(n2, 2);
            if (bl2 && this.getDockablePath(dockablePath = new DockablePath(), new DockableCriteria(dockable))) {
                TitledPanel titledPanel = dockablePath.getTitledPanel();
                titledPanel.minimize(false, 0);
            }
            if (bl = BitField.isSet(n2, 1)) {
                this.setDockableVisible(dockable, true, 0);
            }
            ++n;
        }
    }

    private int safeGetDefaultVisibility(Dockable dockable, Layout layout) {
        try {
            int n;
            int n2 = n = dockable.getDefaultVisibility(layout);
            return n2;
        }
        catch (AbstractMethodError abstractMethodError) {
            System.out.println(dockable.getClass().getName() + ".getDefaultVisibility(Layout) not implemented");
            abstractMethodError.printStackTrace();
            return 0;
        }
    }

    private ArrayList getAllDockables() {
        ArrayList arrayList = this.getDockablePaths();
        int n = arrayList.size();
        ArrayList<Dockable> arrayList2 = new ArrayList<Dockable>(n);
        int n2 = 0;
        while (n2 < n) {
            DockablePath dockablePath = (DockablePath)arrayList.get(n2);
            Dockable dockable = dockablePath.getDockable();
            arrayList2.add(dockable);
            ++n2;
        }
        return arrayList2;
    }

    private ArrayList getNewFactories() {
        LayoutsImpl layoutsImpl = LayoutsImpl.getInstance();
        Object[] objectArray = layoutsImpl.getKnownDockableFactories();
        ArrayList arrayList = new ArrayList(objectArray.length);
        IdeUtil.addAll(arrayList, objectArray);
        ArrayList arrayList2 = this.getRegisteredFactories();
        arrayList2.removeAll(arrayList);
        return arrayList2;
    }

    private ArrayList getRegisteredFactories() {
        ArrayList arrayList = this._factoryRegistry.getDockableFactoriesNames();
        return arrayList;
    }

    private void installFactories(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)arrayList.get(n2);
            DockableFactory dockableFactory = this._factoryRegistry.getFactory(string);
            try {
                String string2 = "Installed " + dockableFactory.getClass().getName();
                String string3 = "installFactories";
                dockableFactory.install();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    private void dumpAllDockables() {
    }

    private void dumpRegisteredFactories() {
    }

    private void saveVisibilityLayout(VisibilityLayout visibilityLayout) {
        visibilityLayout.clear();
        int n = 0;
        while (n < this._dockPanelHosts.size()) {
            DockPanelHost dockPanelHost = (DockPanelHost)this._dockPanelHosts.get(n);
            dockPanelHost.saveVisibilityLayout(visibilityLayout);
            ++n;
        }
    }

    private void switchVisibilityLayout(VisibilityLayout visibilityLayout, VisibilityLayout visibilityLayout2, Layout layout) {
        this.addDockableEventContext(1);
        try {
            this._printInvalidDockingOperations = true;
            String[] stringArray = VisibilityLayout.getNewDockables(visibilityLayout, visibilityLayout2);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                ViewId viewId = new ViewId(string);
                Dockable dockable = this.getDockable(viewId);
                int n2 = dockable.getType();
                boolean bl = BitField.isSet(n2, 32);
                if (!bl) {
                    int n3 = this.safeGetDefaultVisibility(dockable, layout);
                    boolean bl2 = BitField.isSet(n3, 1);
                    boolean bl3 = BitField.isSet(n3, 2);
                    boolean bl4 = BitField.isSet(n3, 4);
                    visibilityLayout2.setVisible(string, bl2);
                    visibilityLayout2.setMinimized(string, bl3);
                    visibilityLayout2.setRaised(string, bl4);
                }
                ++n;
            }
            int n4 = 0;
            while (n4 < this._dockPanelHosts.size()) {
                DockPanelHost dockPanelHost = (DockPanelHost)this._dockPanelHosts.get(n4);
                dockPanelHost.loadVisibilityLayout(visibilityLayout2, false, 1);
                ++n4;
            }
        }
        finally {
            this._printInvalidDockingOperations = false;
            this.removeDockableEventContext(1);
        }
    }

    private static VisibilityLayout getVisibilityLayout(Layout layout) {
        String string = layout.getName();
        LayoutsImpl layoutsImpl = LayoutsImpl.getInstance();
        VisibilityLayout visibilityLayout = layoutsImpl.getVisibilityLayout(string);
        return visibilityLayout;
    }

    private void loadValidLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        int n = 0;
        if (ProfileIDs.PROFILE_LOADVALIDLAYOUT) {
            n = IdeProfile.startEvent(3304);
        }
        int n2 = 0;
        while (n2 < this._sidePorts.length) {
            SidePort sidePort = this._sidePorts[n2];
            String string = sidePort.getPanelName();
            StructuredPropertyAccess structuredPropertyAccess2 = structuredPropertyAccess.getChildNode(string);
            try {
                sidePort.loadLayout(xMLDockLayoutPersistence, structuredPropertyAccess2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        Iterator iterator = structuredPropertyAccess.getChildNodes();
        while (iterator.hasNext()) {
            StructuredPropertyAccess structuredPropertyAccess3 = (StructuredPropertyAccess)iterator.next();
            if (!"panel".equals(structuredPropertyAccess3.getName())) continue;
            try {
                FloatDockWindow floatDockWindow = new FloatDockWindow(this._frame);
                floatDockWindow.loadLayout(xMLDockLayoutPersistence, structuredPropertyAccess3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (ProfileIDs.PROFILE_LOADVALIDLAYOUT) {
            IdeProfile.endEvent(n);
        }
    }

    void setFloatVisible(FloatDockWindow floatDockWindow, boolean bl) {
        if (!this._bIsUIVisible) {
            if (bl) {
                if (this._floatToShow == null) {
                    this._floatToShow = new ArrayList(3);
                }
                this._floatToShow.add(floatDockWindow);
            } else if (this._floatToShow != null) {
                this._floatToShow.remove(floatDockWindow);
            }
        } else {
            floatDockWindow.getGUI().setVisible(bl);
        }
    }

    static void transfer(TitledPanel titledPanel, DockPanel dockPanel, DockLayoutConstraint dockLayoutConstraint) {
        DockPanel dockPanel2 = titledPanel.getDockPanel();
        if (dockPanel2 != null) {
            int n = titledPanel.getClientCount();
            ArrayList<DockableHolder> arrayList = new ArrayList<DockableHolder>(n);
            int n2 = 0;
            while (n2 < n) {
                DockableHolder dockableHolder = titledPanel.getHolder(n2);
                Dockable dockable = dockableHolder.getDockable();
                int n3 = titledPanel.getDockableStatus(dockable);
                if (BitField.isSet(n3, 2) && BitField.isSet(n3, 8)) {
                    arrayList.add(dockableHolder);
                }
                ++n2;
            }
            if (arrayList.size() == n) {
                dockPanel2.remove(titledPanel);
                dockPanel2.revalidate();
            } else {
                TitledPanel titledPanel2 = new TitledPanel();
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    DockableHolder dockableHolder = (DockableHolder)arrayList.get(n4);
                    Dockable dockable = dockableHolder.getDockable();
                    titledPanel.removeClient(dockable, 0);
                    DockableHolder dockableHolder2 = new DockableHolder(dockable);
                    Boolean bl = dockableHolder.getFloatOnTop();
                    dockableHolder2.setFloatOnTop(bl);
                    int n5 = titledPanel2.addClient(dockableHolder2, 0);
                    titledPanel2.setClientVisible(n5, true, 0);
                    ++n4;
                }
                titledPanel = titledPanel2;
            }
        }
        dockPanel.add((Component)titledPanel, dockLayoutConstraint);
        dockPanel.revalidate();
    }

    public void floatPanel(TitledPanel titledPanel, Point point) {
        DockableHolder dockableHolder = titledPanel.getSelectedHolder();
        Dockable dockable = dockableHolder.getDockable();
        this.dockFloat(titledPanel, point);
        if (dockable != null) {
            this.activateDockable(dockable);
        }
    }

    private void tellMeWhenIdeIsUp() {
        Ide.addIdeListener(new 1());
    }

    private void ideIsUp() {
        if (this._floatToShow != null) {
            int n = 0;
            while (n < this._floatToShow.size()) {
                FloatDockWindow floatDockWindow = (FloatDockWindow)this._floatToShow.get(n);
                floatDockWindow.getGUI().setVisible(true);
                ++n;
            }
        }
        this._bIsUIVisible = true;
        this._floatToShow = null;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        switch (n) {
            case 42: {
                this.activateNextDockable(true);
                break;
            }
            case 43: {
                this.activateNextDockable(false);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        switch (ideAction.getCommandId()) {
            case 42: 
            case 43: {
                ideAction.setEnabled(true);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        IdeSettings ideSettings = Ide.getSettings();
        DockingConfigOptions dockingConfigOptions = (DockingConfigOptions)ideSettings.getData("DockingConfigOptions");
        this.setPentaLayoutStyle(dockingConfigOptions.getStyle());
    }

    public Controller getController() {
        return this;
    }

    public DividerControlledPanel getDividerControlledPanel(int n) {
        SidePort sidePort = this._sidePorts[n];
        DividerControlledPanel dividerControlledPanel = sidePort.getDividerControlledPanel();
        return dividerControlledPanel;
    }

    DockPanelHost[] getAllDockPanelHosts() {
        return this._dockPanelHosts.toArray(new DockPanelHost[this._dockPanelHosts.size()]);
    }

    static void mav$ideIsUp(DockStationImpl dockStationImpl) {
        dockStationImpl.ideIsUp();
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ Component v$cRestoreFocus;
        final /* synthetic */ DockStationImpl this$0;

        public void run() {
            IdeUtil.tryToRestoreFocus(this.v$cRestoreFocus);
        }

        public 2(DockStationImpl dockStationImpl, Component component) {
            this.v$cRestoreFocus = component;
            this.this$0 = dockStationImpl;
        }
    }

    public final class 1
    extends IdeAdapter {
        public void mainWindowOpened(IdeEvent ideEvent) {
            DockStationImpl.mav$ideIsUp(DockStationImpl.this);
            Ide.removeIdeListener(this);
        }
    }
}

