/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.ide.Ide;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.ideimpl.window.WindowingConstants;

final class DragFeedback {
    private static final Color BG_COLOR = WindowingConstants.DRAG_FEEDBACK_BACKGROUND;
    private static final Color BORDER_COLOR = WindowingConstants.DRAG_FEEDBACK_OUTLINE;
    private DragFeedbackWindow _feedbackWindow;
    private DragFeedbackGlassPane _feedbackGlassPane;
    private Component _oldGlassPane;

    void $init$() {
        this._feedbackWindow = new DragFeedbackWindow();
        this._feedbackGlassPane = new DragFeedbackGlassPane();
    }

    DragFeedback() {
        this.$init$();
        JRootPane jRootPane = Ide.getMainWindow().getRootPane();
        this._oldGlassPane = jRootPane.getGlassPane();
        jRootPane.setGlassPane(this._feedbackGlassPane);
        this._feedbackGlassPane.setVisible(true);
    }

    void setFeedbackPosition(int n, int n2, int n3, int n4) {
        this.setFloatingFeedbackPosition(n, n2, n3, n4);
    }

    void setFloatingFeedbackPosition(int n, int n2, int n3, int n4) {
        if (!this._feedbackWindow.isVisible()) {
            this._feedbackGlassPane.setVisible(false);
            this._feedbackWindow.setVisible(true);
        }
        this._feedbackWindow.setFeedback(n, n2, n3, n4);
    }

    void dispose() {
        if (this._feedbackWindow != null) {
            this._feedbackWindow.dispose();
            this._feedbackWindow = null;
        }
        this._feedbackGlassPane.setVisible(false);
        this._feedbackGlassPane = null;
        JRootPane jRootPane = Ide.getMainWindow().getRootPane();
        jRootPane.setGlassPane(this._oldGlassPane);
        this._oldGlassPane = null;
    }

    static Color ra$BG_COLOR() {
        return BG_COLOR;
    }

    static Color ra$BORDER_COLOR() {
        return BORDER_COLOR;
    }

    private static final class DragFeedbackGlassPane
    extends JPanel {
        private static final Point PT = new Point();
        private final DragFeedbackPanel _feedback;

        void $init$() {
            this._feedback = new DragFeedbackPanel();
        }

        DragFeedbackGlassPane() {
            this.$init$();
            this.setLayout(null);
            this.setOpaque(false);
            this._feedback.setOpaque(false);
            this.add(this._feedback);
        }

        void setFeedback(int n, int n2, int n3, int n4) {
            DragFeedbackGlassPane.PT.x = n;
            DragFeedbackGlassPane.PT.y = n2;
            SwingUtilities.convertPointFromScreen(PT, this);
            this._feedback.setBounds(DragFeedbackGlassPane.PT.x, DragFeedbackGlassPane.PT.y, n3, n4);
            this._feedback.revalidate();
        }
    }

    private static final class DragFeedbackWindow
    extends JWindow {
        DragFeedbackWindow() {
            DragFeedbackPanel dragFeedbackPanel = new DragFeedbackPanel();
            dragFeedbackPanel.setUsageVisible(true);
            this.getContentPane().add((Component)dragFeedbackPanel, "Center");
        }

        void setFeedback(int n, int n2, int n3, int n4) {
            this.setBounds(n, n2, n3, n4);
            this.validate();
        }
    }

    private static final class DragFeedbackPanel
    extends JPanel {
        private final MultiLineLabel _lblUsage;

        void $init$() {
            this._lblUsage = new MultiLineLabel();
        }

        DragFeedbackPanel() {
            this.$init$();
            Border border = BorderFactory.createLineBorder(DragFeedback.ra$BORDER_COLOR());
            this.setBorder(border);
            this.setBackground(UIManager.getColor("window"));
            String string = IdeImplArb.getString(54);
            this._lblUsage.setText(string);
            this._lblUsage.setVisible(false);
            this._lblUsage.setAlignment(3);
            this._lblUsage.setMaximumSize(this._lblUsage.getPreferredSize());
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalGlue());
            this.add((Component)this._lblUsage);
            this.add(Box.createVerticalGlue());
        }

        void setUsageVisible(boolean bl) {
            this._lblUsage.setVisible(bl);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(DragFeedback.ra$BG_COLOR());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

