/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputListener;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controls.FloatingToolWindow;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.WaitCursor;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.JDK;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;
import oracle.ideimpl.docking.AbstractDockPanelHost;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.FloatDockUI;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.controls.Handlebar;

final class FloatDockWindow
extends AbstractDockPanelHost
implements ComponentListener,
ContainerListener,
ActionListener,
MouseInputListener,
DockPanelHost,
SwingConstants,
FloatingToolWindow {
    static final String PANEL_NAME = "panel";
    private static final int BORDER_WEST = 1;
    private static final int BORDER_EAST = 2;
    private static final int BORDER_NORTH = 4;
    private static final int BORDER_SOUTH = 8;
    private static final int CORNER_SIZE = 15;
    private static final boolean REALTIME_RESIZE = true;
    private static final String KEY_X = "x";
    private static final String KEY_Y = "y";
    private static final String KEY_WIDTH = "width";
    private static final String KEY_HEIGHT = "height";
    private DockPanel _dockPanel;
    private Handlebar _title;
    private SmallSquareButton _buttonClose;
    private FloatDockUI _ui;
    private JFrame _frame;
    private boolean _bDragging;
    private Point _ptLastDrag;
    private int _nOrient;
    private Point _ptDraggedFrom;
    private Point _ptMovedFrom;

    public FloatDockWindow(JFrame jFrame) {
        this.$init$();
        this._frame = jFrame;
        this.createHost();
    }

    public void createWindowUI() {
        boolean bl = this.isFloatOnTop();
        this._ui = bl ? new FloatDockDialogUI(this._frame) : new FloatDockDialogUI();
        this._ui.getContentPane().setLayout(new BorderLayout());
        this.createTitle();
        this.createBorder();
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.attach(this._ui);
        InputMap inputMap = Ide.getIdeInputMap();
        InputMap inputMap2 = this._ui.getRootPane().getInputMap(1);
        inputMap2.setParent(inputMap);
        ActionMap actionMap = Ide.getIdeActionMap();
        ActionMap actionMap2 = this._ui.getRootPane().getActionMap();
        actionMap2.setParent(actionMap);
        this.attachHost();
    }

    private void createHost() {
        DockPanel dockPanel;
        this._dockPanel = dockPanel = new DockPanel();
    }

    private void attachHost() {
        DockPanel dockPanel = this.getDockPanel();
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        dockStationImpl.registerDockPanelHost(this);
        ActiveViewHandlerImpl activeViewHandlerImpl = dockStationImpl.getActiveViewHandler();
        activeViewHandlerImpl.addControllerProvider(dockPanel, dockStationImpl);
        this._ui.getContentPane().add((Component)dockPanel, "Center");
        dockPanel.addContainerListener(this);
        int n = dockPanel.getTitledPanelCount();
        int n2 = 0;
        while (n2 < n) {
            TitledPanel titledPanel = dockPanel.getTitledPanel(n2);
            titledPanel.addComponentListener(this);
            ++n2;
        }
        this.visibleCountChanges();
    }

    private void createBorder() {
        Color color = UIManager.getColor("Panel.background");
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IdeConstants.COLOR_IDE_LINES), BorderFactory.createLineBorder(color, 3));
        JRootPane jRootPane = this._ui.getRootPane();
        jRootPane.setBorder(compoundBorder);
        jRootPane.addMouseListener(this);
        jRootPane.addMouseMotionListener(this);
    }

    private void createTitle() {
        this._title = new Handlebar();
        this._title.setOrientation(0);
        this._buttonClose = new SmallSquareButton(IdeArb.getInstance(), 463, 464);
        this._title.addButton(this._buttonClose, 0);
        this._title.addMouseListener(this);
        this._title.addMouseMotionListener(this);
        this._buttonClose.addActionListener(this);
        this._ui.getContentPane().add((Component)((Object)this._title), "North");
    }

    public Window getGUI() {
        return (Window)((Object)this._ui);
    }

    public void adjustClientSize(Dimension dimension, boolean bl) {
        Insets insets = this._ui.getRootPane().getInsets();
        insets.top += this._title.getSize().height;
        dimension.width = dimension.width + (insets.left + insets.right) * (bl ? -1 : 1);
        dimension.height = dimension.height + (insets.top + insets.bottom) * (bl ? -1 : 1);
    }

    public DockPanel getDockPanel() {
        return this._dockPanel;
    }

    public DockInsertionPoint getDockInsertionAt(Point point) {
        DockInsertionPoint dockInsertionPoint = null;
        if (this.isVisible()) {
            DockPanel dockPanel = this.getDockPanel();
            Point point2 = new Point(point);
            SwingUtilities.convertPointFromScreen(point2, dockPanel);
            dockInsertionPoint = dockPanel.getDockInsertionAt(point2);
        }
        return dockInsertionPoint;
    }

    private void closeHost() {
        this._ui.asWindow().dispose();
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        dockStationImpl.unregisterDockPanelHost(this);
        dockStationImpl.getActiveViewHandler().removeControllerProvider(this._dockPanel);
    }

    public StructuredPropertyAccess saveLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence) {
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess(PANEL_NAME);
        Point point = new Point();
        this.getLocation(point);
        Dimension dimension = new Dimension();
        this.getSize(dimension);
        defaultStructuredPropertyAccess.setProperty("position", "float");
        defaultStructuredPropertyAccess.setProperty(KEY_X, Integer.toString(point.x));
        defaultStructuredPropertyAccess.setProperty(KEY_Y, Integer.toString(point.y));
        defaultStructuredPropertyAccess.setProperty(KEY_WIDTH, Integer.toString(dimension.width));
        defaultStructuredPropertyAccess.setProperty(KEY_HEIGHT, Integer.toString(dimension.height));
        defaultStructuredPropertyAccess.setProperty("visible", Boolean.toString(this.isVisible()));
        DockPanel dockPanel = this.getDockPanel();
        dockPanel.saveLayout(xMLDockLayoutPersistence, defaultStructuredPropertyAccess);
        return defaultStructuredPropertyAccess;
    }

    private static int getAttribute(StructuredPropertyAccess structuredPropertyAccess, String string, int n) {
        String string2 = structuredPropertyAccess.getProperty(string, null);
        int n2 = string2 == null ? n : Integer.parseInt(string2);
        return n2;
    }

    public void loadLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        DockPanel dockPanel = this.getDockPanel();
        dockPanel.loadLayout(xMLDockLayoutPersistence, structuredPropertyAccess);
        this.createWindowUI();
        int n = FloatDockWindow.getAttribute(structuredPropertyAccess, KEY_X, 0);
        int n2 = FloatDockWindow.getAttribute(structuredPropertyAccess, KEY_Y, 0);
        int n3 = FloatDockWindow.getAttribute(structuredPropertyAccess, KEY_WIDTH, 100);
        int n4 = FloatDockWindow.getAttribute(structuredPropertyAccess, KEY_HEIGHT, 100);
        this.setBounds(n, n2, n3, n4);
    }

    private boolean isFloatOnTop() {
        DockPanel dockPanel = this.getDockPanel();
        TitledPanel[] titledPanelArray = dockPanel.getAllTitledPanels();
        boolean bl = true;
        int n = 0;
        while (bl && n < titledPanelArray.length) {
            TitledPanel titledPanel = titledPanelArray[n];
            int n2 = titledPanel.getClientCount();
            int n3 = 0;
            while (bl && n3 < n2) {
                DockableHolder dockableHolder = titledPanel.getHolder(n3);
                bl = dockableHolder.isFloatOnTop();
                ++n3;
            }
            ++n;
        }
        return bl;
    }

    private Handlebar getHandlebar() {
        return this._title;
    }

    private void whenClose() {
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        dockStationImpl.addDockableEventContext(20);
        try {
            DockPanel dockPanel = this.getDockPanel();
            TitledPanel[] titledPanelArray = dockPanel.getAllTitledPanels();
            int n = titledPanelArray.length;
            int n2 = 0;
            while (n2 < n) {
                TitledPanel titledPanel = titledPanelArray[n2];
                if (-1 != dockPanel.indexOfTitledPanel(titledPanel)) {
                    titledPanel.closePanel(20);
                }
                ++n2;
            }
        }
        finally {
            dockStationImpl.removeDockableEventContext(20);
        }
        this.hide();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._buttonClose) {
            this.whenClose();
        }
    }

    private boolean isVisible() {
        return this._ui.asWindow().isVisible();
    }

    private void hide() {
        this._ui.asWindow().setVisible(false);
    }

    public Dimension getSize(Dimension dimension) {
        return this._ui.asWindow().getSize(dimension);
    }

    public void setSize(int n, int n2) {
        this._ui.asWindow().setSize(n, n2);
    }

    public Point getLocation(Point point) {
        return this._ui.asWindow().getLocation(point);
    }

    private void setLocation(int n, int n2) {
        this._ui.asWindow().setLocation(n, n2);
    }

    public Rectangle getBounds() {
        return this._ui.asWindow().getBounds();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this._ui.asWindow().setBounds(n, n2, n3, n4);
    }

    public void validate() {
        this._ui.asWindow().validate();
    }

    public void componentAdded(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        component.addComponentListener(this);
        this.visibleCountChanges();
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        component.removeComponentListener(this);
        this.visibleCountChanges();
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.visibleCountChanges();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.visibleCountChanges();
    }

    private void visibleCountChanges() {
        DockPanel dockPanel = this.getDockPanel();
        int n = dockPanel.getTitledPanelCount();
        if (n == 0) {
            this.closeHost();
        } else {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                TitledPanel titledPanel = dockPanel.getTitledPanel(n3);
                if (titledPanel.getVisibleCount() > 0) {
                    ++n2;
                }
                ++n3;
            }
            DockStationImpl dockStationImpl = DockStationImpl.getInstance();
            switch (n2) {
                case 0: {
                    dockStationImpl.setFloatVisible(this, false);
                    break;
                }
                case 1: {
                    this.setMultiHost(false);
                    dockStationImpl.setFloatVisible(this, true);
                    break;
                }
                default: {
                    this.setMultiHost(true);
                    dockStationImpl.setFloatVisible(this, true);
                }
            }
        }
    }

    private void setMultiHost(boolean bl) {
        this.getHandlebar().setVisible(bl);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this._title) {
            this.borderMouseDragged(mouseEvent);
        } else {
            this.titleMouseDragged(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this._title) {
            this.borderMouseExited();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this._title) {
            this.borderMouseMoved(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this._title) {
            this.borderMousePressed(mouseEvent);
        } else {
            this.titleMousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this._title) {
            this.borderMouseReleased();
        }
    }

    private int getPositionOnBorder(Point point) {
        JRootPane jRootPane = this._ui.getRootPane();
        Dimension dimension = jRootPane.getSize();
        Insets insets = jRootPane.getInsets();
        int n = 0;
        if (point.x < insets.left) {
            n |= 1;
        } else if (point.x > dimension.width - insets.right) {
            n |= 2;
        }
        if (n != 0) {
            if (point.y < 15) {
                n |= 4;
            } else if (point.y > dimension.height - 15) {
                n |= 8;
            }
        }
        int n2 = 0;
        if (point.y < insets.top) {
            n2 |= 4;
        } else if (point.y > dimension.height - insets.bottom) {
            n2 |= 8;
        }
        if (n2 != 0) {
            if (point.x < 15) {
                n2 |= 1;
            } else if (point.x > dimension.width - 15) {
                n2 |= 2;
            }
        }
        return n | n2;
    }

    private static int borderToCursor(int n) {
        switch (n) {
            case 1: {
                return 10;
            }
            case 2: {
                return 11;
            }
            case 4: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 5: {
                return 6;
            }
            case 9: {
                return 4;
            }
            case 6: {
                return 7;
            }
            case 10: {
                return 5;
            }
        }
        return 0;
    }

    void $init$() {
        this._ptLastDrag = new Point();
    }

    private void setDragLastPosition(int n, int n2) {
        this._ptLastDrag.setLocation(n, n2);
        SwingUtilities.convertPointToScreen(this._ptLastDrag, this._ui.asWindow());
    }

    private void setDragLastPosition(Point point) {
        this.setDragLastPosition(point.x, point.y);
    }

    private Point getDragOffset(Point point) {
        point = new Point(point);
        SwingUtilities.convertPointToScreen(point, this._ui.asWindow());
        point.x -= this._ptLastDrag.x;
        point.y -= this._ptLastDrag.y;
        return point;
    }

    private void borderMouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.getPositionOnBorder(point);
        Cursor cursor = Cursor.getPredefinedCursor(FloatDockWindow.borderToCursor(n));
        this._ui.getRootPane().setCursor(cursor);
    }

    private void borderMouseExited() {
        Cursor cursor = Cursor.getPredefinedCursor(0);
        this._ui.getRootPane().setCursor(cursor);
    }

    private void borderMousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.getPositionOnBorder(point);
        if (n != 0) {
            this.setDragLastPosition(point);
            this._nOrient = n;
            this._bDragging = true;
        }
    }

    private void borderMouseDragged(MouseEvent mouseEvent) {
        if (this._bDragging) {
            Point point = mouseEvent.getPoint();
            Point point2 = this.getDragOffset(point);
            Dimension dimension = this._ui.asWindow().getMinimumSize();
            Rectangle rectangle = this.getBounds();
            if ((this._nOrient & 2) != 0) {
                int n = rectangle.width + point2.x;
                if (n < dimension.width) {
                    n = dimension.width;
                }
                rectangle.width = n;
            }
            if ((this._nOrient & 1) != 0) {
                int n = rectangle.width - point2.x;
                if (n < dimension.width) {
                    n = dimension.width;
                    point2.x = rectangle.width - n;
                }
                rectangle.width = n;
                rectangle.x += point2.x;
            }
            if ((this._nOrient & 8) != 0) {
                int n = rectangle.height + point2.y;
                if (n < dimension.height) {
                    n = dimension.height;
                }
                rectangle.height = n;
            }
            if ((this._nOrient & 4) != 0) {
                int n = rectangle.height - point2.y;
                if (n < dimension.height) {
                    n = dimension.height;
                    point2.y = rectangle.height - n;
                }
                rectangle.height = n;
                rectangle.y += point2.y;
            }
            this.setDragLastPosition(point);
            this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.validate();
        }
    }

    private void borderMouseReleased() {
        if (this._bDragging) {
            this._bDragging = false;
        }
    }

    private void titleMousePressed(MouseEvent mouseEvent) {
        this._ptDraggedFrom = new Point(mouseEvent.getPoint());
        SwingUtilities.convertPointToScreen(this._ptDraggedFrom, this._ui.asWindow());
        this._ptMovedFrom = new Point();
        this.getLocation(this._ptMovedFrom);
    }

    private void titleMouseDragged(MouseEvent mouseEvent) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        if (eventQueue.peekEvent(mouseEvent.getID()) == null && !mouseEvent.isConsumed()) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, this._ui.asWindow());
            this.setLocation(this._ptMovedFrom.x + (point.x - this._ptDraggedFrom.x), this._ptMovedFrom.y + (point.y - this._ptDraggedFrom.y));
        }
    }

    static Handlebar mav$getHandlebar(FloatDockWindow floatDockWindow) {
        return floatDockWindow.getHandlebar();
    }

    private class FloatDockDialogUI
    extends JDialog
    implements FloatDockUI {
        private boolean _bIsVisible;
        private Dimension _dimSaved;

        public FloatDockDialogUI() {
            this.$init$();
            this.setUndecorated(true);
        }

        public FloatDockDialogUI(Frame frame) {
            super(frame);
            this.$init$();
            this.setUndecorated(true);
        }

        public FloatDockWindow getFloatDockWindow() {
            return FloatDockWindow.this;
        }

        public Window asWindow() {
            return this;
        }

        public boolean isFocusable() {
            return false;
        }

        void $init$() {
            this._bIsVisible = false;
            this._dimSaved = new Dimension(0, 0);
        }

        public boolean isVisible() {
            if (JDK.HAS_BUG_4390137) {
                return this._bIsVisible;
            }
            return super.isVisible();
        }

        public void setSize(Dimension dimension) {
            if (JDK.HAS_BUG_4390137) {
                this._dimSaved.setSize(dimension);
                super.setSize(dimension);
            } else {
                super.setSize(dimension);
            }
        }

        public void setVisible(boolean bl) {
            if (JDK.HAS_BUG_4390137) {
                if (bl != this._bIsVisible) {
                    if (bl) {
                        this.setSize(this._dimSaved);
                        if (!this.isVisible()) {
                            super.setVisible(true);
                        }
                    } else {
                        this._dimSaved.setSize(this.getSize());
                        super.setSize(0, 0);
                    }
                    this._bIsVisible = bl;
                }
            } else {
                super.setVisible(bl);
            }
        }

        public Dimension getMinimumSize() {
            Dimension dimension = FloatDockWindow.this.getDockPanel().getMinimumSize();
            Dimension dimension2 = FloatDockWindow.mav$getHandlebar(FloatDockWindow.this).getMinimumSize();
            dimension.height += dimension2.height;
            return dimension;
        }

        public Dimension getPreferredSize() {
            return this.getLayout().preferredLayoutSize(this);
        }

        public void dispose() {
            DockStationImpl.getInstance().unregisterDockPanelHost(FloatDockWindow.this);
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.detach(this);
            super.dispose();
        }

        public void show() {
            DockPanel dockPanel;
            super.show();
            Component component = this.getFocusOwner();
            if ((component == this || component == null) && (dockPanel = FloatDockWindow.this.getDockPanel()) != null) {
                dockPanel.transferFocus();
            }
        }
    }
}

