/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import oracle.ide.Ide;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.docking.AbstractTitledPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.window.MaximizedWindowInfo;
import oracle.ideimpl.window.WindowingConstants;

final class MaximizedTitledPanel
extends AbstractTitledPanel
implements TitleChangeListener,
MaximizedWindowInfo {
    private TitledPanel _titledPanel;
    private DockableHolder _holder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MaximizedTitledPanel(TitledPanel titledPanel, DockableHolder dockableHolder) {
        this._titledPanel = titledPanel;
        this._holder = dockableHolder;
        this.createTitle();
        this.createUIMap();
        this.attachHolder();
        this.setBorder(WindowingConstants.FLAT_COMPOUND_BORDER);
    }

    protected DockableHolder getSelectedHolder() {
        return this._holder;
    }

    private void attachHolder() {
        this.add((Component)((Object)this._handlebar), "North");
        Dockable dockable = this._holder.getDockable();
        dockable.addTitleChangeListener(this);
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        DockableEvent dockableEvent = new DockableEvent(dockable, 0, 4);
        dockStationImpl.fireDockableEvent(dockableEvent);
        JComponent jComponent = this._holder.getOrCreateComponent();
        jComponent.setVisible(true);
        this.add((Component)jComponent, "Center");
        this.adjustTitle(dockable);
        this.adjustButtons(dockable);
    }

    private void detachHolder() {
        Dockable dockable = this._holder.getDockable();
        dockable.removeTitleChangeListener(this);
    }

    protected JPopupMenu getTitleContextMenu() {
        DockableHolder dockableHolder = this.getSelectedHolder();
        return this.createSystemMenu(dockableHolder);
    }

    static {
        $assertionsDisabled = MaximizedTitledPanel.class.desiredAssertionStatus() ^ true;
    }

    protected void whenSystemMenuClose(DockableHolder dockableHolder) {
        if (!$assertionsDisabled && dockableHolder != this.getSelectedHolder()) {
            throw new AssertionError();
        }
        this.whenClose(20);
    }

    protected void whenMinimize(int n) {
    }

    protected void whenMaximize(int n) {
    }

    protected void whenRestore(int n, DockableHolder dockableHolder) {
        MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
        mainWindowImpl.restore();
    }

    protected void whenClose(int n) {
        DockableHolder dockableHolder = this.getSelectedHolder();
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        dockStationImpl.addDockableEventContext(n);
        try {
            this.whenRestore(n, dockableHolder);
            dockStationImpl.close(dockableHolder.getDockable());
            IdeUtil.tryToRestoreFocus(null);
        }
        finally {
            dockStationImpl.removeDockableEventContext(n);
        }
    }

    protected void systemMenuSizeDocked() {
    }

    protected void whenSystemMenuFloat(DockableHolder dockableHolder) {
        this.whenRestore(4, dockableHolder);
        DockStationImpl.getInstance().floatPanel(this._titledPanel, new Point(10, 10));
    }

    protected boolean isMinimized() {
        return false;
    }

    protected boolean isMinimizable() {
        return false;
    }

    protected boolean isMaximized() {
        return true;
    }

    protected boolean isMaximizable() {
        return true;
    }

    protected boolean isFloating() {
        return false;
    }

    protected boolean canMove() {
        return false;
    }

    protected boolean canSize() {
        return false;
    }

    public int getClientCount() {
        return 1;
    }

    public Dockable getClient(int n) {
        return this._holder.getDockable();
    }

    public boolean isClientAccessible(Dockable dockable) {
        return dockable == this._holder.getDockable();
    }

    public JComponent getMaximizeComponent() {
        return this;
    }

    public void maximize() {
        this._titledPanel.maximizeHolder(this._holder);
    }

    public void restore() {
        this.detachHolder();
        this._titledPanel.restoreHolder(this._holder);
    }

    public int getWindowType() {
        return 1;
    }

    public void titleChange(TitleChangeEvent titleChangeEvent) {
        Dockable dockable = this._holder.getDockable();
        String string = dockable.getTitleName();
        Icon icon = dockable.getTabIcon();
        this._handlebar.setTitle(string);
        this._handlebar.setIcon(icon);
    }
}

