/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import oracle.ide.docking.Dockable;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.MoveFeedback;
import oracle.ideimpl.docking.TitledPanel;

final class MoveDock
extends MoveFeedback {
    private Dockable _dockable;
    private Point _ptLast;
    private DockInsertionPoint _dip;

    MoveDock(Dockable dockable, JComponent jComponent) {
        super(jComponent);
        this._dockable = dockable;
        Point point = jComponent.getLocationOnScreen();
        Dimension dimension = jComponent.getSize();
        this._ptLast = new Point(point.x + dimension.width / 2, point.y + dimension.height / 2);
    }

    protected void moveBy(int n, int n2) {
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        DockablePath dockablePath = new DockablePath();
        dockStationImpl.getDockablePath(dockablePath, new DockableCriteria(this._dockable));
        TitledPanel titledPanel = dockablePath.getTitledPanel();
        Dimension dimension = new Dimension(n, n2);
        double d = Double.MAX_VALUE;
        DockInsertionPoint dockInsertionPoint = null;
        DockPanelHost[] dockPanelHostArray = dockStationImpl.getAllDockPanelHosts();
        int n3 = 0;
        while (n3 < dockPanelHostArray.length) {
            DockPanelHost dockPanelHost = dockPanelHostArray[n3];
            DockInsertionPoint dockInsertionPoint2 = dockPanelHost.getClosestDockInsertionPoint(this._ptLast, dimension, titledPanel);
            if (dockInsertionPoint2 != null) {
                DockLayoutPanel dockLayoutPanel = dockInsertionPoint2.getContainer();
                Point point = dockLayoutPanel.getLocationOnScreen();
                Point point2 = dockInsertionPoint2.getAnchor();
                Point point3 = new Point(point2.x + point.x, point2.y + point.y);
                double d2 = point3.distance(this._ptLast.x, this._ptLast.y);
                if (d2 < d) {
                    dockInsertionPoint = dockInsertionPoint2;
                    d = d2;
                }
            }
            ++n3;
        }
        if (dockInsertionPoint != null) {
            this._dip = dockInsertionPoint;
            this._ptLast = new Point(this._dip.getAnchor());
            Point point = this._dip.getContainer().getLocationOnScreen();
            this._ptLast.translate(point.x, point.y);
        }
    }

    protected void adjustPosition() {
        if (this._dip != null) {
            Point point = this._dip.getContainer().getLocationOnScreen();
            Rectangle rectangle = this._dip.getFeedback();
            this.setBounds(point.x + rectangle.x, point.y + rectangle.y, rectangle.width, rectangle.height);
            this.validate();
        } else {
            Point point = this._cOver.getLocationOnScreen();
            Dimension dimension = this._cOver.getSize();
            this.setBounds(point.x, point.y, dimension.width, dimension.height);
            this.validate();
        }
    }

    protected void commit() {
        if (this._dip != null) {
            DockStationImpl dockStationImpl = DockStationImpl.getInstance();
            DockLayoutConstraint dockLayoutConstraint = this._dip.createConstraint();
            if (this._dip.getOrientation() != 4) {
                DockPanel dockPanel = (DockPanel)this._dip.getContainer();
                dockStationImpl._dock(this._dockable, dockPanel, dockLayoutConstraint, true, 0);
            } else {
                TitledPanel titledPanel = (TitledPanel)this._dip.getCenterReferenceComponent();
                titledPanel.addClient(this._dockable, true, 0);
                titledPanel.activateDockable(this._dockable);
                titledPanel.getParent().validate();
            }
        }
    }
}

