/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JWindow;
import oracle.ide.docking.Dockable;
import oracle.ide.util.GraphicsUtils;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.MoveDock;
import oracle.ideimpl.docking.MoveFloat;
import oracle.ideimpl.docking.SizeDock;
import oracle.ideimpl.docking.SizeFloat;
import oracle.ideimpl.docking.TitledPanel;

abstract class MoveFeedback
extends JWindow
implements KeyEventDispatcher {
    private static final Dimension DEFAULT_SIZE = new Dimension(100, 30);
    private static final int STEP_SMALL = 1;
    private static final int STEP_NORMAL = 10;
    private static final int STEP_LARGE = 50;
    private JButton _lbl;
    protected Component _cOver;

    protected abstract void moveBy(int var1, int var2);

    protected void commit() {
    }

    protected void rollback() {
    }

    public MoveFeedback(Component component) {
        this._cOver = component;
        this._lbl = new JButton();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this._lbl, "Center");
        this.setSize(DEFAULT_SIZE);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(this);
        this.setVisible(true);
        this.requestFocus();
        this.adjustPosition();
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            int n = 0;
            switch (keyEvent.getModifiers()) {
                case 1: {
                    n = 1;
                    break;
                }
                case 0: {
                    n = 10;
                    break;
                }
                case 2: {
                    n = 50;
                }
            }
            if (n != 0) {
                boolean bl = false;
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        this.moveBy(-n, 0);
                        bl = true;
                        break;
                    }
                    case 39: {
                        this.moveBy(n, 0);
                        bl = true;
                        break;
                    }
                    case 38: {
                        this.moveBy(0, -n);
                        bl = true;
                        break;
                    }
                    case 40: {
                        this.moveBy(0, n);
                        bl = true;
                        break;
                    }
                    case 10: {
                        this.commit();
                        this.byebye();
                        break;
                    }
                    case 27: {
                        this.rollback();
                        this.byebye();
                    }
                }
                if (bl) {
                    this.adjustPosition();
                }
            }
        }
        return true;
    }

    private final void byebye() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.setVisible(false);
        this.dispose();
    }

    protected void adjustPosition() {
        GraphicsUtils.centerWindowOnComponent(this, this._cOver);
    }

    protected final void setText(Point point) {
        this._lbl.setText(point.x + " x " + point.y);
    }

    protected final void setText(Dimension dimension) {
        this._lbl.setText(dimension.width + " x " + dimension.height);
    }

    private static int limit(int n, int n2, int n3) {
        return n2 < n ? n : (n2 > n3 ? n3 : n2);
    }

    protected static void limit(Point point, int n, int n2) {
        point.x = MoveFeedback.limit(0, point.x, n);
        point.y = MoveFeedback.limit(0, point.y, n2);
    }

    protected static void limit(Dimension dimension, int n, int n2, int n3, int n4) {
        dimension.width = MoveFeedback.limit(n, dimension.width, n2);
        dimension.height = MoveFeedback.limit(n3, dimension.height, n4);
    }

    protected static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    static MoveFeedback createMoveFloat(Window window) {
        return new MoveFloat(window);
    }

    static MoveFeedback createSizeFloat(Window window) {
        return new SizeFloat(window);
    }

    static MoveFeedback createSizeDock(DockPanel dockPanel, TitledPanel titledPanel) {
        return new SizeDock(dockPanel, titledPanel);
    }

    static MoveFeedback createMoveDock(Dockable dockable, JComponent jComponent) {
        return new MoveDock(dockable, jComponent);
    }
}

