/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import oracle.ide.controls.PentaLayout;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.IdeImpl;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;
import oracle.ideimpl.docking.AbstractDockPanelHost;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.VisibleComponentAgent;
import oracle.ideimpl.docking.VisibleComponentEvent;
import oracle.ideimpl.docking.VisibleComponentListener;
import oracle.ideimpl.docking.shutter.ShutterManager;

final class SidePort
extends AbstractDockPanelHost {
    private static final int MIN_SIDE_WIDTH = 240;
    private static final int MIN_WEST_SIDE_WIDTH = 280;
    private static final int MIN_SIDE_HEIGHT = 150;
    private static final String LAYOUT_KEY_DOCKSIZE = "dockSize";
    private static final String LAYOUT_KEY_FLOAT_SIZE = "floatSize";
    private static final String[] PANEL_NAMES = new String[]{"WEST", "EAST", "NORTH", "SOUTH"};
    private int _side;
    private DividerControlledPanel _dividerControlledPanel;
    private Container _container;

    public SidePort(Container container, int n) {
        this._container = container;
        this._side = n;
        this.addDividerPanel();
    }

    private void addDividerPanel() {
        DividerControlledPanel dividerControlledPanel;
        Integer[] integerArray = new Integer[]{PentaLayout.WEST, PentaLayout.EAST, PentaLayout.NORTH, PentaLayout.SOUTH};
        Integer n = integerArray[this._side];
        String string = PentaLayout.getBorderLayoutEquivalent(n);
        DockPanel dockPanel = new DockPanel();
        this._dividerControlledPanel = dividerControlledPanel = new DividerControlledPanel(dockPanel, string);
        Dimension dimension = this.getDefaultSideSize();
        dividerControlledPanel.setRestoredSize(dimension);
        this._container.add((Component)dividerControlledPanel, n);
        VisibleComponentAgent visibleComponentAgent = new VisibleComponentAgent();
        visibleComponentAgent.attachTo(dockPanel);
        visibleComponentAgent.addVisibleComponentListener(new 1());
    }

    private Dimension getDefaultSideSize() {
        int n;
        int n2;
        switch (this._side) {
            case 0: {
                Rectangle rectangle = IdeImpl.getStartupCoordinates();
                n2 = Math.max(rectangle.width / 5, 280);
                n = Math.max(rectangle.height / 6, 150);
                break;
            }
            default: {
                Rectangle rectangle = IdeImpl.getStartupCoordinates();
                n2 = Math.max(rectangle.width / 5, 240);
                n = Math.max(rectangle.height / 6, 150);
            }
        }
        return new Dimension(n2, n);
    }

    private static int getDropZoneSize(int n, boolean bl) {
        if (bl) {
            return n / 4;
        }
        return 25;
    }

    private Rectangle getDropZone(boolean bl) {
        Point point = this._container.getLocationOnScreen();
        Dimension dimension = this._container.getSize();
        Rectangle rectangle = new Rectangle(point, dimension);
        switch (this._side) {
            case 0: {
                rectangle.width = SidePort.getDropZoneSize(rectangle.width, bl);
                break;
            }
            case 1: {
                rectangle.x = rectangle.x + rectangle.width - SidePort.getDropZoneSize(rectangle.width, bl);
                rectangle.width = SidePort.getDropZoneSize(rectangle.width, bl);
                break;
            }
            case 2: {
                rectangle.height = SidePort.getDropZoneSize(rectangle.width, bl);
                break;
            }
            default: {
                rectangle.y = rectangle.y + rectangle.height - SidePort.getDropZoneSize(rectangle.width, bl);
                rectangle.height = SidePort.getDropZoneSize(rectangle.width, bl);
            }
        }
        return rectangle;
    }

    public DockInsertionPoint getDockInsertionAt(Point point) {
        Rectangle rectangle;
        DockInsertionPoint dockInsertionPoint = null;
        Point point2 = new Point();
        DockPanel dockPanel = this.getDockPanel();
        point2.setLocation(point);
        SwingUtilities.convertPointFromScreen(point2, dockPanel);
        dockInsertionPoint = dockPanel.getDockInsertionAt(point2);
        if ((dockPanel.getWidth() == 0 || dockPanel.getHeight() == 0) && (rectangle = this.getDropZone(false)).contains(point)) {
            rectangle = this.getDropZone(true);
            Point point3 = dockPanel.getLocationOnScreen();
            rectangle.x -= point3.x;
            rectangle.y -= point3.y;
            Point point4 = new Point(rectangle.x + rectangle.width / 2, rectangle.x + rectangle.height / 2);
            dockInsertionPoint = new DockInsertionPoint(null, 0, point4, rectangle);
            dockInsertionPoint.setContainer(dockPanel);
        }
        return dockInsertionPoint;
    }

    public DockPanel getDockPanel() {
        return this._dividerControlledPanel.getDockPanel();
    }

    public DividerControlledPanel getDividerControlledPanel() {
        return this._dividerControlledPanel;
    }

    String getPanelName() {
        return PANEL_NAMES[this._side];
    }

    void loadLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence, StructuredPropertyAccess structuredPropertyAccess) {
        DockPanel dockPanel = this._dividerControlledPanel.getDockPanel();
        dockPanel.loadLayout(xMLDockLayoutPersistence, structuredPropertyAccess);
        Dimension dimension = this._dividerControlledPanel.getRestoredSize();
        String string = structuredPropertyAccess.getProperty(LAYOUT_KEY_DOCKSIZE, "-1");
        int n = Integer.parseInt(string);
        if (n != -1) {
            if (this._side <= 1) {
                dimension.width = n;
            } else {
                dimension.height = n;
            }
            this._dividerControlledPanel.setRestoredSize(dimension);
        }
        ShutterManager shutterManager = ShutterManager.getInstance();
        int n2 = shutterManager.getShutterPanelSize(this._side);
        String string2 = structuredPropertyAccess.getProperty(LAYOUT_KEY_FLOAT_SIZE, Integer.toString(n2));
        shutterManager.setShutterPanelSize(this._side, Integer.parseInt(string2));
    }

    public StructuredPropertyAccess saveLayout(XMLDockLayoutPersistence xMLDockLayoutPersistence) {
        int n;
        String string = this.getPanelName();
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess(string);
        Dimension dimension = this._dividerControlledPanel.getRestoredSize();
        int n2 = n = this._side <= 1 ? dimension.width : dimension.height;
        if (n > 4) {
            defaultStructuredPropertyAccess.setProperty(LAYOUT_KEY_DOCKSIZE, Integer.toString(n));
        }
        int n3 = ShutterManager.getInstance().getShutterPanelSize(this._side);
        defaultStructuredPropertyAccess.setProperty(LAYOUT_KEY_FLOAT_SIZE, Integer.toString(n3));
        DockPanel dockPanel = this._dividerControlledPanel.getDockPanel();
        dockPanel.saveLayout(xMLDockLayoutPersistence, defaultStructuredPropertyAccess);
        return defaultStructuredPropertyAccess;
    }

    public void setActiveViewHandler(ActiveViewHandlerImpl activeViewHandlerImpl) {
        DockPanel dockPanel = this.getDockPanel();
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        activeViewHandlerImpl.addControllerProvider(dockPanel, dockStationImpl);
    }

    final class 1
    implements VisibleComponentListener {
        private DividerControlledPanel getDCP(VisibleComponentEvent visibleComponentEvent) {
            return (DividerControlledPanel)visibleComponentEvent.getContainer().getParent();
        }

        public void visibleCountChanges(VisibleComponentEvent visibleComponentEvent) {
            DividerControlledPanel dividerControlledPanel = this.getDCP(visibleComponentEvent);
            if (visibleComponentEvent.getVisibleCount() == 0) {
                dividerControlledPanel.setResizable(false);
            } else {
                dividerControlledPanel.setResizable(true);
            }
        }
    }
}

