/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Container;
import java.awt.Dimension;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.MoveFeedback;
import oracle.ideimpl.docking.TitledPanel;

final class SizeDock
extends MoveFeedback {
    private DockPanel _dp;
    private DockDivider _horzDd;
    private DockDivider _vertDd;
    private DividerControlledPanel _dcp;
    private DockLayoutInfo _dli;

    SizeDock(DockPanel dockPanel, TitledPanel titledPanel) {
        super(titledPanel);
        Container container;
        this._dp = dockPanel;
        dockPanel.validate();
        DockLayout dockLayout = (DockLayout)dockPanel.getLayout();
        this._horzDd = dockLayout.getDivider(titledPanel, 0);
        this._vertDd = dockLayout.getDivider(titledPanel, 2);
        if ((this._horzDd == null || this._vertDd == null) && (container = dockPanel.getParent()) instanceof DividerControlledPanel) {
            this._dcp = (DividerControlledPanel)container;
        }
        this._dli = dockPanel.getLayoutInfo(titledPanel);
        this.setText();
    }

    private void setText() {
        Dimension dimension = this._dli.getSize(1);
        this.setText(dimension);
    }

    protected void moveBy(int n, int n2) {
        if (n != 0) {
            String string;
            if (this._horzDd != null) {
                this._horzDd.moveBy(n, true);
            } else if (this._dcp != null && ((string = this._dcp.getOrientation()).equals("East") || string.equals("West"))) {
                this._dcp.moveBy(n);
            }
        }
        if (n2 != 0) {
            String string;
            if (this._vertDd != null) {
                this._vertDd.moveBy(n2, false);
            } else if (this._dcp != null && ((string = this._dcp.getOrientation()).equals("North") || string.equals("South"))) {
                this._dcp.moveBy(n2);
            }
        }
        this._dp.validate();
        this.setText();
    }
}

