/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.ide.controls.DragComponentEvent;
import oracle.ide.controls.DragComponentListener;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.Site;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.ProfileIDs;
import oracle.ideimpl.controls.TabbedHeader;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.docking.AbstractTitledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.FloatDockUI;
import oracle.ideimpl.docking.FloatDockWindow;
import oracle.ideimpl.docking.MaximizedTitledPanel;
import oracle.ideimpl.docking.MoveFeedback;
import oracle.ideimpl.docking.SidePort;
import oracle.ideimpl.docking.TitledPanelDragListener;
import oracle.ideimpl.docking.TitledPanelTabDragListener;
import oracle.ideimpl.docking.VisibilityLayout;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterMargin;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.resource.IdeImplArb;

public final class TitledPanel
extends AbstractTitledPanel
implements DropTargetListener,
TitleChangeListener,
SwingConstants {
    private static final TabCloseAction TAB_CLOSE_ACTION = new TabCloseAction();
    private final TabbedHeader _tabHeader;
    private final JPanel _centerPanel;
    private JComponent _centerComponent;
    private DragComponentListener _titleDragListener;
    private DragComponentListener _tabDragListener;
    private Point _ptDragEnter;
    private final DefaultListModel _model;
    private final DoubleClickTrigger _tabTrigger;

    void $init$() {
        this._tabTrigger = new DoubleClickTrigger();
    }

    public TitledPanel() {
        this.$init$();
        this.setOpaque(false);
        this.createTitle();
        Box box = new Box(2);
        this._buttonPin = new SmallSquareButton(IdeImplArb.getInstance(), 55, 56);
        this._model = new DefaultListModel();
        this._tabHeader = new TabbedHeader(this._model);
        this._centerPanel = new JPanel(new BorderLayout());
        CustomTab customTab = this._tabHeader.getCustomTab();
        Color color = UIManager.getColor("controlText");
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 144);
        customTab.setCompressible(true);
        customTab.setCtrlClickCloseEnabled(true);
        customTab.setCloseAction(TAB_CLOSE_ACTION);
        this._tabHeader.setBorder(new TabbedHeaderBorder(this._tabHeader));
        this._tabHeader.setControls(box);
        this._buttonPin.setForeground(color2);
        this._buttonPin.setOpaque(false);
        this._buttonPin.setRolloverEnabled(false);
        this._buttonPin.addActionListener(this);
        this._centerPanel.setOpaque(false);
        this._centerPanel.setBorder(new CenterPanelBorder());
        this.add((Component)this._centerPanel, "Center");
        this._buttonPin.setAlignmentY(0.75f);
        box.add(Box.createHorizontalStrut(14));
        box.add(this._buttonPin);
        box.add(Box.createHorizontalStrut(customTab.getCornerSize() + 1));
        this.add((Component)this._tabHeader, "North");
        this._tabHeader.setVisible(true);
        this._buttonPin.setVisible(true);
        this.setBorder(null);
        this._tabHeader.addMouseListener(this);
        this._tabHeader.addMouseMotionListener(this);
        EventListener eventListener = new EventListener(null);
        customTab.addSelectionListener(eventListener);
        customTab.addMouseListener(eventListener);
        customTab.addMouseMotionListener(eventListener);
        new DropTarget(customTab, 2, this);
        this.createUIMap();
        KeyUtil.removeCtrlTabFromTraversalKeys(this);
    }

    public void containerActivated(boolean bl) {
        this._tabHeader.setFocused(bl);
        this._centerPanel.repaint();
        super.containerActivated(bl);
    }

    private void whenTabSelectionChanges(ListSelectionEvent listSelectionEvent) {
        int n;
        DockableHolder dockableHolder = this.getHolderForComponent(this._centerComponent);
        if (dockableHolder != null) {
            TitledPanel.fireDockableHidden(dockableHolder, 4);
        }
        DockableHolder dockableHolder2 = (n = listSelectionEvent.getFirstIndex()) != -1 ? this.getHolder(n) : null;
        this.setHolder(dockableHolder2, false);
        if (dockableHolder2 != null) {
            TitledPanel.fireDockableShown(dockableHolder2, 4);
        }
        this.adjustTitle();
        this.revalidate();
        this.repaint();
    }

    private DefaultCustomTabPage getPage(int n) {
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._model.getElementAt(n);
        return defaultCustomTabPage;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TitledPanel[");
        int n = this.getClientCount();
        int n2 = 0;
        while (n2 < n) {
            if (n2 != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.getClient(n2).getUniqueName());
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addNotify() {
        super.addNotify();
        if (this.getVisibleCount() != 0) {
            this.adjustButtons();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.getVisibleCount() != 0) {
            this.adjustButtons();
        }
    }

    protected boolean isMinimized() {
        return false;
    }

    private boolean isMinimized(int n) {
        DockableHolder dockableHolder = this.getHolder(n);
        return dockableHolder != null && dockableHolder.isMinimized();
    }

    protected boolean isMinimizable() {
        return this.getShutterMargin() != null;
    }

    protected boolean isMaximized() {
        return false;
    }

    protected boolean isMaximizable() {
        return this.isFloating() ^ true;
    }

    public ShutterMargin getShutterMargin() {
        DockPanel dockPanel = this.getDockPanel();
        if (dockPanel != null) {
            return dockPanel.getShutterMargin();
        }
        return null;
    }

    public int addClient(DockableHolder dockableHolder, int n) {
        Dockable dockable = dockableHolder.getDockable();
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        dockStationImpl.undock(dockable, n);
        DefaultCustomTabPage defaultCustomTabPage = new DefaultCustomTabPage(dockable.getTabIcon(), dockable.getTabName(), dockableHolder);
        String string = dockable.getTitleName();
        defaultCustomTabPage.setLongLabel(string);
        defaultCustomTabPage.setTooltip(string);
        defaultCustomTabPage.setVisible(false);
        int n2 = this._model.getSize();
        this._model.addElement(defaultCustomTabPage);
        dockStationImpl.addToCache(dockable);
        dockable.addTitleChangeListener(this);
        return n2;
    }

    public void addClient(Dockable dockable, boolean bl, int n) {
        DockableHolder dockableHolder = new DockableHolder(dockable);
        int n2 = this.addClient(dockableHolder, n);
        if (bl) {
            this.setClientVisible(n2, bl, n);
        }
    }

    public void removeClient(Dockable dockable, int n) {
        int n2 = this.getClientPos(dockable);
        this.removeClientAt(n2, n);
    }

    private void removeClientAt(int n, int n2) {
        ShutterMargin shutterMargin;
        DockableHolder dockableHolder = this.getHolder(n);
        Dockable dockable = dockableHolder.getDockable();
        dockable.removeTitleChangeListener(this);
        this.removeClientComponent(dockableHolder, n2);
        DockStationImpl.getInstance().removeFromCache(dockable);
        this.removeHolder(n);
        if (dockableHolder.isMinimized() && (shutterMargin = this.getShutterMargin()) != null) {
            shutterMargin.refreshShutter(this);
        }
    }

    public DockableHolder getHolder(int n) {
        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)this._model.getElementAt(n);
        return (DockableHolder)defaultCustomTabPage.getUserObject();
    }

    private void removeHolder(int n) {
        this._model.removeElementAt(n);
    }

    public int getClientCount() {
        return this._model.getSize();
    }

    public Dockable getClient(int n) {
        return this.getHolder(n).getDockable();
    }

    DockableHolder getHolder(Dockable dockable) {
        int n = this.getClientPos(dockable);
        return this.getHolder(n);
    }

    public int getClientPos(Dockable dockable) {
        if (dockable != null) {
            int n = this.getClientCount();
            int n2 = 0;
            while (n2 < n) {
                Dockable dockable2 = this.getClient(n2);
                if (dockable.equals(dockable2)) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    private DockableHolder getHolderForComponent(Component component) {
        if (component != null) {
            int n = this.getClientCount();
            while (n-- > 0) {
                DockableHolder dockableHolder = this.getHolder(n);
                if (component != dockableHolder.getComponent()) continue;
                return dockableHolder;
            }
        }
        return null;
    }

    public boolean isClient(Dockable dockable) {
        return this.getClientPos(dockable) != -1;
    }

    public boolean isClientVisible(int n) {
        DefaultCustomTabPage defaultCustomTabPage = this.getPage(n);
        return defaultCustomTabPage.isVisible();
    }

    public boolean isClientAccessible(Dockable dockable) {
        int n = this.getClientPos(dockable);
        if (!this.isClientVisible(n)) {
            return false;
        }
        if (this.isMinimizable() && this.isMinimized(n)) {
            ShutterMargin shutterMargin = this.getShutterMargin();
            return shutterMargin.hasShutter(this);
        }
        return this.isVisible();
    }

    int getDockableStatus(Dockable dockable) {
        int n = this.getClientPos(dockable);
        return this.getDockableStatus(n);
    }

    private int getDockableStatus(int n) {
        int n2 = 0;
        if (this.isMinimized(n)) {
            ShutterMargin shutterMargin = this.getShutterMargin();
            if (shutterMargin != null) {
                Dockable dockable;
                ShutterPanel shutterPanel;
                if (shutterMargin.hasShutter(this)) {
                    n2 |= 4;
                    if (this.isClientVisible(n)) {
                        n2 |= 8;
                    }
                }
                if ((shutterPanel = ShutterManager.getInstance().getShutterPanel()).isClientAccessible(dockable = this.getClient(n))) {
                    n2 |= 0x30;
                }
            }
        } else {
            n2 |= 2;
            if (this.isVisible() && this.isClientVisible(n)) {
                int n3;
                n2 |= 8;
                if (n == this.getSelectedIndex()) {
                    n2 |= 0x20;
                }
                if (this.isActive() && (n3 = this.getSelectedIndex()) == n) {
                    n2 |= 0x10;
                }
            }
        }
        return n2;
    }

    private int getClientComponentIndex(Dockable dockable) {
        int n = this.getClientCount();
        int n2 = 0;
        while (n2 < n) {
            DockableHolder dockableHolder = this.getHolder(n2);
            if (dockableHolder.getDockable().equals(dockable)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    void closePanel(int n) {
        boolean bl = false;
        if (GraphicsUtils.isAncestorOfFocusedComponent(this)) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.clearGlobalFocusOwner();
            bl = true;
        }
        int n2 = this.getClientCount();
        DockableHolder[] dockableHolderArray = new DockableHolder[n2];
        int n3 = n2 - 1;
        while (n3 >= 0) {
            dockableHolderArray[n3] = this.getHolder(n3);
            --n3;
        }
        int n4 = n2 - 1;
        while (n4 >= 0) {
            DockableHolder dockableHolder = dockableHolderArray[n4];
            Dockable dockable = dockableHolder.getDockable();
            if (this.isClient(dockable)) {
                this.closeClient(dockableHolder, n);
            }
            --n4;
        }
        if (this.getClientCount() == 0) {
            this.getParent().remove(this);
        } else {
            this.setVisible(false);
        }
        if (bl) {
            IdeUtil.tryToRestoreFocus(null);
        }
    }

    public void closeClient(DockableHolder dockableHolder, int n) {
        Dockable dockable = dockableHolder.getDockable();
        int n2 = dockable.getType();
        if (BitField.isSet(n2, 1)) {
            this.removeClient(dockable, n);
        } else {
            this.removeClientComponent(dockableHolder, n);
        }
    }

    private static void fireDockableHidden(DockableHolder dockableHolder, int n) {
        Dockable dockable = dockableHolder.getDockable();
        DockableEvent dockableEvent = new DockableEvent(dockable, 1, n);
        DockStationImpl.getInstance().fireDockableEvent(dockableEvent);
    }

    private static void fireDockableShown(DockableHolder dockableHolder, int n) {
        Dockable dockable = dockableHolder.getDockable();
        DockableEvent dockableEvent = new DockableEvent(dockable, 0, n);
        DockStationImpl.getInstance().fireDockableEvent(dockableEvent);
    }

    public int getVisibleCount() {
        int n = 0;
        int n2 = this.getClientCount();
        int n3 = 0;
        while (n3 < n2) {
            DefaultCustomTabPage defaultCustomTabPage = this.getPage(n3);
            if (defaultCustomTabPage.isVisible()) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    private void removeClientComponent(DockableHolder dockableHolder, int n) {
        JComponent jComponent = dockableHolder.getComponent();
        if (jComponent != null) {
            ShutterMargin shutterMargin;
            int n2 = this.searchPagePosition(dockableHolder);
            DefaultCustomTabPage defaultCustomTabPage = this.getPage(n2);
            defaultCustomTabPage.setVisible(false);
            int n3 = this.getSelectedIndex();
            if (n3 == n2) {
                int n4 = this.getClientCount();
                int n5 = n2;
                while (n5 < n4 - 1) {
                    DefaultCustomTabPage defaultCustomTabPage2 = this.getPage(n5);
                    if (defaultCustomTabPage2.isVisible()) break;
                    ++n5;
                }
                while (n5 >= 0) {
                    DefaultCustomTabPage defaultCustomTabPage3 = this.getPage(n5);
                    if (defaultCustomTabPage3.isVisible()) break;
                    --n5;
                }
                this.setSelectedIndex(n5);
            }
            if (this.getVisibleCount() == 0) {
                this.setVisible(false);
            } else {
                this._tabHeader.getCustomTab().whenTabChanged();
            }
            TitledPanel.fireDockableHidden(dockableHolder, n);
            dockableHolder.setComponent(null);
            if (dockableHolder.isMinimized() && (shutterMargin = this.getShutterMargin()) != null) {
                if (this.getVisibleCount() == 0) {
                    shutterMargin.removeShutter(this);
                } else {
                    shutterMargin.refreshShutter(this);
                }
            }
        }
    }

    private int searchPagePosition(DockableHolder dockableHolder) {
        return this.getClientPos(dockableHolder.getDockable());
    }

    public void setClientVisible(Dockable dockable, boolean bl, int n) {
        int n2 = this.getClientPos(dockable);
        this.setClientVisible(n2, bl, n);
    }

    public void setClientVisible(int n, boolean bl, int n2) {
        if (bl) {
            this.showClient(n, n2);
        } else {
            this.hideClient(n, n2);
        }
    }

    private boolean showClient(int n, int n2) {
        DockableHolder dockableHolder = this.getHolder(n);
        ShutterMargin shutterMargin = this.getShutterMargin();
        boolean bl = this.setPageVisible(n, n2);
        if (bl) {
            if (!this.isMinimizable() || !dockableHolder.isMinimized()) {
                this.setVisible(true);
                if (shutterMargin != null) {
                    shutterMargin.removeShutter(this);
                }
            } else if (shutterMargin != null) {
                bl = shutterMargin.addShutter(this, false);
            }
        }
        return bl;
    }

    private boolean setPageVisible(int n, int n2) {
        boolean bl = false;
        DefaultCustomTabPage defaultCustomTabPage = this.getPage(n);
        if (!defaultCustomTabPage.isVisible()) {
            DockableHolder dockableHolder = this.getHolder(n);
            JComponent jComponent = dockableHolder.getOrCreateComponent();
            if (jComponent != null) {
                bl = true;
                defaultCustomTabPage.setVisible(true);
                if (this.isShowing() || dockableHolder.isMinimized()) {
                    this.setSelectedIndex(n);
                } else if (this.getVisibleCount() == 1) {
                    this.setSelectedIndex(n);
                    Container container = this;
                    while (container != null && !container.isShowing()) {
                        if (!(container instanceof Frame)) {
                            ((Component)container).setVisible(true);
                        }
                        container = container.getParent();
                    }
                    if (container != null) {
                        if (container instanceof JComponent) {
                            JComponent jComponent2 = container;
                            jComponent2.revalidate();
                        } else {
                            container.validate();
                        }
                    }
                }
                TitledPanel.fireDockableShown(dockableHolder, n2);
                this.revalidate();
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private void hideClient(int n, int n2) {
        JComponent jComponent;
        DockableHolder dockableHolder = this.getHolder(n);
        if (this.isMinimizable() && dockableHolder.isMinimized()) {
            DockStationImpl dockStationImpl = DockStationImpl.getInstance();
            ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
            if (shutterPanel.isClientAccessible(dockableHolder)) {
                dockStationImpl.addDockableEventContext(4);
                try {
                    ShutterManager.getInstance().hideShutterPanel(n2 | 4);
                }
                finally {
                    dockStationImpl.removeDockableEventContext(4);
                }
            }
        }
        if ((jComponent = dockableHolder.getComponent()) != null) {
            this.removeClientComponent(dockableHolder, n2);
            jComponent.setVisible(false);
        }
    }

    private void showFloatShutter(Dockable dockable, int n) {
        DockableHolder dockableHolder = this.getHolder(dockable);
        ShutterMargin shutterMargin = this.getShutterMargin();
        this.setClientVisible(dockable, true, n);
        this.setVisible(false);
        shutterMargin.raiseFloatPanel(dockableHolder, n);
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        int n = dimension.width;
        int n2 = dimension.height;
        int n3 = this.getClientCount();
        int n4 = 0;
        while (n4 < n3) {
            DefaultCustomTabPage defaultCustomTabPage = this.getPage(n4);
            if (defaultCustomTabPage.isVisible()) {
                DockableHolder dockableHolder = this.getHolder(n4);
                JComponent jComponent = dockableHolder.getComponent();
                jComponent.setPreferredSize(new Dimension(n, n2));
            }
            ++n4;
        }
    }

    private void updateSiteInfo() {
        int n = this.getClientCount();
        int n2 = 0;
        while (n2 < n) {
            Dockable dockable = this.getClient(n2);
            this.updateSiteInfo(dockable);
            ++n2;
        }
    }

    private void updateSiteInfo(Dockable dockable) {
        Site site = dockable.getSite();
        FloatDockWindow floatDockWindow = this.getFloatContainer();
        if (floatDockWindow != null) {
            Dimension dimension = this.getDockPanel().getSize();
            site.geometry.setSize(dimension);
        }
        site.size = this.getPrefDockedSize();
    }

    protected void adjustTitle(Dockable dockable) {
        super.adjustTitle(dockable);
        int n = this.getClientPos(dockable);
        if (n != -1) {
            DefaultCustomTabPage defaultCustomTabPage = this.getPage(n);
            String string = dockable.getTitleName();
            defaultCustomTabPage.setIcon(dockable.getTabIcon());
            defaultCustomTabPage.setLabel(dockable.getTabName());
            defaultCustomTabPage.setLongLabel(string);
            defaultCustomTabPage.setTooltip(string);
            this._tabHeader.getCustomTab().whenTabChanged();
        }
    }

    protected void adjustButtons(Dockable dockable) {
        this._buttonPin.setVisible(this.isFloating() ^ true);
    }

    private void adjustButtons() {
        DockableHolder dockableHolder = this.getSelectedHolder();
        if (dockableHolder != null) {
            Dockable dockable = dockableHolder.getDockable();
            this.adjustButtons(dockable);
        }
    }

    private void adjustTitle() {
        DockableHolder dockableHolder = this.getSelectedHolder();
        if (dockableHolder != null) {
            Dockable dockable = dockableHolder.getDockable();
            this.adjustTitle(dockable);
            this.adjustButtons(dockable);
        }
    }

    Dimension getPrefDockedSize() {
        DockLayoutInfoLeaf dockLayoutInfoLeaf;
        Dimension dimension = null;
        DockPanel dockPanel = this.getDockPanel();
        if (dockPanel != null && (dockLayoutInfoLeaf = dockPanel.getLayoutInfo(this)) != null) {
            dimension = dockLayoutInfoLeaf.getPrefSize();
        }
        return dimension;
    }

    Dimension getPrefFloatSize() {
        Dockable dockable;
        Site site;
        Dimension dimension = null;
        if (this.getClientCount() > 0 && (site = (dockable = this.getClient(0)).getSite()) != null && site.geometry != null) {
            dimension = site.geometry.getSize();
        }
        if (dimension == null) {
            dimension = new Dimension(this.getPreferredSize());
        }
        return dimension;
    }

    FloatDockWindow getFloatContainer() {
        Container container = this;
        while (container != null) {
            if (container instanceof FloatDockUI) {
                FloatDockUI floatDockUI = (FloatDockUI)((Object)container);
                return floatDockUI.getFloatDockWindow();
            }
            container = container.getParent();
        }
        return null;
    }

    DockPanel getDockPanel() {
        return (DockPanel)this.getParent();
    }

    protected boolean isFloating() {
        return this.getFloatContainer() != null;
    }

    protected boolean canMove() {
        return true;
    }

    protected boolean canSize() {
        return true;
    }

    public void setSelectedIndex(int n) {
        this._tabHeader.getCustomTab().setSelectedPage(n);
    }

    public int getSelectedIndex() {
        return this._tabHeader.getCustomTab().getSelectedPage();
    }

    private JComponent getSelectedClient() {
        JComponent jComponent = null;
        DockableHolder dockableHolder = this.getSelectedHolder();
        if (dockableHolder != null) {
            jComponent = dockableHolder.getOrCreateComponent();
        }
        return jComponent;
    }

    public DockableHolder getSelectedHolder() {
        DockableHolder dockableHolder = null;
        int n = this.getSelectedIndex();
        if (n != -1) {
            dockableHolder = this.getHolder(n);
        }
        return dockableHolder;
    }

    protected void titleMousePressed(MouseEvent mouseEvent) {
        this.activate();
        AbstractTitledPanel._ptStart.setLocation(mouseEvent.getPoint());
        super.titleMousePressed(mouseEvent);
    }

    protected void titleMouseDragged(MouseEvent mouseEvent) {
        if (!AbstractTitledPanel._bDraging && SwingUtilities.isLeftMouseButton(mouseEvent) && AbstractTitledPanel._ptStart.distanceSq(mouseEvent.getPoint()) >= (double)AbstractTitledPanel.DRAGSTART) {
            AbstractTitledPanel._bDraging = true;
            this._titleDragListener = new TitledPanelDragListener(this);
            this.updateSiteInfo();
            SwingUtilities.convertPointToScreen(AbstractTitledPanel._ptStart, mouseEvent.getComponent());
            DragComponentEvent dragComponentEvent = new DragComponentEvent(this, AbstractTitledPanel._ptStart, 1, mouseEvent.getModifiers());
            this._titleDragListener.start(dragComponentEvent);
        }
        if (AbstractTitledPanel._bDraging) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            DragComponentEvent dragComponentEvent = new DragComponentEvent(this, point, 2, mouseEvent.getModifiers());
            this._titleDragListener.move(dragComponentEvent);
        }
    }

    protected void titleMouseReleased(MouseEvent mouseEvent) {
        if (AbstractTitledPanel._bDraging) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            this._titleDragListener.end(new DragComponentEvent(this, point, 3, mouseEvent.getModifiers()));
            AbstractTitledPanel._bDraging = false;
            this._titleDragListener = null;
        } else {
            super.titleMouseReleased(mouseEvent);
        }
    }

    private void tabMousePressed(MouseEvent mouseEvent) {
        if (!this.checkTabPopupAction(mouseEvent)) {
            AbstractTitledPanel._ptStart.setLocation(mouseEvent.getPoint());
            JComponent jComponent = this.getSelectedClient();
            GraphicsUtils.focusComponentOrChild(jComponent, true);
        }
    }

    private void tabMouseClicked(MouseEvent mouseEvent) {
        if (!this.checkTabPopupAction(mouseEvent) && this._tabTrigger.isDoubleClick(mouseEvent)) {
            this.whenMaximize(4);
        }
    }

    private void tabMouseDragged(MouseEvent mouseEvent) {
        DefaultCustomTabPage defaultCustomTabPage;
        Rectangle rectangle;
        int n = this.getSelectedIndex();
        DockableHolder dockableHolder = this.getSelectedHolder();
        if (dockableHolder == null) {
            return;
        }
        if (!AbstractTitledPanel._bDraging && (rectangle = (defaultCustomTabPage = this.getPage(n)).getBounds()).contains(AbstractTitledPanel._ptStart) && SwingUtilities.isLeftMouseButton(mouseEvent) && AbstractTitledPanel._ptStart.distanceSq(mouseEvent.getPoint()) >= (double)AbstractTitledPanel.DRAGSTART) {
            AbstractTitledPanel._bDraging = true;
            this._tabDragListener = new TitledPanelTabDragListener(dockableHolder);
            this.updateSiteInfo();
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            DragComponentEvent dragComponentEvent = new DragComponentEvent(dockableHolder.getComponent(), point, 1, mouseEvent.getModifiers());
            this._tabDragListener.start(dragComponentEvent);
        }
        if (AbstractTitledPanel._bDraging) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            DragComponentEvent dragComponentEvent = new DragComponentEvent(dockableHolder.getComponent(), point, 2, mouseEvent.getModifiers());
            this._tabDragListener.move(dragComponentEvent);
        }
    }

    private void tabMouseReleased(MouseEvent mouseEvent) {
        if (AbstractTitledPanel._bDraging) {
            DockableHolder dockableHolder = this.getSelectedHolder();
            JComponent jComponent = dockableHolder.getComponent();
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
            this._tabDragListener.end(new DragComponentEvent(jComponent, point, 3, mouseEvent.getModifiers()));
            AbstractTitledPanel._bDraging = false;
            this._tabDragListener = null;
        } else {
            this.checkTabPopupAction(mouseEvent);
        }
    }

    private boolean checkTabPopupAction(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            Point point = mouseEvent.getPoint();
            int n = this._tabHeader.getCustomTab().getPageAt(point);
            if (n != -1) {
                DockableHolder dockableHolder = this.getHolder(n);
                this.showTabContextMenu(mouseEvent, dockableHolder);
                bl = true;
            }
        }
        return bl;
    }

    private static DockableHolder loadClientLayout(StructuredPropertyAccess structuredPropertyAccess) {
        StructuredPropertyAccess structuredPropertyAccess2;
        StructuredPropertyAccess structuredPropertyAccess3;
        DockableHolder dockableHolder = null;
        String string = structuredPropertyAccess.getProperty("ID", "");
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        Dockable dockable = dockStationImpl.loadDockable(structuredPropertyAccess3 = (structuredPropertyAccess2 = structuredPropertyAccess.getChildNode("properties")) != null ? structuredPropertyAccess2 : new DefaultStructuredPropertyAccess("default"), string);
        if (dockable != null) {
            dockableHolder = new DockableHolder(dockable);
            Site site = dockable.getSite();
            site.size.width = structuredPropertyAccess.getIntegerProperty("dockWidth", 0);
            site.size.height = structuredPropertyAccess.getIntegerProperty("dockHeight", 0);
            site.geometry.width = structuredPropertyAccess.getIntegerProperty("floatWidth", 0);
            site.geometry.height = structuredPropertyAccess.getIntegerProperty("floatHeight", 0);
            String string2 = structuredPropertyAccess.getProperty("floatOnTop", null);
            Boolean bl = string2 == null ? null : Boolean.valueOf(string2);
            dockableHolder.setFloatOnTop(bl);
        }
        return dockableHolder;
    }

    private static void whenCloseTab(int n, DockableHolder dockableHolder) {
        Dockable dockable = dockableHolder.getDockable();
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        dockStationImpl.addDockableEventContext(n);
        try {
            dockStationImpl.closeDockable(dockable, n);
        }
        finally {
            dockStationImpl.removeDockableEventContext(n);
        }
    }

    private JPopupMenu getTabContextMenu(DockableHolder dockableHolder) {
        return this.createSystemMenu(dockableHolder);
    }

    private void showTabContextMenu(MouseEvent mouseEvent, DockableHolder dockableHolder) {
        JPopupMenu jPopupMenu = this.getTabContextMenu(dockableHolder);
        Point point = GraphicsUtils.getPopupMenuShowPoint(jPopupMenu, mouseEvent);
        jPopupMenu.show(mouseEvent.getComponent(), point.x, point.y);
    }

    protected JPopupMenu getTitleContextMenu() {
        return this.createSystemMenu(null);
    }

    protected void whenShowSystemMenu() {
        int n = this.getSelectedIndex();
        DockableHolder dockableHolder = this.getHolder(n);
        JPopupMenu jPopupMenu = this.getTabContextMenu(dockableHolder);
        Point point = this._tabHeader.getCustomTab().getLocationOnScreen();
        DefaultCustomTabPage defaultCustomTabPage = this.getPage(n);
        Rectangle rectangle = defaultCustomTabPage.getBounds();
        Point point2 = GraphicsUtils.getPopupMenuShowPoint(jPopupMenu, point.x + rectangle.x, point.y + rectangle.height);
        point2.translate(-point.x, -point.y);
        jPopupMenu.show(this._tabHeader.getCustomTab(), point2.x, point2.y);
    }

    protected void whenSystemMenuFloat(DockableHolder dockableHolder) {
        DockStationImpl.getInstance().floatPanel(this, new Point(10, 10));
    }

    protected void whenSystemMenuDock() {
        SwingUtilities.invokeLater(new 2());
    }

    private void _systemMenuDock() {
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        SidePort sidePort = dockStationImpl.getSidePort(0);
        DockPanel dockPanel = (DockPanel)this.getParent();
        DockLayoutInfoLeaf dockLayoutInfoLeaf = dockPanel.getLayoutInfo(this);
        Dimension dimension = dockLayoutInfoLeaf.getSize(2);
        DockLayoutConstraint dockLayoutConstraint = new DockLayoutConstraint(0, dimension);
        sidePort.dock(this, dockLayoutConstraint);
        dockPanel.revalidate();
    }

    protected void systemMenuMoveDocked() {
        DockableHolder dockableHolder = this.getSelectedHolder();
        Dockable dockable = dockableHolder.getDockable();
        JComponent jComponent = dockableHolder.getComponent();
        MoveFeedback.createMoveDock(dockable, jComponent);
    }

    protected void systemMenuMoveFloating() {
        MoveFeedback.createMoveFloat(this.getFloatContainer().getGUI());
    }

    protected void systemMenuSizeFloating() {
        MoveFeedback.createSizeFloat(this.getFloatContainer().getGUI());
    }

    protected void systemMenuSizeDocked() {
        DockPanel dockPanel = this.getDockPanel();
        MoveFeedback.createSizeDock(dockPanel, this);
    }

    protected void whenSystemMenuClose(DockableHolder dockableHolder) {
        TitledPanel.whenCloseTab(20, dockableHolder);
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public void titleChange(TitleChangeEvent titleChangeEvent) {
        Dockable dockable = titleChangeEvent.getDockable();
        this.adjustTitle(dockable);
        this.revalidate();
        this.repaint();
    }

    protected void whenClose(int n) {
        1 var2_2 = new 1(this, n);
        SwingUtilities.invokeLater(var2_2);
    }

    protected void whenMaximize(int n) {
        if (this.isFloating()) {
            return;
        }
        DockableHolder dockableHolder = this.getSelectedHolder();
        MaximizedTitledPanel maximizedTitledPanel = new MaximizedTitledPanel(this, dockableHolder);
        MainWindowImpl mainWindowImpl = (MainWindowImpl)Ide.getMainWindow();
        mainWindowImpl.maximize(maximizedTitledPanel);
    }

    protected void whenRestore(int n, DockableHolder dockableHolder) {
    }

    void maximizeHolder(DockableHolder dockableHolder) {
        GraphicsUtils.focusComponentOrChild(this._centerComponent, true);
    }

    void restoreHolder(DockableHolder dockableHolder) {
        this.setHolder(dockableHolder, true);
    }

    private void setHolder(DockableHolder dockableHolder, boolean bl) {
        if (this._centerComponent != null) {
            this._centerPanel.remove(this._centerComponent);
            this._centerComponent.setVisible(false);
            this._centerComponent = null;
        }
        if (dockableHolder != null) {
            this._centerComponent = dockableHolder.getOrCreateComponent();
            if (this._centerComponent != null) {
                this._centerComponent.setVisible(true);
                this._centerPanel.add((Component)this._centerComponent, "Center");
                if (bl) {
                    GraphicsUtils.focusComponentOrChild(this._centerComponent, true);
                }
            } else {
                String string = dockableHolder.getDockable().getUniqueName();
                System.err.println("Dockable failed to create the component:" + string);
            }
        }
    }

    protected void whenMinimize(int n) {
        if (this.isFloating()) {
            return;
        }
        boolean bl = this.isActive();
        this.minimize(true, n);
        if (bl) {
            IdeUtil.tryToRestoreFocus(null);
        }
    }

    public void restore(int n) {
        ShutterMargin shutterMargin = this.getShutterMargin();
        if (shutterMargin.hasShutter(this)) {
            shutterMargin.removeShutter(this);
            ShutterManager shutterManager = ShutterManager.getInstance();
            ShutterPanel shutterPanel = shutterManager.getShutterPanel();
            int n2 = 0;
            while (n2 < this.getClientCount()) {
                DockableHolder dockableHolder = this.getHolder(n2);
                dockableHolder.setMinimized(false);
                if (shutterPanel.isClientAccessible(dockableHolder)) {
                    shutterManager.hideShutterPanel(0);
                }
                ++n2;
            }
            DockableHolder dockableHolder = this.getSelectedHolder();
            this.setHolder(dockableHolder, true);
            this.setVisible(true);
            TitledPanel.fireDockableShown(dockableHolder, n);
            DockStationImpl.getInstance().activateDockable(dockableHolder.getDockable());
        }
    }

    void minimize(boolean bl, int n) {
        ShutterMargin shutterMargin = this.getShutterMargin();
        if (!shutterMargin.hasShutter(this)) {
            int n2 = 0;
            while (n2 < this.getClientCount()) {
                DockableHolder dockableHolder = this.getHolder(n2);
                dockableHolder.setMinimized(true);
                ++n2;
            }
            this.setVisible(false);
            shutterMargin.addShutter(this, bl);
            DockableHolder dockableHolder = this.getSelectedHolder();
            if (dockableHolder != null) {
                TitledPanel.fireDockableHidden(dockableHolder, n);
            }
        }
    }

    void saveLayout(StructuredPropertyAccess structuredPropertyAccess) {
        int n = this.getClientCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess("dockable");
            try {
                Site site;
                DockableHolder dockableHolder = this.getHolder(n2);
                Dockable dockable = dockableHolder.getDockable();
                this.updateSiteInfo(dockable);
                String string = dockable.getUniqueName();
                DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2 = new DefaultStructuredPropertyAccess("properties");
                dockable.saveLayout(defaultStructuredPropertyAccess2);
                if (defaultStructuredPropertyAccess2.hasAttributes() || defaultStructuredPropertyAccess2.hasChildNodes()) {
                    defaultStructuredPropertyAccess.appendChild(defaultStructuredPropertyAccess2);
                }
                defaultStructuredPropertyAccess.setProperty("ID", string);
                Boolean bl = dockableHolder.getFloatOnTop();
                if (bl != null) {
                    defaultStructuredPropertyAccess.setBooleanProperty("floatOnTop", bl);
                }
                if ((site = dockable.getSite()) != null) {
                    defaultStructuredPropertyAccess.setIntegerProperty("dockWidth", site.size.width);
                    defaultStructuredPropertyAccess.setIntegerProperty("dockHeight", site.size.height);
                    defaultStructuredPropertyAccess.setIntegerProperty("floatWidth", site.geometry.width);
                    defaultStructuredPropertyAccess.setIntegerProperty("floatHeight", site.geometry.height);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            structuredPropertyAccess.appendChild(defaultStructuredPropertyAccess);
            ++n2;
        }
    }

    static TitledPanel loadLayout(StructuredPropertyAccess structuredPropertyAccess) {
        int n = 0;
        if (ProfileIDs.PROFILE_LOADLAYOUT2) {
            n = IdeProfile.startEvent(3305);
        }
        TitledPanel titledPanel = null;
        Iterator iterator = structuredPropertyAccess.getChildNodes("dockable");
        while (iterator.hasNext()) {
            StructuredPropertyAccess structuredPropertyAccess2 = (StructuredPropertyAccess)iterator.next();
            try {
                DockableHolder dockableHolder = TitledPanel.loadClientLayout(structuredPropertyAccess2);
                if (dockableHolder == null) continue;
                if (titledPanel == null) {
                    titledPanel = new TitledPanel();
                    titledPanel.setVisible(false);
                }
                titledPanel.addClient(dockableHolder, 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (ProfileIDs.PROFILE_LOADLAYOUT2) {
            IdeProfile.endEvent(n);
        }
        return titledPanel;
    }

    private boolean isShuttered() {
        ShutterMargin shutterMargin = this.getShutterMargin();
        return shutterMargin != null ? shutterMargin.hasShutter(this) : false;
    }

    void loadVisibilityLayout(VisibilityLayout visibilityLayout, boolean bl, int n) {
        int n2 = this.getSelectedIndex();
        boolean bl2 = false;
        int n3 = this.getClientCount();
        boolean bl3 = this.isShuttered();
        int n4 = 0;
        while (n4 < n3) {
            boolean bl4;
            boolean bl5;
            boolean bl6;
            DockableHolder dockableHolder = this.getHolder(n4);
            Dockable dockable = dockableHolder.getDockable();
            boolean bl7 = false;
            if (bl) {
                bl6 = true;
            } else {
                int n5 = dockable.getType();
                boolean bl8 = BitField.isSet(n5, 32);
                boolean bl9 = bl6 = !bl8;
                if (bl6) {
                    int n6 = this.getDockableStatus(dockable);
                    bl7 = BitField.isSet(n6, 8);
                }
            }
            String string = dockable.getUniqueName();
            if (bl6 && (bl5 = visibilityLayout.isVisible(string)) != bl7) {
                this.setClientVisible(dockable, bl5, n);
            }
            if (bl4 = visibilityLayout.isRaised(string)) {
                n2 = this.getClientComponentIndex(dockable);
            }
            bl2 = bl2 || visibilityLayout.isMinimized(string);
            ++n4;
        }
        if (n2 != -1) {
            this.setSelectedIndex(n2);
        }
        if (bl3 != bl2) {
            if (bl2) {
                this.minimize(false, n);
            } else {
                this.restore(n);
            }
        }
    }

    void saveVisibilityLayout(VisibilityLayout visibilityLayout) {
        DockableHolder dockableHolder = this.getSelectedHolder();
        int n = this.getClientCount();
        int n2 = 0;
        while (n2 < n) {
            DockableHolder dockableHolder2 = this.getHolder(n2);
            Dockable dockable = dockableHolder2.getDockable();
            int n3 = this.getDockableStatus(dockable);
            String string = dockable.getUniqueName();
            boolean bl = BitField.isSet(n3, 8);
            boolean bl2 = BitField.isSet(n3, 4);
            boolean bl3 = dockableHolder == dockableHolder2;
            visibilityLayout.setVisible(string, bl);
            visibilityLayout.setMinimized(string, bl2);
            visibilityLayout.setRaised(string, bl3);
            ++n2;
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this._ptDragEnter = dropTargetDragEvent.getLocation();
        DropTargetListener dropTargetListener = this.findTabDropListener(this._ptDragEnter);
        if (dropTargetListener != null) {
            dropTargetListener.dragEnter(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        DropTargetListener dropTargetListener = this.findTabDropListener(point);
        if (dropTargetListener != null) {
            dropTargetListener.dragOver(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        DropTargetListener dropTargetListener = this.findTabDropListener(this._ptDragEnter);
        if (dropTargetListener != null) {
            dropTargetListener.dragExit(dropTargetEvent);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Point point = dropTargetDropEvent.getLocation();
        DropTargetListener dropTargetListener = this.findTabDropListener(point);
        if (dropTargetListener != null) {
            dropTargetListener.drop(dropTargetDropEvent);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        DropTargetListener dropTargetListener = this.findTabDropListener(point);
        if (dropTargetListener != null) {
            dropTargetListener.dropActionChanged(dropTargetDragEvent);
        }
    }

    private DropTargetListener findTabDropListener(Point point) {
        int n = this._tabHeader.getCustomTab().getPageAt(point);
        if (n != -1) {
            DockableHolder dockableHolder = this.getHolder(n);
            Dockable dockable = dockableHolder.getDockable();
            return dockable.getTabDropListener();
        }
        return null;
    }

    void transferClients(TitledPanel titledPanel, int n) {
        int n2 = titledPanel.getClientCount();
        int n3 = 0;
        while (n3 < n2) {
            DefaultCustomTabPage defaultCustomTabPage = titledPanel.getPage(0);
            DockableHolder dockableHolder = titledPanel.getHolder(0);
            boolean bl = defaultCustomTabPage.isVisible();
            titledPanel.removeClientAt(0, n);
            int n4 = this.addClient(dockableHolder, n);
            if (bl) {
                this.setClientVisible(n4, true, n);
            }
            ++n3;
        }
    }

    public boolean getDockablePath(DockablePath dockablePath, DockableCriteria dockableCriteria) {
        int n = dockableCriteria.getSearchFor();
        switch (n) {
            case 2: {
                Dockable dockable = (Dockable)dockableCriteria.getCriteria();
                int n2 = this.getClientCount();
                int n3 = 0;
                while (n3 < n2) {
                    DockableHolder dockableHolder = this.getHolder(n3);
                    if (dockable.equals(dockableHolder.getDockable())) {
                        dockablePath.setDockableHolder(dockableHolder);
                        dockablePath.setPagePos(n3);
                        return true;
                    }
                    ++n3;
                }
                break;
            }
            case 3: {
                DockableHolder dockableHolder = (DockableHolder)dockableCriteria.getCriteria();
                int n4 = this.getClientCount();
                int n5 = 0;
                while (n5 < n4) {
                    DockableHolder dockableHolder2 = this.getHolder(n5);
                    if (dockableHolder2 == dockableHolder) {
                        dockablePath.setDockableHolder(dockableHolder2);
                        dockablePath.setPagePos(n5);
                        return true;
                    }
                    ++n5;
                }
                break;
            }
        }
        return false;
    }

    void getDockablePaths(List list) {
        int n = this.getClientCount();
        int n2 = 0;
        while (n2 < n) {
            DockablePath dockablePath = new DockablePath();
            dockablePath.setPagePos(n2);
            DockableHolder dockableHolder = this.getHolder(n2);
            dockablePath.setDockableHolder(dockableHolder);
            list.add(dockablePath);
            ++n2;
        }
    }

    public void setDockableVisible(DockablePath dockablePath, boolean bl, int n) {
        int n2 = dockablePath.getPagePos();
        this.setClientVisible(n2, bl, n);
    }

    boolean activate() {
        JComponent jComponent = this.getSelectedClient();
        JComponent jComponent2 = GraphicsUtils.getFocusableComponentOrChild(jComponent, true);
        if (jComponent2 != null) {
            jComponent2.requestFocus();
            return true;
        }
        return false;
    }

    public boolean activateDockable(Dockable dockable) {
        int n = this.getClientPos(dockable);
        boolean bl = this.activateDockable(n, 0);
        return bl;
    }

    private boolean activateDockable(int n, int n2) {
        boolean bl = false;
        if (this.isMinimizable() && this.isMinimized(n)) {
            DockableHolder dockableHolder = this.getHolder(n);
            Dockable dockable = dockableHolder.getDockable();
            this.showFloatShutter(dockable, n2);
            bl = true;
        } else if (this.isClientVisible(n)) {
            this.setSelectedIndex(n);
            this.activate();
            bl = true;
        }
        return bl;
    }

    public boolean activateDockable(DockablePath dockablePath, int n) {
        int n2 = dockablePath.getPagePos();
        return this.activateDockable(n2, n);
    }

    boolean getActiveDockablePath(DockablePath dockablePath) {
        int n;
        if (this.isActive() && (n = this.getSelectedIndex()) >= 0) {
            dockablePath.setPagePos(n);
            DockableHolder dockableHolder = this.getHolder(n);
            dockablePath.setDockableHolder(dockableHolder);
            return true;
        }
        return false;
    }

    boolean isActive() {
        return super.isActive() || this._centerComponent != null && this._centerComponent.getParent() instanceof MaximizedTitledPanel;
    }

    static void mav$_systemMenuDock(TitledPanel titledPanel) {
        titledPanel._systemMenuDock();
    }

    static void maS$whenCloseTab(int n, DockableHolder dockableHolder) {
        TitledPanel.whenCloseTab(n, dockableHolder);
    }

    static void mav$tabMouseReleased(TitledPanel titledPanel, MouseEvent mouseEvent) {
        titledPanel.tabMouseReleased(mouseEvent);
    }

    static void mav$tabMousePressed(TitledPanel titledPanel, MouseEvent mouseEvent) {
        titledPanel.tabMousePressed(mouseEvent);
    }

    static void mav$tabMouseDragged(TitledPanel titledPanel, MouseEvent mouseEvent) {
        titledPanel.tabMouseDragged(mouseEvent);
    }

    static void mav$tabMouseClicked(TitledPanel titledPanel, MouseEvent mouseEvent) {
        titledPanel.tabMouseClicked(mouseEvent);
    }

    static void mav$whenTabSelectionChanges(TitledPanel titledPanel, ListSelectionEvent listSelectionEvent) {
        titledPanel.whenTabSelectionChanges(listSelectionEvent);
    }

    public final class 2
    implements Runnable {
        public void run() {
            TitledPanel.mav$_systemMenuDock(TitledPanel.this);
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ int v$flags;
        final /* synthetic */ TitledPanel this$0;

        public void run() {
            int n = this.this$0.getClientCount();
            while (n-- > 0) {
                DockableHolder dockableHolder = this.this$0.getHolder(n);
                TitledPanel.maS$whenCloseTab(this.v$flags, dockableHolder);
            }
        }

        public 1(TitledPanel titledPanel, int n) {
            this.v$flags = n;
            this.this$0 = titledPanel;
        }
    }

    private final class EventListener
    implements MouseInputListener,
    ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TitledPanel.mav$whenTabSelectionChanges(TitledPanel.this, listSelectionEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TitledPanel.mav$tabMouseClicked(TitledPanel.this, mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            TitledPanel.mav$tabMouseDragged(TitledPanel.this, mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TitledPanel.mav$tabMousePressed(TitledPanel.this, mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TitledPanel.mav$tabMouseReleased(TitledPanel.this, mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private EventListener() {
        }

        EventListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class TabbedHeaderBorder
    extends AbstractBorder {
        private final TabbedHeader _tabHeader;

        TabbedHeaderBorder(TabbedHeader tabbedHeader) {
            this._tabHeader = tabbedHeader;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            CustomTab customTab = this._tabHeader.getCustomTab();
            Color color = graphics.getColor();
            Rectangle rectangle = customTab.getBounds();
            int n5 = customTab.getCornerSize();
            int n6 = rectangle.y;
            int n7 = rectangle.x;
            int n8 = n6 > 0 || n7 > 0 ? 1 : n5;
            graphics.setColor(IdeConstants.COLOR_IDE_LINES);
            graphics.translate(n, n2);
            graphics.drawLine(n3 - 1, n8, n3 - 1, n4 - 1);
            if (n8 > 1) {
                graphics.drawLine(n3 - n8 - 1, 0, n3 - 1, n8);
            }
            if (n6 > 0) {
                graphics.drawLine(n8, 0, n3 - n8 - 1, 0);
            } else {
                graphics.drawLine(rectangle.x + rectangle.width, 0, n3 - n8 - 1, 0);
                if (n7 > 0) {
                    graphics.drawLine(n8, 0, n7 + n5, 0);
                }
            }
            if (n8 > 1 && (n7 > 0 || n6 > 0)) {
                graphics.drawLine(0, n8, n8, 0);
            }
            graphics.drawLine(0, n8, 0, n4 - 1);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 0;
            insets.left = 0;
            insets.bottom = 0;
            insets.right = 1;
            return insets;
        }
    }

    private static final class CenterPanelBorder
    extends LineBorder {
        CenterPanelBorder() {
            this(IdeConstants.COLOR_IDE_LINES);
        }

        CenterPanelBorder(Color color) {
            super(color);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.lineColor);
            graphics.translate(n, n2);
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(0, 0, 0, n4 - 2);
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 2);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }

    private static final class TabCloseAction
    extends AbstractAction {
        public TabCloseAction() {
            this.putValue("ShortDescription", TabCloseAction.getCloseActionLabel());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)object;
            DockableHolder dockableHolder = (DockableHolder)defaultCustomTabPage.getUserObject();
            TitledPanel.maS$whenCloseTab(20, dockableHolder);
        }

        private static String getCloseActionLabel() {
            KeyStroke keyStroke = AbstractTitledPanel.getClosePanelKeyStroke();
            String string = IdeImplArb.getString(44) + " (" + KeyUtil.toString(keyStroke) + ")";
            return string;
        }
    }
}

