/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import oracle.ide.controls.DragComponentEvent;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.docking.AbstractDockPanelDragListener;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.TitledPanel;

final class TitledPanelDragListener
extends AbstractDockPanelDragListener {
    private TitledPanel _titledPanel;

    public TitledPanelDragListener(TitledPanel titledPanel) {
        super(titledPanel.getHolder(0));
        this._titledPanel = titledPanel;
    }

    protected DockInsertionPoint getDockInsertionPoint(DragComponentEvent dragComponentEvent) {
        DockLayoutConstraint dockLayoutConstraint;
        TitledPanel titledPanel;
        DockInsertionPoint dockInsertionPoint = null;
        if ((dragComponentEvent.getModifiers() & 2) == 0 && (dockInsertionPoint = DockStationImpl.getInstance().getDockInsertionAt(dragComponentEvent.getPoint())) != null && !DockPanel.canDock(titledPanel = this._titledPanel, dockLayoutConstraint = dockInsertionPoint.createConstraint())) {
            dockInsertionPoint = null;
        }
        return dockInsertionPoint;
    }

    protected void dragComponent(DragComponentEvent dragComponentEvent) {
    }

    protected void dropComponent(DragComponentEvent dragComponentEvent) {
        DockInsertionPoint dockInsertionPoint = this.getDockInsertionPoint(dragComponentEvent);
        if (dockInsertionPoint == null) {
            this.floatComponent(dragComponentEvent);
        } else if (dockInsertionPoint.getOrientation() != 4) {
            this.dockComponent(dockInsertionPoint);
        } else {
            this.dockCenterComponent(dockInsertionPoint);
        }
    }

    private void floatComponent(DragComponentEvent dragComponentEvent) {
        Rectangle rectangle = this.getFloatingRect(dragComponentEvent);
        Container container = this._titledPanel.getParent();
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        dockStationImpl.dockFloat(this._titledPanel, rectangle.getLocation());
        this._titledPanel.activate();
        container.validate();
    }

    private void dockComponent(DockInsertionPoint dockInsertionPoint) {
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        DockPanel dockPanel = (DockPanel)dockInsertionPoint.getContainer();
        DockPanel dockPanel2 = this._titledPanel.getDockPanel();
        DockLayoutInfoLeaf dockLayoutInfoLeaf = dockPanel2.getLayoutInfo(this._titledPanel);
        Dimension dimension = dockLayoutInfoLeaf.getSize(2);
        DockLayoutConstraint dockLayoutConstraint = dockInsertionPoint.createConstraint();
        dockLayoutConstraint.setPreferredDimension(dimension);
        dockStationImpl._dock(this._titledPanel, dockPanel, dockLayoutConstraint);
        this._titledPanel.activate();
        dockPanel2.revalidate();
    }

    private void dockCenterComponent(DockInsertionPoint dockInsertionPoint) {
        TitledPanel titledPanel = (TitledPanel)dockInsertionPoint.getCenterReferenceComponent();
        DockStationImpl.transferClients(this._titledPanel, titledPanel, 12);
    }
}

