/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import oracle.ide.controls.DragComponentEvent;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.Site;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.docking.AbstractDockPanelDragListener;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.TitledPanel;

public class TitledPanelTabDragListener
extends AbstractDockPanelDragListener {
    protected DockableHolder _source;

    protected TitledPanelTabDragListener(DockableHolder dockableHolder) {
        super(dockableHolder);
        this._source = dockableHolder;
    }

    protected boolean isDraggingTab() {
        return true;
    }

    protected DockInsertionPoint getDockInsertionPoint(DragComponentEvent dragComponentEvent) {
        DockLayoutConstraint dockLayoutConstraint;
        JComponent jComponent;
        DockInsertionPoint dockInsertionPoint = null;
        if ((dragComponentEvent.getModifiers() & 2) == 0 && (dockInsertionPoint = DockStationImpl.getInstance().getDockInsertionAt(dragComponentEvent.getPoint())) != null && !DockPanel.canDock(jComponent = this._source.getComponent(), dockLayoutConstraint = dockInsertionPoint.createConstraint())) {
            dockInsertionPoint = null;
        }
        return dockInsertionPoint;
    }

    protected void dragComponent(DragComponentEvent dragComponentEvent) {
    }

    protected void dropComponent(DragComponentEvent dragComponentEvent) {
        DockInsertionPoint dockInsertionPoint = this.getDockInsertionPoint(dragComponentEvent);
        if (dockInsertionPoint == null) {
            this.floatComponent(dragComponentEvent);
        } else if (dockInsertionPoint.getOrientation() != 4) {
            this.dockComponent(dockInsertionPoint);
        } else {
            this.dockCenterComponent(dockInsertionPoint);
        }
        JComponent jComponent = this._source.getOrCreateComponent();
        jComponent.setVisible(true);
    }

    private void floatComponent(DragComponentEvent dragComponentEvent) {
        int n = 12;
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        Rectangle rectangle = this.getFloatingRect(dragComponentEvent);
        Dockable dockable = this._source.getDockable();
        dockStationImpl.undock(dockable, n);
        DockingParam dockingParam = new DockingParam();
        Point point = rectangle.getLocation();
        Site site = dockable.getSite();
        Dimension dimension = site.geometry.getSize();
        Rectangle rectangle2 = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        dockingParam.setFloatingPosition(rectangle2);
        dockingParam.setFloatOnTop(this._source.getFloatOnTop());
        dockStationImpl.dock(dockable, dockingParam, n);
        dockStationImpl.setDockableVisible(dockable, true, n);
        dockStationImpl.activateDockable(dockable);
    }

    protected void dockComponent(DockInsertionPoint dockInsertionPoint) {
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        DockPanel dockPanel = (DockPanel)dockInsertionPoint.getContainer();
        Dockable dockable = this._source.getDockable();
        int n = 12;
        dockStationImpl.undock(dockable, n);
        TitledPanel titledPanel = dockStationImpl._dock(dockable, dockPanel, dockInsertionPoint.createConstraint(), true, n);
        titledPanel.activate();
        dockPanel.validate();
    }

    protected void dockCenterComponent(DockInsertionPoint dockInsertionPoint) {
        TitledPanel titledPanel = (TitledPanel)dockInsertionPoint.getCenterReferenceComponent();
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        Dockable dockable = this._source.getDockable();
        dockStationImpl.undock(dockable, 12);
        titledPanel.addClient(dockable, true, 12);
        titledPanel.activateDockable(dockable);
        titledPanel.getParent().validate();
    }
}

