/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;

public final class VisibilityLayout {
    private static final int FLAG_VISIBLE = 1;
    private static final int FLAG_MINIMIZED = 2;
    private static final int FLAG_RAISED = 4;
    private String _internalName;
    private String _displayName;
    private HashMap _visibilityInfo;

    void $init$() {
        this._visibilityInfo = new HashMap();
    }

    public VisibilityLayout(String string, String string2) {
        this.$init$();
        this._internalName = string;
        this._displayName = string2;
    }

    private String getInternalName() {
        return this._internalName;
    }

    private String getDisplayName() {
        return this._displayName;
    }

    private int getFlags(String string) {
        Integer n = (Integer)this._visibilityInfo.get(string);
        return n == null ? 0 : n;
    }

    private void setFlags(String string, int n) {
        this._visibilityInfo.put(string, new Integer(n));
    }

    private boolean getFlag(String string, int n) {
        int n2 = this.getFlags(string);
        return BitField.isSet(n2, n);
    }

    private void setFlag(String string, boolean bl, int n) {
        int n2 = this.getFlags(string);
        int n3 = bl ? BitField.set(n2, n) : BitField.unset(n2, n);
        this.setFlags(string, n3);
    }

    public void setVisible(String string, boolean bl) {
        this.setFlag(string, bl, 1);
    }

    public boolean isVisible(String string) {
        return this.getFlag(string, 1);
    }

    public void setMinimized(String string, boolean bl) {
        this.setFlag(string, bl, 2);
    }

    public boolean isMinimized(String string) {
        return this.getFlag(string, 2);
    }

    public void setRaised(String string, boolean bl) {
        this.setFlag(string, bl, 4);
    }

    public boolean isRaised(String string) {
        return this.getFlag(string, 4);
    }

    public static String[] getNewDockables(VisibilityLayout visibilityLayout, VisibilityLayout visibilityLayout2) {
        Set set = visibilityLayout._visibilityInfo.keySet();
        Set set2 = visibilityLayout2._visibilityInfo.keySet();
        HashSet hashSet = new HashSet(set);
        hashSet.removeAll(set2);
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void clear() {
        this._visibilityInfo.clear();
    }

    public StructuredPropertyAccess save() {
        String string = this.getInternalName();
        DefaultStructuredPropertyAccess defaultStructuredPropertyAccess = new DefaultStructuredPropertyAccess(string);
        String string2 = this.getDisplayName();
        defaultStructuredPropertyAccess.setProperty("displayName", string2);
        Set set = this._visibilityInfo.keySet();
        for (String string3 : set) {
            boolean bl;
            boolean bl2;
            DefaultStructuredPropertyAccess defaultStructuredPropertyAccess2 = new DefaultStructuredPropertyAccess(string3);
            boolean bl3 = this.isVisible(string3);
            if (bl3) {
                defaultStructuredPropertyAccess2.setProperty("visible", Boolean.TRUE.toString());
            }
            if (bl2 = this.isMinimized(string3)) {
                defaultStructuredPropertyAccess2.setProperty("minimized", Boolean.TRUE.toString());
            }
            if (bl = this.isRaised(string3)) {
                defaultStructuredPropertyAccess2.setProperty("raised", Boolean.TRUE.toString());
            }
            defaultStructuredPropertyAccess.appendChild(defaultStructuredPropertyAccess2);
        }
        return defaultStructuredPropertyAccess;
    }

    public static VisibilityLayout load(StructuredPropertyAccess structuredPropertyAccess) {
        String string = structuredPropertyAccess.getName();
        String string2 = structuredPropertyAccess.getProperty("displayName", string);
        VisibilityLayout visibilityLayout = new VisibilityLayout(string, string2);
        Iterator iterator = structuredPropertyAccess.getChildNodes();
        while (iterator.hasNext()) {
            StructuredPropertyAccess structuredPropertyAccess2 = (StructuredPropertyAccess)iterator.next();
            String string3 = structuredPropertyAccess2.getName();
            String string4 = structuredPropertyAccess2.getProperty("visible", Boolean.FALSE.toString());
            boolean bl = Boolean.valueOf(string4);
            visibilityLayout.setVisible(string3, bl);
            String string5 = structuredPropertyAccess2.getProperty("minimized", Boolean.FALSE.toString());
            boolean bl2 = Boolean.valueOf(string5);
            visibilityLayout.setMinimized(string3, bl2);
            String string6 = structuredPropertyAccess2.getProperty("raised", Boolean.FALSE.toString());
            boolean bl3 = Boolean.valueOf(string6);
            visibilityLayout.setRaised(string3, bl3);
        }
        return visibilityLayout;
    }
}

