/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import oracle.ideimpl.docking.VisibleComponentEvent;
import oracle.ideimpl.docking.VisibleComponentListener;

final class VisibleComponentAgent
implements ContainerListener,
ComponentListener {
    private ArrayList _listeners;

    void $init$() {
        this._listeners = new ArrayList();
    }

    public void attachTo(Container container) {
        container.addContainerListener(this);
    }

    public void addVisibleComponentListener(VisibleComponentListener visibleComponentListener) {
        if (!this._listeners.contains(this._listeners)) {
            this._listeners.add(visibleComponentListener);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.whenComponentChanges(component.getParent(), component);
    }

    public void componentHidden(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.whenComponentChanges(component.getParent(), component);
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentAdded(ContainerEvent containerEvent) {
        Container container = containerEvent.getContainer();
        Component component = containerEvent.getChild();
        this.whenComponentChanges(container, component);
        component.addComponentListener(this);
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        Container container = containerEvent.getContainer();
        Component component = containerEvent.getChild();
        component.removeComponentListener(this);
        this.whenComponentChanges(container, component);
    }

    private void whenComponentChanges(Container container, Component component) {
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Component component2 = container.getComponent(n3);
            if (component2.isVisible()) {
                ++n2;
            }
            ++n3;
        }
        VisibleComponentEvent visibleComponentEvent = new VisibleComponentEvent(container, component, n2);
        n = this._listeners.size();
        int n4 = 0;
        while (n4 < n) {
            VisibleComponentListener visibleComponentListener = (VisibleComponentListener)this._listeners.get(n4);
            visibleComponentListener.visibleCountChanges(visibleComponentEvent);
            ++n4;
        }
    }

    VisibleComponentAgent() {
        this.$init$();
    }
}

