/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.controls;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import oracle.ideimpl.docking.controls.DividerEvent;
import oracle.ideimpl.docking.controls.DividerListener;

public final class Divider
extends Box
implements SwingConstants {
    private int _orientation;
    private transient boolean dragging;
    private transient int x1;
    private transient int y1;
    private transient int x2;
    private transient int y2;

    public Divider(int n, int n2) {
        super(0);
        this.enableEvents(48);
        this.setOrientation(n);
        this.add(Box.createRigidArea(new Dimension(n2, n2)));
    }

    private int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int n) {
        this._orientation = n;
        int n2 = this._orientation == 0 ? 9 : 11;
        this.setCursor(Cursor.getPredefinedCursor(n2));
    }

    public void addDividerListener(DividerListener dividerListener) {
        this.listenerList.add(DividerListener.class, dividerListener);
    }

    public void removeDividerListener(DividerListener dividerListener) {
        this.listenerList.remove(DividerListener.class, dividerListener);
    }

    protected void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    private void fireDividerListener(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        DividerEvent dividerEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == DividerListener.class) {
                if (dividerEvent == null) {
                    dividerEvent = new DividerEvent(this, n);
                }
                ((DividerListener)objectArray[n2 + 1]).dividerMoved(dividerEvent);
            }
            n2 -= 2;
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 502: {
                if (!this.dragging) break;
                Graphics graphics = this.getRpGraphics();
                graphics.drawLine(this.x1, this.y1, this.x2, this.y2);
                graphics.dispose();
                this.dragging = false;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (this.getOrientation() == 0) {
                    this.fireDividerListener(n2);
                    break;
                }
                this.fireDividerListener(n);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 506: {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Graphics graphics = this.getRpGraphics();
                if (this.dragging) {
                    graphics.drawLine(this.x1, this.y1, this.x2, this.y2);
                } else {
                    this.dragging = true;
                }
                if (this.getOrientation() == 0) {
                    this.x1 = 0;
                    this.y1 = n2;
                    this.x2 = this.getWidth();
                    this.y2 = n2;
                } else {
                    this.x1 = n;
                    this.y1 = 0;
                    this.x2 = n;
                    this.y2 = this.getHeight();
                }
                graphics.drawLine(this.x1, this.y1, this.x2, this.y2);
                graphics.dispose();
                break;
            }
            default: {
                super.processMouseMotionEvent(mouseEvent);
            }
        }
    }

    private Graphics getRpGraphics() {
        JRootPane jRootPane = this.getRootPane();
        Point point = this.getLocationOnScreen();
        Point point2 = jRootPane.getLocationOnScreen();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        Graphics graphics = jRootPane.getGraphics();
        graphics.setXORMode(jRootPane.getBackground());
        graphics.translate(point3.x, point3.y);
        return graphics;
    }
}

