/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.ButtonsLayoutManager;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.util.BitField;
import oracle.javatools.controls.GradientPanel;
import oracle.javatools.util.SwingUtils;

public final class Handlebar
extends GradientPanel
implements SwingConstants {
    private static final int FLAG_ACTIVE = 1;
    private static final int FLAG_TRUNCATE_TITLE = 2;
    private static final int FLAG_BUTTONS_VISIBLE = 4;
    private static final int ROT_LEFT = -1;
    private static final int ROT_NONE = 0;
    private static final int MINIMUM_SIZE_TO_SHOW_BUTTONS = 50;
    private static final boolean USE_ANTIALIAS = false;
    private static final int GAP_BEFORE_TITLE = 3;
    private static final int GAP_AFTER_TITLE = 3;
    private static final int GAP_ICON = 1;
    private static final Dimension MINIMUM_SIZE = new Dimension(3, 3);
    private Rectangle2D _rectTitle;
    private int _nOrient;
    private String _sTitle;
    private Icon _icon;
    private int _flags;
    private static final int GAP_ABOVE = 1;
    private static final int GAP_BELOW = 1;

    void $init$() {
        this._nOrient = 0;
        this._sTitle = "";
        this._flags = 4;
    }

    public Handlebar() {
        super(5);
        this.$init$();
        this.setLayout(new ButtonsLayoutManager(1));
        this.setOrientation(0);
        this.adjustColors();
        this.setFont(UIManager.getFont("Label.font"));
    }

    public String getTitle() {
        return this._sTitle;
    }

    public void setTitle(String string) {
        this._sTitle = string != null ? string : "";
        this.getAccessibleContext().setAccessibleName(string);
        this.invalidateUI();
    }

    private Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
        this.invalidateUI();
    }

    private boolean isButtonsVisible() {
        return BitField.isSet(this._flags, 4);
    }

    private void setButtonsVisible(boolean bl) {
        this._flags = bl ? BitField.set(this._flags, 4) : BitField.unset(this._flags, 4);
    }

    public void addButton(SmallSquareButton smallSquareButton, int n) {
        smallSquareButton.setRolloverEnabled(false);
        smallSquareButton.setForeground(this.isActive() ? IdeUIManager.getActiveTitleButtonColor() : IdeUIManager.getInactiveTitleButtonColor());
        this.add(smallSquareButton, new Integer(n));
    }

    public void removeButton(int n) {
        ButtonsLayoutManager buttonsLayoutManager = (ButtonsLayoutManager)this.getLayout();
        Component component = buttonsLayoutManager.getButton(n);
        if (component != null) {
            this.remove(component);
        }
    }

    public void setActive(boolean bl) {
        if (this.isActive() != bl) {
            this._flags = BitField.toggle(this._flags, 1);
            this.adjustColors();
        }
    }

    public boolean isActive() {
        return BitField.isSet(this._flags, 1);
    }

    private void adjustColors() {
        boolean bl = this.isActive();
        this.setGradientStartColor(bl ? IdeUIManager.getActiveTitleGradientLightColor() : IdeUIManager.getInactiveTitleGradientLightColor());
        this.setBackground(bl ? IdeUIManager.getActiveTitleGradientDarkColor() : IdeUIManager.getInactiveTitleGradientDarkColor());
        this.setForeground(bl ? IdeUIManager.getActiveTitleForegroundColor() : IdeUIManager.getInactiveTitleForegroundColor());
        ButtonsLayoutManager buttonsLayoutManager = (ButtonsLayoutManager)this.getLayout();
        int n = buttonsLayoutManager.getButtonCount();
        while (n-- > 0) {
            Component component = buttonsLayoutManager.getButton(n);
            component.setForeground(bl ? IdeUIManager.getActiveTitleButtonColor() : IdeUIManager.getInactiveTitleButtonColor());
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }

    private int getRotation() {
        return this._nOrient == 0 ? 0 : -1;
    }

    public void setTruncateTitle(boolean bl) {
        if (this.isTruncateTitle() != bl) {
            this._flags = BitField.toggle(this._flags, 2);
            if (this.isShowing()) {
                this.invalidateUI();
            }
        }
    }

    private void invalidateUI() {
        this.setPreferredSize(null);
        this.clearCachedInfo();
        this.repaint();
    }

    private boolean isTruncateTitle() {
        return BitField.isSet(this._flags, 2);
    }

    private ButtonsLayoutManager getButtonLayout() {
        return (ButtonsLayoutManager)this.getLayout();
    }

    public int getOrientation() {
        return this._nOrient;
    }

    public void setOrientation(int n) {
        this.getButtonLayout().setOrientation(n);
        this._nOrient = n;
        this.setGradientDirection(n == 0 ? 5 : 3);
        this.setPreferredSize(null);
        this.revalidate();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        ButtonsLayoutManager buttonsLayoutManager = this.getButtonLayout();
        Rectangle rectangle = buttonsLayoutManager.getSpaceLeft();
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = rectangle.width - (insets.left + insets.right);
        int n4 = rectangle.height - (insets.top + insets.bottom);
        this.paint(graphics2D, n, n2, n3, n4, dimension.width, dimension.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.adaptButtonsBasedOnSize();
    }

    private void adaptButtonsBasedOnSize() {
        boolean bl;
        if (this.getOrientation() == 1) {
            bl = this.getHeight() > 50;
        } else {
            boolean bl2 = bl = this.getWidth() > 50;
        }
        if (this.isButtonsVisible() != bl) {
            this.setButtonsVisible(bl);
            ButtonsLayoutManager buttonsLayoutManager = (ButtonsLayoutManager)this.getLayout();
            int n = buttonsLayoutManager.getButtonCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = buttonsLayoutManager.getButton(n2);
                component.setVisible(bl);
                ++n2;
            }
        }
    }

    public boolean isFocusable() {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        if (this.isPreferredSizeSet()) {
            dimension = super.getPreferredSize();
        } else {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            if (graphics2D != null) {
                dimension = this.getPreferredSize(graphics2D);
                this.setPreferredSize(dimension);
            } else {
                dimension = this.getMinimumSize();
            }
        }
        return dimension;
    }

    private void clearCachedInfo() {
        this._rectTitle = null;
    }

    public Dimension getMinimumSize() {
        return MINIMUM_SIZE;
    }

    private Dimension getPreferredSize(Graphics2D graphics2D) {
        Rectangle2D rectangle2D = this.getTitleRect(graphics2D);
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        Icon icon = this.getIcon();
        int n = icon == null ? 0 : icon.getIconWidth();
        int n2 = icon == null ? 0 : icon.getIconHeight();
        int n3 = 0;
        int n4 = this.getComponentCount();
        while (n4-- > 0) {
            Component component = this.getComponent(n4);
            n3 = Math.max(n3, component.getMinimumSize().height);
        }
        double d3 = (double)(3 + n) + d + 3.0;
        double d4 = 1.0 + Math.max((double)n2, Math.max(d2, (double)n3)) + 1.0;
        if (this.getRotation() != 0) {
            double d5 = d3;
            d3 = d4;
            d4 = d5;
        }
        Insets insets = this.getInsets();
        double d6 = (double)insets.left + d3 + (double)insets.right;
        double d7 = (double)insets.top + d4 + (double)insets.bottom;
        Dimension dimension = new Dimension((int)d6, (int)d7);
        return dimension;
    }

    private void paint(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(n, n2);
        if (this.adaptTransform(graphics2D, n6)) {
            int n7 = n3;
            n3 = n4;
            n4 = n7;
        }
        this.paintTitle(graphics2D, n3, n4);
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
    }

    private Rectangle2D getTitleRect(Graphics2D graphics2D) {
        if (this._rectTitle == null) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            this._rectTitle = this.getFont().getStringBounds(this.getTitle(), fontRenderContext);
        }
        return this._rectTitle;
    }

    private void paintTitle(Graphics2D graphics2D, int n, int n2) {
        int n3;
        int n4 = 3;
        Icon icon = this.getIcon();
        int n5 = n3 = icon == null ? 0 : icon.getIconWidth() + 1;
        if (icon != null && n4 + n3 < n) {
            int n6 = (n2 - 1 - 1 - icon.getIconHeight()) / 2 + 1;
            icon.paintIcon((Component)((Object)this), graphics2D, n4, n6);
            n4 += n3;
        }
        Rectangle2D rectangle2D = this.getTitleRect(graphics2D);
        float f = (float)(((double)(n2 - 1 - 1) - rectangle2D.getHeight()) / 2.0 - rectangle2D.getY()) + 1.0f;
        Color color = this.getForeground();
        Font font = this.getFont();
        graphics2D.setColor(color);
        graphics2D.setFont(font);
        String string = this.getTitle();
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(n4, 0, n - n4 - 3, n2);
        SwingUtils.drawString((Graphics2D)graphics2D, (String)string, (float)n4, (float)f);
        graphics2D.setClip(shape);
        this.setToolTipText(string);
    }

    private boolean adaptTransform(Graphics2D graphics2D, int n) {
        boolean bl = false;
        int n2 = this.getRotation();
        if (n2 != 0) {
            graphics2D.rotate((double)n2 * Math.PI / 2.0, 0.0, 0.0);
            graphics2D.translate(-n, 0);
            bl = true;
        }
        return bl;
    }
}

