/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.shutter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.Ide;
import oracle.ide.controls.GlobalMouseDispatcher;
import oracle.ideimpl.TitledContainer;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterMargin;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.docking.shutter.ShutterTab;

final class MouseActivationController {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_RAISED = 1;
    private static final int STATE_RAISE_PENDING = 2;
    private static final int STATE_RERAISE_PENDING = 3;
    private static final int STATE_HIDE_PENDING = 4;
    private static final int DEFAULT_RAISE_DELAY_MSEC = 400;
    private static final int DEFAULT_RERAISE_DELAY_MSEC = 125;
    private static final int DEFAULT_HIDE_DELAY_MSEC = 400;
    private static final int DEFAULT_HIDE_TOGGLE_DELAY_MSEC = 500;
    private final EventListener _eventListener;
    private int _state;
    private Timer _timer;
    private ShutterTab _shutterTab;
    private DockableHolder _holder;
    private long _autoRaiseTime;
    private transient boolean _listening;

    void $init$() {
        this._eventListener = new EventListener(null);
    }

    MouseActivationController() {
        this.$init$();
    }

    void mouseEntered(ShutterTab shutterTab, DockableHolder dockableHolder) {
        switch (this.getState()) {
            case 0: {
                this._shutterTab = shutterTab;
                this._holder = dockableHolder;
                this.startRaiseTimer();
                break;
            }
            case 1: {
                if (this._shutterTab == shutterTab && this._holder == dockableHolder) break;
                this._shutterTab = shutterTab;
                this._holder = dockableHolder;
                this.startReraiseTimer();
                break;
            }
            default: {
                this.assertUnexpectedState();
            }
        }
    }

    void mouseMoved(ShutterTab shutterTab, DockableHolder dockableHolder) {
        switch (this.getState()) {
            case 2: {
                this.stopTimer();
                this._shutterTab = shutterTab;
                this._holder = dockableHolder;
                this.startRaiseTimer();
                break;
            }
            case 3: {
                this.stopTimer();
                this._shutterTab = shutterTab;
                this._holder = dockableHolder;
                this.startReraiseTimer();
                break;
            }
            case 4: {
                this.stopTimer();
                this.setState(1);
                this.mouseEntered(shutterTab, dockableHolder);
                break;
            }
            default: {
                this.mouseEntered(shutterTab, dockableHolder);
            }
        }
    }

    void mouseExited(ShutterTab shutterTab) {
        switch (this.getState()) {
            case 3: {
                this.stopTimer();
                this.setState(1);
                break;
            }
            case 2: {
                this.stopTimer();
                this._shutterTab = null;
                this._holder = null;
                this.setState(0);
                break;
            }
        }
    }

    void mousePressed(ShutterTab shutterTab, DockableHolder dockableHolder) {
        int n = 4;
        switch (this.getState()) {
            case 0: {
                this._shutterTab = shutterTab;
                this._holder = dockableHolder;
                this._shutterTab.raisePanel(this._holder, 4);
                this.setState(1);
                this.addGlobalMouseListener();
                break;
            }
            case 2: {
                this.stopTimer();
                this.addGlobalMouseListener();
                this._shutterTab = shutterTab;
                this._holder = dockableHolder;
                this._shutterTab.raisePanel(this._holder, 4);
                this.setState(1);
                break;
            }
            case 3: 
            case 4: {
                this.stopTimer();
                this._shutterTab = shutterTab;
                this._holder = dockableHolder;
                this._shutterTab.raisePanel(this._holder, 4);
                this.setState(1);
                break;
            }
            case 1: {
                ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
                boolean bl = shutterPanel.isClientAccessible(dockableHolder);
                if (!bl || !this._shutterTab.isSelected()) {
                    this._shutterTab = shutterTab;
                    this._holder = dockableHolder;
                    this._shutterTab.raisePanel(this._holder, 4);
                    break;
                }
                if (System.currentTimeMillis() - this._autoRaiseTime <= (long)MouseActivationController.getHideToggleDelay()) break;
                this.removeGlobalMouseListener();
                this._shutterTab.retractPanel(4);
                this._shutterTab = null;
                this._holder = null;
                this.setState(0);
                break;
            }
        }
    }

    void dragEnter(ShutterTab shutterTab, DockableHolder dockableHolder) {
        switch (this.getState()) {
            case 0: {
                this._shutterTab = shutterTab;
                this._holder = dockableHolder;
                this._shutterTab.raisePanel(this._holder, 0);
                this.setState(1);
                break;
            }
            case 1: {
                if (this._shutterTab == shutterTab && this._holder == dockableHolder) break;
                this._shutterTab = shutterTab;
                this._holder = dockableHolder;
                this._shutterTab.raisePanel(this._holder, 0);
                break;
            }
            default: {
                this.assertUnexpectedState();
            }
        }
    }

    void dragOver(ShutterTab shutterTab, DockableHolder dockableHolder) {
        if (this._shutterTab != shutterTab || this._holder != dockableHolder) {
            this.dragEnter(shutterTab, dockableHolder);
        }
    }

    private int getState() {
        return this._state;
    }

    private void setState(int n) {
        this._state = n;
        this._autoRaiseTime = 0L;
    }

    private void startRaiseTimer() {
        this.setState(2);
        this.startTimer(MouseActivationController.getRaiseDelay());
    }

    private void startReraiseTimer() {
        this.setState(3);
        this.startTimer(MouseActivationController.getReraiseDelay());
    }

    private void startHideTimer() {
        this.setState(4);
        this.startTimer(MouseActivationController.getHideDelay());
    }

    private void startTimer(int n) {
        this._timer = new Timer(n, this._eventListener);
        this._timer.setRepeats(false);
        this._timer.start();
    }

    private void stopTimer() {
        this._timer.stop();
        this._timer = null;
    }

    private void addGlobalMouseListener() {
        GlobalMouseDispatcher globalMouseDispatcher = GlobalMouseDispatcher.getInstance();
        globalMouseDispatcher.addMouseListener(this._eventListener);
        this._listening = true;
    }

    private void removeGlobalMouseListener() {
        GlobalMouseDispatcher globalMouseDispatcher = GlobalMouseDispatcher.getInstance();
        globalMouseDispatcher.removeMouseListener(this._eventListener);
        this._listening = false;
    }

    private void assertUnexpectedState() {
    }

    private static boolean isOverTooltip(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        Window window = SwingUtilities.getWindowAncestor(component);
        return window != null ? MouseActivationController.containsTooltip(window) : false;
    }

    private static boolean containsTooltip(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            if (component instanceof Container) {
                Container container2 = (Container)component;
                if (container2 instanceof JToolTip) {
                    return true;
                }
                if (MouseActivationController.containsTooltip(container2)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean isOverFloatingComponent(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        while (component != null) {
            if (component instanceof ShutterPanel || component instanceof ShutterTab || component instanceof ShutterMargin) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    private static boolean isShutterPanelChild(Component component) {
        return SwingUtilities.getAncestorOfClass(ShutterPanel.class, component) != null;
    }

    private static boolean isInEditorOrDockable(Component component) {
        return SwingUtilities.getAncestorOfClass(TitledContainer.class, component) != null;
    }

    private static int getRaiseDelay() {
        return MouseActivationController.getIntProperty("Docking.raiseShutterDelay", 400);
    }

    private static int getReraiseDelay() {
        return MouseActivationController.getIntProperty("Docking.reraiseShutterDelay", 125);
    }

    private static int getHideDelay() {
        return MouseActivationController.getIntProperty("Docking.hideShutterDelay", 400);
    }

    private static int getHideToggleDelay() {
        return MouseActivationController.getIntProperty("Docking.hideToggleDelay", 500);
    }

    private static int getIntProperty(String string, int n) {
        String string2 = Ide.getProperty(string);
        return string2 != null ? Integer.valueOf(string2) : n;
    }

    private static String getStateName(int n) {
        return n == 0 ? "STATE_NORMAL" : (n == 2 ? "STATE_RAISE_PENDING" : (n == 3 ? "STATE_RERAISE_PENDING" : (n == 1 ? "STATE_RAISED" : (n == 4 ? "STATE_HIDE_PENDING" : "???"))));
    }

    static int mav$getState(MouseActivationController mouseActivationController) {
        return mouseActivationController.getState();
    }

    static ShutterTab ra$_shutterTab(MouseActivationController mouseActivationController) {
        return mouseActivationController._shutterTab;
    }

    static void mav$stopTimer(MouseActivationController mouseActivationController) {
        mouseActivationController.stopTimer();
    }

    static void mav$startHideTimer(MouseActivationController mouseActivationController) {
        mouseActivationController.startHideTimer();
    }

    static void mav$assertUnexpectedState(MouseActivationController mouseActivationController) {
        mouseActivationController.assertUnexpectedState();
    }

    static boolean maS$isOverTooltip(MouseEvent mouseEvent) {
        return MouseActivationController.isOverTooltip(mouseEvent);
    }

    static boolean maS$isOverFloatingComponent(MouseEvent mouseEvent) {
        return MouseActivationController.isOverFloatingComponent(mouseEvent);
    }

    static void mav$setState(MouseActivationController mouseActivationController, int n) {
        mouseActivationController.setState(n);
    }

    static boolean maS$isShutterPanelChild(Component component) {
        return MouseActivationController.isShutterPanelChild(component);
    }

    static boolean maS$isInEditorOrDockable(Component component) {
        return MouseActivationController.isInEditorOrDockable(component);
    }

    static void mav$removeGlobalMouseListener(MouseActivationController mouseActivationController) {
        mouseActivationController.removeGlobalMouseListener();
    }

    static void wa$_shutterTab(MouseActivationController mouseActivationController, ShutterTab shutterTab) {
        mouseActivationController._shutterTab = shutterTab;
    }

    static void wa$_holder(MouseActivationController mouseActivationController, DockableHolder dockableHolder) {
        mouseActivationController._holder = dockableHolder;
    }

    static DockableHolder ra$_holder(MouseActivationController mouseActivationController) {
        return mouseActivationController._holder;
    }

    static void wa$_autoRaiseTime(MouseActivationController mouseActivationController, long l) {
        mouseActivationController._autoRaiseTime = l;
    }

    static void mav$addGlobalMouseListener(MouseActivationController mouseActivationController) {
        mouseActivationController.addGlobalMouseListener();
    }

    private final class EventListener
    implements MouseListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            switch (MouseActivationController.mav$getState(MouseActivationController.this)) {
                case 2: {
                    MouseActivationController.mav$stopTimer(MouseActivationController.this);
                    MouseActivationController.ra$_shutterTab(MouseActivationController.this).raisePanel(MouseActivationController.ra$_holder(MouseActivationController.this), 0);
                    MouseActivationController.mav$setState(MouseActivationController.this, 1);
                    MouseActivationController.wa$_autoRaiseTime(MouseActivationController.this, System.currentTimeMillis());
                    MouseActivationController.mav$addGlobalMouseListener(MouseActivationController.this);
                    break;
                }
                case 3: {
                    boolean bl = MouseActivationController.ra$_shutterTab(MouseActivationController.this).isSelected();
                    MouseActivationController.mav$stopTimer(MouseActivationController.this);
                    MouseActivationController.ra$_shutterTab(MouseActivationController.this).raisePanel(MouseActivationController.ra$_holder(MouseActivationController.this), 0);
                    MouseActivationController.ra$_shutterTab(MouseActivationController.this).setSelected(bl);
                    MouseActivationController.mav$setState(MouseActivationController.this, 1);
                    MouseActivationController.wa$_autoRaiseTime(MouseActivationController.this, System.currentTimeMillis());
                    break;
                }
                case 4: {
                    MouseActivationController.mav$stopTimer(MouseActivationController.this);
                    MouseActivationController.mav$removeGlobalMouseListener(MouseActivationController.this);
                    MouseActivationController.ra$_shutterTab(MouseActivationController.this).retractPanel(0);
                    MouseActivationController.wa$_shutterTab(MouseActivationController.this, null);
                    MouseActivationController.wa$_holder(MouseActivationController.this, null);
                    MouseActivationController.mav$setState(MouseActivationController.this, 0);
                    break;
                }
                default: {
                    MouseActivationController.mav$assertUnexpectedState(MouseActivationController.this);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            int n = 4;
            switch (MouseActivationController.mav$getState(MouseActivationController.this)) {
                case 1: {
                    if (MouseActivationController.maS$isShutterPanelChild(component)) {
                        MouseActivationController.ra$_shutterTab(MouseActivationController.this).setSelected(true);
                        break;
                    }
                    if (component == MouseActivationController.ra$_shutterTab(MouseActivationController.this) || !MouseActivationController.maS$isInEditorOrDockable(component)) break;
                    MouseActivationController.mav$removeGlobalMouseListener(MouseActivationController.this);
                    MouseActivationController.ra$_shutterTab(MouseActivationController.this).retractPanel(4);
                    MouseActivationController.wa$_shutterTab(MouseActivationController.this, null);
                    MouseActivationController.wa$_holder(MouseActivationController.this, null);
                    MouseActivationController.mav$setState(MouseActivationController.this, 0);
                    break;
                }
                case 3: 
                case 4: {
                    if (MouseActivationController.maS$isShutterPanelChild(component)) {
                        MouseActivationController.mav$stopTimer(MouseActivationController.this);
                        MouseActivationController.ra$_shutterTab(MouseActivationController.this).setSelected(true);
                        MouseActivationController.mav$setState(MouseActivationController.this, 1);
                        break;
                    }
                    if (component == MouseActivationController.ra$_shutterTab(MouseActivationController.this)) break;
                    MouseActivationController.mav$stopTimer(MouseActivationController.this);
                    MouseActivationController.mav$removeGlobalMouseListener(MouseActivationController.this);
                    MouseActivationController.ra$_shutterTab(MouseActivationController.this).retractPanel(4);
                    MouseActivationController.wa$_shutterTab(MouseActivationController.this, null);
                    MouseActivationController.wa$_holder(MouseActivationController.this, null);
                    MouseActivationController.mav$setState(MouseActivationController.this, 0);
                    break;
                }
                default: {
                    MouseActivationController.mav$assertUnexpectedState(MouseActivationController.this);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            switch (MouseActivationController.mav$getState(MouseActivationController.this)) {
                case 4: {
                    if (!MouseActivationController.maS$isOverTooltip(mouseEvent) && !MouseActivationController.maS$isOverFloatingComponent(mouseEvent)) break;
                    MouseActivationController.mav$stopTimer(MouseActivationController.this);
                    MouseActivationController.mav$setState(MouseActivationController.this, 1);
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                default: {
                    MouseActivationController.mav$assertUnexpectedState(MouseActivationController.this);
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            switch (MouseActivationController.mav$getState(MouseActivationController.this)) {
                case 3: {
                    if (MouseActivationController.ra$_shutterTab(MouseActivationController.this) == null || MouseActivationController.ra$_shutterTab(MouseActivationController.this).isSelected()) break;
                    MouseActivationController.mav$stopTimer(MouseActivationController.this);
                    MouseActivationController.mav$startHideTimer(MouseActivationController.this);
                    break;
                }
                case 1: {
                    if (MouseActivationController.ra$_shutterTab(MouseActivationController.this) == null || MouseActivationController.ra$_shutterTab(MouseActivationController.this).isSelected()) break;
                    MouseActivationController.mav$startHideTimer(MouseActivationController.this);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    MouseActivationController.mav$assertUnexpectedState(MouseActivationController.this);
                }
            }
        }

        private EventListener() {
        }

        EventListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

