/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.shutter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableListener;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.docking.shutter.ShutterTab;

public final class ShutterMargin
extends JPanel
implements DockableListener,
LayoutManager2 {
    private static final int GAP = 4;
    private String _orientation;

    ShutterMargin(String string) {
        this._orientation = string;
        Border border = BorderFactory.createEmptyBorder(this._orientation == "South" ? 1 : 0, this._orientation == "East" ? 1 : 0, this._orientation == "North" ? 1 : 0, this._orientation == "West" ? 1 : 0);
        this.setBorder(border);
        this.setLayout(this);
        this.setOpaque(false);
        DockStationImpl.getInstance().addDockableListener(this, null);
    }

    public boolean hasShutter(TitledPanel titledPanel) {
        return this.getShutter(titledPanel) != null;
    }

    public boolean addShutter(TitledPanel titledPanel, boolean bl) {
        if (titledPanel.getVisibleCount() <= 0) {
            return false;
        }
        ShutterTab shutterTab = this.getShutter(titledPanel);
        if (shutterTab == null) {
            shutterTab = new ShutterTab(titledPanel);
            this.add((Component)shutterTab, this.getInsertionPoint(titledPanel));
            if (bl) {
                ShutterMargin.showMove(titledPanel, shutterTab);
            }
        }
        this.refreshShutter(titledPanel);
        return true;
    }

    public void removeShutter(TitledPanel titledPanel) {
        int n = this.getShutterPos(titledPanel);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public void refreshShutter(TitledPanel titledPanel) {
        ShutterTab shutterTab = this.getShutter(titledPanel);
        if (shutterTab != null) {
            shutterTab.refresh();
        }
    }

    String getOrientation() {
        return this._orientation;
    }

    private ShutterTab getShutter(TitledPanel titledPanel) {
        int n = this.getShutterPos(titledPanel);
        return n >= 0 ? this.getShutter(n) : null;
    }

    private ShutterTab getShutter(Dockable dockable) {
        int n = this.getShutterPos(dockable);
        return n >= 0 ? this.getShutter(n) : null;
    }

    private ShutterTab getShutter(int n) {
        return (ShutterTab)this.getComponent(n);
    }

    private int getShutterPos(TitledPanel titledPanel) {
        int n = this.getShutterCount();
        int n2 = 0;
        while (n2 < n) {
            ShutterTab shutterTab = this.getShutter(n2);
            if (shutterTab.getTitledPanel() == titledPanel) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int getShutterPos(Dockable dockable) {
        int n = this.getShutterCount();
        int n2 = 0;
        while (n2 < n) {
            ShutterTab shutterTab = this.getShutter(n2);
            if (shutterTab.isClient(dockable)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private int getShutterCount() {
        return this.getComponentCount();
    }

    /*
     * Unable to fully structure code
     */
    private int getInsertionPoint(TitledPanel var1_1) {
        var2_2 = this.getDockPanel().getAllTitledPanels();
        var3_3 = var2_2.length;
        var4_4 = this.getShutterCount();
        var5_5 = 0;
        var6_6 = 0;
        while (var6_6 < var4_4) {
            block3: {
                var7_7 = this.getShutter(var6_6);
                if (!(var7_7 instanceof ShutterTab)) break block3;
                var8_8 = var7_7;
                var9_9 = var8_8.getTitledPanel();
                if (var1_1 != var9_9) ** GOTO lbl18
                return -1;
lbl-1000:
                // 1 sources

                {
                    var10_10 = var2_2[var5_5];
                    if (var10_10 == var1_1) {
                        return var6_6;
                    }
                    if (var10_10 == var9_9) break;
                    ++var5_5;
lbl18:
                    // 2 sources

                    ** while (var5_5 < var3_3)
                }
            }
            ++var6_6;
        }
        return var6_6;
    }

    private DockPanel getDockPanel() {
        DividerControlledPanel dividerControlledPanel = (DividerControlledPanel)this.getParent();
        return dividerControlledPanel.getDockPanel();
    }

    private static void showMove(JComponent jComponent, JComponent jComponent2) {
        Graphics2D graphics2D;
        int n = 5;
        Component component = jComponent.getRootPane().getGlassPane();
        if (component != null && (graphics2D = (Graphics2D)component.getGraphics()) != null) {
            Rectangle rectangle = jComponent.getBounds();
            Rectangle rectangle2 = jComponent2.getBounds();
            Rectangle rectangle3 = SwingUtilities.convertRectangle(jComponent.getParent(), rectangle, component);
            Rectangle rectangle4 = SwingUtilities.convertRectangle(jComponent2.getParent(), rectangle2, component);
            graphics2D.setXORMode(Color.GRAY);
            int n2 = rectangle4.x - rectangle3.x;
            int n3 = rectangle4.y - rectangle3.y;
            int n4 = rectangle4.width - rectangle3.width;
            int n5 = rectangle4.height - rectangle3.height;
            Rectangle rectangle5 = new Rectangle(0, 0, 0, 0);
            int n6 = 1;
            while (n6 <= 5) {
                graphics2D.drawRect(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
                rectangle5.x = rectangle3.x + n2 * n6 / 5;
                rectangle5.y = rectangle3.y + n3 * n6 / 5;
                rectangle5.width = rectangle3.width + n4 * n6 / 5;
                rectangle5.height = rectangle3.height + n5 * n6 / 5;
                graphics2D.drawRect(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
                try {
                    Thread.sleep(7 + n6 * 7);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n6;
            }
            graphics2D.drawRect(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
        }
    }

    public void dockableHidden(DockableEvent dockableEvent) {
        this.dockableShown(dockableEvent, false);
    }

    public void dockableShown(DockableEvent dockableEvent) {
        this.dockableShown(dockableEvent, true);
    }

    private void dockableShown(DockableEvent dockableEvent, boolean bl) {
        Dockable dockable = dockableEvent.getSource();
        ShutterTab shutterTab = this.getShutter(dockable);
        if (shutterTab != null) {
            shutterTab.getModel().setSelected(bl);
        }
    }

    public void raiseFloatPanel(DockableHolder dockableHolder, int n) {
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        if (!shutterPanel.isClientAccessible(dockableHolder)) {
            ShutterTab shutterTab = this.getShutter(dockableHolder.getDockable());
            if (shutterTab != null) {
                shutterTab.setSelectedHolder(dockableHolder);
            }
            DockStationImpl dockStationImpl = DockStationImpl.getInstance();
            DockPanel dockPanel = this.getDockPanel();
            int n2 = dockStationImpl.getPanelOrientation(dockPanel);
            shutterPanel.showPanel(dockableHolder, n2, n);
        }
    }

    public void addLayoutComponent(String string, Component component) {
        throw new UnsupportedOperationException();
    }

    public void layoutContainer(Container container) {
        int n = this.getComponentCount();
        if (n != 0) {
            Insets insets = this.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            int n4 = this.getWidth() - n2;
            int n5 = this.getHeight() - n3;
            if (this._orientation == "West" || this._orientation == "East") {
                int n6 = insets.top;
                int n7 = 0;
                while (n7 < n) {
                    Component component = this.getComponent(n7);
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(insets.left, n6, n4, dimension.height);
                    n6 += dimension.height + 4;
                    ++n7;
                }
            } else {
                int n8 = insets.left;
                int n9 = 0;
                while (n9 < n) {
                    Component component = this.getComponent(n9);
                    Dimension dimension = component.getPreferredSize();
                    component.setBounds(n8, insets.top, dimension.width, n5);
                    n8 += dimension.width + 4;
                    ++n9;
                }
            }
        }
        this.repaint();
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        if (this.getComponentCount() != 0) {
            Dimension dimension2 = new Dimension(this.getComponent(0).getPreferredSize());
            if (this._orientation == "West" || this._orientation == "East") {
                dimension2.height = 0;
            } else {
                dimension2.width = 0;
            }
            dimension = dimension2;
            Insets insets = this.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
        } else {
            dimension = new Dimension(0, 0);
        }
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

