/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.shutter;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controls.DragComponentEvent;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ideimpl.controls.OneLineBorder;
import oracle.ideimpl.controls.dockLayout.DockLayoutUtil;
import oracle.ideimpl.docking.AbstractTitledPanel;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.controls.Divider;
import oracle.ideimpl.docking.controls.DividerEvent;
import oracle.ideimpl.docking.controls.DividerListener;
import oracle.ideimpl.docking.shutter.ShutterMargin;
import oracle.ideimpl.docking.shutter.ShutterPanelDragListener;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.window.WindowingConstants;

public final class ShutterPanel
extends AbstractTitledPanel
implements TitleChangeListener,
DividerListener,
ComponentListener {
    private static final boolean SHUTTER_PANEL_ANIMATION = Boolean.getBoolean("jdev.docking.shutter_animation");
    private static final int MIN_SIZE = 30;
    private View _lastActiveView;
    private DockableHolder _holder;
    private Divider _divider;
    private OneLineBorder _dividerBorder;
    private ShutterPanelDragListener _tabDragListener;
    private boolean _allowDetachPanel;
    private DesktopBackgroundMouseListener _desktopBackgroundMouseListener;
    private int[] _sizes;
    private int _orientation;
    private static final String TITLED_PANEL_CARD = "titledPanel";
    private static final String CAPTURE_PANEL_CARD = "capturePanel";
    private final CardLayout _cardLayout;
    private final JPanel _titledPanel;
    private final CapturePanel _capturePanel;

    void $init$() {
        this._allowDetachPanel = true;
        this._sizes = new int[]{180, 180, 180, 180};
        this._orientation = -1;
        this._cardLayout = new CardLayout();
        this._titledPanel = new JPanel(new BorderLayout());
        this._capturePanel = new CapturePanel();
    }

    ShutterPanel() {
        this.$init$();
        this.init();
    }

    protected DockableHolder getSelectedHolder() {
        return this.getHolder();
    }

    void setFloatingSize(int n, int n2) {
        this._sizes[n] = n2;
    }

    int getFloatingSize(int n) {
        return this._sizes[n];
    }

    int getFloatingSize() {
        return this.getFloatingSize(this.getOrientation());
    }

    int getOrientation() {
        return this._orientation;
    }

    private Dockable getDockable() {
        return this.getHolder().getDockable();
    }

    private void init() {
        this.setBorder(WindowingConstants.FLAT_COMPOUND_BORDER);
        this.setLayout(this._cardLayout);
        this.add((Component)this._titledPanel, TITLED_PANEL_CARD);
        this.add((Component)this._capturePanel, CAPTURE_PANEL_CARD);
        this.setVisible(false);
        this.createTitle();
        this.createUIMap();
        this._dividerBorder = new OneLineBorder(4, IdeConstants.COLOR_IDE_LINES);
        this._divider = new Divider(0, 4);
        this._divider.setOpaque(false);
        this._divider.setBorder(this._dividerBorder);
        this._divider.addDividerListener(this);
        this._titledPanel.add((Component)this._divider, "East");
        this.setFocusCycleRoot(true);
    }

    protected void createTitle() {
        super.createTitle();
        this.setActive(true);
    }

    public void setVisible(boolean bl) {
        if (this.isVisible() != bl) {
            super.setVisible(bl);
            Container container = this.getParent();
            if (container != null) {
                EditorManagerImpl editorManagerImpl = (EditorManagerImpl)EditorManager.getEditorManager();
                JComponent jComponent = editorManagerImpl.getDesktopBackground();
                if (bl) {
                    this._desktopBackgroundMouseListener = new DesktopBackgroundMouseListener();
                    jComponent.addMouseListener(this._desktopBackgroundMouseListener);
                } else {
                    jComponent.removeMouseListener(this._desktopBackgroundMouseListener);
                    this._desktopBackgroundMouseListener = null;
                }
            }
        }
    }

    private void whenDesktopBackgroundMouseClicked() {
        this.detachPanel();
        IdeUtil.tryToRestoreFocus(null);
    }

    void showPanel(DockableHolder dockableHolder, int n, int n2) {
        boolean bl;
        DockableHolder dockableHolder2 = this.getHolder();
        boolean bl2 = dockableHolder2 != null;
        boolean bl3 = bl = n == this._orientation;
        if (bl2) {
            this.listenFocus(false);
            this._titledPanel.remove(dockableHolder2.getComponent());
            DockStationImpl dockStationImpl = DockStationImpl.getInstance();
            DockableEvent dockableEvent = new DockableEvent(this.getDockable(), 1, n2);
            dockStationImpl.fireDockableEvent(dockableEvent);
        } else {
            this._lastActiveView = Ide.getMainWindow().getLastActiveView();
        }
        this.setOrientation(n);
        this.setHolder(dockableHolder);
        ShutterMargin shutterMargin = ShutterPanel.getShutterMargin(n);
        shutterMargin.addComponentListener(this);
        Dockable dockable = this.getDockable();
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        DockableEvent dockableEvent = new DockableEvent(dockable, 0, n2);
        dockStationImpl.fireDockableEvent(dockableEvent);
        JComponent jComponent = dockableHolder.getOrCreateComponent();
        this._titledPanel.add((Component)jComponent, "Center");
        this.adjustTitle(dockable);
        this.adjustButtons(dockable);
        if (SHUTTER_PANEL_ANIMATION) {
            PanelAnimator.raisePanel(this);
        } else {
            this.adaptSize();
            this.setVisible(true);
        }
        SwingUtilities.invokeLater(new 1(this, jComponent));
        if (bl2 && bl) {
            jComponent.repaint();
        }
        this.listenFocus(true);
    }

    private DockableHolder getHolder() {
        return this._holder;
    }

    private void setHolder(DockableHolder dockableHolder) {
        if (this.getHolder() != null) {
            Dockable dockable = this.getHolder().getDockable();
            dockable.removeTitleChangeListener(this);
        }
        this._holder = dockableHolder;
        if (this.getHolder() != null) {
            Dockable dockable = this.getHolder().getDockable();
            dockable.addTitleChangeListener(this);
        }
    }

    private void listenFocus(boolean bl) {
        this._allowDetachPanel = bl;
    }

    void hidePanel(int n) {
        DockableHolder dockableHolder = this.getHolder();
        if (dockableHolder != null) {
            Dockable dockable = dockableHolder.getDockable();
            this.detachDockable(n);
            this.getParent().validate();
            DockStationImpl dockStationImpl = DockStationImpl.getInstance();
            dockStationImpl.fireDockableEvent(new DockableEvent(dockable, 1, n));
        }
    }

    private void detachDockable(int n) {
        this.listenFocus(false);
        if (SHUTTER_PANEL_ANIMATION && n == 0) {
            PanelAnimator.hidePanel(this);
        } else {
            this.setVisible(false);
            if (SHUTTER_PANEL_ANIMATION) {
                PanelAnimator.cancel();
            }
        }
        JComponent jComponent = this.getHolder().getComponent();
        if (jComponent != null) {
            this._titledPanel.remove(jComponent);
        }
        this.setHolder(null);
        ShutterMargin shutterMargin = ShutterPanel.getShutterMargin(this._orientation);
        shutterMargin.removeComponentListener(this);
        if (this._lastActiveView != null) {
            GraphicsUtils.focusComponentOrChild(this._lastActiveView.getGUI(), true);
            this._lastActiveView = null;
        }
    }

    private static ShutterMargin getShutterMargin(int n) {
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        DividerControlledPanel dividerControlledPanel = dockStationImpl.getDividerControlledPanel(n);
        ShutterMargin shutterMargin = dividerControlledPanel.getShutterMargin();
        return shutterMargin;
    }

    private void setOrientation(int n) {
        if (this._orientation != n) {
            int n2;
            String string;
            int n3;
            String string2;
            int n4;
            this._orientation = n;
            switch (n) {
                case 0: {
                    n4 = 0;
                    string2 = "North";
                    n3 = 1;
                    string = "East";
                    n2 = 4;
                    break;
                }
                case 1: {
                    n4 = 0;
                    string2 = "North";
                    n3 = 1;
                    string = "West";
                    n2 = 8;
                    break;
                }
                case 2: {
                    n4 = 1;
                    string2 = "West";
                    n3 = 0;
                    string = "South";
                    n2 = 1;
                    break;
                }
                default: {
                    n4 = 1;
                    string2 = "West";
                    n3 = 0;
                    string = "North";
                    n2 = 2;
                }
            }
            this._titledPanel.add((Component)((Object)this._handlebar), string2);
            this._handlebar.setOrientation(n4);
            OneLineBorder oneLineBorder = (OneLineBorder)this._handlebar.getBorder();
            int n5 = n4 == 1 ? 8 : 2;
            oneLineBorder.setSides(n5);
            this._titledPanel.add((Component)this._divider, string);
            this._divider.setOrientation(n3);
            this._dividerBorder.setSides(n2);
        }
    }

    private void adaptSize() {
        int n = this._sizes[this._orientation];
        ShutterMargin shutterMargin = ShutterPanel.getShutterMargin(this._orientation);
        Rectangle rectangle = shutterMargin.getBounds();
        Rectangle rectangle2 = SwingUtilities.convertRectangle(shutterMargin.getParent(), rectangle, this.getParent());
        switch (this._orientation) {
            case 0: {
                this.setBounds(rectangle2.x + rectangle2.width, rectangle2.y, n, rectangle2.height);
                break;
            }
            case 1: {
                this.setBounds(rectangle2.x - n, rectangle2.y, n, rectangle2.height);
                break;
            }
            case 2: {
                this.setBounds(rectangle2.x, rectangle2.y + rectangle2.height, rectangle2.width, n);
                break;
            }
            case 3: {
                this.setBounds(rectangle2.x, rectangle2.y - n, rectangle2.width, n);
            }
        }
        this.validate();
    }

    protected boolean isMinimized() {
        return true;
    }

    protected boolean isMinimizable() {
        return true;
    }

    protected boolean isMaximized() {
        return false;
    }

    protected boolean isMaximizable() {
        return false;
    }

    protected boolean isFloating() {
        return false;
    }

    protected boolean canMove() {
        return false;
    }

    protected boolean canSize() {
        return false;
    }

    protected JPopupMenu getTitleContextMenu() {
        DockableHolder dockableHolder = this.getHolder();
        return this.createSystemMenu(dockableHolder);
    }

    protected void whenMinimize(int n) {
    }

    protected void whenMaximize(int n) {
    }

    protected void whenRestore(int n, DockableHolder dockableHolder) {
        DockablePath dockablePath;
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        if (dockStationImpl.getDockablePath(dockablePath = new DockablePath(), new DockableCriteria(dockableHolder))) {
            TitledPanel titledPanel = dockablePath.getTitledPanel();
            this._lastActiveView = null;
            this.hidePanel(n);
            titledPanel.restore(n);
        }
    }

    protected void whenSystemMenuClose(DockableHolder dockableHolder) {
        this.whenClose(20, dockableHolder);
    }

    protected void whenClose(int n) {
        this.whenClose(n, this.getHolder());
    }

    private void whenClose(int n, DockableHolder dockableHolder) {
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        dockStationImpl.addDockableEventContext(n);
        try {
            DockablePath dockablePath = new DockablePath();
            if (dockStationImpl.getDockablePath(dockablePath, new DockableCriteria(dockableHolder))) {
                this.hidePanel(0);
                TitledPanel titledPanel = dockablePath.getTitledPanel();
                titledPanel.closeClient(dockableHolder, n);
                dockableHolder.setComponent(null);
                IdeUtil.tryToRestoreFocus(null);
            }
        }
        finally {
            dockStationImpl.removeDockableEventContext(n);
        }
    }

    protected void titleMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showTitleContextMenu(mouseEvent);
        } else {
            AbstractTitledPanel._ptStart.setLocation(mouseEvent.getPoint());
        }
    }

    protected void titleMouseDragged(MouseEvent mouseEvent) {
        JComponent jComponent = this.getHolder().getComponent();
        if (!AbstractTitledPanel._bDraging && SwingUtilities.isLeftMouseButton(mouseEvent) && AbstractTitledPanel._ptStart.distanceSq(mouseEvent.getPoint()) >= (double)AbstractTitledPanel.DRAGSTART) {
            AbstractTitledPanel._bDraging = true;
            this.listenFocus(false);
            this._tabDragListener = new ShutterPanelDragListener(this.getHolder());
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, jComponent);
            this._tabDragListener.start(new DragComponentEvent(jComponent, point, 1, mouseEvent.getModifiers()));
        }
        if (AbstractTitledPanel._bDraging) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, jComponent);
            this._tabDragListener.move(new DragComponentEvent(jComponent, point, 2, mouseEvent.getModifiers()));
        }
    }

    protected void titleMouseReleased(MouseEvent mouseEvent) {
        if (AbstractTitledPanel._bDraging) {
            Point point = mouseEvent.getPoint();
            JComponent jComponent = this.getHolder().getComponent();
            SwingUtilities.convertPointToScreen(point, jComponent);
            this._tabDragListener.end(new DragComponentEvent(jComponent, point, 3, mouseEvent.getModifiers()));
            AbstractTitledPanel._bDraging = false;
            this._tabDragListener = null;
            if (this.getHolder() != null) {
                this.listenFocus(true);
            }
        } else if (mouseEvent.isPopupTrigger()) {
            this.showTitleContextMenu(mouseEvent);
        }
    }

    protected void systemMenuSizeDocked() {
    }

    protected void whenSystemMenuFloat(DockableHolder dockableHolder) {
        this.whenRestore(4, dockableHolder);
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        DockablePath dockablePath = new DockablePath();
        if (dockStationImpl.getDockablePath(dockablePath, new DockableCriteria(dockableHolder))) {
            TitledPanel titledPanel = dockablePath.getTitledPanel();
            dockStationImpl.floatPanel(titledPanel, new Point(10, 10));
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.adaptSize();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void containerActivated(boolean bl) {
        super.containerActivated(bl);
        if (!bl && this._allowDetachPanel) {
            this.detachPanel();
        }
    }

    private void detachPanel() {
        DockStationImpl dockStationImpl = DockStationImpl.getInstance();
        dockStationImpl.addDockableEventContext(4);
        try {
            this.hidePanel(4);
        }
        finally {
            dockStationImpl.removeDockableEventContext(4);
        }
    }

    public int getClientCount() {
        return this.getHolder() == null ? 0 : 1;
    }

    public Dockable getClient(int n) {
        return this.getHolder().getDockable();
    }

    public boolean isClientAccessible(Dockable dockable) {
        return this.getHolder() != null && this.getHolder().getDockable() == dockable;
    }

    public boolean isClientAccessible(DockableHolder dockableHolder) {
        return this.getHolder() != null && this.getHolder() == dockableHolder;
    }

    public void dividerMoved(DividerEvent dividerEvent) {
        int n;
        int n2 = 30;
        int n3 = dividerEvent.getDelta();
        Container container = this.getParent();
        if (DockLayoutUtil.isHorz(this._orientation)) {
            ShutterMargin shutterMargin = ShutterPanel.getShutterMargin(0);
            Rectangle rectangle = SwingUtilities.convertRectangle(shutterMargin.getParent(), shutterMargin.getBounds(), container);
            int n4 = rectangle.x + rectangle.width;
            ShutterMargin shutterMargin2 = ShutterPanel.getShutterMargin(1);
            Point point = SwingUtilities.convertPoint(shutterMargin2.getParent(), shutterMargin2.getLocation(), container);
            n = point.x - n4 - 30;
        } else {
            ShutterMargin shutterMargin = ShutterPanel.getShutterMargin(2);
            Rectangle rectangle = SwingUtilities.convertRectangle(shutterMargin.getParent(), shutterMargin.getBounds(), container);
            int n5 = rectangle.y + rectangle.height;
            ShutterMargin shutterMargin3 = ShutterPanel.getShutterMargin(3);
            Point point = SwingUtilities.convertPoint(shutterMargin3.getParent(), shutterMargin3.getLocation(), container);
            n = point.y - n5 - 30;
        }
        if (!DockLayoutUtil.isBefore(this._orientation)) {
            n3 = -n3;
        }
        this._sizes[this._orientation] = Math.min(Math.max(this._sizes[this._orientation] + n3, 30), n);
        this.adaptSize();
    }

    public void titleChange(TitleChangeEvent titleChangeEvent) {
        Dockable dockable = this.getHolder().getDockable();
        this.adjustTitle(dockable);
    }

    void capture() {
        this.setVisible(true);
        this.adaptSize();
        this._cardLayout.show(this, TITLED_PANEL_CARD);
        this._capturePanel.capture(this._titledPanel, this.getOrientation());
        this._cardLayout.show(this, CAPTURE_PANEL_CARD);
    }

    void uncapture() {
        this._cardLayout.show(this, TITLED_PANEL_CARD);
        this._capturePanel.uncapture();
    }

    int getCaptureOrientation() {
        return this._capturePanel.getOrientation();
    }

    void setActive(boolean bl) {
        this._handlebar.setActive(bl);
    }

    static void mav$whenDesktopBackgroundMouseClicked(ShutterPanel shutterPanel) {
        shutterPanel.whenDesktopBackgroundMouseClicked();
    }

    static void mav$adaptSize(ShutterPanel shutterPanel) {
        shutterPanel.adaptSize();
    }

    public class DesktopBackgroundMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            ShutterPanel.mav$whenDesktopBackgroundMouseClicked(ShutterPanel.this);
        }

        DesktopBackgroundMouseListener() {
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ JComponent v$component;
        final /* synthetic */ ShutterPanel this$0;

        public void run() {
            GraphicsUtils.focusComponentOrChild(this.v$component, true);
        }

        public 1(ShutterPanel shutterPanel, JComponent jComponent) {
            this.v$component = jComponent;
            this.this$0 = shutterPanel;
        }
    }

    private static final class PanelAnimator
    implements ActionListener {
        private static final PanelAnimator INSTANCE = new PanelAnimator();
        private static final int ANIMATE_DELAY_MSEC = 240;
        private static final int ANIMATE_RAISE_STEP_MSEC = 16;
        private static final int ANIMATE_RAISE_STEP_PIXELS = 6;
        private static final int ANIMATE_HIDE_STEP_MSEC = 16;
        private static final int ANIMATE_HIDE_STEP_PIXELS = 8;
        private static final Object RAISE_ACTION = "raise";
        private static final Object HIDE_ACTION = "hide";
        private Timer _timer;
        private long _curTime;
        private ShutterPanel _panel;
        private boolean _isRaising;

        private PanelAnimator() {
        }

        static void raisePanel(ShutterPanel shutterPanel) {
            INSTANCE.start(shutterPanel, RAISE_ACTION);
        }

        static void hidePanel(ShutterPanel shutterPanel) {
            INSTANCE.start(shutterPanel, HIDE_ACTION);
        }

        static void cancel() {
            INSTANCE.done();
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            int n = this._panel.getFloatingSize();
            long l = actionEvent.getWhen();
            long l2 = l - this._curTime;
            int n2 = this._isRaising ? 6 : 8;
            int n3 = (int)(l2 * (long)n2 / (long)this._timer.getDelay());
            this.adjustPanelSize(this._isRaising ? n3 : -n3);
            this._panel.validate();
            this._curTime = l;
            int n4 = this.getPanelSize();
            if (this._isRaising ? n4 >= n : n4 <= 0) {
                this._panel.setVisible(this._isRaising);
                this.done();
            }
        }

        private void start(ShutterPanel shutterPanel, Object object) {
            boolean bl;
            boolean bl2 = bl = object == RAISE_ACTION;
            if (this._timer != null) {
                if (!bl && !this._isRaising) {
                    return;
                }
                this._timer.stop();
                this._timer = null;
                int n = this.getPanelSize();
                int n2 = this._panel.getCaptureOrientation();
                this._panel = shutterPanel;
                this._panel.setActive(bl);
                this._panel.capture();
                if (this._panel.getOrientation() == n2) {
                    this.adjustPanelSize(-shutterPanel.getFloatingSize() + n);
                } else {
                    this.adjustPanelSize(bl ? -shutterPanel.getFloatingSize() : 0);
                }
            } else {
                if (bl && shutterPanel.isVisible() && shutterPanel.getOrientation() == shutterPanel.getCaptureOrientation()) {
                    ShutterPanel.mav$adaptSize(shutterPanel);
                    return;
                }
                this._panel = shutterPanel;
                this._panel.setActive(bl);
                this._panel.capture();
                if (bl) {
                    this.adjustPanelSize(-this._panel.getFloatingSize());
                }
            }
            this._isRaising = bl;
            this._curTime = System.currentTimeMillis();
            this._timer = new Timer(this._isRaising ? 16 : 16, this);
            this._timer.setInitialDelay(240);
            this._timer.start();
        }

        private void done() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
            if (this._panel != null) {
                this._panel.uncapture();
                this._panel = null;
            }
            this._curTime = 0L;
            this._isRaising = false;
        }

        private int getPanelSize() {
            switch (this._panel.getOrientation()) {
                case 0: 
                case 1: {
                    return this._panel.getWidth();
                }
                case 2: 
                case 3: {
                    return this._panel.getHeight();
                }
            }
            return 0;
        }

        private void adjustPanelSize(int n) {
            int n2 = this._panel.getX();
            int n3 = this._panel.getY();
            int n4 = this._panel.getWidth();
            int n5 = this._panel.getHeight();
            int n6 = this._panel.getFloatingSize();
            int n7 = Math.min(Math.max(n4 + n, 0), n6);
            int n8 = Math.min(Math.max(n5 + n, 0), n6);
            switch (this._panel.getOrientation()) {
                case 0: {
                    this._panel.setBounds(n2, n3, n7, n5);
                    break;
                }
                case 1: {
                    this._panel.setBounds(Math.max(n2 + n4 - n6, n2 - n), n3, n7, n5);
                    break;
                }
                case 2: {
                    this._panel.setBounds(n2, n3, n4, n8);
                    break;
                }
                case 3: {
                    this._panel.setBounds(n2, Math.max(n3 + n5 - n6, n3 - n), n4, n8);
                }
            }
        }
    }

    private static final class CapturePanel
    extends JPanel {
        BufferedImage _image;
        int _orientation;
        boolean _isTrailing;

        CapturePanel() {
            super(null);
        }

        void capture(Component component, int n) {
            this._image = this.captureComponentImage(component);
            this._orientation = n;
            if (this._image != null) {
                this._isTrailing = this._orientation == 0 || this._orientation == 2;
            }
        }

        void uncapture() {
            this._image = null;
            this._isTrailing = false;
        }

        int getOrientation() {
            return this._orientation;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this._image != null) {
                int n = this._isTrailing ? this.getWidth() - this._image.getWidth() : 0;
                int n2 = this._isTrailing ? this.getHeight() - this._image.getHeight() : 0;
                graphics.drawImage(this._image, n, n2, null);
            }
        }

        private BufferedImage captureComponentImage(Component component) {
            int n = component.getWidth();
            int n2 = component.getHeight();
            if (n == 0 || n2 == 0) {
                return null;
            }
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            component.paintAll(graphics2D);
            graphics2D.dispose();
            return bufferedImage;
        }
    }
}

