/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.shutter;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.border.Border;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.util.BitField;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.controls.RolloverButton;
import oracle.ideimpl.docking.DockableHolder;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.shutter.MouseActivationController;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterMargin;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.util.DropFileUtil;
import oracle.ideimpl.window.WindowingConstants;
import oracle.javatools.util.SwingUtils;

final class ShutterTab
extends RolloverButton
implements TitleChangeListener,
MouseMotionListener,
MouseListener,
DropTargetListener {
    private static final Border[] BORDER_SCHEME = new Border[]{RolloverButton.BORDER_DOWN, RolloverButton.BORDER_LINE, RolloverButton.BORDER_UP};
    private static final int LPAD_SELECTED = 6;
    private static final int RPAD_SELECTED = 18;
    private static final int LPAD_UNSELECTED = 6;
    private static final int RPAD_UNSELECTED = 6;
    private static final int GAP_ICON_TEXT = 2;
    private final TitledPanel _titledPanel;
    private transient Dimension _maxItemSize;
    private transient Dimension[] _iconSizes;
    private transient Rectangle[] _textRects;
    private transient Rectangle[] _itemBounds;
    private transient DropTargetListener _dropTargetListener;

    ShutterTab(TitledPanel titledPanel) {
        this._titledPanel = titledPanel;
        this.setBorderScheme(BORDER_SCHEME);
        this.setOpaque(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        new DropTarget(this, 2, this);
    }

    String getOrientation() {
        return this.getShutterMargin().getOrientation();
    }

    TitledPanel getTitledPanel() {
        return this._titledPanel;
    }

    boolean isClient(Dockable dockable) {
        return this._titledPanel.isClient(dockable);
    }

    void setSelectedHolder(DockableHolder dockableHolder) {
        this.setSelectedIndex(this._titledPanel.getClientPos(dockableHolder.getDockable()));
    }

    void refresh() {
        this.revalidate();
    }

    void raisePanel(DockableHolder dockableHolder, int n) {
        ShutterMargin shutterMargin;
        if (dockableHolder != null && (shutterMargin = this.getShutterMargin()) != null) {
            this.setSelectedHolder(dockableHolder);
            shutterMargin.raiseFloatPanel(dockableHolder, n);
            this.setSelected(n != 0);
        }
    }

    void retractPanel(int n) {
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        shutterPanel.hidePanel(n);
        this.setSelected(false);
    }

    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            Font font = this.getFont();
            if (graphics2D != null && font != null) {
                this._maxItemSize = this.calculateItemDimensions(graphics2D, font);
                this._itemBounds = this.calculateItemBounds();
                Dimension dimension = this.getDefaultSize();
                this.setPreferredSize(dimension);
                return dimension;
            }
            return new Dimension(10, 10);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void invalidate() {
        super.invalidate();
        this.setPreferredSize(null);
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        boolean bl;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        this.updateItemBounds(n2, n3);
        Insets insets = this.getInsets();
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, n2, n3);
        }
        if (bl = this.isVertical()) {
            graphics2D.rotate(Math.toRadians(90.0));
            graphics2D.translate(0, -n2);
            n = n2;
        } else {
            n = n3;
        }
        Font font = this.getFont();
        graphics2D.setFont(font);
        int n4 = 0;
        while (n4 < this._titledPanel.getClientCount()) {
            if (this._titledPanel.isClientVisible(n4)) {
                int n5;
                DockableHolder dockableHolder = this._titledPanel.getHolder(n4);
                Dockable dockable = dockableHolder.getDockable();
                Rectangle rectangle = this._itemBounds[n4];
                int n6 = n5 = bl ? rectangle.y : rectangle.x;
                if (n5 == 0) {
                    n5 += bl ? insets.top : insets.left;
                } else {
                    graphics2D.setColor(WindowingConstants.CONTROL_SHADOW_COLOR);
                    graphics2D.drawLine(n5, 0, n5, n);
                    ++n5;
                }
                boolean bl2 = n4 == this.getSelectedIndex();
                Dimension dimension = this._iconSizes[n4];
                n5 += bl2 ? 6 : 6;
                if (dimension.width > 0) {
                    Icon icon = dockable.getTabIcon();
                    icon.paintIcon(this, graphics2D, n5, (n - dimension.height) / 2);
                    n5 += dimension.width;
                }
                if (bl2) {
                    if (dimension.width > 0) {
                        n5 += 2;
                    }
                    Rectangle rectangle2 = this._textRects[n4];
                    String string = dockable.getTabName();
                    graphics2D.setColor(this.getForeground());
                    SwingUtils.drawString((Graphics)graphics2D, (String)string, (int)(n5 + rectangle2.x), (int)((n - rectangle2.height) / 2 - rectangle2.y));
                }
            }
            ++n4;
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        MouseActivationController mouseActivationController = ShutterManager.getInstance().getMouseActivationController();
        DockableHolder dockableHolder = this.getDockableHolder(dropTargetDragEvent.getLocation());
        mouseActivationController.dragEnter(this, dockableHolder);
        this._dropTargetListener = this.getDropTargetListener(dockableHolder);
        if (this._dropTargetListener != null) {
            this._dropTargetListener.dragEnter(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this._dropTargetListener != null) {
            this._dropTargetListener.dragExit(dropTargetEvent);
            this._dropTargetListener = null;
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        DockableHolder dockableHolder = this.getDockableHolder(dropTargetDragEvent.getLocation());
        MouseActivationController mouseActivationController = ShutterManager.getInstance().getMouseActivationController();
        mouseActivationController.dragOver(this, dockableHolder);
        this._dropTargetListener = this.getDropTargetListener(dockableHolder, dropTargetDragEvent);
        if (this._dropTargetListener != null) {
            this._dropTargetListener.dragOver(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DockableHolder dockableHolder = this.getDockableHolder(dropTargetDropEvent.getLocation());
        this._dropTargetListener = this.getDropTargetListener(dockableHolder);
        if (this._dropTargetListener != null) {
            this._dropTargetListener.drop(dropTargetDropEvent);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        DockableHolder dockableHolder = this.getDockableHolder(dropTargetDragEvent.getLocation());
        this._dropTargetListener = this.getDropTargetListener(dockableHolder, dropTargetDragEvent);
        if (this._dropTargetListener != null) {
            this._dropTargetListener.dropActionChanged(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (!BitField.isSet(n, 16)) {
            MouseActivationController mouseActivationController = ShutterManager.getInstance().getMouseActivationController();
            mouseActivationController.mouseEntered(this, this.getDockableHolder(mouseEvent.getPoint()));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        MouseActivationController mouseActivationController = ShutterManager.getInstance().getMouseActivationController();
        mouseActivationController.mouseExited(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        MouseActivationController mouseActivationController = ShutterManager.getInstance().getMouseActivationController();
        mouseActivationController.mousePressed(this, this.getDockableHolder(mouseEvent.getPoint()));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        MouseActivationController mouseActivationController = ShutterManager.getInstance().getMouseActivationController();
        mouseActivationController.mouseMoved(this, this.getDockableHolder(mouseEvent.getPoint()));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void titleChange(TitleChangeEvent titleChangeEvent) {
        this.invalidate();
    }

    private boolean isVertical() {
        String string = this.getOrientation();
        return string == "West" || string == "East";
    }

    private int getSelectedIndex() {
        return this._titledPanel.getSelectedIndex();
    }

    private void setSelectedIndex(int n) {
        if (n != this.getSelectedIndex()) {
            this._titledPanel.setSelectedIndex(n);
            this.revalidate();
        }
    }

    private ShutterMargin getShutterMargin() {
        return (ShutterMargin)this.getParent();
    }

    private DropTargetListener getDropTargetListener(DockableHolder dockableHolder) {
        DropTargetListener dropTargetListener = dockableHolder.getDockable().getTabDropListener();
        return dropTargetListener != null ? dropTargetListener : DropFileUtil.getDefaultDropFileListener();
    }

    private DropTargetListener getDropTargetListener(DockableHolder dockableHolder, DropTargetDragEvent dropTargetDragEvent) {
        DropTargetListener dropTargetListener = this.getDropTargetListener(dockableHolder);
        if (dropTargetListener != this._dropTargetListener) {
            if (this._dropTargetListener != null) {
                this._dropTargetListener.dragExit(dropTargetDragEvent);
            }
            if (dropTargetListener != null) {
                dropTargetListener.dragEnter(dropTargetDragEvent);
            }
        }
        return dropTargetListener;
    }

    private DockableHolder getDockableHolder(Point point) {
        int n = 0;
        while (n < this._itemBounds.length) {
            Rectangle rectangle = this._itemBounds[n];
            if (rectangle != null && rectangle.contains(point)) {
                return this._titledPanel.getHolder(n);
            }
            ++n;
        }
        return this._titledPanel.getSelectedHolder();
    }

    private Dimension getDefaultSize() {
        int n = this._titledPanel.getClientCount();
        int n2 = this._maxItemSize.height;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (this._titledPanel.isClientVisible(n4)) {
                if (n3 != 0) {
                    ++n3;
                }
                n3 += this.getItemWidth(n4);
            }
            ++n4;
        }
        boolean bl = this.isVertical();
        if (bl) {
            int n5 = n3;
            n3 = n2;
            n2 = n5;
        }
        Insets insets = this.getInsets();
        return new Dimension(n3 += insets.left + insets.right, n2 += insets.top + insets.bottom);
    }

    private int getItemWidth(int n) {
        if (n == this.getSelectedIndex()) {
            return 6 + this._maxItemSize.width + 18;
        }
        Dimension dimension = this._iconSizes[n];
        return 6 + (dimension.width > 0 ? dimension.width : this._maxItemSize.height) + 6;
    }

    private void updateItemBounds(int n, int n2) {
        Dimension dimension = this.getPreferredSize();
        if (dimension.width != n || dimension.height != n2) {
            this._maxItemSize.width += n - dimension.width;
            this._maxItemSize.height += n2 - dimension.height;
            this._itemBounds = this.calculateItemBounds();
        }
    }

    private Rectangle[] calculateItemBounds() {
        int n = this._titledPanel.getClientCount();
        boolean bl = this.isVertical();
        Insets insets = this.getInsets();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            if (this._titledPanel.isClientVisible(n3)) {
                n2 = n3;
            }
            ++n3;
        }
        Rectangle[] rectangleArray = new Rectangle[n];
        int n4 = bl ? insets.left + this._maxItemSize.height + insets.right : insets.top + this._maxItemSize.height + insets.bottom;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            boolean bl2 = this._titledPanel.isClientVisible(n6);
            int n7 = 0;
            if (bl2) {
                n7 = n5 == 0 ? (n7 += bl ? insets.top : insets.left) : ++n7;
                n7 += this.getItemWidth(n6);
                if (n6 == n2) {
                    n7 += bl ? insets.bottom : insets.right;
                }
            }
            rectangleArray[n6] = new Rectangle(n5, 0, n7, n4);
            n5 += n7;
            ++n6;
        }
        if (bl) {
            int n8 = 0;
            while (n8 < n) {
                Rectangle rectangle = rectangleArray[n8];
                int n9 = rectangle.x;
                rectangle.x = rectangle.y;
                rectangle.y = n9;
                int n10 = rectangle.width;
                rectangle.width = rectangle.height;
                rectangle.height = n10;
                ++n8;
            }
        }
        return rectangleArray;
    }

    private Dimension calculateItemDimensions(Graphics2D graphics2D, Font font) {
        int n = this._titledPanel.getClientCount();
        this._iconSizes = new Dimension[n];
        this._textRects = new Rectangle[n];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Rectangle rectangle;
            DockableHolder dockableHolder = this._titledPanel.getHolder(n4);
            Dockable dockable = dockableHolder.getDockable();
            Icon icon = dockable.getTabIcon();
            Dimension dimension = new Dimension();
            if (icon != null) {
                dimension.width = icon.getIconWidth();
                dimension.height = icon.getIconHeight();
            }
            this._iconSizes[n4] = dimension;
            String string = dockable.getTabName();
            if (ModelUtil.hasLength((String)string)) {
                Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
                rectangle = rectangle2D.getBounds();
            } else {
                rectangle = new Rectangle();
            }
            this._textRects[n4] = rectangle;
            if (this._titledPanel.isClientVisible(n4)) {
                int n5 = dimension.width + rectangle.width;
                if (dimension.width > 0 && rectangle.width > 0) {
                    n5 += 2;
                }
                n2 = Math.max(n5, n2);
                n3 = Math.max(dimension.height, n3);
                n3 = Math.max(rectangle.height, n3);
            }
            ++n4;
        }
        return new Dimension(n2, n3);
    }
}

