/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.UIManager;
import oracle.javatools.util.SwingUtils;

final class AcceleratorIcon
implements Icon {
    private static final boolean TRANSPARENT_BACKGROUND = false;
    private static final Color TRANSPARENT = new Color(0, 0, 0, 255);
    private Icon _baseIcon;
    private String _sLink;
    private Rectangle2D _rectLink;
    private static final int STYLE_ON_TOP = 0;
    private static final int STYLE_RIGHT = 1;
    private final int _style;
    private static final int GAP = 1;
    private static Font _fntLink;
    private static final int DEFAULT_ICON_HEIGHT = 10;
    private static final int DEFAULT_ICON_WIDTH = 10;

    void $init$() {
        this._style = 0;
    }

    public AcceleratorIcon(Icon icon, int n) {
        this.$init$();
        this.setBaseIcon(icon);
        this.setLink(n);
    }

    public boolean equals(Object object) {
        if (object instanceof Icon) {
            Icon icon = (Icon)object;
            return icon.equals(this._baseIcon);
        }
        return false;
    }

    private void setBaseIcon(Icon icon) {
        this._baseIcon = icon;
    }

    private void setLink(int n) {
        this._sLink = Integer.toString(n);
        this._rectLink = null;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this._baseIcon != null) {
            n4 = this._baseIcon.getIconWidth();
            n3 = this._baseIcon.getIconHeight();
            this._baseIcon.paintIcon(component, graphics2D, n, n2);
        } else {
            n4 = 10;
            n3 = 10;
        }
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        Color color2 = graphics2D.getBackground();
        Rectangle2D rectangle2D = this.getLinkRect(graphics2D);
        graphics2D.setColor(component.getForeground());
        graphics2D.setBackground(component.getBackground());
        Font font2 = AcceleratorIcon.getLinkFont(graphics2D);
        graphics2D.setFont(font2);
        switch (0) {
            case 1: {
                SwingUtils.drawString((Graphics)graphics2D, (String)this._sLink, (int)(n + n4 + 1), (int)((int)(-rectangle2D.getY())));
                break;
            }
            case 0: {
                int n5 = (int)((double)n + ((double)n4 - rectangle2D.getWidth()) / 2.0);
                int n6 = (int)((double)n2 + ((double)n3 - rectangle2D.getHeight()) / 2.0);
                int n7 = (int)((double)n6 - rectangle2D.getY());
                graphics2D.clearRect(n5, n6, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                SwingUtils.drawString((Graphics)graphics2D, (String)this._sLink, (int)n5, (int)n7);
                SwingUtils.drawString((Graphics)graphics2D, (String)this._sLink, (int)n5, (int)n7);
            }
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setBackground(color2);
    }

    public int getIconWidth() {
        int n;
        if (this._baseIcon != null) {
            n = this._baseIcon.getIconWidth();
            switch (0) {
                case 1: {
                    ++n;
                    Rectangle2D rectangle2D = this.getLinkRect(null);
                    if (rectangle2D == null) {
                        n += 5;
                        break;
                    }
                    n += (int)rectangle2D.getWidth();
                    break;
                }
            }
        } else {
            n = 10;
        }
        return n;
    }

    public int getIconHeight() {
        int n = this._baseIcon != null ? this._baseIcon.getIconHeight() : 10;
        return n;
    }

    private Rectangle2D getLinkRect(Graphics2D graphics2D) {
        if (this._rectLink == null && graphics2D != null) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            this._rectLink = AcceleratorIcon.getLinkFont(graphics2D).getStringBounds(this._sLink, fontRenderContext);
        }
        return this._rectLink;
    }

    private static Font getLinkFont(Graphics2D graphics2D) {
        if (_fntLink == null) {
            Font font = UIManager.getFont("Button.font");
            if (font == null) {
                font = graphics2D.getFont();
            }
            if (font != null) {
                float f = font.getSize2D();
                float f2 = f * 0.8f;
                _fntLink = font.deriveFont(f2);
            }
        }
        return _fntLink;
    }
}

